/*
 * Decompiled with CFR 0.152.
 */
package cds.moc;

import cds.moc.HealpixImpl;
import cds.tools.pixtools.CDSHealpix;

public final class Healpix
implements HealpixImpl {
    public static final int MAXORDER = 29;

    @Override
    public long ang2pix(int order, double lon, double lat) throws Exception {
        double theta = 1.5707963267948966 - lat / 180.0 * Math.PI;
        double phi = lon / 180.0 * Math.PI;
        return CDSHealpix.ang2pix_nest(order, theta, phi);
    }

    @Override
    public double[] pix2ang(int order, long npix) throws Exception {
        double[] lonlat = CDSHealpix.pix2ang_nest(order, npix);
        return new double[]{lonlat[1] * 180.0 / Math.PI, (1.5707963267948966 - lonlat[0]) * 180.0 / Math.PI};
    }

    @Override
    public long[] queryDisc(int order, double lon, double lat, double radius) throws Exception {
        return CDSHealpix.query_disc(order, lon, lat, Math.toRadians(radius), true);
    }

    public static final long pow2(long order) {
        return 1 << (int)order;
    }

    public static final long log2(long nside) {
        int i = 0;
        while (nside >>> ++i > 0L) {
        }
        return --i;
    }
}

