/*
 * Decompiled with CFR 0.152.
 */
package cds.image;

public class Iqefunc {
    static double hsq2 = 0.7071067811865476;
    static final int MA = 6;
    static final int MITER = 64;
    static double[] pval;
    static int mx;
    static int mp;
    static int winsize;
    static double[] w;
    static double[] xi;
    static double[] yi;
    static final int MMA = 16;
    private static double[] atry;
    private static double[] da;
    private static double[] oneda;
    private static double[] beta;
    private static double[] cv;
    private static double ochisq;

    public static int iqe(double[] pfm, int mx, int my, double[] parm, double[] sdev) {
        int[] nbg = new int[1];
        double[] bgv = new double[1];
        double[] bgs = new double[1];
        double[] ap = new double[6];
        double[] cv = new double[6];
        double[] est = new double[6];
        double[] sec = new double[6];
        double s2f = 2.0 * Math.sqrt(2.0 * Math.log(2.0));
        double r2d = 45.0 / Math.atan(1.0);
        for (int n = 0; n < 7; ++n) {
            sdev[n] = 0.0;
            parm[n] = 0.0;
        }
        winsize = mx * my - 1;
        if (Iqefunc.iqebgv(pfm, mx, my, bgv, bgs, nbg) != 0) {
            return -1;
        }
        parm[6] = bgv[0];
        sdev[6] = bgs[0];
        if (Iqefunc.iqemnt(pfm, mx, my, bgv[0], bgs[0], est) != 0) {
            return -2;
        }
        parm[0] = est[1];
        parm[1] = s2f * est[2];
        parm[2] = est[3];
        parm[3] = s2f * est[4];
        parm[5] = est[0];
        if (Iqefunc.iqesec(pfm, mx, my, bgv[0], est, sec) != 0) {
            return -3;
        }
        parm[4] = r2d * sec[5];
        if (Iqefunc.iqefit(pfm, mx, my, bgv[0], sec, ap, cv) < 0) {
            return -4;
        }
        parm[0] = ap[1];
        sdev[0] = cv[1];
        parm[1] = s2f * ap[2];
        sdev[1] = s2f * cv[2];
        parm[2] = ap[3];
        sdev[2] = cv[3];
        parm[3] = s2f * ap[4];
        sdev[3] = s2f * cv[4];
        parm[4] = Iqefunc.fmod(r2d * ap[5] + 180.0, 180.0);
        sdev[4] = r2d * cv[5];
        if (sdev[4] > 180.0) {
            sdev[4] = 180.0;
        }
        parm[5] = ap[0];
        sdev[5] = cv[0];
        return 0;
    }

    public static int iqebgv(double[] pfm, int mx, int my, double[] bgm, double[] bgs, int[] nbg) {
        int n;
        int pf0;
        int m;
        bgm[0] = 0.0;
        bgs[0] = 0.0;
        nbg[0] = 0;
        int pfs0 = 0;
        int pfs1 = mx - 1;
        int pfs2 = mx * (my - 1);
        int pfs3 = mx * my - 1;
        int ns = mx < my ? mx - 1 : my - 1;
        int ms = mx < my ? mx / 4 : my / 4;
        double[] pfb = new double[8 * ns * ms];
        int pwb = 4 * ns * ms;
        int nt = 0;
        int pf = 0;
        int pw = pwb;
        for (m = 0; m < ms; ++m) {
            pf0 = pfs0;
            int pf1 = pfs1;
            int pf2 = pfs2;
            int pf3 = pfs3;
            for (n = 0; n < ns; ++n) {
                pfb[pf++] = pfm[pf0++];
                pfb[pf++] = pfm[pf1];
                pf1 += mx;
                pfb[pf++] = pfm[pf2];
                pf2 -= mx;
                pfb[pf++] = pfm[pf3--];
            }
            nt += 4 * ns;
            ns -= 2;
            pfs0 += mx + 1;
            pfs1 += mx - 1;
            pfs2 -= mx - 1;
            pfs3 -= mx + 1;
        }
        pf0 = 0;
        pf = 0;
        pw = pwb;
        n = nt;
        int mt = 0;
        mt = nt;
        while (n-- != 0) {
            pfb[pw++] = 1.0;
        }
        Iqefunc.hsort(mt, pfb);
        nt = mt;
        m = mt / 2;
        n = mt / 20;
        double ba = pfb[m];
        double bs = 0.606 * (ba - pfb[n]);
        if (bs <= 0.0) {
            bs = Math.sqrt(Math.abs(ba));
        }
        bgm[0] = ba;
        for (m = 0; m < 5; ++m) {
            pf = 0;
            pw = pwb;
            double fks = 5.0 * bs;
            bs = 0.0;
            double bm = 0.0;
            mt = 0;
            n = 0;
            while (n < nt) {
                double val = pfb[pf++];
                if (0.0 < pfb[pw] && Math.abs(val - ba) < fks) {
                    bm += val;
                    bs += val * val;
                    ++mt;
                } else {
                    pfb[pw] = 0.0;
                }
                ++n;
                ++pw;
            }
            if (mt < 1) {
                return -2;
            }
            ba = bm / (double)mt;
            bs = 0.0 < (bs = bs / (double)mt - ba * ba) ? Math.sqrt(bs) : 0.0;
        }
        bgm[0] = ba;
        bgs[0] = bgs[0] / bs;
        nbg[0] = mt;
        return 0;
    }

    public static int iqemnt(double[] pfm, int mx, int my, double bgv, double bgs, double[] amm) {
        double val;
        double x;
        int nt;
        int nx;
        int ndx = 0;
        int ndy = 0;
        double[] av = new double[1];
        double[] dx = new double[1];
        double[] dy = new double[1];
        double dv = 5.0 * bgs;
        double xm = (double)mx - 1.0;
        double ym = (double)my - 1.0;
        for (nx = 0; nx < 6; ++nx) {
            amm[nx] = 0.0;
        }
        int ny = 1;
        nx = 1;
        int n = 1;
        int nxc = mx / 2;
        int nyc = my / 2;
        int n2 = nt = nxc < nyc ? nxc : nyc;
        while (nt-- != 0 && Iqefunc.estm9p(pfm, mx, my, nxc, nyc, av, dx, dy) == 0) {
            if (n != 0) {
                n = 0;
            } else {
                if (dx[0] * (double)ndx < 0.0) {
                    nx = 0;
                }
                if (dy[0] * (double)ndy < 0.0) {
                    ny = 0;
                }
            }
            if (nx == 0 && ny == 0) break;
            ndx = 0.0 < dx[0] ? nx : -nx;
            ndy = 0.0 < dy[0] ? ny : -ny;
            nxc += ndx;
            nyc += ndy;
        }
        double y = 0.0;
        nt = 0;
        ny = my;
        int pf = 0;
        double ay = 0.0;
        double ax = 0.0;
        while (ny-- != 0) {
            x = 0.0;
            nx = mx;
            while (nx-- != 0) {
                int n3 = pf++;
                val = pfm[n3] - bgv;
                if (dv < val) {
                    ax += x;
                    ay += y;
                    ++nt;
                }
                x += 1.0;
            }
            y += 1.0;
        }
        if (nt < 1) {
            return -1;
        }
        nx = (int)Math.floor(ax / (double)nt);
        val = pfm[nx + mx * (ny = (int)Math.floor(ay / (double)nt))];
        if (av[0] < val) {
            nxc = nx;
            nyc = ny;
        }
        nt = 0;
        nx = 1;
        x = nxc;
        y = nyc;
        int ioff = nxc + mx * nyc;
        n = mx < my ? mx - 1 : my - 1;
        pf = ioff;
        int psize = ioff;
        if (psize < 0 || psize > winsize) {
            return -99;
        }
        double am = val = pfm[pf] - bgv;
        ax = val * x;
        ay = val * y;
        double axx = val * x * x;
        double ayy = val * y * y;
        double axy = val * x * y;
        ++nt;
        int kn = 1;
        int ks = 1;
        int ki = 1;
        while (n-- != 0) {
            int k = kn;
            if (ki == 0 && ks == -1) {
                if (nx == 0) break;
                nx = 0;
            }
            int n4 = ioff = ki != 0 ? ks : ks * mx;
            while (k-- != 0) {
                if (ki != 0) {
                    x += (double)ks;
                } else {
                    y += (double)ks;
                }
                if (x < 0.0 || y < 0.0 || xm < x || ym < y) break;
                pf += ioff;
                psize = ioff;
                if (psize < 0 || psize > winsize) break;
                val = pfm[pf] - bgv;
                if (!(dv < val)) continue;
                am += val;
                ax += val * x;
                ay += val * y;
                axx += val * x * x;
                ayy += val * y * y;
                axy += val * x * y;
                ++nt;
                ++nx;
            }
            if ((ki = ki != 0 ? 0 : 1) == 0) continue;
            ks = -ks;
            ++kn;
        }
        if (am <= 0.0) {
            return -1;
        }
        amm[1] = ax / am;
        amm[3] = ay / am;
        amm[2] = 0.0 < (axx = axx / am - amm[1] * amm[1]) ? Math.sqrt(axx) : 0.0;
        ayy = ayy / am - amm[3] * amm[3];
        amm[4] = 0.0 < ayy ? Math.sqrt(ayy) : 0.0;
        axy = (axy / am - amm[1] * amm[3]) / axx;
        amm[5] = Iqefunc.fmod(Math.atan(axy) + 4.0 * Math.atan(1.0), 4.0 * Math.atan(1.0));
        nx = (int)amm[1];
        ny = (int)amm[3];
        amm[0] = pfm[nx + ny * mx] - bgv;
        return 0;
    }

    private static double fmod(double a, double b) {
        double res = 0.0;
        long k = 0L;
        if (a > 0.0) {
            if (b > 0.0) {
                k = (long)(a / b);
                res = a - (double)k * b;
                return res;
            }
            if (b < 0.0) {
                k = (long)Math.rint(a / b);
                res = a - (double)k * b;
                return res;
            }
        }
        if (a <= 0.0) {
            if (b <= 0.0) {
                k = (long)(a / b);
                res = a - (double)k * b;
                return res;
            }
            if (b > 0.0) {
                k = (long)Math.rint(a / b);
                res = a - (double)k * b;
                return res;
            }
        }
        return res;
    }

    public static int estm9p(double[] pfm, int mx, int my, int nx, int ny, double[] rm, double[] dx, double[] dy) {
        int n;
        int ix;
        int[] idx = new int[9];
        double[] fb = new double[9];
        double[] wb = new double[9];
        if (nx < 1 || mx < nx - 2 || ny < 1 || my < ny - 2) {
            return -1;
        }
        int iy = 3;
        int pfb = 0;
        int pwb = 0;
        int i = nx - 1 + mx * (ny - 1);
        while (iy-- != 0) {
            ix = 3;
            while (ix-- != 0) {
                fb[pfb++] = pfm[i++];
                wb[pwb++] = 1.0;
            }
            i += mx - 3;
        }
        Iqefunc.indexx(9, fb, idx);
        wb[idx[8]] = 0.0;
        int nt = 0;
        double am = 0.0;
        for (n = 0; n < 9; ++n) {
            if (!(0.0 < wb[n])) continue;
            am += fb[n];
            ++nt;
        }
        rm[0] = am / (double)nt;
        am = 0.0;
        double a = 0.0;
        iy = 0;
        ix = 0;
        for (n = 0; n < 9; n += 3) {
            if (0.0 < wb[n]) {
                a += fb[n];
                ++ix;
            }
            if (!(0.0 < wb[n + 2])) continue;
            am += fb[n + 2];
            ++iy;
        }
        dx[0] = 0.5 * (am / (double)iy - a / (double)ix);
        am = 0.0;
        a = 0.0;
        iy = 0;
        ix = 0;
        for (n = 0; n < 3; ++n) {
            if (0.0 < wb[n]) {
                a += fb[n];
                ++ix;
            }
            if (!(0.0 < wb[n + 6])) continue;
            am += fb[n + 6];
            ++iy;
        }
        dy[0] = 0.5 * (am / (double)iy - a / (double)ix);
        return 0;
    }

    public static int iqesec(double[] pfm, int mx, int my, double bgv, double[] est, double[] sec) {
        int ioff;
        double rh;
        double rl;
        double y;
        double x;
        int n;
        int[] ns = new int[8];
        double[] sb = new double[8];
        double fac = 1.0 / Math.atan(1.0);
        for (n = 0; n < 6; ++n) {
            sec[n] = 0.0;
        }
        for (n = 0; n < 8; ++n) {
            sb[n] = 0.0;
            ns[n] = 0;
        }
        double xc = x = est[1];
        double xm = (double)mx - 1.0;
        double yc = y = est[3];
        double ym = (double)my - 1.0;
        if (est[2] < est[4]) {
            rl = 2.0 * est[2];
            rh = 4.0 * est[4];
            n = (int)Math.ceil(16.0 * est[4]);
        } else {
            rl = 2.0 * est[4];
            rh = 4.0 * est[2];
            n = (int)Math.ceil(16.0 * est[2]);
        }
        int nxc = (int)Math.floor(x + 0.5);
        int nyc = (int)Math.floor(y + 0.5);
        int pf = ioff = nxc + mx * nyc;
        int kn = 1;
        int ks = 1;
        int ki = 1;
        while (n-- != 0) {
            int k = kn;
            int n2 = ioff = ki != 0 ? ks : ks * mx;
            while (k-- != 0) {
                int idx;
                if (ki != 0) {
                    x += (double)ks;
                } else {
                    y += (double)ks;
                }
                if (x < 0.0 || y < 0.0 || xm < x || ym < y) break;
                pf += ioff;
                int psize = ioff;
                if (psize < 0 || psize > winsize) break;
                double dx = x - xc;
                double dy = y - yc;
                double r = Math.sqrt(dx * dx + dy * dy);
                if (!(rl < r) || !(r < rh)) continue;
                double f = pfm[pf] - bgv;
                int n3 = idx = (int)(fac * Math.atan2(y - yc, x - xc) + 8.5) % 8;
                sb[n3] = sb[n3] + (0.0 < f ? f : 0.0);
                int n4 = idx;
                ns[n4] = ns[n4] + 1;
            }
            if ((ki = ki != 0 ? 0 : 1) == 0) continue;
            ks = -ks;
            ++kn;
        }
        for (n = 0; n < 8; ++n) {
            if (ns[n] < 1) {
                ns[n] = 1;
            }
            int n5 = n;
            sb[n5] = sb[n5] / (double)ns[n];
        }
        double a2r = sb[0] - sb[2] + sb[4] - sb[6];
        double a2i = sb[1] - sb[3] + sb[5] - sb[7];
        for (n = 0; n < 6; ++n) {
            sec[n] = est[n];
        }
        if (a2r == 0.0 && a2i == 0.0) {
            return -2;
        }
        sec[5] = Iqefunc.fmod(0.5 * Math.atan2(a2i, a2r), 4.0 / fac);
        return 0;
    }

    public static int iqefit(double[] pfm, int mx, int my, double bgv, double[] est, double[] ap, double[] cm) {
        int ny;
        int nx;
        int nys;
        int n;
        double[] chi = new double[1];
        for (n = 0; n < 6; ++n) {
            cm[n] = 0.0;
            ap[n] = 0.0;
        }
        int nxs = (int)Math.floor(est[1] - 4.0 * est[2]);
        if (nxs < 0) {
            nxs = 0;
        }
        if ((nys = (int)Math.floor(est[3] - 4.0 * est[4])) < 0) {
            nys = 0;
        }
        if (mx < nxs + (nx = (int)Math.ceil(8.0 * est[2]))) {
            nx = my - nxs;
        }
        if (my < nys + (ny = (int)Math.ceil(8.0 * est[4]))) {
            ny = my - nys;
        }
        double[] pfb = new double[2 * nx * ny];
        int i = nxs + mx * nys;
        int psize = i;
        if (psize < 0 || psize > winsize) {
            return -99;
        }
        int pf = 0;
        int iy = ny;
        while (iy-- != 0) {
            int ix = nx;
            while (ix-- != 0) {
                pfb[pf++] = pfm[i++] - bgv;
                psize = pf;
                if (psize <= winsize) continue;
                return -99;
            }
            psize = i += mx - nx;
            if (psize >= 0 && psize <= winsize) continue;
            return -99;
        }
        ap[0] = est[0];
        ap[1] = est[1] - (double)nxs;
        ap[2] = est[2];
        ap[3] = est[3] - (double)nys;
        ap[4] = est[4];
        ap[5] = est[5];
        n = Iqefunc.g2efit(pfb, nx, ny, ap, cm, chi);
        ap[1] = ap[1] + (double)nxs;
        ap[3] = ap[3] + (double)nys;
        return n;
    }

    public static int g2einit(double[] val, int nx, int ny) {
        if (nx < 1) {
            pval = null;
            mp = 0;
            mx = 0;
            return -1;
        }
        pval = val;
        mx = nx;
        mp = 0 < ny ? ny * nx : nx;
        double fh = 0.5 * Math.sqrt(0.6);
        double w1 = 0.19753086419753085;
        double w2 = 0.12345679012345678;
        double w3 = 0.07716049382716049;
        Iqefunc.xi[0] = 0.0;
        Iqefunc.yi[0] = 0.0;
        Iqefunc.w[0] = w1;
        Iqefunc.xi[1] = 0.0;
        Iqefunc.yi[1] = fh;
        Iqefunc.w[1] = w2;
        Iqefunc.xi[2] = 0.0;
        Iqefunc.yi[2] = -fh;
        Iqefunc.w[2] = w2;
        Iqefunc.xi[3] = fh;
        Iqefunc.yi[3] = 0.0;
        Iqefunc.w[3] = w2;
        Iqefunc.xi[4] = -fh;
        Iqefunc.yi[4] = 0.0;
        Iqefunc.w[4] = w2;
        Iqefunc.xi[5] = fh;
        Iqefunc.yi[5] = fh;
        Iqefunc.w[5] = w3;
        Iqefunc.xi[6] = -fh;
        Iqefunc.yi[6] = fh;
        Iqefunc.w[6] = w3;
        Iqefunc.xi[7] = fh;
        Iqefunc.yi[7] = -fh;
        Iqefunc.w[7] = w3;
        Iqefunc.xi[8] = -fh;
        Iqefunc.yi[8] = -fh;
        Iqefunc.w[8] = w3;
        return 0;
    }

    public static int g2efunc(int idx, double[] val, double[] fval, double[] psig, double[] a, double[] dyda, int ma) {
        double ff;
        double yy;
        double xx;
        if (idx < 0 || mp <= idx) {
            return -1;
        }
        if (a[2] <= 0.0 || a[4] <= 0.0) {
            return -2;
        }
        double xc = (double)(idx % mx) - a[1];
        double yc = (double)(idx / mx) - a[3];
        val[0] = pval[idx];
        psig[0] = 1.0;
        double si = Math.sin(a[5]);
        double ci = Math.cos(a[5]);
        double sum = 0.0;
        for (int n = 0; n < 9; ++n) {
            double x = xc + xi[n];
            double y = yc + yi[n];
            xx = (ci * x + si * y) / a[2];
            yy = (-si * x + ci * y) / a[4];
            sum += w[n] * Math.exp(-0.5 * (xx * xx + yy * yy));
        }
        xx = (ci * xc + si * yc) / a[2];
        yy = (-si * xc + ci * yc) / a[4];
        fval[0] = ff = a[0] * sum;
        dyda[0] = sum;
        dyda[1] = ff * (ci * xx / a[2] - si * yy / a[4]);
        dyda[2] = ff * xx * xx / a[2];
        dyda[3] = ff * (si * xx / a[2] + ci * yy / a[4]);
        dyda[4] = ff * yy * yy / a[4];
        dyda[5] = ff * ((si * xc - ci * yc) * xx / a[2] + (ci * xc + si * yc) * yy / a[4]);
        return 0;
    }

    public static int g2efit(double[] val, int nx, int ny, double[] ap, double[] cv, double[] pchi) {
        int ni;
        int n;
        int[] lista = new int[6];
        double[] apo = new double[6];
        double[] a1 = new double[1];
        double[] alpha = new double[36];
        double[] cvm = new double[36];
        if (Iqefunc.g2einit(val, nx, ny) != 0) {
            return -1;
        }
        double pi = 4.0 * Math.atan(1.0);
        a1[0] = -1.0;
        int mt = nx * ny;
        for (n = 0; n < 6; ++n) {
            lista[n] = n;
            cv[n] = 0.0;
        }
        double c2 = 0.0;
        pchi[0] = 0.0;
        double a2 = 0.0;
        int na = 0;
        for (ni = 0; ni < 64; ++ni) {
            for (n = 0; n < 6; ++n) {
                apo[n] = ap[n];
            }
            if (Iqefunc.mrqmin(mt, ap, 6, lista, 6, cvm, alpha, pchi, a1) != 0) {
                return -2;
            }
            if (a1[0] < a2 && Math.abs(pchi[0] - c2) < 1.0E-5 * c2) break;
            if (a1[0] < a2) {
                c2 = pchi[0];
                na = 0;
            } else {
                ++na;
            }
            a2 = a1[0];
            if (5 < na) break;
            if (ap[0] <= 0.0) {
                ap[0] = 0.5 * apo[0];
            }
            if (ap[2] <= 0.0) {
                ap[2] = 0.5 * apo[2];
            }
            if (ap[4] <= 0.0) {
                ap[4] = 0.5 * apo[4];
            }
            ap[5] = Iqefunc.fmod(ap[5], pi);
            if (!(ap[1] < 0.0 || (double)nx < ap[1] || ap[3] < 0.0) && !((double)ny < ap[3])) continue;
            return -3;
        }
        a1[0] = 0.0;
        if (Iqefunc.mrqmin(mt, ap, 6, lista, 6, cvm, alpha, pchi, a1) != 0) {
            return -2;
        }
        ap[5] = Iqefunc.fmod(ap[5] + pi, pi);
        for (n = 0; n < 6; ++n) {
            cv[n] = Math.sqrt(cvm[n + n * 6]);
        }
        return 64 <= ni ? -4 : ni;
    }

    public static int mrqmin(int ndata, double[] a, int ma, int[] lista, int mfit, double[] covar, double[] alpha, double[] chisq, double[] alamda) {
        int k;
        int j;
        if (alamda[0] < 0.0) {
            if (16 < ma || ma < mfit) {
                return -3;
            }
            int kk = mfit;
            for (j = 0; j < ma; ++j) {
                int ihit = 0;
                for (k = 0; k < mfit; ++k) {
                    if (lista[k] != j) continue;
                    ++ihit;
                }
                if (ihit == 0) {
                    lista[kk++] = j;
                    continue;
                }
                if (ihit <= true) continue;
                return -1;
            }
            if (kk != ma) {
                return -2;
            }
            alamda[0] = 0.001;
            Iqefunc.mrqcof(ndata, a, ma, lista, mfit, alpha, beta, chisq);
            if (chisq[0] <= 0.0) {
                return -4;
            }
            ochisq = chisq[0];
        }
        for (j = 0; j < mfit; ++j) {
            for (k = 0; k < mfit; ++k) {
                double d = alpha[j + k * ma];
                Iqefunc.cv[j + k * mfit] = d;
                covar[j + k * ma] = d;
            }
            double d = alpha[j + j * ma] * (1.0 + alamda[0]);
            Iqefunc.cv[j + j * mfit] = d;
            covar[j + j * ma] = d;
            Iqefunc.oneda[j] = beta[j];
        }
        if (Iqefunc.gaussj(cv, mfit, oneda, 1) != 0) {
            return -5;
        }
        for (j = 0; j < mfit; ++j) {
            Iqefunc.da[j] = oneda[j];
        }
        if (alamda[0] == 0.0) {
            for (j = 0; j < mfit; ++j) {
                for (k = 0; k < mfit; ++k) {
                    covar[j + k * ma] = cv[j + k * mfit];
                }
            }
            Iqefunc.covsrt(covar, ma, lista, mfit);
            return 0;
        }
        for (j = 0; j < ma; ++j) {
            Iqefunc.atry[j] = a[j];
        }
        for (j = 0; j < mfit; ++j) {
            Iqefunc.atry[lista[j]] = a[lista[j]] + da[j];
        }
        Iqefunc.mrqcof(ndata, atry, ma, lista, mfit, covar, da, chisq);
        if (0.0 < chisq[0] && chisq[0] < ochisq) {
            alamda[0] = alamda[0] * 0.1;
            ochisq = chisq[0];
            for (j = 0; j < mfit; ++j) {
                for (k = 0; k < mfit; ++k) {
                    alpha[j + k * ma] = covar[j + k * ma];
                }
                Iqefunc.beta[j] = da[j];
                a[lista[j]] = atry[lista[j]];
            }
        } else {
            alamda[0] = alamda[0] * 10.0;
            chisq[0] = ochisq;
        }
        return 0;
    }

    public static int mrqcof(int ndata, double[] a, int ma, int[] lista, int mfit, double[] alpha, double[] veta, double[] chisq) {
        int k;
        int j;
        double[] ymod = new double[1];
        double[] sig2i = new double[1];
        double[] y = new double[1];
        double[] dyda = new double[16];
        for (j = 0; j < mfit; ++j) {
            for (k = 0; k <= j; ++k) {
                alpha[j + k * ma] = 0.0;
            }
            veta[j] = 0.0;
        }
        chisq[0] = 0.0;
        for (int i = 0; i < ndata; ++i) {
            if (Iqefunc.g2efunc(i, y, ymod, sig2i, a, dyda, ma) != 0) continue;
            double dy = y[0] - ymod[0];
            j = 0;
            while (j < mfit) {
                double wt = dyda[lista[j]] * sig2i[0];
                for (k = 0; k <= j; ++k) {
                    int n = j + k * ma;
                    alpha[n] = alpha[n] + wt * dyda[lista[k]];
                }
                int n = j++;
                veta[n] = veta[n] + dy * wt;
            }
            chisq[0] = chisq[0] + dy * dy * sig2i[0];
        }
        for (j = 1; j < mfit; ++j) {
            for (k = 0; k < j; ++k) {
                alpha[k + j * ma] = alpha[j + k * ma];
            }
        }
        return 0;
    }

    public static void indexx(int n, double[] arrin, int[] indx) {
        int j;
        for (j = 0; j < n; ++j) {
            indx[j] = j;
        }
        int l = n >> 1;
        int ir = n - 1;
        while (true) {
            double q;
            int indxt;
            if (l > 0) {
                indxt = indx[--l];
                q = arrin[indxt];
            } else {
                indxt = indx[ir];
                q = arrin[indxt];
                indx[ir] = indx[0];
                if (--ir == 0) {
                    indx[0] = indxt;
                    return;
                }
            }
            int i = l;
            for (j = (l << 1) + 1; j <= ir; j += i + 1) {
                if (j < ir && arrin[indx[j]] < arrin[indx[j + 1]]) {
                    ++j;
                }
                if (!(q < arrin[indx[j]])) break;
                indx[i] = indx[j];
                i = j;
            }
            indx[i] = indxt;
        }
    }

    public static void swap(double[] a, int i, int j) {
        double t = a[i];
        a[i] = a[j];
        a[j] = t;
    }

    public static int gaussj(double[] a, int n, double[] b, int m) {
        int l;
        int k;
        int j;
        int icol = 0;
        int irow = 0;
        int[] indxc = new int[16];
        int[] indxr = new int[16];
        int[] ipiv = new int[16];
        if (16 < n) {
            return -3;
        }
        for (j = 0; j < n; ++j) {
            ipiv[j] = 0;
        }
        for (int i = 0; i < n; ++i) {
            double dum;
            double big = 0.0;
            for (j = 0; j < n; ++j) {
                if (ipiv[j] == 1) continue;
                for (k = 0; k < n; ++k) {
                    if (ipiv[k] == 0) {
                        dum = Math.abs(a[j + k * n]);
                        if (!(dum >= big)) continue;
                        big = dum;
                        irow = j;
                        icol = k;
                        continue;
                    }
                    if (ipiv[k] <= 1) continue;
                    return -1;
                }
            }
            int n2 = icol;
            ipiv[n2] = ipiv[n2] + 1;
            if (irow != icol) {
                for (l = 0; l < n; ++l) {
                    Iqefunc.swap(a, irow + l * n, icol + l * n);
                }
                for (l = 0; l < m; ++l) {
                    Iqefunc.swap(b, irow + l * n, icol + l * n);
                }
            }
            indxr[i] = irow;
            indxc[i] = icol;
            if (a[icol + icol * n] == 0.0) {
                return -2;
            }
            double pivinv = 1.0 / a[icol + icol * n];
            a[icol + icol * n] = 1.0;
            for (l = 0; l < n; ++l) {
                int n3 = icol + l * n;
                a[n3] = a[n3] * pivinv;
            }
            for (l = 0; l < m; ++l) {
                int n4 = icol + l * n;
                b[n4] = b[n4] * pivinv;
            }
            for (int ll = 0; ll < n; ++ll) {
                if (ll == icol) continue;
                dum = a[ll + icol * n];
                a[ll + icol * n] = 0.0;
                for (l = 0; l < n; ++l) {
                    int n5 = ll + l * n;
                    a[n5] = a[n5] - a[icol + l * n] * dum;
                }
                for (l = 0; l < m; ++l) {
                    int n6 = ll + l * n;
                    b[n6] = b[n6] - b[icol + l * n] * dum;
                }
            }
        }
        for (l = n - 1; l >= 0; --l) {
            if (indxr[l] == indxc[l]) continue;
            for (k = 0; k < n; ++k) {
                Iqefunc.swap(a, k + indxr[l] * n, k + indxc[l] * n);
            }
        }
        return 0;
    }

    public static int covsrt(double[] covar, int ma, int[] lista, int mfit) {
        int i;
        int j;
        for (j = 0; j < ma - 1; ++j) {
            for (i = j + 1; i < ma; ++i) {
                covar[i + j * ma] = 0.0;
            }
        }
        for (i = 0; i < mfit - 1; ++i) {
            for (j = i + 1; j < mfit; ++j) {
                if (lista[j] > lista[i]) {
                    covar[lista[j] + lista[i] * ma] = covar[i + j * ma];
                    continue;
                }
                covar[lista[i] + lista[j] * ma] = covar[i + j * ma];
            }
        }
        double swap = covar[0];
        for (j = 0; j < ma; ++j) {
            covar[j * ma] = covar[j + j * ma];
            covar[j + j * ma] = 0.0;
        }
        covar[lista[0] + lista[0] * ma] = swap;
        for (j = 1; j < mfit; ++j) {
            covar[lista[j] + lista[j] * ma] = covar[j * ma];
        }
        for (j = 1; j < ma; ++j) {
            for (i = 0; i < j; ++i) {
                covar[i + j * ma] = covar[j + i * ma];
            }
        }
        return 0;
    }

    public static void hsort(int n, double[] ra) {
        int l = n >> 1;
        int ir = n - 1;
        while (true) {
            double rra;
            if (l > 0) {
                rra = ra[--l];
            } else {
                rra = ra[ir];
                ra[ir] = ra[0];
                if (--ir == 0) {
                    ra[0] = rra;
                    return;
                }
            }
            int i = l;
            int j = (l << 1) + 1;
            while (j <= ir) {
                if (j < ir && ra[j] < ra[j + 1]) {
                    ++j;
                }
                if (rra < ra[j]) {
                    ra[i] = ra[j];
                    i = j;
                    j += i + 1;
                    continue;
                }
                j = ir + 1;
            }
            ra[i] = rra;
        }
    }

    static {
        w = new double[9];
        xi = new double[9];
        yi = new double[9];
        atry = new double[16];
        da = new double[16];
        oneda = new double[16];
        beta = new double[16];
        cv = new double[256];
    }
}

