/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.CellSink;

public class Range {
    public final long from;
    public long to;

    public Range(long from, long to) {
        this.from = from;
        this.to = to;
    }

    public void toCells(CellSink sink) {
        int twiceDd;
        long l = this.from;
        long h = this.to;
        do {
            long len = h - l;
            assert (len > 0L);
            int ddMaxFromLen = 63 - Long.numberOfLeadingZeros(len) >> 1;
            int ddMaxFromLow = Long.numberOfTrailingZeros(l) >> 1;
            int dd = Math.min(29, Math.min(ddMaxFromLen, ddMaxFromLow));
            twiceDd = dd << 1;
            sink.push(29 - dd, l >> twiceDd);
        } while ((l += 1L << twiceDd) < h);
    }

    public void toCellsWithKnowledge(CellSink sink, int depthMax, int twiceDD, long rangeLenMin, long mask) {
        long l = this.from;
        long h = this.to;
        do {
            long len = h - l;
            assert (len > 0L);
            if (len == rangeLenMin || (l & mask) != 0L) {
                sink.push(depthMax, l >> twiceDD);
                l += rangeLenMin;
                continue;
            }
            int ddMaxFromLen = 63 - Long.numberOfLeadingZeros(len) >> 1;
            int ddMaxFromLow = Long.numberOfTrailingZeros(l) >> 1;
            int dd = Math.min(29, Math.min(ddMaxFromLen, ddMaxFromLow));
            int twiceDd = dd << 1;
            sink.push(29 - dd, l >> twiceDd);
            l += 1L << twiceDd;
        } while (l < h);
    }
}

