/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.CompassPoint;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixNestedNeighbourSelector;
import cds.healpix.HealpixProjector;
import cds.healpix.Interpolator;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.common.math.HackersDelight;
import java.util.EnumSet;

class HealpixNestedInterpolator
implements Interpolator {
    private final HealpixNested h;
    private final NeighbourSelector hns;
    private final long EQUAT_D0H_BITS_MASK;
    private final HealpixProjector proj = new HealpixProjector();
    private double[] xy = new double[2];
    private double x;
    private double y;
    private long xInt;
    private long yInt;
    private int iBaseCell;
    private int jBaseCell;
    private int iInBaseCell;
    private int jInBaseCell;
    private long baseCellBits;
    private double cellCenterX;
    private double cellCenterY;
    private double dX;
    private double dY;
    private int quarter = 0;
    private NeighbourList neigList;

    HealpixNestedInterpolator(HealpixNested healpixNested) {
        this.h = healpixNested;
        this.hns = new HealpixNestedNeighbourSelector(this.h);
        this.neigList = new NeighbourList(this.h.depth);
        this.EQUAT_D0H_BITS_MASK = 4L << this.h.twiceDepth;
    }

    @Override
    public int depth() {
        return this.h.depth;
    }

    @Override
    public int interpolate(double lonRad, double latRad, long[] resultHashs, double[] resultWeights) {
        this.project(lonRad, latRad);
        this.shiftAndRotateAndScale();
        this.discretize();
        this.computeQuarter();
        this.computeBaseCellCoos();
        this.computeCoosInBaseCell();
        this.computeBaseCellHashBits();
        return this.computeHashsAndWeights(resultHashs, resultWeights);
    }

    private boolean isBaseCellInEquatRegionFromBits(long baseCellBits) {
        return (baseCellBits & this.EQUAT_D0H_BITS_MASK) != 0L;
    }

    private boolean isInNorthPolarCapFromBits(long baseCellBits) {
        return baseCellBits > this.EQUAT_D0H_BITS_MASK;
    }

    private int computeHashsAndWeights(long[] resultHashs, double[] resultWeights) {
        long ijInterleavedBits = this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell);
        long hashC = this.baseCellBits | ijInterleavedBits;
        if (this.isInBaseCellBorderFromBits(this.iInBaseCell, this.jInBaseCell)) {
            if (this.isBaseCellInEquatRegionFromBits(this.baseCellBits)) {
                if (ijInterleavedBits == 0L && this.quarter == 0) {
                    assert (this.dX >= 0.0 && this.dY >= 0.0);
                    resultHashs[0] = hashC;
                    resultWeights[0] = (1.0 - this.dX) * (1.0 - this.dY);
                    double halfWS = 0.5 * this.dX * this.dY;
                    resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell);
                    resultWeights[2] = this.dX * (1.0 - this.dY) + halfWS;
                    resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell - 1);
                    resultWeights[3] = (1.0 - this.dX) * this.dY + halfWS;
                    return 3;
                }
                if (ijInterleavedBits == this.h.xyMask && this.quarter == 3) {
                    assert (this.dX < 0.0 && this.dY < 0.0);
                    resultHashs[0] = hashC;
                    resultWeights[0] = (1.0 + this.dX) * (1.0 + this.dY);
                    double halfWN = 0.5 * this.dX * this.dY;
                    resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell);
                    resultWeights[2] = this.dX * (1.0 + this.dY) + halfWN;
                    resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell + 1);
                    resultWeights[3] = (1.0 + this.dX) * this.dY + halfWN;
                    return 3;
                }
                return this.computeHashsAndWeights(hashC, this.quarter, resultHashs, resultWeights);
            }
            if (this.isInNorthPolarCapFromBits(this.baseCellBits)) {
                if (ijInterleavedBits == this.h.xMask && this.quarter == 1) {
                    assert (this.dX < 0.0 && this.dY >= 0.0);
                    double halfWE = -0.5 * this.dX * this.dY;
                    resultHashs[0] = hashC;
                    resultWeights[0] = (1.0 + this.dX) * (1.0 - this.dY) + halfWE;
                    resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell);
                    resultWeights[2] = -this.dX * (1.0 - this.dY) + halfWE;
                    resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell - 1);
                    resultWeights[3] = (1.0 - this.dX) * this.dY;
                    return 3;
                }
                if (ijInterleavedBits == this.h.yMask && this.quarter == 2) {
                    assert (this.dX >= 0.0 && this.dY < 0.0);
                    double halfWW = -0.5 * this.dX * this.dY;
                    resultHashs[0] = hashC;
                    resultWeights[0] = (1.0 - this.dX) * (1.0 + this.dY) + halfWW;
                    resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell);
                    resultWeights[2] = this.dX * (1.0 + this.dY);
                    resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell + 1);
                    resultWeights[3] = (1.0 - this.dX) * this.dY + halfWW;
                    return 3;
                }
                return this.computeHashsAndWeights(hashC, this.quarter, resultHashs, resultWeights);
            }
            if (ijInterleavedBits == this.h.xMask && this.quarter == 1) {
                assert (this.dX < 0.0 && this.dY >= 0.0);
                double halfWE = -0.5 * this.dX * this.dY;
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 + this.dX) * (1.0 - this.dY) + halfWE;
                resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell);
                resultWeights[2] = -this.dX * (1.0 - this.dY);
                resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell - 1);
                resultWeights[3] = (1.0 - this.dX) * this.dY + halfWE;
                return 3;
            }
            if (ijInterleavedBits == this.h.yMask && this.quarter == 2) {
                assert (this.dX >= 0.0 && this.dY < 0.0);
                double halfWW = -0.5 * this.dX * this.dY;
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 - this.dX) * (1.0 + this.dY) + halfWW;
                resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell);
                resultWeights[2] = this.dX * (1.0 + this.dY) + halfWW;
                resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell + 1);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                return 3;
            }
            return this.computeHashsAndWeights(hashC, this.quarter, resultHashs, resultWeights);
        }
        switch (this.quarter) {
            case 0: {
                assert (this.dX >= 0.0 && this.dY >= 0.0);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 - this.dX) * (1.0 - this.dY);
                resultHashs[1] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell - 1);
                resultWeights[1] = this.dX * this.dY;
                resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell);
                resultWeights[2] = this.dX * (1.0 - this.dY);
                resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell - 1);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                break;
            }
            case 1: {
                assert (this.dX < 0.0 && this.dY >= 0.0);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 + this.dX) * (1.0 - this.dY);
                resultHashs[1] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell - 1);
                resultWeights[1] = -this.dX * this.dY;
                resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell);
                resultWeights[2] = -this.dX * (1.0 - this.dY);
                resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell - 1);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                break;
            }
            case 2: {
                assert (this.dX >= 0.0 && this.dY < 0.0);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 - this.dX) * (1.0 + this.dY);
                resultHashs[1] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell + 1);
                resultWeights[1] = -this.dX * this.dY;
                resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell - 1, this.jInBaseCell);
                resultWeights[2] = this.dX * (1.0 + this.dY);
                resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell + 1);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                break;
            }
            case 3: {
                assert (this.dX < 0.0 && this.dY < 0.0);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 + this.dX) * (1.0 + this.dY);
                resultHashs[1] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell + 1);
                resultWeights[1] = this.dX * this.dY;
                resultHashs[2] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell + 1, this.jInBaseCell);
                resultWeights[2] = this.dX * (1.0 + this.dY);
                resultHashs[3] = this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell + 1);
                resultWeights[3] = (1.0 + this.dX) * this.dY;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return 4;
    }

    private int computeHashsAndWeights(long hashC, int quarter, long[] resultHashs, double[] resultWeights) {
        switch (quarter) {
            case 0: {
                assert (this.dX >= 0.0 && this.dY >= 0.0);
                this.hns.neighbours(hashC, EnumSet.of(CompassPoint.MainWind.S, CompassPoint.MainWind.SE, CompassPoint.MainWind.SW), this.neigList);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 - this.dX) * (1.0 - this.dY);
                resultHashs[1] = this.neigList.get(CompassPoint.MainWind.S);
                resultWeights[1] = this.dX * this.dY;
                resultHashs[2] = this.neigList.get(CompassPoint.MainWind.SW);
                resultWeights[2] = this.dX * (1.0 - this.dY);
                resultHashs[3] = this.neigList.get(CompassPoint.MainWind.SE);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                break;
            }
            case 1: {
                assert (this.dX < 0.0 && this.dY >= 0.0);
                this.hns.neighbours(hashC, EnumSet.of(CompassPoint.MainWind.E, CompassPoint.MainWind.SE, CompassPoint.MainWind.SW), this.neigList);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 + this.dX) * (1.0 - this.dY);
                resultHashs[1] = this.neigList.get(CompassPoint.MainWind.E);
                resultWeights[1] = -this.dX * this.dY;
                resultHashs[2] = this.neigList.get(CompassPoint.MainWind.NE);
                resultWeights[2] = -this.dX * (1.0 - this.dY);
                resultHashs[3] = this.neigList.get(CompassPoint.MainWind.SE);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                break;
            }
            case 2: {
                assert (this.dX >= 0.0 && this.dY < 0.0);
                this.hns.neighbours(hashC, EnumSet.of(CompassPoint.MainWind.W, CompassPoint.MainWind.SW, CompassPoint.MainWind.NW), this.neigList);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 - this.dX) * (1.0 + this.dY);
                resultHashs[1] = this.neigList.get(CompassPoint.MainWind.W);
                resultWeights[1] = -this.dX * this.dY;
                resultHashs[2] = this.neigList.get(CompassPoint.MainWind.SW);
                resultWeights[2] = this.dX * (1.0 + this.dY);
                resultHashs[3] = this.neigList.get(CompassPoint.MainWind.NW);
                resultWeights[3] = (1.0 - this.dX) * this.dY;
                break;
            }
            case 3: {
                assert (this.dX < 0.0 && this.dY < 0.0);
                this.hns.neighbours(hashC, EnumSet.of(CompassPoint.MainWind.N, CompassPoint.MainWind.NE, CompassPoint.MainWind.NW), this.neigList);
                resultHashs[0] = hashC;
                resultWeights[0] = (1.0 + this.dX) * (1.0 + this.dY);
                resultHashs[1] = this.neigList.get(CompassPoint.MainWind.N);
                resultWeights[1] = this.dX * this.dY;
                resultHashs[2] = this.neigList.get(CompassPoint.MainWind.NE);
                resultWeights[2] = this.dX * (1.0 + this.dY);
                resultHashs[3] = this.neigList.get(CompassPoint.MainWind.NW);
                resultWeights[3] = (1.0 + this.dX) * this.dY;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.neigList.clear();
        return 4;
    }

    private boolean isInBaseCellBorderFromBits(long iInBaseCell, long jInBaseCell) {
        return 0L == iInBaseCell || iInBaseCell == (long)this.h.nsideRemainderMask || 0L == jInBaseCell || jInBaseCell == (long)this.h.nsideRemainderMask;
    }

    private void project(double lon, double lat) {
        this.proj.project(lon, lat, this.xy);
        this.x = this.xy[0];
        assert (-8.0 < this.x && this.x < 8.0);
        this.y = this.xy[1];
        assert (-2.0 <= this.y && this.y <= 2.0);
        if (this.x < 0.0) {
            this.x += 8.0;
        }
        assert (0.0 <= this.x && this.x < 8.0);
    }

    private void shiftAndRotateAndScale() {
        this.y += 1.0;
        double tmp = this.x;
        this.x += this.y;
        this.y -= tmp;
        this.y += 8.0;
        this.x = this.h.timeHalfNsideP(this.x);
        this.y = this.h.timeHalfNsideP(this.y);
        assert (0.0 <= this.x && this.x <= 5.000000000000001 * (double)this.h.nside) : this.x;
        assert (0.0 <= this.y && this.y <= 5.000000000000001 * (double)this.h.nside) : this.y;
    }

    private void discretize() {
        this.xInt = HackersDelight.floorLongP(this.x);
        assert (0L <= this.xInt && this.xInt <= (long)(5 * this.h.nside)) : this.xInt + " <= " + 4 * this.h.nside;
        this.yInt = HackersDelight.floorLongP(this.y);
        assert (0L <= this.yInt && this.yInt <= (long)(5 * this.h.nside)) : this.yInt + " <= " + 4 * this.h.nside;
    }

    private void computeQuarter() {
        this.cellCenterX = (double)this.xInt + 0.5;
        this.cellCenterY = (double)this.yInt + 0.5;
        this.dX = this.cellCenterX - this.x;
        this.dY = this.cellCenterY - this.y;
        this.quarter = (int)(HackersDelight.toBits(this.dX) >> 63);
        assert (this.x >= this.cellCenterX && this.quarter == 1 || this.x < this.cellCenterX && this.quarter == 0);
        this.quarter |= (int)(HackersDelight.toBits(this.dY) >> 62);
        assert (this.y >= this.cellCenterY && (this.quarter | 2) == 2 || this.y < this.cellCenterY && (this.quarter | 2) == 0);
        assert (this.quarter >= 0 && this.quarter < 4);
    }

    private void computeBaseCellCoos() {
        this.iBaseCell = this.h.dividedByNsideQuotient(this.xInt);
        assert (0 <= this.iBaseCell && this.iBaseCell <= 5);
        this.jBaseCell = this.h.dividedByNsideQuotient(this.yInt);
        assert (0 <= this.jBaseCell && this.jBaseCell <= 5) : this.jBaseCell;
    }

    private void computeCoosInBaseCell() {
        this.iInBaseCell = this.h.moduloNside(this.xInt);
        assert (0 <= this.iInBaseCell && this.iInBaseCell < this.h.nside);
        this.jInBaseCell = this.h.moduloNside(this.yInt);
        assert (0 <= this.jInBaseCell && this.jInBaseCell < this.h.nside);
    }

    private void computeBaseCellHashBits() {
        this.jBaseCell = 5 - (this.iBaseCell + this.jBaseCell);
        if (this.jBaseCell >= 0) {
            assert (this.jBaseCell <= 2);
            this.baseCellBits = (long)((this.jBaseCell << 2) + (this.iBaseCell - (--this.jBaseCell >>> 63) & 3)) << this.h.twiceDepth;
        } else if (this.jBaseCell == -1) {
            this.baseCellBits = (long)(this.iBaseCell - 1 & 3) << this.h.twiceDepth | this.h.yMask;
        } else if (this.jBaseCell == -2) {
            this.baseCellBits = (long)(this.iBaseCell - 2) << this.h.twiceDepth | this.h.xyMask;
        } else assert (false);
    }
}

