/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.HashComputer;
import cds.healpix.HealpixNested;
import cds.healpix.HealpixProjector;
import cds.healpix.common.math.HackersDelight;

final class HealpixNestedHashComputer
implements HashComputer {
    private final HealpixNested h;
    private final HealpixProjector proj = new HealpixProjector();
    private double[] xy = new double[2];
    private double x;
    private double y;
    private long xInt;
    private long yInt;
    private int iBaseCell;
    private int jBaseCell;
    private int iInBaseCell;
    private int jInBaseCell;
    private long baseCellBits;

    HealpixNestedHashComputer(HealpixNested healpixNested) {
        this.h = healpixNested;
    }

    @Override
    public int depth() {
        return this.h.depth;
    }

    @Override
    public long hash(double lonRad, double latRad) {
        this.project(lonRad, latRad);
        this.shiftAndRotateAndScale();
        this.discretize();
        this.computeBaseCellCoos();
        this.computeCoosInBaseCell();
        this.computeBaseCellHashBits();
        return this.baseCellBits | this.h.fc.ij2hash(this.iInBaseCell, this.jInBaseCell);
    }

    private void project(double lon, double lat) {
        this.proj.project(lon, lat, this.xy);
        this.x = this.xy[0];
        assert (-8.0 < this.x && this.x < 8.0);
        this.y = this.xy[1];
        assert (-2.0 <= this.y && this.y <= 2.0);
        if (this.x < 0.0) {
            this.x += 8.0;
        }
        assert (0.0 <= this.x && this.x < 8.0);
    }

    private void shiftAndRotateAndScale() {
        this.y += 1.0;
        double tmp = this.x;
        this.x += this.y;
        this.y -= tmp;
        this.y += 8.0;
        this.x = this.h.timeHalfNsideP(this.x);
        this.y = this.h.timeHalfNsideP(this.y);
        assert (0.0 <= this.x && this.x <= 5.000000000000001 * (double)this.h.nside) : this.x;
        assert (0.0 <= this.y && this.y <= 5.000000000000001 * (double)this.h.nside) : this.y;
    }

    private void discretize() {
        this.xInt = HackersDelight.floorLongP(this.x);
        assert (0L <= this.xInt && this.xInt <= 5L * (long)this.h.nside) : this.xInt + " <= " + 4L * (long)this.h.nside;
        this.yInt = HackersDelight.floorLongP(this.y);
        assert (0L <= this.yInt && this.yInt <= 5L * (long)this.h.nside) : this.yInt + " <= " + 4L * (long)this.h.nside;
    }

    private void computeBaseCellCoos() {
        this.iBaseCell = this.h.dividedByNsideQuotient(this.xInt);
        assert (0 <= this.iBaseCell && this.iBaseCell <= 5);
        this.jBaseCell = this.h.dividedByNsideQuotient(this.yInt);
        assert (0 <= this.jBaseCell && this.jBaseCell <= 5) : this.jBaseCell;
    }

    private void computeCoosInBaseCell() {
        this.iInBaseCell = this.h.moduloNside(this.xInt);
        assert (0 <= this.iInBaseCell && this.iInBaseCell < this.h.nside);
        this.jInBaseCell = this.h.moduloNside(this.yInt);
        assert (0 <= this.jInBaseCell && this.jInBaseCell < this.h.nside);
    }

    private void computeBaseCellHashBits() {
        this.jBaseCell = 5 - (this.iBaseCell + this.jBaseCell);
        if (this.jBaseCell >= 0) {
            assert (this.jBaseCell <= 2);
            this.baseCellBits = (long)((this.jBaseCell << 2) + (this.iBaseCell - (--this.jBaseCell >>> 63) & 3)) << this.h.twiceDepth;
        } else if (this.jBaseCell == -1) {
            this.baseCellBits = (long)(this.iBaseCell - 1 & 3) << this.h.twiceDepth | this.h.yMask;
        } else if (this.jBaseCell == -2) {
            this.baseCellBits = (long)(this.iBaseCell - 2) << this.h.twiceDepth | this.h.xyMask;
        } else assert (false);
    }
}

