/*
 * Decompiled with CFR 0.152.
 */
package cds.fits;

import cds.aladin.MyInputStream;
import cds.fits.HeaderFits;
import cds.image.Hdecomp;
import cds.tools.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;

public class UtilFits {
    static final int NOCOMPRESS = 0;
    static final int RICE1 = 1;
    static final int RICEONE = 2;
    static final int GZIP1 = 3;
    static final int GZIP2 = 4;
    static final int HCOMPRESS1 = 5;
    static final int PLIO1 = 6;
    static final String[] ZCMPTYPE = new String[]{"NOCOMPRESS", "RICE_1", "RICE_ONE", "GZIP_1", "GZIP_2", "HCOMPRESS_1", "PLIO_1"};
    private static String[] KEYIGNORE = new String[]{"TFIELDS", "TFIELDS", "TTYPE1", "TFORM1", "ZIMAGE", "ZTILE1", "ZTILE2", "ZCMPTYPE", "ZNAME1", "ZVAL1", "ZNAME2", "ZVAL2", "ZSIMPLE", "ZBITPIX", "ZNAXIS", "ZNAXIS1", "ZNAXIS2", "ZEXTEND", "ZPCOUNT", "ZGCOUNT", "ZTENSION"};
    private static final long MASK = 0xFFFFFFFFL;
    private static final int[] nonzero_count = new int[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};

    public static byte[] uncompress(HeaderFits headerFits, MyInputStream dis) throws Exception {
        return UtilFits.uncompress(null, headerFits, dis, false);
    }

    public static byte[] uncompress(HeaderFits outHeader, HeaderFits inHeader, MyInputStream dis, boolean flagSkip) throws Exception {
        int n;
        int bitpix;
        if (inHeader == null) {
            inHeader = new HeaderFits(dis);
        } else if (inHeader.isEmpty()) {
            inHeader.readHeader(dis);
        }
        int nnaxis1 = inHeader.getIntFromHeader("NAXIS1");
        int nnaxis2 = inHeader.getIntFromHeader("NAXIS2");
        int theap = nnaxis1 * nnaxis2;
        try {
            theap = inHeader.getIntFromHeader("THEAP");
        }
        catch (Exception e) {
            // empty catch block
        }
        int pcount = inHeader.getIntFromHeader("PCOUNT");
        if (flagSkip) {
            dis.skip(theap + pcount);
            return new byte[0];
        }
        try {
            bitpix = inHeader.getIntFromHeader("ZBITPIX");
        }
        catch (Exception e) {
            System.err.println("Not a compressed image in this HDU => return as is");
            if (outHeader != null) {
                inHeader.copyTo(outHeader);
            }
            byte[] buf = new byte[theap + pcount];
            dis.readFully(buf);
            return buf;
        }
        int naxis1 = inHeader.getIntFromHeader("ZNAXIS1");
        int naxis2 = inHeader.getIntFromHeader("ZNAXIS2");
        int npix = n = Math.abs(bitpix) / 8;
        int taille = naxis1 * naxis2 * n;
        String sCmp = inHeader.getStringFromHeader("ZCMPTYPE");
        int nCmp = Util.indexInArrayOf(sCmp, ZCMPTYPE);
        if (nCmp < 0) {
            throw new Exception("Unknown FITS compression method [" + sCmp + "]");
        }
        if (nCmp == 6) {
            throw new Exception("Unsupported FITS compression method [" + sCmp + "]");
        }
        if (nCmp == 5) {
            throw new Exception("Unsupported FITS compression method [" + sCmp + "]");
        }
        int tile1 = naxis1;
        try {
            tile1 = inHeader.getIntFromHeader("ZTILE1");
        }
        catch (Exception e) {
            // empty catch block
        }
        int tile2 = 1;
        try {
            tile2 = inHeader.getIntFromHeader("ZTILE2");
        }
        catch (Exception e) {
            // empty catch block
        }
        int val1 = 32;
        try {
            val1 = inHeader.getIntFromHeader("ZVAL1");
        }
        catch (Exception e) {
            // empty catch block
        }
        int val2 = 4;
        try {
            val2 = inHeader.getIntFromHeader("ZVAL2");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String quantiz = inHeader.getStringFromHeader("ZQUANTIZ");
        }
        catch (Exception e) {
            // empty catch block
        }
        int posCompress = 0;
        int posgzipCompress = -1;
        int posUncompress = -1;
        int posZscale = -1;
        int posZzero = -1;
        int sForm = 32;
        int tfields = inHeader.getIntFromHeader("TFIELDS");
        int pos = 0;
        for (int i = 1; i <= tfields; ++i) {
            String type = inHeader.getStringFromHeader("TTYPE" + i);
            if (type.equals("COMPRESSED_DATA")) {
                posCompress = pos;
                sForm = 66;
            } else if (type.equals("GZIP_COMPRESSED_DATA")) {
                posgzipCompress = pos;
                sForm = 66;
            } else if (type.equals("UNCOMPRESSED_DATA")) {
                posUncompress = pos;
                sForm = 66;
            } else if (type.equals("ZSCALE")) {
                posZscale = pos;
                sForm = 68;
            } else if (type.equals("ZZERO")) {
                posZzero = pos;
                sForm = 68;
            }
            String form = inHeader.getStringFromHeader("TFORM" + i);
            pos += Util.binSizeOf(form);
        }
        if (posUncompress >= 0) {
            System.err.println(sCmp + " FITS image warning (deprecated UNCOMPRESSED_DATA field)");
        }
        byte[] pixelsOrigin = new byte[taille];
        byte[] table = new byte[nnaxis1 * nnaxis2];
        byte[] heap = new byte[pcount];
        try {
            dis.readFully(table);
            dis.skip(theap - nnaxis1 * nnaxis2);
            dis.readFully(heap);
            int nbTileInWidth = naxis1 / tile1;
            if (naxis1 % tile1 != 0) {
                ++nbTileInWidth;
            }
            int pixPos = 0;
            for (int numTile = 0; numTile < nnaxis2; ++numTile) {
                byte[] tile;
                int offsetRec = numTile * nnaxis1;
                int size = UtilFits.getInt(table, offsetRec + posCompress);
                int pos2 = UtilFits.getInt(table, offsetRec + posCompress + 4);
                double bzero = posZzero < 0 ? 0.0 : UtilFits.getDouble(table, offsetRec + posZzero);
                double bscale = posZscale < 0 ? 1.0 : UtilFits.getDouble(table, offsetRec + posZscale);
                int nbRowOfTiles = numTile / nbTileInWidth;
                int nbTileInCurrentRow = numTile % nbTileInWidth;
                pixPos = nbRowOfTiles * tile2 * naxis1 + nbTileInCurrentRow * tile1;
                if (size == 0 && posgzipCompress >= 0) {
                    size = UtilFits.getInt(table, offsetRec + posgzipCompress);
                    pos2 = UtilFits.getInt(table, offsetRec + posgzipCompress + 4);
                    tile = UtilFits.gunzip(heap, pos2, size);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (size == 0 && posUncompress >= 0) {
                    size = UtilFits.getInt(table, offsetRec + posUncompress);
                    pos2 = UtilFits.getInt(table, offsetRec + posUncompress + 4);
                    tile = new byte[size];
                    System.arraycopy(heap, pos2, tile, 0, size);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 1 || nCmp == 2) {
                    if (tile1 == naxis1 && tile2 == 1) {
                        UtilFits.decompRice(heap, pos2, pixelsOrigin, pixPos, tile1 * tile2, val1, val2, bitpix, bzero, bscale);
                        continue;
                    }
                    tile = new byte[tile1 * tile2 * npix];
                    UtilFits.decompRice(heap, pos2, tile, 0, tile1 * tile2, val1, val2, bitpix, 0.0, 1.0);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 3) {
                    tile = UtilFits.decompGzip1(heap, pos2, size);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 4) {
                    tile = UtilFits.decompGzip2(heap, pos2, size, bitpix);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp == 5) {
                    tile = UtilFits.decompHcomp(heap, pos2, size, bitpix);
                    UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
                    continue;
                }
                if (nCmp != 0) continue;
                tile = new byte[tile1 * tile2 * npix];
                System.arraycopy(heap, pos2, tile, 0, tile.length);
                UtilFits.copyTile(tile, tile1, tile2, pixelsOrigin, pixPos, naxis1, naxis2, bitpix, bzero, bscale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (outHeader != null) {
            Hashtable<String, String> map = inHeader.getHashHeader();
            Enumeration<String> e = inHeader.getKeys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (Util.indexInArrayOf(key, KEYIGNORE) >= 0) continue;
                String val = key.equals("XTENSION") ? "IMAGE" : (key.equals("BITPIX") ? bitpix + "" : (key.equals("NAXIS1") ? naxis1 + "" : (key.equals("NAXIS2") ? naxis2 + "" : (key.equals("NAXIS") ? "2" : (key.equals("PCOUNT") ? "0" : (key.equals("GCOUNT") ? "1" : map.get(key)))))));
                outHeader.setKeyValue(key, val);
            }
        }
        return pixelsOrigin;
    }

    private static byte[] decompGzip1(byte[] buf, int pos, int size) throws Exception {
        return UtilFits.gunzip(buf, pos, size);
    }

    private static byte[] decompGzip2(byte[] buf, int pos, int size, int bitpix) throws Exception {
        byte[] b = UtilFits.gunzip(buf, pos, size);
        int nbyte = Math.abs(bitpix) / 8;
        int n = b.length / nbyte;
        byte[] c = new byte[b.length];
        int k = 0;
        for (int j = 0; j < n; ++j) {
            for (int i = 0; i < nbyte; ++i) {
                c[k++] = b[i * n + j];
            }
        }
        return c;
    }

    private static byte[] decompHcomp(byte[] buf, int pos, int size, int bitpix) throws Exception {
        ByteArrayInputStream bytein = new ByteArrayInputStream(buf, pos, size);
        return Hdecomp.decomp(bytein);
    }

    public static byte[] gunzip(byte[] buf, int pos, int size) throws Exception {
        ByteArrayInputStream bytein = new ByteArrayInputStream(buf, pos, size);
        GZIPInputStream gzin = new GZIPInputStream(bytein);
        ByteArrayOutputStream byteout = new ByteArrayOutputStream();
        int res = 0;
        byte[] tmp = new byte[1024];
        while (res >= 0) {
            res = gzin.read(tmp, 0, tmp.length);
            if (res <= 0) continue;
            byteout.write(tmp, 0, res);
        }
        return byteout.toByteArray();
    }

    public static void decompRice(byte[] buf, int pos, byte[] array, int offset, int tileSize, int nblock, int bsize, int bitpix, double bzero, double bscale) throws Exception {
        int i;
        int fsmax;
        int fsbits;
        switch (bsize) {
            case 1: {
                fsbits = 3;
                fsmax = 6;
                break;
            }
            case 2: {
                fsbits = 4;
                fsmax = 14;
                break;
            }
            case 4: {
                fsbits = 5;
                fsmax = 25;
                break;
            }
            default: {
                throw new Exception("RICE FITS decompRice error: bitpix must be 8, 16 or 32");
            }
        }
        int bbits = 1 << fsbits;
        int lastpix = 0;
        for (i = 0; i < bsize; ++i) {
            int bytevalue = 0xFF & buf[pos++];
            lastpix = lastpix << 8 | bytevalue;
        }
        int b = 0xFF & buf[pos++];
        int nbits = 8;
        i = 0;
        while (i < tileSize) {
            int diff;
            nbits -= fsbits;
            while (nbits < 0) {
                b = b << 8 | 0xFF & buf[pos++];
                nbits += 8;
            }
            int fs = (b >>> nbits) - 1;
            b &= (1 << nbits) - 1;
            int imax = i + nblock;
            if (imax > tileSize) {
                imax = tileSize;
            }
            if (fs < 0) {
                while (i < imax) {
                    UtilFits.setPixVal(array, bitpix, i + offset, (double)lastpix * bscale + bzero);
                    ++i;
                }
                continue;
            }
            if (fs == fsmax) {
                while (i < imax) {
                    int k = bbits - nbits;
                    diff = b << k;
                    k -= 8;
                    while (k >= 0) {
                        b = 0xFF & buf[pos++];
                        diff |= b << k;
                        k -= 8;
                    }
                    if (nbits > 0) {
                        b = 0xFF & buf[pos++];
                        diff |= b >>> -k;
                        b &= (1 << nbits) - 1;
                    } else {
                        b = 0;
                    }
                    diff = (diff & 1) == 0 ? (diff >>>= 1) : ~(diff >>> 1);
                    lastpix = diff + lastpix;
                    UtilFits.setPixVal(array, bitpix, i + offset, (double)lastpix * bscale + bzero);
                    ++i;
                }
                continue;
            }
            while (i < imax) {
                while (b == 0) {
                    nbits += 8;
                    b = 0xFF & buf[pos++];
                }
                int nzero = nbits - nonzero_count[b];
                b ^= 1 << (nbits -= nzero + 1);
                nbits -= fs;
                while (nbits < 0) {
                    b = b << 8 | 0xFF & buf[pos++];
                    nbits += 8;
                }
                diff = nzero << fs | b >>> nbits;
                b &= (1 << nbits) - 1;
                diff = (diff & 1) == 0 ? (diff >>>= 1) : ~(diff >>> 1);
                lastpix = diff + lastpix;
                UtilFits.setPixVal(array, bitpix, i + offset, (double)lastpix * bscale + bzero);
                ++i;
            }
        }
    }

    private static void copyTile(byte[] tile, int tileWidth, int tileHeight, byte[] pix, int pixPos, int width, int height, int bitpix, double bzero, double bscale) throws Exception {
        boolean flagScale;
        boolean bl = flagScale = bscale != 1.0 || bzero != 0.0;
        if (!flagScale) {
            int npix = Math.abs(bitpix) / 8;
            if (tileWidth == width) {
                System.arraycopy(tile, 0, pix, pixPos * npix, tileWidth * tileHeight * npix);
                return;
            }
            for (int y = 0; y < tileHeight; ++y) {
                int src = y * tileWidth;
                int trg = (pixPos + y * width) * npix;
                System.arraycopy(tile, src, pix, trg, tileWidth * npix);
            }
            return;
        }
        for (int y = 0; y < tileHeight; ++y) {
            for (int x = 0; x < tileWidth; ++x) {
                double val = UtilFits.getPixVal1(tile, bitpix, y * tileWidth + x);
                val = val * bscale + bzero;
                UtilFits.setPixVal(pix, bitpix, pixPos + y * width + x, val);
            }
        }
    }

    public static final int getByte(byte[] t, int i) {
        return t[i] & 0xFF;
    }

    public static final int getShort(byte[] t, int i) {
        return t[i] << 8 | t[i + 1] & 0xFF;
    }

    public static final int getInt(byte[] t, int i) {
        return t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF;
    }

    public static final long getLong(byte[] t, int i) {
        return (long)(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL;
    }

    public static final double getFloat(byte[] t, int i) {
        return Float.intBitsToFloat(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF);
    }

    public static final double getDouble(byte[] t, int i) {
        long a = (long)(t[i] << 24 | (t[i + 1] & 0xFF) << 16 | (t[i + 2] & 0xFF) << 8 | t[i + 3] & 0xFF) << 32 | (long)(t[i + 4] << 24 | (t[i + 5] & 0xFF) << 16 | (t[i + 6] & 0xFF) << 8 | t[i + 7] & 0xFF) & 0xFFFFFFFFL;
        return Double.longBitsToDouble(a);
    }

    public static final double getPixVal1(byte[] t, int bitpix, int i) {
        try {
            switch (bitpix) {
                case 8: {
                    return UtilFits.getByte(t, i);
                }
                case 16: {
                    return UtilFits.getShort(t, i * 2);
                }
                case 32: {
                    return UtilFits.getInt(t, i * 4);
                }
                case 64: {
                    return UtilFits.getLong(t, i * 8);
                }
                case -32: {
                    return UtilFits.getFloat(t, i * 4);
                }
                case -64: {
                    return UtilFits.getDouble(t, i * 8);
                }
            }
            return Double.NaN;
        }
        catch (Exception e) {
            return Double.NaN;
        }
    }

    public static final void setInt(byte[] t, int i, int val) {
        t[i] = (byte)(0xFF & val >>> 24);
        t[i + 1] = (byte)(0xFF & val >>> 16);
        t[i + 2] = (byte)(0xFF & val >>> 8);
        t[i + 3] = (byte)(0xFF & val);
    }

    public static final void setPixVal(byte[] t, int bitpix, int i, double val) {
        switch (bitpix) {
            case 8: {
                t[i] = (byte)(0xFF & (int)val);
                break;
            }
            case 16: {
                int c = (int)val;
                t[i *= 2] = (byte)(0xFF & c >>> 8);
                t[i + 1] = (byte)(0xFF & c);
                break;
            }
            case 32: {
                UtilFits.setInt(t, i *= 4, (int)val);
                break;
            }
            case 64: {
                long c1 = (long)val;
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                UtilFits.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                UtilFits.setInt(t, i + 4, c);
                break;
            }
            case -32: {
                int c = Float.floatToIntBits((float)val);
                UtilFits.setInt(t, i *= 4, c);
                break;
            }
            case -64: {
                long c1 = Double.doubleToLongBits(val);
                int c = (int)(0xFFFFFFFFL & c1 >>> 32);
                UtilFits.setInt(t, i *= 8, c);
                c = (int)(0xFFFFFFFFL & c1);
                UtilFits.setInt(t, i + 4, c);
            }
        }
    }
}

