/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.Qbox;
import cds.astro.Region;

public class ZonalRegion
extends Region {
    Astroframe frame;
    double lon0;
    double lon1;
    double dlon;
    double lat0;
    double lat1;
    double[][] R;
    double zmin;
    double zmax;
    double smax;
    double xmin;
    double ymax;
    double tmax;

    private void set_zone(double lon0, double lon1, double lat0, double lat1) {
        int i;
        if (DEBUG) {
            System.out.println("#...new Zone(" + lon0 + ".." + lon1 + ", " + lat0 + ".." + lat1 + ")[" + this.frame + "]");
        }
        this.lon0 = lon0;
        this.lon1 = lon1;
        if (lat0 > lat1) {
            this.lat0 = lat1;
            this.lat1 = lat0;
        } else {
            this.lat0 = lat0;
            this.lat1 = lat1;
        }
        double clat = 0.5 * (lat0 + lat1);
        double clon = 0.5 * (lon0 + lon1);
        if (lon0 > lon1) {
            clon += 180.0;
        }
        this.centroid = new Coo(clon, clat);
        Coo[] v3 = new Coo[4];
        this.minrad = 180.0;
        this.maxrad = 0.0;
        v3[0] = new Coo(lon0, lat0);
        v3[1] = new Coo(lon0, lat1);
        v3[2] = new Coo(clon, lat0);
        v3[3] = new Coo(clon, lat1);
        double r = this.centroid.distc(v3[0], v3[1]);
        if (r < this.minrad) {
            this.minrad = r;
        }
        if (r > this.maxrad) {
            this.maxrad = r;
        }
        for (i = 0; i < 4; ++i) {
            r = this.centroid.distance(v3[i]);
            if (r < this.minrad) {
                this.minrad = r;
            }
            if (!(r > this.maxrad)) continue;
            this.maxrad = r;
        }
        if (DEBUG) {
            System.out.println("#   min/max radius = " + this.minrad + "/" + this.maxrad);
        }
        v3[0] = new Coo(clon, 0.0);
        v3[1] = new Coo(clon + 90.0, 0.0);
        v3[2] = new Coo(0.0, 90.0);
        if (this.frame != null) {
            for (i = 0; i < 3; ++i) {
                this.frame.toICRS(v3[i]);
            }
            this.frame.toICRS(this.centroid);
        }
        this.R = new double[3][3];
        for (i = 0; i < 3; ++i) {
            this.R[i][0] = v3[i].x;
            this.R[i][1] = v3[i].y;
            this.R[i][2] = v3[i].z;
        }
        this.dlon = lon1 - lon0;
        if (this.dlon < 0.0) {
            this.dlon += 360.0;
        }
        if (this.dlon > 360.0) {
            System.err.println("#+++Zone(lon=" + lon0 + "," + lon1 + ") lon.range reduced to +/-180deg");
            this.dlon = 360.0;
        }
        this.dlon /= 2.0;
        this.xmin = AstroMath.cosd(this.dlon);
        this.ymax = AstroMath.sind(this.dlon);
        this.tmax = AstroMath.tand(this.dlon / 2.0);
        this.zmin = AstroMath.sind(lat0);
        this.zmax = AstroMath.sind(lat1);
        this.smax = Math.abs(this.zmin);
        double az = Math.abs(this.zmax);
        if (az > this.smax) {
            this.smax = az;
        }
        this.smax = 1.0 / Math.sqrt(1.0 - this.smax * this.smax);
        if (DEBUG) {
            System.out.println(Coo.toString("Rotation matrix ", this.R));
            System.out.println("    xmin=" + this.xmin + ", ymax=" + this.ymax + ", tmax=" + this.tmax + "\n    smax=" + this.smax);
        }
    }

    ZonalRegion(Astroframe frame, double lon0, double lon1, double lat0, double lat1) {
        this.frame = frame;
        this.set_zone(lon0, lon1, lat0, lat1);
    }

    ZonalRegion(double lon0, double lon1, double lat0, double lat1) {
        this.frame = null;
        this.set_zone(lon0, lon1, lat0, lat1);
    }

    ZonalRegion(Astroframe frame, Coo center, double width, double height) {
        if (width > 360.0 || height > 180.0) {
            System.err.println("#+++Zone(" + center + ", dim=" + width + "/" + height + "): too large width/height!");
            if (width > 360.0) {
                width = 360.0;
            }
            if (height > 180.0) {
                height = 180.0;
            }
        }
        this.frame = frame;
        double w = width / 2.0;
        double h = height / 2.0;
        double lon = center.getLon();
        double lat = center.getLat();
        this.set_zone(lon - w, lon + w, lat - h, lat + h);
    }

    ZonalRegion(Coo center, double width, double height) {
        this(null, center, width, height);
    }

    @Override
    public final String toString() {
        StringBuffer b = new StringBuffer();
        if (this.R == null) {
            b.append("*INVALID*");
        }
        b.append("Zone");
        if (this.frame != null) {
            b.append("[" + this.frame + "]");
        }
        b.append("(" + this.centroid + ", " + 2.0 * this.dlon + "x" + (this.lat1 - this.lat0) + ")");
        return b.toString();
    }

    @Override
    public final double area() {
        if (this.centroid == null) {
            return Double.NaN;
        }
        return 57.29577951308232 * (this.zmax - this.zmin) * 2.0 * this.dlon;
    }

    @Override
    public boolean checkCoo(Coo point) {
        if (this.R == null) {
            return false;
        }
        if (DEBUG) {
            System.out.println("#...Zone.checkCoo(" + point + ")");
        }
        double[] v = new double[]{point.x, point.y, point.z};
        Coo.rotateVector(this.R, v);
        if (v[2] >= this.zmin && v[2] <= this.zmax) {
            if (v[0] >= this.xmin) {
                return true;
            }
            double cos2b = v[0] * v[0] + v[1] * v[1];
            if (this.xmin > 0.707) {
                return v[1] * v[1] <= this.ymax * this.ymax * cos2b;
            }
            return v[0] >= this.xmin * Math.sqrt(cos2b);
        }
        return false;
    }

    private boolean intersects(double[] u0, double[] u1) {
        double y;
        double x;
        double cosb;
        double z;
        int i;
        double s = Coo.dotprod(u0, u1);
        double[] v = new double[3];
        Coo.vecprod(u0, u1, v);
        for (i = 0; i < 2; ++i) {
            z = i == 0 ? this.zmin : this.zmax;
            cosb = Math.sqrt(1.0 - z * z);
            double A = cosb * v[0];
            double B = cosb * v[1];
            double C = z * v[2];
            double D = A * A + B * B - C * C;
            if (DEBUG) {
                Coo c1 = new Coo(u0[0], u0[1], u0[2]);
                Coo c2 = new Coo(u1[0], u1[1], u1[2]);
                System.out.println("#...inter(z=" + z + ") " + c1 + "->" + c2 + " : " + (D >= 0.0));
            }
            if (D < 0.0) continue;
            if (this.dlon >= 180.0) {
                return true;
            }
            double[] t = new double[2];
            int nt = 1;
            double den = C - A;
            if (den == 0.0) {
                t[0] = A / B;
            } else {
                D = Math.sqrt(D);
                t[0] = (-B - D) / den;
                t[1] = (-B + D) / den;
                nt = 2;
            }
            if (DEBUG) {
                System.out.println("#      tmax=" + this.tmax + ": " + nt + "solutions: " + t[0] + "," + t[1]);
            }
            while (--nt >= 0) {
                if (Math.abs(t[nt]) > this.tmax || !((x = cosb * (1.0 - t[nt] * t[nt]) / (den = 1.0 + t[nt] * t[nt])) * u0[0] + (y = cosb * (2.0 * t[nt]) / den) * u0[1] + z * u0[2] >= s) || !(x * u1[0] + y * u1[1] + z * u1[2] >= s)) continue;
                return true;
            }
        }
        if (this.dlon >= 180.0) {
            return false;
        }
        double num1 = -this.xmin * v[0] / v[2];
        double num2 = -this.ymax * v[1] / v[2];
        if (DEBUG) {
            Coo c1 = new Coo(u0[0], u0[1], u0[2]);
            Coo c2 = new Coo(u1[0], u1[1], u1[2]);
            System.out.println("#...solutions(lon) in " + c1 + " -> " + c2 + " tanb=" + (num1 + num2) + "," + (num1 - num2));
        }
        for (i = 0; i < 2; ++i) {
            double tanb = i == 0 ? num1 + num2 : num1 - num2;
            z = tanb * (cosb = 1.0 / Math.sqrt(1.0 + tanb * tanb));
            if (!(z >= this.zmin) || !(z <= this.zmax)) continue;
            x = cosb * this.xmin;
            y = cosb * this.ymax;
            if (i > 0) {
                y = -y;
            }
            if (!(x * u0[0] + y * u0[1] + z * u0[2] >= s) || !(x * u1[0] + y * u1[1] + z * u1[2] >= s)) continue;
            return true;
        }
        return false;
    }

    int iCircle(Coo centre, double radius, boolean deep_check) {
        if (this.R == null) {
            return 0;
        }
        Coo c = new Coo(centre);
        if (DEBUG) {
            String type = deep_check ? "[deep]" : "[light]";
            System.out.println("#...Zone.checkCircle(" + c + ", r=" + radius + ")" + type);
        }
        c.rotate(this.R);
        double clat = c.getLat();
        if (clat - radius > this.lat1) {
            return 0;
        }
        if (clat + radius < this.lat0) {
            return 0;
        }
        if (this.dlon >= 180.0) {
            return clat + radius <= this.lat1 && clat - radius >= this.lat0 ? -1 : 1;
        }
        double clon = c.getLon();
        if (clon > 180.0) {
            clon -= 360.0;
        }
        if ((clon = Math.abs(clon)) > this.dlon + radius * this.smax) {
            return 0;
        }
        if (!deep_check) {
            return 1;
        }
        int nin = 0;
        Coo point = new Coo();
        double s2r = 2.0 * AstroMath.sind(radius / 2.0);
        s2r *= s2r;
        point.set(this.lat0, -clon);
        if (c.dist2(point) <= s2r) {
            ++nin;
        }
        point.set(point.x, -point.y, point.z);
        if (c.dist2(point) <= s2r) {
            ++nin;
        }
        point.set(this.lat1, -clon);
        if (c.dist2(point) <= s2r) {
            ++nin;
        }
        point.set(point.x, -point.y, point.z);
        if (c.dist2(point) <= s2r) {
            ++nin;
        }
        if (DEBUG) {
            System.out.println("#...circle(" + c + ") nin=" + nin);
        }
        if (nin == 4) {
            return 3;
        }
        if (nin != 0) {
            return 1;
        }
        double cosr = 1.0 - s2r / 2.0;
        double zext = c.z / cosr;
        if (Math.abs(zext) >= 1.0) {
            return 1;
        }
        double cosdl = cosr * Math.sqrt((1.0 - zext * zext) / (c.x * c.x + c.y * c.y));
        double dl = 90.0 - AstroMath.asind(cosdl);
        if (clon > this.dlon + dl) {
            return 0;
        }
        return c.z <= this.zmax && c.z >= this.zmin && clon < this.dlon ? -1 : 1;
    }

    @Override
    public int checkCircle(Coo centre, double radius) {
        return this.iCircle(centre, radius, true);
    }

    @Override
    public int checkQbox(int qbox) {
        if (this.centroid == null) {
            return 0;
        }
        Qbox abox = new Qbox();
        abox.set(qbox);
        int i = this.iCircle(abox.center(), Qbox.maxRadius(qbox), false);
        if (DEBUG) {
            System.out.println("#...................=" + i);
        }
        if (i < 1) {
            return i;
        }
        double[][] u4 = new double[5][3];
        Qbox.ucorners(abox.qbox, u4);
        int inside = 0;
        for (i = 0; i < 4; ++i) {
            Coo.rotateVector(this.R, u4[i]);
            if (DEBUG) {
                Coo c = new Coo(u4[i][0], u4[i][1], u4[i][2]);
                System.out.print("#   Corner#" + i + " = " + c);
                c.rotate_1(this.R);
                System.out.println(" (" + c + ")");
            }
            if (!(u4[i][2] >= this.zmin) || !(u4[i][2] <= this.zmax)) continue;
            if (u4[i][0] >= this.xmin) {
                ++inside;
                continue;
            }
            double cosb = Math.sqrt(u4[i][0] * u4[i][0] + u4[i][1] * u4[i][1]);
            if (!(u4[i][0] >= this.xmin * cosb)) continue;
            ++inside;
        }
        if (DEBUG) {
            System.out.println("#..." + abox + abox.center() + " (xmin=" + this.xmin + "): inside=" + inside);
        }
        if (inside > 0 && inside < 4) {
            return 1;
        }
        u4[4][0] = u4[0][0];
        u4[4][1] = u4[0][1];
        u4[4][2] = u4[0][2];
        for (i = 0; i < 4; ++i) {
            if (DEBUG) {
                Coo c1 = new Coo(u4[i][0], u4[i][1], u4[i][2]);
                Coo c2 = new Coo(u4[i + 1][0], u4[i + 1][1], u4[i + 1][2]);
                System.out.println("#...intersection " + c1 + " -> " + c2 + " = " + this.intersects(u4[i], u4[i + 1]));
            }
            if (!this.intersects(u4[i], u4[i + 1])) continue;
            return 1;
        }
        if (inside == 4) {
            return -1;
        }
        if (DEBUG) {
            System.out.println("#...DISJOINT/IS_PARTOF: " + (abox.inside(this.centroid) ? 3 : 0));
        }
        return abox.inside(this.centroid) ? 3 : 0;
    }
}

