/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrotime;
import cds.astro.Converter;
import cds.astro.Editing;
import cds.astro.Parsing;
import cds.astro.Udef;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class Unit {
    public double value;
    public String symbol;
    private long mksa;
    protected double factor;
    protected double offset;
    static final char[] x = "0123456789abcdef".toCharArray();
    static boolean initialized = false;
    static int DEBUG = 0;
    private static final byte _e0 = 48;
    private static final byte _m0 = 2;
    private static final long _1 = 0x230303030303030L;
    private static final long _LOG = -9151314442816847872L;
    private static final long _log = Long.MIN_VALUE;
    private static final long _mag = 0x100000000000000L;
    private static final long _MJD = 4769364993205350448L;
    private static final long _pic = 0x2000000000000000L;
    private static final long _sex = 0x1000000000000000L;
    private static final long _abs = 0x4000000000000000L;
    static final Editing editing = new Editing("-- ");
    private static Hashtable hUnit = new Hashtable(149);
    private static ArrayList aUnit = null;
    private static Hashtable hConv = new Hashtable(31);
    private static final String[] MKSA = new String[]{"mag", "kg", "m", "s", "A", "K", "cd", "mol"};
    private static final char[] MKSAdim = new char[]{'\u0000', 'M', 'L', 'T', 'A', 'K', '\u0000', '\u0000'};
    private static final String[] mul_symb = new String[]{"mu", "da", "k", "m", "c", "u", "M", "n", "G", "d", "h", "p", "T", "f", "P", "a", "E", "z", "Z", "y", "Y", "\u00b5"};
    private static final String[] mul_text = new String[]{"micro", "deca", "kilo", "milli", "centi", "micro", "mega", "nano", "giga", "deci", "hecto", "pico", "tera", "femto(10-15)", "peta(10+15)", "atto(10-18)", "exa(10+18)", "zepto(10-21)", "zetta(10+21)", "yocto(10-24)", "yotta(10+24)", "micro"};
    private static final int[] mul_fact = new int[]{-6, 1, 3, -3, -2, -6, 6, -9, 9, -1, 2, -12, 12, -15, 15, -18, 18, -21, 21, -24, 24, -6};
    private static final String[] op_symb = new String[]{"2", "3", "+", "-", "/", ".", "*", " "};
    private static final String[] op_text = new String[]{"square ", "cubic ", "power+", "power-", "per ", "times ", "times ", "times "};
    private static final String[] log_symb = new String[]{"log(", "log[", "[", "dex", "mag(", "mag["};
    private static final char[] log_end = new char[]{')', ']', ']', '\u0000', ')', ']'};
    private static final Udef[] uDef = new Udef[]{new Udef("---", "", 0x230303030303030L, 1.0), new Udef("%", "percent", 0x230303030303030L, 0.01), new Udef("h", "hour ", 157678974777962544L, 3600.0), new Udef("min", "minute ", 157678974777962544L, 60.0), new Udef("s", "second ", 157678974777962544L, 1.0), new Udef("mag", "magnitude ", 0x330303030303030L, 1.0), new Udef("Jy", "Jansky(10-26W/m2/Hz) ", 157960436869771312L, 1.0E-26), new Udef("deg", "degree ", 0x230303030303030L, 0.002777777777777778), new Udef("rad", "radian ", 0x230303030303030L, 0.15915494309189535), new Udef("sr", "steradian ", 0x230303030303030L, 0.07957747154594767), new Udef("arcmin", "minute of arc ", 0x230303030303030L, 4.6296296296296294E-5), new Udef("arcsec", "second of arc ", 0x230303030303030L, 7.71604938271605E-7), new Udef("mas", "milli-second of arc ", 0x230303030303030L, 7.716049382716049E-10), new Udef("uas", "micro-second of arc ", 0x230303030303030L, 7.71604938271605E-13), new Udef("Sun", "Solar unit ", 0x230303030303030L, 1.0), new Udef("Msun", "solar mass ", 157960445459705904L, 1.989E30), new Udef("solMass", "solar mass ", 157960445459705904L, 1.989E30), new Udef("Rsun", "solar radius ", 157680069994623024L, 6.9599E8), new Udef("solRad", "solar radius ", 157680069994623024L, 6.9599E8), new Udef("Lsun", "solar luminosity ", 157962631598059568L, 3.826E26), new Udef("solLum", "solar luminosity ", 157962631598059568L, 3.826E26), new Udef("Mgeo", "Earth mass ", 157960445459705904L, 5.976E24), new Udef("geoMass", "Earth mass ", 157960445459705904L, 5.976E24), new Udef("Mjup", "Jupiter mass ", 157960445459705904L, 1.902E27), new Udef("jovMass", "Jupiter mass ", 157960445459705904L, 1.902E27), new Udef("m", "metre ", 157680069994623024L, 1.0), new Udef("Hz", "Herz ", 157678966188027952L, 1.0), new Udef("kg", "kilogram ", 157960445459705904L, 1.0), new Udef("g", "gram ", 157960445459705904L, 0.001), new Udef("K", "Kelvin ", 157678970483060784L, 1.0), new Udef("Pa", "Pascal ", 157959337358143536L, 1.0), new Udef("T", "Tesla ", 157960436852994096L, 1.0), new Udef("V", "Volt ", 157962631581282352L, 1.0), new Udef("W", "Watt ", 157962631598059568L, 1.0), new Udef("J", "Joule ", 157962635893026864L, 1.0), new Udef("eV", "electron-Volt ", 157962635893026864L, 1.602177E-19), new Udef("Ry", "Rydberg(13.6eV) ", 157962635893026864L, 2.1798948E-18), new Udef("yr", "year ", 157678974777962544L, 3.15576E7), new Udef("a", "year ", 157678974777962544L, 3.15576E7), new Udef("d", "day ", 157678974777962544L, 86400.0), new Udef("AU", "astronomical unit ", 157680069994623024L, 1.49598E11), new Udef("au", "astronomical unit ", 157680069994623024L, 1.49598E11), new Udef("pc", "parsec ", 157680069994623024L, 3.0857E16), new Udef("al", "light-year ", 157680069994623024L, 9.46053E15), new Udef("JD", "Julian Date ", 4769364993205350448L, 86400.0, -2.073600432E11), new Udef("pix", "pixel ", 0x230303030303030L, 1.0), new Udef("ct", "count ", 0x230303030303030L, 1.0), new Udef("ph", "photon ", 0x230303030303030L, 1.0), new Udef("A", "Ampere ", 157678970499772464L, 1.0), new Udef("barn", "barn(10-28m2) ", 0x230323030303030L, 1.0E-28), new Udef("bit", "binary information unit ", 0x230303030303030L, 1.0), new Udef("byte", "byte(8bits) ", 0x230303030303030L, 1.0), new Udef("C", "Coulomb ", 157678974794739760L, 1.0), new Udef("D", "Debye (dipole)", 157680074306367536L, 3.333333333333333E-30), new Udef("cd", "candela(lumen/sr) ", 157678970482995504L, 1.0), new Udef("F", "Farad ", 157395313696452656L, 1.0), new Udef("H", "Henry ", 157962635859472432L, 1.0), new Udef("lm", "lumen ", 157678970482995504L, 0.07957747154594767), new Udef("lx", "lux(lm/m2) ", 157676771459739952L, 0.07957747154594767), new Udef("mol", "mole ", 157678970482995249L, 1.0), new Udef("N", "Newton ", 157961536381399088L, 1.0), new Udef("Ohm", "Ohm(V/A) ", 157962631564505136L, 1.0), new Udef("S", "Siemens(A/V) ", 157395309401485360L, 1.0), new Udef("Wb", "Weber(V.s) ", 157962635876249648L, 1.0), new Udef("u", "atomic mass unit ", 157960445459705904L, 1.6605387E-27), new Udef("\u00b5as", "micro-second of arc ", 0x230303030303030L, 7.71604938271605E-13), new Udef("\"d:m:s\"", "degree arcminute arcsecond (sexagesimal angle from degree)", 1310600475089842224L, 0.002777777777777778), new Udef("\"h:m:s\"", "hour minutes seconds (sexagesimal time from hours)", 1310600479384809520L, 3600.0), new Udef("\"h:m\"", "hour minutes (sexagesimal time from hours)", 2463521983991656496L, 3600.0), new Udef("\"m:s\"", "minutes seconds (sexagesimal time from minutes)", 2463521983991656496L, 60.0), new Udef("\"hhmmss\"", "hour minutes seconds (sexagesimal time without separator)", 2463521983991656496L, 3600.0), new Udef("\"ddmmss\"", "degree arcminute arcsecond (sexagesimal angle without separator)", 0x2230303030303030L, 0.002777777777777778), new Udef("\"date\"", "Fully qualified date", 4769364993205350448L, 86400.0), new Udef("\"datime\"", "Fully qualified date/time (ISO-8601)", 4769364993205350448L, 86400.0), new Udef("\"YYYYMMDD\"", "Fully qualified date (without separator)", 7075208002419044400L, 86400.0), new Udef("\"month\"", "Month name or number (range 1..12)", 0x230303030303030L, 86400.0), new Udef("\"MM/YY\"", "Month/Year(from 1900)", 157678974777962544L, 86400.0), new Udef("\"MM/yy\"", "Month/Year(from 2000 when yy<50)", 157678974777962544L, 86400.0), new Udef("\"day\"", "Day of month number", 0x230303030303030L, 86400.0), new Udef("pi", "pi(=3.14...)", 0x230303030303030L, Math.PI), new Udef("\u03c0", "pi(=3.14...)", 0x230303030303030L, Math.PI), new Udef("c", "c(speed_of_light)", 157680065699655728L, 2.99792458E8), new Udef("G", "G(gravitation constant)", 157400785451233328L, 6.673E-11), new Udef("\\h", "hbar(Planck constant)", 157962640187994160L, 1.0545716E-34), new Udef("\u210f", "hbar(Planck constant)", 157962640187994160L, 1.0545716E-34), new Udef("e", "e(electron_charge) ", 157678974794739760L, 1.602177E-19), new Udef("k", "k(Boltzmann) ", 157962635892961328L, 1.38065E-23), new Udef("R", "R(gas_constant) ", 157962635892961327L, 8.3143), new Udef("mp", "mp(proton_mass) ", 157960445459705904L, 1.672661E-27), new Udef("me", "me(electron_mass) ", 157960445459705904L, 9.109382E-31), new Udef("a0", "(Bohr radius) ", 157680069994623024L, 5.29177208E-11), new Udef("eps0", "(electric constant) ", 157394214184824880L, 8.854187817620389E-12), new Udef("mu0", "(magnetic constant) ", 157961536347844656L, 1.2566370614359173E-6), new Udef("\u00b50", "(magnetic constant) ", 157961536347844656L, 1.2566370614359173E-6), new Udef("alpha", "(fine structure constant) ", 0x230303030303030L, 0.0072973525205055605), new Udef("muB", "(Bohr magneton) ", 157681169523028016L, 9.274009E-28), new Udef("degC", "Celsius ", 157678970483060784L, 1.0, 273.15), new Udef("MJD", "Modified Julian Date (JD-2400000.5) ", 4769364993205350448L, 86400.0), new Udef("atm", "atmosphere ", 157959337358143536L, 101325.0), new Udef("mmHg", "mercury_mm ", 157959337358143536L, 133.3224), new Udef("l", "litre ", 0x230333030303030L, 0.001), new Udef("hr", "hour(use 'h') ", 157678974777962544L, 3600.0), new Udef("sec", "second (use 's')", 157678974777962544L, 1.0), new Udef("inch", "inch ", 157680069994623024L, 0.0254), new Udef("t", "ton ", 157960445459705904L, 1000.0), new Udef("\"month\"", "month ", 0x230303030303030L, 1.0), new Udef("erg", "erg(10-7J) ", 157962635893026864L, 1.0E-7), new Udef("dyn", "dyne(10-5N) ", 157961536381399088L, 1.0E-5), new Udef("bar", "bar(10+5Pa) ", 157959337358143536L, 100000.0), new Udef("gauss", "Gauss(10-4T) ", 157960436852994096L, 1.0E-4), new Udef("cal", "calorie ", 157962635893026864L, 4.1854), new Udef("\u00c5", "Angstroem(0.1nm) ", 157680069994623024L, 1.0E-10), new Udef("Angstrom", "Angstroem(0.1nm) ", 157680069994623024L, 1.0E-10), new Udef("lyr", "light-year (c*yr) ", 157680069994623024L, 9.46053E15), new Udef("degF", "Fahrenheit ", 157678970483060784L, 0.5555555555555556, 255.3722222222222)};

    private static synchronized void init() {
        int deb = DEBUG;
        DEBUG = 0;
        for (int i = 0; i < uDef.length; ++i) {
            hUnit.put(Unit.uDef[i].symb, new Integer(i));
        }
        initialized = true;
        Converter hms2dms = new Converter("\"h:m:s\"", "\"d:m:s\"", 15.0);
        Converter dms2hms = new Converter("\"d:m:s\"", "\"h:m:s\"", 0.06666666666666667);
        DEBUG = deb;
    }

    private static final Udef uLookup(String symbol) {
        Object o;
        if (!initialized) {
            Unit.init();
        }
        if ((o = hUnit.get(symbol)) instanceof String) {
            o = hUnit.get(o);
        }
        if (!(o instanceof Integer)) {
            return null;
        }
        int i = (Integer)o;
        if (i < uDef.length) {
            return uDef[i];
        }
        Udef u = (Udef)aUnit.get(i -= uDef.length);
        return u;
    }

    private static final Udef uLookup(long mksa) {
        int i;
        Udef u = null;
        if (!initialized) {
            Unit.init();
        }
        for (i = 0; i < uDef.length; ++i) {
            if (Unit.uDef[i].mksa != mksa || Unit.uDef[i].orig != 0.0) continue;
            if (Unit.uDef[i].fact == 1.0) {
                return uDef[i];
            }
            if (u != null) continue;
            u = uDef[i];
        }
        if (u != null) {
            return u;
        }
        if (aUnit != null) {
            int n = aUnit.size();
            for (i = 0; i < n; ++i) {
                u = (Udef)aUnit.get(i);
                if (u.mksa != mksa) continue;
                return u;
            }
        }
        return u;
    }

    private static final Udef uLookup(Parsing t, int len) {
        String symb = new String(t.a, t.pos, len);
        Udef u = Unit.uLookup(symb);
        if (u != null) {
            t.pos += len;
        }
        return u;
    }

    public static final Enumeration symbols() {
        if (!initialized) {
            Unit.init();
        }
        return hUnit.keys();
    }

    public static synchronized Unit addSymbol(String symbol, String equiv, String explain) throws ParseException {
        Udef old_def = Unit.uLookup(symbol);
        Unit old_unit = old_def == null ? null : new Unit(old_def.symb);
        Unit new_unit = new Unit(equiv);
        if (DEBUG > 0) {
            System.out.println("----addSymbol(" + symbol + ") = " + equiv + " = " + new_unit);
        }
        if (aUnit == null) {
            aUnit = new ArrayList(16);
        }
        if (!Double.isNaN(new_unit.value)) {
            if ((new_unit.mksa & 0x8100000000000000L) != 0L) {
                Unit u = new Unit(new_unit);
                u.dexp();
                new_unit.factor = u.factor * u.value;
            } else {
                new_unit.factor *= new_unit.value;
            }
        }
        Udef new_def = new Udef(symbol, explain, new_unit.mksa, new_unit.factor);
        int i = aUnit.size() + uDef.length;
        aUnit.add(new_def);
        hUnit.put(symbol, new Integer(i));
        if (DEBUG > 0) {
            System.out.println("====Added units #" + i + " = " + new_def);
        }
        return old_unit;
    }

    public static synchronized Unit addSymbol(String symbol, String equiv) throws ParseException {
        return Unit.addSymbol(symbol, equiv, equiv + " ");
    }

    public static synchronized void registerConverter(String source_unit, String target_unit, Converter special_converter) {
        String symbols = source_unit + Converter.SEP + target_unit;
        hConv.put(symbols, special_converter);
    }

    public static Converter getConverter(String source_unit, String target_unit) {
        String symbols = source_unit + Converter.SEP + target_unit;
        Converter c = (Converter)hConv.get(symbols);
        return c;
    }

    public static boolean checkSymbol(String symbol) {
        return Unit.uLookup(symbol) != null;
    }

    public Unit() {
        this.set();
    }

    public Unit(Unit u) {
        this.set(u);
    }

    public Unit(String symbol) throws ParseException {
        this.set(symbol);
    }

    public double getValue() {
        return this.value;
    }

    public double getSIvalue() {
        return this.value * this.factor + this.offset;
    }

    public long getSIdim() {
        return this.mksa;
    }

    public static long unitless() {
        return 0x230303030303030L;
    }

    public String getUnit() {
        return this.symbol;
    }

    public String getSIunit() {
        StringBuffer b = new StringBuffer(64);
        this.toSI(b, 0);
        return "" + b;
    }

    private static final String toExpr(String s) {
        int i;
        char[] b = s.toCharArray();
        for (i = 0; i < b.length && Character.isLetter(b[i]); ++i) {
        }
        if (i < b.length) {
            return "(" + s + ")";
        }
        return s;
    }

    private static final int skipBrackets(StringBuffer b) {
        int len1 = b.length() - 1;
        int ini1 = 0;
        if (len1 <= 0) {
            return 0;
        }
        while (b.charAt(ini1) == '(' && b.charAt(len1) == ')') {
            while (b.charAt(--len1) == ' ') {
            }
            while (b.charAt(++ini1) == ' ') {
            }
            b.setLength(++len1);
        }
        return ini1;
    }

    private static final int getPower(Parsing t) {
        int s = 43;
        int pow = 0;
        int inum = 0;
        int posini = t.pos;
        t.pos = t.length - 1;
        if (Character.isDigit(t.a[t.pos])) {
            while (Character.isDigit(t.a[t.pos])) {
                --t.pos;
            }
            s = t.a[t.pos];
            if (s != 43 && s != 45) {
                ++t.pos;
            }
            inum = t.pos;
            pow = t.parseInt();
        }
        if (pow != 0) {
            if (t.a[0] == '(') {
                if (t.a[inum - 1] != ')') {
                    pow = 0;
                }
            } else {
                for (int i = 0; i < inum; ++i) {
                    if (Character.isLetter(t.a[i])) continue;
                    pow = 0;
                }
            }
        }
        t.pos = pow == 0 ? posini : inum;
        return pow;
    }

    public final void log() throws ArithmeticException {
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: log(" + this.symbol + ")");
        }
        this.value = AstroMath.log(this.value);
        this.mksa |= Long.MIN_VALUE;
        if (this.symbol != null) {
            this.symbol = "[" + this.symbol + "]";
        }
    }

    public final void mag() throws ArithmeticException {
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: mag(" + this.symbol + ")");
        }
        this.value = -2.5 * AstroMath.log(this.value);
        if (this.mksa == 0x230303030303030L && this.factor == 1.0) {
            this.mksa |= 0x100000000000000L;
            if (this.symbol != null) {
                this.symbol = "mag";
            }
        } else {
            this.mksa |= 0x8100000000000000L;
            if (this.symbol != null) {
                this.symbol = "mag[" + this.symbol + "]";
            }
        }
    }

    public final void dexp() throws ArithmeticException {
        if ((this.mksa & Long.MIN_VALUE) == 0L) {
            throw new ArithmeticException("****Unit: dexp(" + this.symbol + ")");
        }
        double ls = (this.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        this.value = AstroMath.dexp(this.value / ls);
        this.mksa &= 0x7EFFFFFFFFFFFFFFL;
        if (this.symbol == null) {
            return;
        }
        int i = -1;
        int last = this.symbol.length() - 1;
        char c = this.symbol.charAt(last);
        if (c == ']') {
            i = this.symbol.indexOf(91);
        } else if (c == ')') {
            i = this.symbol.indexOf(40);
        }
        if (i >= 0) {
            this.symbol = this.symbol.substring(i + 1, last);
        } else {
            StringBuffer b = new StringBuffer(64);
            this.toSI(b, 0);
            this.symbol = "" + b;
        }
    }

    public final void power(int expo) throws ArithmeticException {
        int i;
        double error = 0.0;
        double r = 1.0;
        double v = 1.0;
        long u = 0x230303030303030L;
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: can't power log[unit]: " + this.symbol);
        }
        for (i = expo; i > 0; --i) {
            r *= this.factor;
            v *= this.value;
            u += this.mksa;
            if (((u -= 0x230303030303030L) & 0x8480808080808080L) == 0L) continue;
            error += 1.0;
        }
        while (i < 0) {
            r /= this.factor;
            v /= this.value;
            u += 0x230303030303030L;
            if (((u -= this.mksa) & 0x8480808080808080L) != 0L) {
                error += 1.0;
            }
            ++i;
        }
        if (error > 0.0) {
            throw new ArithmeticException("****Unit: power too large: ()^" + expo);
        }
        this.factor = r;
        this.value = v;
        this.mksa = u;
        if (expo != 1 && this.symbol != null) {
            if (expo == 0) {
                this.symbol = "";
            } else if (this.symbol.length() > 0) {
                Parsing t = new Parsing(this.symbol);
                int pow = Unit.getPower(t);
                if (pow == 0) {
                    this.symbol = Unit.toExpr(this.symbol) + expo;
                } else {
                    i = 0;
                    pow *= expo;
                    if (t.a[0] == '(') {
                        i = 1;
                        t.advance(-1);
                    }
                    this.symbol = expo == 1 ? this.symbol.substring(i, t.pos) : Unit.toExpr(this.symbol.substring(i, t.pos)) + pow;
                }
            }
        }
    }

    public final void sqrt() throws ArithmeticException {
        if ((this.mksa & 0x8100000000000000L) != 0L) {
            throw new ArithmeticException("****Unit: log(" + this.symbol + ")");
        }
        if ((this.mksa & 0x101010101010101L) != 0L) {
            throw new ArithmeticException("****Unit: sqrt(" + this.symbol + ") is impossible");
        }
        this.value = Math.sqrt(this.value);
        this.factor = Math.sqrt(this.factor);
        this.mksa = this.mksa + 0x230303030303030L >> 1;
        if (this.symbol != null && this.symbol.length() > 1) {
            Parsing t = new Parsing(this.symbol);
            int i = 0;
            int pow = 0;
            pow = Unit.getPower(t);
            if ((pow & 1) != 0) {
                pow = 0;
            }
            if (t.a[0] == '(') {
                i = 1;
                t.advance(-1);
            }
            if (pow == 2) {
                this.symbol = this.symbol.substring(i, t.pos);
            } else if (pow != 0) {
                this.symbol = Unit.toExpr(this.symbol.substring(i, t.pos)) + (pow /= 2);
            }
            if (pow == 0 && t.length > 0) {
                this.symbol = "sqrt(" + this.symbol + ")";
            }
        }
    }

    public final boolean isUnitless() {
        return (this.mksa & Long.MAX_VALUE) == 0x230303030303030L;
    }

    public final boolean isCompatibleWith(Unit unit) {
        if (((unit.mksa | this.mksa) & 0x4000000000000000L) != 0L) {
            return (this.mksa ^ 0x4000000000000000L) == unit.mksa;
        }
        return (this.mksa & 0x7EFFFFFFFFFFFFFFL) == (unit.mksa & 0x7EFFFFFFFFFFFFFFL);
    }

    public final boolean equals(Object o) {
        boolean res = false;
        if (o instanceof Unit) {
            Unit u = (Unit)o;
            if (u.mksa == this.mksa) {
                res = (this.mksa & Long.MIN_VALUE) != 0L ? this.factor == u.factor && this.value == u.value : this.factor * this.value == u.factor * u.value;
            }
        }
        return res;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        int hcode = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.factor);
        hcode = hcode * 123 + (int)(l ^ l >>> 32);
        hcode = hcode * 123 + (int)(this.mksa ^ this.mksa >>> 32);
        return hcode;
    }

    public static void convert(Unit source_unit, Unit target_unit) throws ArithmeticException {
        String s = source_unit.symbol + Converter.SEP + target_unit.symbol;
        Object o = hConv.get(s);
        if (o != null) {
            double r;
            Converter c = (Converter)o;
            target_unit.value = r = c.convert(source_unit.value);
            return;
        }
        Unit.convertUnit(source_unit, target_unit);
    }

    public static void convertUnit(Unit source_unit, Unit target_unit) throws ArithmeticException {
        double f = source_unit.factor / target_unit.factor;
        if (DEBUG > 0) {
            source_unit.dump("...convert:source=");
            target_unit.dump("...convert:target=");
        }
        if ((target_unit.mksa & 0xCFFFFFFFFFFFFFFFL) == (source_unit.mksa & 0xCFFFFFFFFFFFFFFFL)) {
            target_unit.value = f * source_unit.value + (source_unit.offset - target_unit.offset) / target_unit.factor;
            return;
        }
        if ((target_unit.mksa & 0x7EFFFFFFFFFFFFFFL) != (source_unit.mksa & 0x7EFFFFFFFFFFFFFFL)) {
            throw new ArithmeticException("****Unit: can't convert " + source_unit.symbol + " into " + target_unit.symbol);
        }
        if ((target_unit.mksa & Long.MIN_VALUE) == 0L) {
            double ls = (source_unit.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
            target_unit.value = f * AstroMath.dexp(source_unit.value / ls);
            return;
        }
        if ((source_unit.mksa & Long.MIN_VALUE) != 0L) {
            target_unit.value = (source_unit.mksa & 0x100000000000000L) != 0L ? -0.4 * source_unit.value : source_unit.value;
            target_unit.value += AstroMath.log(f);
            if ((target_unit.mksa & 0x100000000000000L) != 0L) {
                target_unit.value *= -2.5;
            }
            return;
        }
        double ls = (target_unit.mksa & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        target_unit.value = ls * AstroMath.log(f * source_unit.value);
    }

    public void convertFrom(Unit source_unit) throws ArithmeticException {
        Unit.convert(source_unit, this);
    }

    public void convertTo(Unit unit) throws ArithmeticException {
        double f = this.factor / unit.factor;
        if (DEBUG > 0) {
            this.dump("...convertTo:source= ");
            unit.dump("...convertTo:target= ");
        }
        if (this.mksa == unit.mksa && (this.mksa & Long.MIN_VALUE) == 0L) {
            this.value = (this.value * this.factor + this.offset - unit.offset) / unit.factor;
            this.factor = unit.factor;
            this.offset = unit.offset;
            this.symbol = unit.symbol;
            return;
        }
        Unit temp = new Unit(this);
        this.symbol = unit.symbol;
        this.mksa = unit.mksa;
        this.factor = unit.factor;
        this.offset = unit.offset;
        this.convertFrom(temp);
    }

    public final void plus(Unit unit) throws ArithmeticException {
        boolean error = false;
        if (((this.mksa | unit.mksa) & 0x4000000000000000L) != 0L) {
            if (this.mksa != (0x4000000000000000L ^ unit.mksa)) {
                error = true;
            } else {
                this.mksa |= 0x4000000000000000L;
            }
        } else {
            boolean bl = error = (this.mksa & 0xDFFFFFFFFFFFFFFFL) != (unit.mksa & 0xDFFFFFFFFFFFFFFFL);
        }
        if (error) {
            throw new ArithmeticException("****Unit: can't combine: " + this.symbol + " + " + unit.symbol);
        }
        this.value += unit.value * unit.factor / this.factor;
    }

    public final void minus(Unit unit) throws ArithmeticException {
        boolean error = false;
        if (((this.mksa | unit.mksa) & 0x4000000000000000L) != 0L) {
            if (this.mksa == unit.mksa) {
                this.mksa ^= 0x4000000000000000L;
            } else if ((unit.mksa & 0x4000000000000000L) != 0L) {
                error = true;
            }
        } else {
            boolean bl = error = (this.mksa & 0xDFFFFFFFFFFFFFFFL) != (unit.mksa & 0xDFFFFFFFFFFFFFFFL);
        }
        if (error) {
            throw new ArithmeticException("****Unit: can't combine: " + this.symbol + " - " + unit.symbol);
        }
        this.value -= unit.value * unit.factor / this.factor;
    }

    public final void sum(Unit unit) throws ArithmeticException {
        boolean error = false;
        if (((this.mksa | unit.mksa) & 0x8100000000000000L) == 0L) {
            this.plus(unit);
            return;
        }
        if (DEBUG > 0) {
            this.dump("...sum:term1");
            unit.dump("...sum:term2");
        }
        if ((this.mksa & 0x7EFFFFFFFFFFFFFFL) != (unit.mksa & 0x7EFFFFFFFFFFFFFFL)) {
            throw new ArithmeticException("****Unit: can't sum: " + this.symbol + " + " + unit.symbol);
        }
        long rlog = this.mksa & 0x8100000000000000L;
        long ulog = unit.mksa & 0x8100000000000000L;
        if (rlog != ulog) {
            Unit tunit = new Unit(this);
            tunit.convertFrom(unit);
            this.sum(tunit);
            return;
        }
        double ls = (rlog & 0x100000000000000L) != 0L ? -2.5 : 1.0;
        double dv = unit.value - this.value;
        this.value += ls * AstroMath.log(1.0 + unit.factor / this.factor * Math.exp(dv / ls));
    }

    public final void mult(double s) throws ArithmeticException {
        if ((this.mksa & 0x4000000000000000L) != 0L && s != 1.0) {
            throw new ArithmeticException("****Unit.mult on a date!");
        }
        this.value *= s;
    }

    public final void mult(Unit unit) throws ArithmeticException {
        long u = this.mksa;
        double r = this.factor;
        double v = this.value;
        double o = this.offset;
        if ((this.mksa & 0x4000000000000000L) != 0L && unit.factor != 1.0) {
            throw new ArithmeticException("****Unit.mult on a date!");
        }
        if (!(((this.mksa | unit.mksa) & Long.MIN_VALUE) == 0L || this.mksa == 0x230303030303030L && this.factor == 1.0 || unit.mksa == 0x230303030303030L && unit.factor == 1.0)) {
            throw new ArithmeticException("****Unit: can't multiply logs: " + this.symbol + " x " + unit.symbol);
        }
        if (this.offset != 0.0 || unit.offset != 0.0) {
            if (this.mksa == 0x230303030303030L) {
                this.offset = unit.offset;
            } else if (unit.mksa != 0x230303030303030L) {
                this.offset = 0.0;
            }
        }
        v *= unit.value;
        r *= unit.factor;
        u += unit.mksa;
        if (((u -= 0x230303030303030L) & 0xC80808080808080L) != 0L) {
            throw new ArithmeticException("****too large powers in: " + this.symbol + " x " + unit.symbol);
        }
        this.mksa = u;
        this.factor = r;
        this.value = v;
        if (this.symbol != null && unit.symbol != null) {
            if (unit.mksa == 0x230303030303030L && unit.factor == 1.0) {
                return;
            }
            this.symbol = this.mksa == 0x230303030303030L && this.factor == 1.0 ? unit.symbol : (this.symbol.equals(unit.symbol) && this.factor == unit.factor ? Unit.toExpr(this.symbol) + "2" : Unit.toExpr(this.symbol) + "." + Unit.toExpr(unit.symbol));
        }
    }

    public final void div(Unit unit) throws ArithmeticException {
        long u = this.mksa;
        double r = this.factor;
        double v = this.value;
        if ((this.mksa & 0x4000000000000000L) != 0L && unit.factor != 1.0) {
            throw new ArithmeticException("****Unit.div  on a date!");
        }
        if (!(((this.mksa | unit.mksa) & Long.MIN_VALUE) == 0L || this.mksa == 0x230303030303030L && this.factor == 1.0 || unit.mksa == 0x230303030303030L && unit.factor == 1.0)) {
            throw new ArithmeticException("****Unit: can't divide logs: " + this.symbol + " x " + unit.symbol);
        }
        if (this.offset != 0.0 || unit.offset != 0.0) {
            if (this.mksa == 0x230303030303030L) {
                this.offset = unit.offset;
            } else if (unit.mksa != 0x230303030303030L) {
                this.offset = 0.0;
            }
        }
        v /= unit.value;
        r /= unit.factor;
        u += 0x230303030303030L;
        if (((u -= unit.mksa) & 0x8C80808080808080L) != 0L) {
            throw new ArithmeticException("****too large powers in: " + this.symbol + " / " + unit.symbol);
        }
        this.mksa = u;
        this.factor = r;
        this.value = v;
        if (this.symbol != null && unit.symbol != null) {
            if (unit.mksa == 0x230303030303030L && unit.factor == 1.0) {
                return;
            }
            this.symbol = this.mksa == 0x230303030303030L && this.factor == 1.0 ? Unit.toExpr(unit.symbol) + "-1" : (this.symbol.equals(unit.symbol) ? Unit.edf(this.factor) : Unit.toExpr(this.symbol) + "/" + Unit.toExpr(unit.symbol));
        }
    }

    public final void prod(Unit unit) throws ArithmeticException {
        if ((this.mksa & Long.MIN_VALUE) == 0L && (unit.mksa & Long.MIN_VALUE) == 0L) {
            this.mult(unit);
            return;
        }
        Unit runit = new Unit(this);
        Unit tunit = new Unit(unit);
        if ((runit.mksa & Long.MIN_VALUE) != 0L) {
            runit.mksa &= 0x7EFFFFFFFFFFFFFFL;
            runit.convertFrom(this);
        }
        if ((tunit.mksa & Long.MIN_VALUE) != 0L) {
            tunit.mksa &= 0x7EFFFFFFFFFFFFFFL;
            tunit.convertFrom(this);
        }
        runit.mult(tunit);
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            if ((this.mksa & 0x100000000000000L) != 0L) {
                runit.mag();
            } else {
                runit.log();
            }
        }
        this.set(runit);
    }

    private final int unit1(Parsing text, StringBuffer edited) throws ParseException {
        int s;
        int i;
        int posini = text.pos;
        Udef theUnit = uDef[0];
        int mult_index = -1;
        int power = 1;
        int op = 0;
        int error = 0;
        boolean close_bracket = false;
        int edited_pos = -1;
        this.mksa = 0x230303030303030L;
        this.factor = 1.0;
        if (text.pos >= text.length) {
            return 0;
        }
        if (DEBUG > 0) {
            System.out.println("....unit1(" + text + ")");
        }
        switch (text.a[text.pos]) {
            case '(': {
                theUnit = null;
                ++text.pos;
                boolean bl = close_bracket = edited != null;
                if (close_bracket) {
                    edited_pos = edited.length();
                    edited.append('(');
                }
                this.unitec(text, edited);
                if (text.pos < text.length && text.a[text.pos] == ')') {
                    ++text.pos;
                } else {
                    throw new ParseException("****Unit: Missing ) in '" + text + "'", text.pos);
                }
                if (!close_bracket) break;
                i = edited.length();
                while (--i >= 0 && edited.charAt(i) == ' ') {
                }
                edited.setLength(++i);
                edited.append(')');
                close_bracket = false;
                break;
            }
            case '\"': {
                i = text.matchingQuote();
                if (i < text.length) {
                    ++i;
                }
                if ((theUnit = Unit.uLookup(text, i - text.pos)) != null) break;
                throw new ParseException("****Unit: quoted unit does not match", text.pos);
            }
            case '-': {
                s = text.pos++;
                if (text.pos >= text.length) break;
                if (Character.isDigit(text.a[text.pos])) {
                    text.pos = s;
                    break;
                }
                while (text.pos < text.length && text.a[text.pos] == '-') {
                    ++text.pos;
                }
                break;
            }
            case '%': {
                theUnit = Unit.uLookup(text, 1);
                break;
            }
            case '\\': {
                for (i = text.pos + 1; i < text.length && Character.isLetter(text.a[i]); ++i) {
                }
                theUnit = Unit.uLookup(text, i - text.pos);
                if (theUnit != null) break;
                ++error;
                break;
            }
            default: {
                for (i = text.pos; i < text.length && Character.isLetter(text.a[i]); ++i) {
                }
                if (i < text.length && text.a[i] == '0') {
                    ++i;
                }
                if ((theUnit = Unit.uLookup(text, i - text.pos)) != null) break;
                s = text.pos;
                if (text.length - text.pos > 1) {
                    mult_index = text.lookup(mul_symb);
                }
                if (mult_index < 0 || (theUnit = Unit.uLookup(text, i - text.pos)) != null) break;
                text.pos = s;
            }
        }
        if (error == 0 && text.pos < text.length) {
            op = text.a[text.pos];
        }
        if (theUnit != null && (theUnit.mksa & 0x6000000000000000L) != 0L) {
            op = 0;
        }
        if (op == 43 || op == 45 || op == 94 || Character.isDigit((char)op) && op != 48) {
            if (DEBUG > 0) {
                System.out.print("    look for power with op=" + (char)op);
            }
            if (op == 94) {
                ++text.pos;
            }
            if (text.pos < text.length) {
                op = text.a[text.pos];
                if (op == 43) {
                    ++text.pos;
                }
                if (op != 45) {
                    op = 43;
                }
                if ((power = text.parseInt()) == 0) {
                    ++error;
                } else if (power > 0 && power < 10 && edited != null) {
                    --text.pos;
                    i = text.lookup(op_symb);
                    if (i >= 0) {
                        if (edited_pos >= 0) {
                            edited.insert(edited_pos, op_text[i]);
                        } else {
                            edited.append(op_text[i]);
                        }
                        op = 32;
                    } else {
                        ++text.pos;
                    }
                }
                if (DEBUG > 0) {
                    System.out.print(", power=" + power);
                }
            } else {
                ++error;
            }
            if (DEBUG > 0) {
                System.out.println(", error=" + error);
            }
        }
        if (error > 0) {
            throw new ParseException("****Unit: '" + text + "'+" + text.pos, text.pos);
        }
        if (mult_index >= 0) {
            this.factor *= AstroMath.dexp(mul_fact[mult_index]);
            if (edited != null) {
                edited.append(mul_text[mult_index]);
            }
        }
        if (theUnit != null) {
            this.factor *= theUnit.fact;
            this.mksa = theUnit.mksa;
            this.offset = theUnit.orig;
            if (edited != null) {
                edited.append(theUnit.expl);
            }
        }
        if (power != 1) {
            this.power(power);
            if (op != 32 && edited != null) {
                edited.append("power");
                if (power >= 0) {
                    edited.append((char)op);
                }
                edited.append(power);
            }
        }
        s = text.pos - posini;
        if (DEBUG > 0) {
            System.out.println("  =>unit1: return=" + s + ", f=" + this.factor + ", val=" + this.value);
        }
        return s;
    }

    private final boolean unitec(Parsing text, StringBuffer edited) throws ParseException {
        int i;
        int posini = text.pos;
        Unit tunit = null;
        int log_index = -1;
        char op = '\u0000';
        char end = '\u0000';
        boolean error = false;
        this.mksa = 0x230303030303030L;
        if (DEBUG > 0) {
            System.out.print("....unitec(" + text + "): factor=");
        }
        text.gobbleSpaces();
        int s = text.pos;
        this.factor = text.parseFactor();
        if (DEBUG > 0) {
            System.out.println(this.factor);
        }
        if (edited != null && s != text.pos) {
            edited.append(text.a, s, text.pos - s);
        }
        if ((log_index = text.lookup(log_symb)) >= 0) {
            end = log_end[log_index];
            if (edited != null) {
                edited.append(log_symb[log_index & 0xFFFFFFFC]);
            }
            s = text.pos;
            double facilog = text.parseFactor();
            if (edited != null && s != text.pos) {
                edited.append(text.a, s, text.pos - s);
                this.offset = AstroMath.log(facilog);
            }
            if (DEBUG > 0) {
                System.out.println(", offset=" + this.offset);
            }
        }
        s = -1;
        while (text.pos < text.length && text.a[text.pos] != end) {
            if (op == '\u0000') {
                i = this.unit1(text, edited);
                if (DEBUG > 0 && tunit != null) {
                    tunit.dump("..unitec");
                }
                op = 'x';
            } else {
                if (tunit == null) {
                    tunit = new Unit();
                }
                i = tunit.unit1(text, edited);
                if (DEBUG > 0) {
                    tunit.dump("..unitec");
                    System.out.println("    combining with op=" + op);
                    System.out.println("    this=" + this + " \tfactor=" + this.factor);
                    System.out.println("    temp=" + tunit + " \tfactor=" + tunit.factor);
                }
                if (op == '/') {
                    this.div(tunit);
                } else {
                    this.mult(tunit);
                }
            }
            if (text.match('#')) {
                int old_pos = text.pos - 1;
                double o = text.parseFactor();
                if (text.pos <= old_pos + 3) {
                    text.pos = old_pos;
                } else {
                    this.offset = o;
                }
                if (edited != null && this.offset != 0.0) {
                    edited.append("(offseted by ");
                    editing.editDouble(edited, this.offset, 16);
                    edited.append(')');
                }
            }
            if ((s = (this.mksa & 0x4000000000000000L) != 0L ? -1 : text.lookup(op_symb)) < 0) break;
            op = op_symb[s].charAt(0);
            if (edited == null) continue;
            i = edited.length();
            while (--i >= 0 && edited.charAt(i) == ' ') {
            }
            edited.setLength(++i);
            edited.append(' ');
            edited.append(op_text[s]);
        }
        if (log_index >= 0) {
            if (edited != null) {
                i = edited.length();
                while (--i >= 0 && edited.charAt(i) == ' ') {
                }
                edited.setLength(++i);
                edited.append(log_end[log_index & 0xFFFFFFFC]);
            }
            if (text.pos < text.length && end != '\u0000' && text.a[text.pos] == end) {
                end = '\u0000';
                ++text.pos;
            }
            this.mksa |= Long.MIN_VALUE;
            if (this.factor != 1.0) {
                this.offset = AstroMath.log(this.factor);
                this.factor = 1.0;
            }
            if ((log_index & 4) != 0) {
                this.mksa |= 0x100000000000000L;
            }
        }
        if (s >= 0) {
            throw new ParseException("****Unit.text+" + text.pos + " (missing operand): " + text, text.pos);
        }
        if (end != '\u0000') {
            throw new ParseException("****Unit.text+" + text.pos + " (missing '" + end + "'): " + text, text.pos);
        }
        text.gobbleSpaces();
        if (DEBUG > 0) {
            System.out.println("  =>unitec: return=" + (text.pos > posini) + "\tfactor=" + this.factor);
        }
        return text.pos > posini;
    }

    public final void set() {
        this.symbol = null;
        this.mksa = 0x230303030303030L;
        this.factor = 1.0;
        this.value = Double.NaN;
        this.offset = 0.0;
    }

    public final void set(Unit u) {
        this.mksa = u.mksa;
        this.symbol = u.symbol;
        this.value = u.value;
        this.factor = u.factor;
        this.offset = u.offset;
    }

    public boolean parsing(Parsing t) {
        boolean has_symbol;
        boolean has_value;
        double val;
        int pos;
        int posini;
        block43: {
            posini = t.pos;
            if (!initialized) {
                Unit.init();
            }
            t.gobbleSpaces();
            pos = t.pos;
            if (DEBUG > 0) {
                System.out.print("....parsing(" + t + "):");
            }
            val = t.parseFactor();
            if (DEBUG > 0) {
                System.out.print(" val=" + val);
            }
            has_value = t.pos > pos;
            t.gobbleSpaces();
            if (t.lookup(op_symb) >= 0) {
                has_value = false;
                t.pos = pos;
                if (DEBUG > 0) {
                    System.out.print("(FALSE!)");
                }
            }
            pos = t.pos;
            this.offset = 0.0;
            this.symbol = null;
            if (DEBUG > 0) {
                System.out.println("\n    Interpret '" + t + "'");
            }
            try {
                has_symbol = this.unitec(t, null);
                this.symbol = String.copyValueOf(t.a, pos, t.pos - pos);
                Object o = hUnit.get(this.symbol);
                if (o instanceof String) {
                    this.symbol = (String)o;
                }
                if (!(has_value & (this.mksa & 0x2000000000000000L) != 0L)) break block43;
                int pos_end = t.pos;
                if (DEBUG > 0) {
                    System.out.print("    parsing via parseComplex(" + this.symbol + ")");
                }
                t.set(posini);
                t.gobbleSpaces();
                try {
                    t.parseComplex(this.symbol);
                    t.set(pos_end);
                }
                catch (Exception e) {
                    t.set(posini);
                    return false;
                }
            }
            catch (Exception e) {
                if (DEBUG > 0) {
                    System.out.println("++++unitec catched: " + e);
                    e.printStackTrace();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception i) {
                        // empty catch block
                    }
                }
                has_symbol = false;
                t.pos = pos;
            }
        }
        if (DEBUG > 0) {
            System.out.println("\n    interpret '" + t + "', has_value=" + has_value);
        }
        if (!has_value && t.pos < t.length) {
            int j;
            pos = t.pos;
            if (!has_symbol && t.currentChar() == '\"' && (j = t.matchingQuote()) > 0) {
                if (DEBUG > 0) {
                    System.out.println("....parsing: t.matchingQuote()=" + j);
                }
                j -= pos;
                this.symbol = t.toString(++j);
                t.advance(j);
                t.gobbleSpaces();
                pos = t.pos;
                try {
                    val = t.parseComplex(this.symbol);
                }
                catch (ParseException e) {
                    String msg = e.getMessage();
                    if (msg.indexOf("parseComplex((") >= 0) {
                        System.err.println(e);
                    }
                    t.set(posini);
                    return false;
                }
                if (t.status() != 0) {
                    String msg = t.error_message;
                    int ip1 = msg.indexOf(" interpreted as (");
                    if (ip1 > 0) {
                        ip1 = msg.indexOf(40, ip1);
                        int ip2 = msg.indexOf(41, ip1);
                        String correct_symbol = msg.substring(ip1 + 1, ip2);
                        if (DEBUG > 0) {
                            System.out.println("....parsing: adding Hash " + this.symbol + " => " + correct_symbol);
                        }
                        hUnit.put(this.symbol, correct_symbol);
                        this.symbol = correct_symbol;
                        t.pos = pos;
                        try {
                            val = t.parseComplex(this.symbol);
                        }
                        catch (ParseException pe) {
                            System.err.println(pe);
                            pe.printStackTrace();
                            t.set(posini);
                            return false;
                        }
                    } else {
                        System.err.println(msg);
                        t.set(posini);
                        return false;
                    }
                }
                has_value = true;
                Udef u = t.isDate() ? Unit.uLookup("MJD") : (t.isDays() ? Unit.uLookup("d") : (t.isTime() ? Unit.uLookup("\"h:m:s\"") : Unit.uLookup("\"d:m:s\"")));
                try {
                    Unit.addSymbol(this.symbol, u.symb, Parsing.explainComplex(this.symbol));
                    u = Unit.uLookup(this.symbol);
                    u.mksa |= 0x2000000000000000L;
                }
                catch (ParseException pe) {
                    System.err.println(pe);
                    pe.printStackTrace();
                }
                this.mksa = u.mksa;
                this.factor = u.fact;
            }
            if (has_symbol && t.pos < t.length) {
                if (DEBUG > 0) {
                    System.out.println("....parsing: symbol=" + this.symbol + ", interpret: " + t);
                }
                if (this.mksa == 4769364993205350448L) {
                    if (DEBUG > 0) {
                        System.out.print("    parsing via Astrotime(");
                    }
                    Astrotime datime = new Astrotime();
                    if (Character.isLetter(this.symbol.charAt(0))) {
                        t.set(posini);
                    }
                    if (DEBUG > 0) {
                        System.out.print(t + ") symbol=" + this.symbol);
                    }
                    if (has_value = datime.parsing(t)) {
                        val = datime.getMJD();
                    }
                    if (DEBUG > 0) {
                        System.out.println(" has_value=" + has_value + ", MJD=" + val);
                        datime.dump("datime ");
                    }
                } else if ((this.mksa & 0x2000000000000000L) != 0L) {
                    try {
                        val = t.parseComplex(this.symbol);
                        has_value = true;
                    }
                    catch (Exception e) {
                        t.set(posini);
                        return false;
                    }
                }
            }
        }
        double d = this.value = has_value ? val : Double.NaN;
        if (has_symbol | has_value) {
            return true;
        }
        t.pos = posini;
        return false;
    }

    public void set(String text) throws ParseException {
        Parsing t = new Parsing(text);
        this.set();
        if (DEBUG > 0) {
            this.dump("set(" + t + ")");
        }
        boolean p = this.parsing(t);
        t.gobbleSpaces();
        if (DEBUG > 0) {
            System.out.println("....Unit.set(" + text + ")" + p + " => " + this.toString());
        }
        if (t.pos < t.length) {
            throw new ParseException("****Unit: set '" + text + "'+" + t.pos, t.pos);
        }
    }

    public int parse(String text, int offset) {
        Parsing t = new Parsing(text, offset);
        this.parsing(t);
        return t.pos;
    }

    public int parseUnit(String text, int offset) {
        int o = this.parse(text, offset);
        this.setUnit();
        return o;
    }

    public int parseValue(String text, int offset) {
        Parsing t = new Parsing(text, offset);
        t.gobbleSpaces();
        int posini = t.pos;
        if (DEBUG > 0) {
            System.out.println("....parsing: symbol=" + this.symbol + ", interpret: " + t);
        }
        if (this.mksa == 4769364993205350448L) {
            if (DEBUG > 0) {
                System.out.print("    parsing via Astrotime(");
            }
            Astrotime datime = new Astrotime();
            if (Character.isLetter(this.symbol.charAt(0))) {
                t.set(posini);
            }
            if (DEBUG > 0) {
                System.out.print(t + ") symbol=" + this.symbol);
            }
            if (datime.parsing(t)) {
                this.value = datime.getMJD();
            } else {
                t.set(posini);
            }
            if (DEBUG > 0) {
                System.out.println(" => MJD=" + this.value);
                datime.dump("datime ");
            }
        } else if ((this.mksa & 0x2000000000000000L) != 0L) {
            try {
                this.value = t.parseComplex(this.symbol);
            }
            catch (Exception e) {
                this.value = Double.NaN;
                t.set(posini);
            }
        } else {
            this.value = (this.mksa & 0x1000000000000000L) != 0L ? t.parseSexa() : t.parseFactor();
        }
        if (t.pos == posini) {
            return offset;
        }
        return t.pos;
    }

    public void setUnit() {
        if (Double.isNaN(this.factor)) {
            this.factor = 1.0;
        }
        double f = this.factor;
        if (Double.isNaN(this.value)) {
            this.value = 1.0;
        }
        this.factor *= this.value;
        this.value = 1.0;
        if (f != this.factor) {
            this.symbol = this.symbol == null ? Unit.edf(this.factor) : Unit.edf(this.factor) + Unit.toExpr(this.symbol);
        }
    }

    public void setUnit(String text) throws ParseException {
        if (DEBUG > 0) {
            System.out.println("....Unit.setUnit(" + text + ")");
        }
        this.set(text);
        this.setUnit();
    }

    public void setValue(String text) throws ParseException {
        int length = text.length();
        int pos = this.parseValue(text, 0);
        if (pos == 0) {
            this.value = Double.NaN;
        } else {
            while (pos < length && Character.isWhitespace(text.charAt(pos))) {
                ++pos;
            }
        }
        if (pos < length) {
            throw new ParseException("****Unit: setValue '" + text + "'+" + pos, pos);
        }
    }

    public void setValue(double value) {
        this.value = value;
    }

    private static final StringBuffer edf(StringBuffer buf, double factor) {
        return editing.editDouble(buf, factor, 10);
    }

    private static final String edf(double factor) {
        if (factor == 1.0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(32);
        Unit.edf(buf, factor);
        return "" + buf;
    }

    private static final int edu(StringBuffer buf, long mksa, int option) {
        int i;
        int len0 = buf.length();
        int nu = 0;
        boolean sep = false;
        if ((mksa & Long.MIN_VALUE) != 0L && ((mksa &= Long.MAX_VALUE) & 0x100000000000000L) != 0L) {
            mksa &= 0xFEFFFFFFFFFFFFFFL;
        }
        if (mksa == 0x230303030303030L) {
            return 0;
        }
        if (option > 0) {
            nu = (mksa & 0x100000000000000L) == 0L ? 0 : 1;
            for (long m = mksa << 8 >> 8; m != 0L; m >>>= 8) {
                if ((m & 0xFFL) == 48L) continue;
                ++nu;
            }
            for (i = 0; i < uDef.length; ++i) {
                if (Unit.uDef[i].mksa != mksa || Unit.uDef[i].fact != 1.0) continue;
                buf.append(Unit.uDef[i].symb);
                break;
            }
            if (nu == 1) {
                return buf.length() - len0;
            }
            if (buf.length() != len0) {
                buf.append(" [");
            } else {
                nu = 0;
            }
        }
        int o = 2;
        int xff = 7;
        for (i = 0; i < 8; ++i) {
            int e = (int)(mksa >>> 56 - (i << 3) & (long)xff) - o;
            o = 48;
            xff = 255;
            if (e == 0) continue;
            if (sep) {
                buf.append(".");
            }
            sep = true;
            buf.append(MKSA[i]);
            if (e == 1) continue;
            if (e > 0) {
                buf.append("+");
            }
            buf.append(e);
        }
        if (nu > 0) {
            buf.append("]");
        }
        return buf.length() - len0;
    }

    private void toSI(StringBuffer b, int option) {
        boolean close = false;
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            b.append((this.mksa & 0x100000000000000L) != 0L ? "mag[" : "log[");
        }
        if (this.factor != 1.0) {
            Unit.edf(b, this.factor);
            if (this.offset != 0.0) {
                b.append('(');
                close = true;
            }
        }
        Unit.edu(b, this.mksa, option);
        if (this.offset != 0.0) {
            b.append("#");
            Unit.edf(b, -this.offset);
            if (close) {
                b.append(')');
            }
        }
        if ((this.mksa & Long.MIN_VALUE) != 0L) {
            b.append("]");
        }
    }

    public void dump(String title) {
        char[] xdim = new char[24];
        long m = this.mksa;
        int i = 24;
        while (i > 0) {
            xdim[--i] = x[(int)(m & 0xFL)];
            xdim[--i] = x[(int)((m >>>= 4) & 0xFL)];
            m >>>= 4;
            xdim[--i] = 46;
        }
        xdim[i] = 120;
        System.out.println(title + ": symbol='" + this.symbol + "', value=" + this.value);
        System.out.print("        factor=" + this.factor + ", Dim0" + new String(xdim));
        if (this.offset != 0.0) {
            System.out.print(" offset=" + this.offset);
        }
        System.out.println("");
    }

    public final StringBuffer editDimension(StringBuffer buf) {
        for (int i = 1; i < MKSAdim.length; ++i) {
            int dim;
            if (MKSAdim[i] == '\u0000' || (dim = (int)(this.mksa >> (7 - i) * 8 & 0xFFL) - 48) == 0) continue;
            buf.append(MKSAdim[i]);
            if (dim > 0) {
                buf.append('+');
            }
            buf.append(dim);
        }
        return buf;
    }

    public final String dimension() {
        StringBuffer b = new StringBuffer(16);
        this.editDimension(b);
        return b.toString();
    }

    public final StringBuffer editValue(StringBuffer buf) {
        if (Double.isNaN(this.value)) {
            return Unit.edf(buf, this.value);
        }
        if (this.mksa == 4769364993205350448L) {
            if (this.symbol.startsWith("\"dat")) {
                double mjd = this.value + this.offset / this.factor;
                int day = (int)mjd;
                if (this.value < 0.0) {
                    --day;
                }
                double sec = (mjd - (double)day) * 86400.0;
                editing.editDate(buf, day);
                if (this.symbol.startsWith("\"datim")) {
                    buf.append('T');
                    editing.editSexa(buf, sec / 3600.0, 2, -10, 0x20 | 5);
                } else if (sec >= 1.0E-6) {
                    editing.editDecimal(buf, sec / 86400.0, 0, -11, 0);
                }
            } else if (this.symbol.charAt(0) == '\"') {
                editing.editComplex(buf, this.value, this.symbol);
            } else {
                int ndec = this.symbol.charAt(0) == 'J' ? -10 : -11;
                editing.editDecimal(buf, this.value, 0, ndec, 0);
            }
        } else if ((this.mksa & 0x2000000000000000L) != 0L) {
            editing.editComplex(buf, this.value, this.symbol);
        } else if ((this.mksa & 0x1000000000000000L) != 0L) {
            editing.editSexa(buf, this.value, 1, -9, 5);
        } else {
            Unit.edf(buf, this.value);
        }
        return buf;
    }

    public final StringBuffer edit(StringBuffer buf) {
        boolean symb_edited = false;
        int symlen = 0;
        if (DEBUG > 0) {
            this.dump("unit.edit");
        }
        if (this.symbol != null) {
            symlen = this.symbol.length();
        }
        if ((this.mksa & 0x7000000000000000L) != 0L) {
            symb_edited = true;
            buf.append(this.symbol);
        }
        if (!Double.isNaN(this.value) || symlen == 0) {
            this.editValue(buf);
        }
        if (!(this.mksa == 0x230303030303030L && this.factor == 1.0 || symb_edited)) {
            if (symlen > 0) {
                boolean add_bracket = Character.isDigit(this.symbol.charAt(0));
                if (add_bracket) {
                    buf.append('(');
                }
                buf.append(this.symbol);
                if (add_bracket) {
                    buf.append(')');
                }
            } else {
                buf.append('(');
                this.toSI(buf, 0);
                buf.append(')');
            }
        }
        return buf;
    }

    public static final String explainUnit(String text) {
        Parsing t = new Parsing(text);
        StringBuffer b = new StringBuffer(120);
        Unit u = new Unit();
        int ini1 = 0;
        if (!initialized) {
            Unit.init();
        }
        try {
            u.unitec(t, b);
        }
        catch (Exception e) {
            if (DEBUG > 0) {
                System.out.println("++++explainUnit: catched: " + e);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            if (t.currentChar() == '\"') {
                b.append(Parsing.explainComplex(t.toString()));
            }
            String prefix = "?***bad Unit <";
            b.insert(0, prefix);
            b.insert(prefix.length(), text);
            b.insert(prefix.length() + text.length(), "> ");
        }
        ini1 = Unit.skipBrackets(b);
        return b.toString().substring(ini1);
    }

    public final String explainUnit() {
        StringBuffer b = new StringBuffer(120);
        Parsing t = new Parsing(this.symbol);
        Unit u = new Unit();
        int ini1 = 0;
        try {
            u.unitec(t, b);
        }
        catch (Exception e) {
            if (DEBUG > 0) {
                System.out.println("++++explainUnit: catched: " + e);
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception i) {
                    // empty catch block
                }
            }
            if (t.currentChar() == '\"') {
                b.append(Parsing.explainComplex(t.toString()));
            }
            String prefix = "?***bad Unit <";
            b.insert(0, prefix);
            b.insert(prefix.length(), this.symbol);
            b.insert(prefix.length() + this.symbol.length(), "> ");
        }
        ini1 = Unit.skipBrackets(b);
        b.append(" (");
        this.toSI(b, 1);
        b.append(")");
        return b.toString().substring(ini1);
    }

    public final String toStringInSI() {
        StringBuffer b = new StringBuffer(64);
        Unit u = new Unit(this);
        if ((u.mksa & Long.MIN_VALUE) != 0L) {
            u.mksa &= 0x7EFFFFFFFFFFFFFFL;
        }
        if (u.offset != 0.0) {
            Udef base = Unit.uLookup(u.mksa);
            u.symbol = base.symb;
            u.offset = base.orig;
        }
        u.factor = 1.0;
        u.convertFrom(this);
        if (!Double.isNaN(this.value)) {
            Unit.edf(b, u.value);
            if (b.length() == 0) {
                b.append('1');
            }
        }
        u.toSI(b, 0);
        return "" + b;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(120);
        boolean symb_edited = false;
        if (DEBUG > 0) {
            this.dump("unit.toString");
        }
        if ((this.mksa & 0x7000000000000000L) != 0L) {
            symb_edited = true;
            b.append(this.symbol);
        }
        if (!Double.isNaN(this.value)) {
            this.editValue(b);
            if (b.length() == 0) {
                b.append((this.mksa & Long.MIN_VALUE) != 0L ? (char)'0' : '1');
            }
        }
        if (!(this.mksa == 0x230303030303030L && this.factor == 1.0 || symb_edited)) {
            if (this.symbol != null) {
                boolean add_bracket = Character.isDigit(this.symbol.charAt(0));
                if (add_bracket) {
                    b.append('(');
                }
                b.append(this.symbol);
                if (add_bracket) {
                    b.append(')');
                }
            } else {
                b.append('(');
                this.toSI(b, 0);
                b.append(')');
            }
        }
        return b.toString();
    }

    public String editedValue() {
        StringBuffer b = new StringBuffer(120);
        this.editValue(b);
        return b.toString();
    }
}

