/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AbstractRegion;
import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.CircularRegion;
import cds.astro.ConvexRegion;
import cds.astro.Coo;
import cds.astro.EllipticalRegion;
import cds.astro.Proj3;
import cds.astro.ZonalRegion;
import java.io.Serializable;

public class Region
extends AbstractRegion
implements Serializable {
    @Override
    public String toString() {
        return this.toString();
    }

    @Override
    public double area() {
        return this.area();
    }

    @Override
    public boolean checkCoo(Coo point) {
        return this.checkCoo(point);
    }

    @Override
    public int checkCircle(Coo point, double r) {
        return this.checkCircle(point, r);
    }

    Region() {
        this.centroid = null;
    }

    public static Region circle(Coo center, double radius) {
        CircularRegion reg = new CircularRegion(center, radius);
        return reg;
    }

    public static Region box(Astroframe frame, Coo center, double width, double height) {
        Coo[] v4 = new Coo[4];
        Proj3 proj = new Proj3(center);
        double x = AstroMath.tand(width / 2.0);
        double y = AstroMath.tand(height / 2.0);
        proj.set(x, y);
        v4[0] = proj.getCoo();
        proj.set(x, -y);
        v4[1] = proj.getCoo();
        proj.set(-x, -y);
        v4[2] = proj.getCoo();
        proj.set(-x, y);
        v4[3] = proj.getCoo();
        double pa = 90.0;
        if (frame != null) {
            for (int i = 0; i < 4; ++i) {
                frame.toICRS(v4[i]);
            }
            Coo c = new Coo(center);
            frame.toICRS(c);
            proj.set(x, 0.0);
            Coo w = proj.getCoo();
            frame.toICRS(w);
            pa = c.posAngle(w);
        }
        if (DEBUG) {
            System.out.print("#...Creating box(" + center + " " + width + "x" + height + "deg)");
            if (frame != null) {
                System.out.print("[" + frame.toString() + "]");
            }
            System.out.println(" as convex:");
            for (int i = 0; i < 4; ++i) {
                v4[i].dump("#" + i + "#");
            }
        }
        ConvexRegion reg = new ConvexRegion(v4);
        reg.setBox(width, height, pa);
        return reg;
    }

    public static Region rotatedBox(Coo center, double dim1, double dim2, double posangle) {
        Coo[] v4 = new Coo[4];
        Proj3 proj = new Proj3(center);
        double h = AstroMath.tand(dim1 / 2.0);
        double w = AstroMath.tand(dim2 / 2.0);
        double c = AstroMath.cosd(posangle);
        double s = AstroMath.sind(posangle);
        double x = c * w + s * h;
        double y = -s * w + c * h;
        proj.set(x, y);
        v4[0] = proj.getCoo();
        w = -w;
        x = c * w + s * h;
        y = -s * w + c * h;
        proj.set(x, y);
        v4[1] = proj.getCoo();
        h = -h;
        x = c * w + s * h;
        y = -s * w + c * h;
        proj.set(x, y);
        v4[2] = proj.getCoo();
        w = -w;
        x = c * w + s * h;
        y = -s * w + c * h;
        proj.set(x, y);
        v4[3] = proj.getCoo();
        if (DEBUG) {
            System.out.println("#...Creating box(" + center + " " + dim1 + "x" + dim2 + "deg, pa=" + posangle + ") as convex:");
            for (int i = 0; i < 4; ++i) {
                v4[i].dump("#" + i + "#");
            }
        }
        ConvexRegion reg = new ConvexRegion(v4);
        reg.setBox(dim1, dim2, posangle);
        return reg;
    }

    public static Region polygon(Coo[] vertices) {
        ConvexRegion reg = new ConvexRegion(vertices);
        return reg;
    }

    public static Region zone(Astroframe frame, double lon0, double lon1, double lat0, double lat1) {
        ZonalRegion reg = new ZonalRegion(frame, lon0, lon1, lat0, lat1);
        return reg;
    }

    public static Region zone(Astroframe frame, Coo center, double width, double height) {
        ZonalRegion reg = new ZonalRegion(frame, center, width, height);
        return reg;
    }

    public static Region ellipse(Astroframe frame, Coo center, double londim, double latdim) {
        EllipticalRegion reg = new EllipticalRegion(frame, center, londim, latdim, 90.0);
        return reg;
    }

    public static Region ellipse(Coo center, double a, double b, double pa) {
        EllipticalRegion reg = new EllipticalRegion(null, center, a, b, pa);
        return reg;
    }
}

