/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Coocube;
import java.io.Serializable;
import java.text.ParseException;

public class QboxNumber
implements Serializable {
    public final int level;
    private static final double PIO2 = 1.5707963267948966;
    static final boolean DEBUG = true;
    static final int ANY = Integer.MIN_VALUE;
    static final int BOX = Integer.MAX_VALUE;
    private static final int MAXLEVEL = 12;
    public static int default_level = 9;
    private static final char[] oct = "01234567".toCharArray();
    private static final double DEG = 57.29577951308232;
    static final double[] MAXRAD = new double[]{54.735610317, 30.361193405, 16.403086517, 8.639594386, 4.449359566, 2.259674852, 1.138910823, 0.571763982, 0.286464128, 0.14337822, 0.071725727, 0.035872027, 0.017938306};
    static final double[] SINRAD = new double[]{0.816496580927726, 0.5054494651244236, 0.2823931345695149, 0.1502185901567493, 0.0775779474805375, 0.0394285430318791, 0.0198764347423619, 0.0099789983974146, 0.0049997213877594, 0.0025024194021835, 0.0012518497600656, 6.260849416742E-4, 3.130824920569E-4};
    static final double[] MINRAD = new double[]{45.0, 21.793189128656, 9.612900642866, 4.557754524215, 2.213411995038, 1.089949904684, 0.540737084594, 0.269302913463, 0.134384274203, 0.067125244187, 0.03354588668, 0.016768757962, 0.008383332446};
    private static final boolean[] move_x = new boolean[]{true, false, false, true};
    private static final byte[][] adj_face = new byte[][]{{0, 2, 14, 10, 6, 3, 11, 0}, {0, 12, 4, 1, 13, 9, 5, 0}, {0, 3, 11, 14, 2, 6, 10, 0}, {0, 13, 1, 5, 9, 12, 4, 0}};
    private static final byte[][] adj_move = new byte[][]{{2, 3, 4, 5}, {1, 4, 3, 6}, {5, 0, 7, 2}, {6, 7, 0, 1}};
    private static final byte[] nearby_xy = new byte[]{21, 35, 33, 5, 19, 17, 1, 3};

    public static final int setLevel(int lev) {
        int old_lev = default_level;
        if (lev >= 0 && lev <= 12) {
            default_level = lev;
        }
        return old_lev;
    }

    static double dist2(double[] v1, double[] v2) {
        double r = v1[0] - v2[0];
        r *= r;
        double d = v1[1] - v2[1];
        d *= d;
        r += d;
        d = v1[2] - v2[2];
        d *= d;
        return r += d;
    }

    static double dotprod(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    static double norm2(double[] v1) {
        return QboxNumber.dotprod(v1, v1);
    }

    static void vecprod(double[] v1, double[] v2, double[] r) {
        r[0] = v1[1] * v2[2] - v1[2] * v2[1];
        r[1] = v1[2] * v2[0] - v1[0] * v2[2];
        r[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    static double det(double[] v1, double[] v2, double[] v3) {
        double[] v = new double[3];
        QboxNumber.vecprod(v1, v2, v);
        return QboxNumber.dotprod(v, v3);
    }

    private static final int center_(int qboxno, double[] XY2) {
        int b = qboxno & Integer.MAX_VALUE;
        int x = 0;
        int y = 0;
        if (b < 9) {
            XY2[0] = 0.0;
            XY2[1] = 0.0;
            return 0;
        }
        int qlev = 0;
        while ((b & 0xFFFFFFF0) != 0) {
            y |= (b & 1) << qlev;
            x |= ((b >>>= 1) & 1) << qlev;
            b >>>= 1;
            ++qlev;
        }
        double f = 1 << qlev;
        XY2[0] = Math.tan((((double)x + 0.5) / f - 0.5) * 1.5707963267948966);
        XY2[1] = Math.tan((((double)y + 0.5) / f - 0.5) * 1.5707963267948966);
        return b & 7;
    }

    static final int corners(int qboxno, double[] blur) {
        int b = qboxno & Integer.MAX_VALUE;
        int x = 0;
        int y = 0;
        if (b == 0) {
            return 0;
        }
        int qlev = 0;
        while ((b & 0xFFFFFFF0) != 0) {
            y |= (b & 1) << qlev;
            x |= ((b >>= 1) & 1) << qlev;
            b >>= 1;
            ++qlev;
        }
        double f = 1 << qlev;
        blur[0] = Math.tan(((double)x / f - 0.5) * 1.5707963267948966);
        blur[1] = Math.tan(((double)y / f - 0.5) * 1.5707963267948966);
        blur[2] = Math.tan(((double)(++x) / f - 0.5) * 1.5707963267948966);
        blur[3] = Math.tan(((double)(++y) / f - 0.5) * 1.5707963267948966);
        return b & 7;
    }

    static final int ucorners(int qboxno, double[][] ucorn) {
        double[] XY2 = new double[4];
        int face = QboxNumber.corners(qboxno, XY2);
        if (face == 0) {
            return face;
        }
        Coocube.setUvec(face, XY2[0], XY2[1], ucorn[0]);
        Coocube.setUvec(face, XY2[2], XY2[1], ucorn[1]);
        Coocube.setUvec(face, XY2[2], XY2[3], ucorn[2]);
        Coocube.setUvec(face, XY2[0], XY2[3], ucorn[3]);
        return face;
    }

    static final int level(double arcmin) {
        int i = MINRAD.length;
        double rad = arcmin / 60.0;
        while (--i > 0) {
            if (!(MINRAD[i] > rad)) continue;
            return i;
        }
        return 0;
    }

    public QboxNumber() {
        this.level = default_level;
    }

    public QboxNumber(int level) {
        this.level = level;
    }

    public QboxNumber(double arcmin) {
        this.level = QboxNumber.level(arcmin);
    }

    public static int qbox(String text) throws ParseException {
        int i;
        char[] a = text.toCharArray();
        int error = 0;
        int qbox = 0;
        for (i = 0; i < a.length && a[i] == ' '; ++i) {
        }
        if (i >= a.length) {
            return qbox;
        }
        if (a[i] >= '1' && a[i] <= '6') {
            qbox = 8 | Character.digit(a[i], 8);
        } else {
            ++error;
        }
        if (++i < a.length && (a[i] == ':' || a[i] == '.')) {
            ++i;
        }
        while (i < a.length && a[i] >= '0' && a[i] < '4') {
            qbox = qbox << 2 | Character.digit(a[i], 4);
            ++i;
        }
        if (i < a.length && Character.toUpperCase(a[i]) == 'A') {
            ++i;
            qbox |= Integer.MIN_VALUE;
        }
        while (i < a.length && a[i] == ' ') {
            ++i;
        }
        if (i < a.length) {
            ++error;
        }
        if (error > 0) {
            throw new ParseException("****QboxNumber: '" + text + "'+" + i, i);
        }
        return qbox;
    }

    public static final int level(int qbox) {
        int n = 0;
        if ((qbox &= Integer.MAX_VALUE) == 0) {
            return -1;
        }
        if ((qbox & 0x7FFF0000) != 0) {
            n = 7;
            qbox >>>= 14;
        }
        while ((qbox & 0xFFFFFFF0) != 0) {
            qbox >>>= 2;
            ++n;
        }
        return n;
    }

    public static final int index(int qbox) {
        int n = QboxNumber.level(qbox);
        int i = (qbox & Integer.MAX_VALUE) - (9 << (n << 1));
        if (i < 0) {
            i += 8;
        }
        return i;
    }

    public static final int face(int qbox) {
        int n = QboxNumber.level(qbox);
        if (n < 0) {
            return 0;
        }
        return qbox >>> (n << 1) & 7;
    }

    private static final int boxno(int level, int face, double X, double Y) {
        int qbox = face;
        qbox |= 8;
        int count = 1 << level;
        double xy = (0.5 + Math.atan(X) / 1.5707963267948966) * (double)count;
        int x = (int)xy;
        xy = (0.5 + Math.atan(Y) / 1.5707963267948966) * (double)count;
        int y = (int)xy;
        if (x >= count) {
            x = count - 1;
        }
        if (y >= count) {
            y = count - 1;
        }
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        qbox <<= level << 1;
        count >>= 1;
        int i = level - 1;
        while (count > 0) {
            qbox |= (x & count) << i << 1 | (y & count) << i;
            count >>= 1;
            --i;
        }
        return qbox;
    }

    public final int qbox(double lon, double lat) {
        double[] XY2 = new double[2];
        double[] u = new double[3];
        Coo.setUvec(lon, lat, u);
        int qbox = Coocube.setXY(u, XY2);
        return QboxNumber.boxno(this.level, qbox, XY2[0], XY2[1]);
    }

    public final int qbox(Coocube cc) {
        return QboxNumber.boxno(this.level, cc.face, cc.X, cc.Y);
    }

    public final int qbox(Coo c) {
        double[] XY2 = new double[2];
        double[] u = new double[]{c.x, c.y, c.z};
        int qbox = Coocube.setXY(u, XY2);
        return QboxNumber.boxno(this.level, qbox, XY2[0], XY2[1]);
    }

    public static final Coo center(int qbox) {
        double[] u = new double[3];
        double[] XY2 = new double[2];
        int face = QboxNumber.center_(qbox, XY2);
        System.out.println("....center: face=" + face + ", XY=" + XY2[0] + "," + XY2[1]);
        Coocube.setUvec(face, XY2[0], XY2[1], u);
        Coo coo = new Coo(u[0], u[1], u[2]);
        coo.dump("Center");
        return coo;
    }

    public static final void center(int qbox, Coo coo) {
        double[] u = new double[3];
        double[] XY2 = new double[2];
        int face = QboxNumber.center_(qbox, XY2);
        Coocube.setUvec(face, XY2[0], XY2[1], u);
        coo.set(u[0], u[1], u[2]);
    }

    public final double maxRadius() {
        return MAXRAD[this.level];
    }

    public final double minRadius() {
        return MINRAD[this.level];
    }

    public static final double area(int qbox) {
        double[] XY2 = new double[4];
        QboxNumber.corners(qbox & Integer.MAX_VALUE, XY2);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            XY2[n] = XY2[n] / Math.sqrt(1.0 + XY2[i] * XY2[i]);
        }
        double S = Math.asin(XY2[0] * XY2[1]) + Math.asin(XY2[2] * XY2[3]) - Math.asin(XY2[0] * XY2[3]) - Math.asin(XY2[1] * XY2[2]);
        return 3282.806350011744 * Math.abs(S);
    }

    public static final double radius(int qbox) {
        double[] XY2 = new double[4];
        double[] XYc = new double[2];
        double rmax = 0.0;
        QboxNumber.center_(qbox & Integer.MAX_VALUE, XYc);
        QboxNumber.corners(qbox & Integer.MAX_VALUE, XY2);
        double denc = 1.0 + XYc[0] * XYc[0] + XYc[1] * XYc[1];
        for (int i = 0; i < 4; ++i) {
            double s2r;
            double X = XY2[i & 2];
            double Y = XY2[(i & 1) << 1 | 1];
            double den = denc * (1.0 + X * X + Y * Y);
            double num = X * XYc[1] - Y * XYc[0];
            num *= num;
            if ((s2r = (num += (X -= XYc[0]) * X + (Y -= XYc[1]) * Y) / den) > rmax) {
                rmax = s2r;
            }
            System.out.println("....radius(): corner#" + i + "(" + (i & 2) + "," + ((i & 1) << 1 | 1) + ") -- X,Y=" + X + "," + Y + "\n          s2r=" + s2r);
        }
        return 57.29577951308232 * Math.asin(Math.sqrt(rmax));
    }

    public static final int adjacent(int qboxno, int direction) {
        byte k;
        int r = 0;
        int shifted = 0;
        int qb = qboxno;
        int dir = direction & 3;
        while ((qb & 0xFFFFFFF0) != 0) {
            k = adj_move[dir][qb & 3];
            if ((k & 4) != 0) {
                r |= (k ^ 4) << shifted;
                qb >>= 2;
                shifted += 2;
                continue;
            }
            qb = qb & 0xFFFFFFFC | k;
            break;
        }
        if ((qb & 0xFFFFFFF0) == 0) {
            k = adj_face[dir][qb & 7];
            if ((k & 8) != 0) {
                int comb = 0;
                for (qb = shifted; qb > 0; qb -= 2) {
                    comb = comb << 2 | 2;
                }
                if (move_x[dir]) {
                    comb >>= 1;
                }
                r = qboxno & comb ^ comb;
                r = move_x[dir] ? (r <<= 1) : (r >>= 1);
                if ((dir & 2) != 0) {
                    r |= comb;
                }
            }
            qb = 8 | k;
        }
        if (shifted > 0) {
            qb <<= shifted;
            qb |= r;
        }
        return qb;
    }

    public static final void nearby(int qboxno, int[] contig) {
        int qbmax = 1 << (QboxNumber.level(qboxno) << 1);
        int nb = 4;
        boolean[] same_face = new boolean[4];
        for (int i = 0; i < 4; ++i) {
            contig[i] = QboxNumber.adjacent(qboxno, i);
            same_face[i] = (contig[i] ^ qboxno) < qbmax;
        }
        contig[7] = 0;
        contig[6] = 0;
        contig[5] = 0;
        contig[4] = 0;
        if (same_face[0]) {
            contig[4] = QboxNumber.adjacent(contig[0], 1);
            contig[5] = QboxNumber.adjacent(contig[0], 2);
            nb += 2;
        }
        if (same_face[3]) {
            contig[6] = QboxNumber.adjacent(contig[3], 1);
            contig[7] = QboxNumber.adjacent(contig[3], 2);
            nb += 2;
        }
        if (nb >= 7) {
            return;
        }
        if (same_face[1]) {
            if (contig[4] == 0) {
                contig[4] = QboxNumber.adjacent(contig[1], 0);
                ++nb;
            }
            if (contig[7] == 0) {
                contig[7] = QboxNumber.adjacent(contig[1], 3);
                ++nb;
            }
        }
        if (nb >= 7) {
            return;
        }
        if (same_face[2]) {
            if (contig[5] == 0) {
                contig[5] = QboxNumber.adjacent(contig[2], 0);
                ++nb;
            }
            if (contig[6] == 0) {
                contig[6] = QboxNumber.adjacent(contig[2], 3);
                ++nb;
            }
        }
    }

    public final int nearby(Coo center, int[] contig, double[] sin2d2) {
        double w;
        int iy;
        int ix;
        int i;
        int qbox = this.qbox(center);
        double[] cXY = new double[2];
        double[] coin = new double[4];
        double[] u = new double[3];
        double[] XY2 = new double[2];
        int face = QboxNumber.corners(qbox, coin);
        int nb = 9;
        QboxNumber.nearby(qbox, contig);
        u[0] = center.x;
        u[1] = center.y;
        u[2] = center.z;
        Coocube.setXY(u, cXY);
        for (i = 0; i < 8; ++i) {
            if (contig[i] == 0) {
                sin2d2[i] = 4.0;
                --nb;
                continue;
            }
            ix = nearby_xy[i] >> 3;
            iy = nearby_xy[i] & 7;
            XY2[0] = (ix & 4) == 0 ? coin[ix] : cXY[ix ^ 4];
            XY2[1] = (iy & 4) == 0 ? coin[iy] : cXY[iy ^ 4];
            Coocube.setUvec(face, XY2[0], XY2[1], u);
            double du = u[0] - center.x;
            w = du * du;
            du = u[1] - center.y;
            w += du * du;
            du = u[2] - center.z;
            sin2d2[i] = w += du * du;
        }
        for (ix = 0; ix < 7; ++ix) {
            for (iy = ix + 1; iy < 8; ++iy) {
                if (sin2d2[ix] <= sin2d2[iy]) continue;
                w = sin2d2[ix];
                sin2d2[ix] = sin2d2[iy];
                sin2d2[iy] = w;
                i = contig[ix];
                contig[ix] = contig[iy];
                contig[iy] = i;
            }
        }
        for (i = 8; i > 0; --i) {
            contig[i] = contig[i - 1];
            sin2d2[i] = sin2d2[i - 1];
        }
        contig[0] = qbox;
        sin2d2[0] = 0.0;
        return nb;
    }

    public static final String toString(int qbox) {
        char[] buf = new char[20];
        int i = buf.length;
        int b = qbox;
        if ((b & Integer.MIN_VALUE) != 0) {
            buf[--i] = 65;
            b &= Integer.MAX_VALUE;
        }
        while ((b & 0xFFFFFFF0) != 0) {
            buf[--i] = oct[b & 3];
            b >>>= 2;
        }
        if (b != 0) {
            buf[--i] = 58;
        }
        buf[--i] = oct[b & 7];
        return new String(buf, i, buf.length - i);
    }

    public final String toString() {
        return "[QboxNumber(" + this.level + ")]";
    }
}

