/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Region;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;

public class Qbox
implements Serializable {
    int qbox;
    private static final double PIO2 = 1.5707963267948966;
    static boolean DEBUG = false;
    static final int ANY = Integer.MIN_VALUE;
    static final int BOX = Integer.MAX_VALUE;
    private static final int MAXLEVEL = 12;
    public static int level = 9;
    static final int QBOX_NONE = 0;
    static final int QBOX_ANY = -1;
    static final int QBOX_SOME = 1;
    private static final char[] oct = "01234567".toCharArray();
    private static final double DEG = 57.29577951308232;
    static final double[] MAXRAD = new double[]{54.735610317, 30.361193405, 16.403086517, 8.639594386, 4.449359566, 2.259674852, 1.138910823, 0.571763982, 0.286464128, 0.14337822, 0.071725727, 0.035872027, 0.017938306};
    static final double[] SINRAD = new double[]{0.816496580927726, 0.5054494651244236, 0.2823931345695149, 0.1502185901567493, 0.0775779474805375, 0.0394285430318791, 0.0198764347423619, 0.0099789983974146, 0.0049997213877594, 0.0025024194021835, 0.0012518497600656, 6.260849416742E-4, 3.130824920569E-4};
    static final double[] MINRAD = new double[]{45.0, 21.793189128656, 9.612900642866, 4.557754524215, 2.213411995038, 1.089949904684, 0.540737084594, 0.269302913463, 0.134384274203, 0.067125244187, 0.03354588668, 0.016768757962, 0.008383332446};

    public static final int setLevel(int lev) {
        int old_lev = level;
        if (lev >= 0 && lev <= 12) {
            level = lev;
        }
        return old_lev;
    }

    private static final int center_(int qboxno, double[] XY2) {
        int b = qboxno & Integer.MAX_VALUE;
        int x = 0;
        int y = 0;
        if (b < 9) {
            XY2[0] = 0.0;
            XY2[1] = 0.0;
            return 0;
        }
        int qlev = 0;
        while ((b & 0xFFFFFFF0) != 0) {
            y |= (b & 1) << qlev;
            x |= ((b >>>= 1) & 1) << qlev;
            b >>>= 1;
            ++qlev;
        }
        double f = 1 << qlev;
        XY2[0] = Math.tan((((double)x + 0.5) / f - 0.5) * 1.5707963267948966);
        XY2[1] = Math.tan((((double)y + 0.5) / f - 0.5) * 1.5707963267948966);
        return b;
    }

    public static final int corners(int qboxno, double[] blur) {
        int b = qboxno & Integer.MAX_VALUE;
        int x = 0;
        int y = 0;
        if (b == 0) {
            return 0;
        }
        int qlev = 0;
        while ((b & 0xFFFFFFF0) != 0) {
            y |= (b & 1) << qlev;
            x |= ((b >>= 1) & 1) << qlev;
            b >>= 1;
            ++qlev;
        }
        double f = 1 << qlev;
        blur[0] = Math.tan(((double)x / f - 0.5) * 1.5707963267948966);
        blur[1] = Math.tan(((double)y / f - 0.5) * 1.5707963267948966);
        blur[2] = Math.tan(((double)(++x) / f - 0.5) * 1.5707963267948966);
        blur[3] = Math.tan(((double)(++y) / f - 0.5) * 1.5707963267948966);
        return b & 7;
    }

    public static final int ucenter(int qboxno, double[] ucenter) {
        double[] XY2 = new double[2];
        int face = Qbox.center_(qboxno, XY2);
        if (face == 0) {
            return face;
        }
        Coocube.setUvec(face, XY2[0], XY2[1], ucenter);
        return face;
    }

    public static final int ucorners(int qboxno, double[][] ucorn) {
        double[] XY2 = new double[4];
        int face = Qbox.corners(qboxno, XY2);
        if (face == 0) {
            return face;
        }
        Coocube.setUvec(face, XY2[0], XY2[1], ucorn[0]);
        Coocube.setUvec(face, XY2[2], XY2[1], ucorn[1]);
        Coocube.setUvec(face, XY2[2], XY2[3], ucorn[2]);
        Coocube.setUvec(face, XY2[0], XY2[3], ucorn[3]);
        return face;
    }

    private static final void range(int qbox, int[] qb) {
        int any = qbox & Integer.MIN_VALUE;
        if ((qbox & Integer.MAX_VALUE) == 0) {
            qb[0] = 9 << (level << 1) | any;
            qb[1] = 15 << (level << 1) | any;
        } else {
            qb[0] = qb[1] = qbox;
            int mask = 8 << (level << 1);
            while ((qb[0] & mask) == 0) {
                qb[0] = qb[0] << 2;
                qb[1] = qb[1] << 2 | 3;
            }
            qb[1] = qb[1] + 1;
            qb[0] = qb[0] | any;
            qb[1] = qb[1] | any;
        }
    }

    public Qbox() {
        this.qbox = 0;
    }

    public Qbox(Qbox qb) {
        this.set(qb);
    }

    public Qbox(Coo coo) {
        this.set(coo);
    }

    private Qbox(int b) {
        this.qbox = b;
    }

    public Qbox(String text) throws ParseException {
        char[] a = text.toCharArray();
        int error = 0;
        int i = 0;
        this.qbox = 0;
        if (i >= a.length) {
            return;
        }
        if (a[i] >= '1' && a[i] <= '6') {
            this.qbox = 8 | Character.digit(a[i], 8);
        } else {
            ++error;
        }
        if (++i < a.length && a[i] == ':') {
            ++i;
        }
        while (i < a.length && a[i] >= '0' && a[i] < '4') {
            this.qbox = this.qbox << 2 | Character.digit(a[i], 4);
            ++i;
        }
        if (i < a.length && Character.toUpperCase(a[i]) == 'A') {
            ++i;
            this.qbox |= Integer.MIN_VALUE;
        }
        if (i < a.length) {
            ++error;
        }
        if (error > 0) {
            throw new ParseException("****Qbox: '" + text + "'+" + i, i);
        }
    }

    public static final int level(int b) {
        int n = 0;
        if ((b &= Integer.MAX_VALUE) == 0) {
            return -1;
        }
        if ((b & 0x7FFF0000) != 0) {
            n = 7;
            b >>>= 14;
        }
        while ((b & 0xFFFFFFF0) != 0) {
            b >>>= 2;
            ++n;
        }
        return n;
    }

    public final int level() {
        return Qbox.level(this.qbox);
    }

    public final boolean isAny() {
        return (this.qbox & Integer.MIN_VALUE) != 0;
    }

    public final void toAny() {
        this.qbox |= Integer.MIN_VALUE;
    }

    public final int box() {
        return this.qbox & Integer.MAX_VALUE;
    }

    public final int index() {
        int n;
        int i = n = this.level();
        if (n >= 0) {
            i = (this.qbox & Integer.MAX_VALUE) - (9 << 2 * n);
        }
        return i;
    }

    public final int face() {
        int n = this.level();
        if (n < 0) {
            return 0;
        }
        return this.qbox >>> 2 * n & 7;
    }

    public final void set(Coocube cc) {
        int y;
        this.qbox = cc.face;
        if (level <= 0) {
            return;
        }
        if (this.qbox == 0) {
            return;
        }
        this.qbox |= 8;
        int count = 1 << level;
        double xy = (0.5 + Math.atan(cc.X) / 1.5707963267948966) * (double)count;
        int x = (int)xy;
        if (x >= count) {
            x = count - 1;
        }
        if ((y = (int)(xy = (0.5 + Math.atan(cc.Y) / 1.5707963267948966) * (double)count)) >= count) {
            y = count - 1;
        }
        this.qbox <<= level << 1;
        count >>= 1;
        int i = level - 1;
        while (count > 0) {
            this.qbox |= (x & count) << i << 1 | (y & count) << i;
            count >>= 1;
            --i;
        }
    }

    public final void set(Qbox qb) {
        this.qbox = qb.qbox;
    }

    public final void set(Coo c) {
        Coocube cc = new Coocube(c);
        this.set(cc);
    }

    final void set(int n) {
        this.qbox = n;
    }

    public final Coocube center() {
        double[] XY2 = new double[2];
        int b = Qbox.center_(this.qbox, XY2);
        return new Coocube(b & 7, XY2[0], XY2[1]);
    }

    public final boolean inside(Coo point) {
        if (this.qbox == 0) {
            return true;
        }
        double[] XY2 = new double[4];
        int face = Qbox.corners(this.qbox & Integer.MAX_VALUE, XY2);
        Coocube cc = new Coocube(point);
        if (cc.face != face) {
            return false;
        }
        return cc.X >= XY2[0] && cc.X <= XY2[2] && cc.Y >= XY2[1] && cc.Y <= XY2[3];
    }

    public static final double maxRadius() {
        return MAXRAD[level];
    }

    public static final double maxRadius(int qbox) {
        if (qbox == 0) {
            return 180.0;
        }
        int lev = Qbox.level(qbox);
        if (lev < 0) {
            return 0.0;
        }
        return MAXRAD[lev];
    }

    public static final double minRadius() {
        return MINRAD[level];
    }

    public static final double minRadius(int qbox) {
        if (qbox == 0) {
            return 180.0;
        }
        int lev = Qbox.level(qbox);
        if (lev < 0) {
            return 0.0;
        }
        return MINRAD[lev];
    }

    public final double area() {
        double[] XY2 = new double[4];
        Qbox.corners(this.qbox & Integer.MAX_VALUE, XY2);
        for (int i = 0; i < 4; ++i) {
            int n = i;
            XY2[n] = XY2[n] / Math.sqrt(1.0 + XY2[i] * XY2[i]);
        }
        double S = Math.asin(XY2[0] * XY2[1]) + Math.asin(XY2[2] * XY2[3]) - Math.asin(XY2[0] * XY2[3]) - Math.asin(XY2[1] * XY2[2]);
        return 3282.806350011744 * Math.abs(S);
    }

    public final double radius() {
        double[] XY2 = new double[4];
        double[] XYc = new double[2];
        double rmax = 0.0;
        Qbox.center_(this.qbox & Integer.MAX_VALUE, XYc);
        Qbox.corners(this.qbox & Integer.MAX_VALUE, XY2);
        double denc = 1.0 + XYc[0] * XYc[0] + XYc[1] * XYc[1];
        for (int i = 0; i < 4; ++i) {
            double s2r;
            double X = XY2[i & 2];
            double Y = XY2[(i & 1) << 1 | 1];
            double den = denc * (1.0 + X * X + Y * Y);
            double num = X * XYc[1] - Y * XYc[0];
            num *= num;
            if (!((s2r = (num += (X -= XYc[0]) * X + (Y -= XYc[1]) * Y) / den) > rmax)) continue;
            rmax = s2r;
        }
        return 57.29577951308232 * Math.asin(Math.sqrt(rmax));
    }

    public final Coo[] corners() {
        Coo[] c = new Coo[4];
        double[] XY2 = new double[4];
        int face = Qbox.corners(this.qbox, XY2);
        if (face == 0) {
            return c;
        }
        double[] u = new double[3];
        Coocube.setUvec(face, XY2[0], XY2[1], u);
        c[0] = new Coo(u[0], u[1], u[2]);
        Coocube.setUvec(face, XY2[2], XY2[1], u);
        c[1] = new Coo(u[0], u[1], u[2]);
        Coocube.setUvec(face, XY2[2], XY2[3], u);
        c[2] = new Coo(u[0], u[1], u[2]);
        Coocube.setUvec(face, XY2[0], XY2[3], u);
        c[3] = new Coo(u[0], u[1], u[2]);
        return c;
    }

    public final String toString() {
        char[] buf = new char[20];
        int i = buf.length;
        int b = this.qbox;
        if ((b & Integer.MIN_VALUE) != 0) {
            buf[--i] = 65;
            b &= Integer.MAX_VALUE;
        }
        while ((b & 0xFFFFFFF0) != 0) {
            buf[--i] = oct[b & 3];
            b >>>= 2;
        }
        if (b != 0) {
            buf[--i] = 58;
        }
        buf[--i] = oct[b & 7];
        return new String(buf, i, buf.length - i);
    }

    private static final void call_down(int qbox, Region geom, ArrayList<Qbox> found) {
        int qb1;
        int qb0;
        int leaf = 8 << (level << 1);
        if (qbox == 0) {
            qb0 = 9;
            qb1 = 14;
        } else {
            qb0 = qbox << 2;
            qb1 = qb0 | 3;
        }
        for (int qb = qb0; qb <= qb1; ++qb) {
            int status = geom.checkQbox(qb);
            if (status == 0) {
                if (!DEBUG) continue;
                System.out.println("#...checkQ(" + qb + ") => NONE");
                continue;
            }
            if (status == -1) {
                if (DEBUG) {
                    System.out.println("#...checkQ(" + qb + ") => +ANY");
                }
                found.add(new Qbox(qb | Integer.MIN_VALUE));
                continue;
            }
            if ((qb & leaf) != 0) {
                if (DEBUG) {
                    System.out.println("#...checkQ(" + qb + ") => +add");
                }
                found.add(new Qbox(qb));
                continue;
            }
            if (DEBUG) {
                System.out.println("#...checkQ(" + qb + ") => ....");
            }
            Qbox.call_down(qb, geom, found);
        }
    }

    static ArrayList in_region(Region region) {
        ArrayList<Qbox> vector = new ArrayList<Qbox>();
        if (region.maxrad < MAXRAD[level]) {
            Qbox cbox = new Qbox(region.centroid);
            if (region.checkQbox(cbox.qbox) == 3) {
                vector.add(cbox);
                return vector;
            }
        }
        Qbox.call_down(0, region, vector);
        return vector;
    }

    public Enumeration list() {
        return new Enumeration(){
            int[] qb;
            {
                this.qb = new int[]{Qbox.this.qbox, 0};
            }

            @Override
            public boolean hasMoreElements() {
                if (this.qb[1] == 0) {
                    Qbox.range(this.qb[0], this.qb);
                }
                return this.qb[0] < this.qb[1];
            }

            public Object nextElement() {
                Qbox e = new Qbox();
                int n = this.qb[0];
                this.qb[0] = n + 1;
                e.qbox = n;
                return e;
            }
        };
    }

    public static Enumeration list(final ArrayList vector) {
        return new Enumeration(){
            ArrayList v;
            int pos;
            int[] qb;
            {
                this.v = vector;
                this.pos = 0;
                this.qb = new int[]{0, 0};
            }

            @Override
            public boolean hasMoreElements() {
                if (this.qb[0] >= this.qb[1]) {
                    if (this.pos >= this.v.size()) {
                        return false;
                    }
                    Qbox o = (Qbox)this.v.get(this.pos++);
                    Qbox.range(o.qbox, this.qb);
                }
                return true;
            }

            public Object nextElement() {
                Qbox e = new Qbox(this.qb[0]);
                this.qb[0] = this.qb[0] + 1;
                return e;
            }
        };
    }

    public static Enumeration list(Region region) {
        ArrayList vector = Qbox.in_region(region);
        return Qbox.list(vector);
    }

    public static Enumeration circle(Coo center, double radius) {
        return Qbox.list(Region.circle(center, radius));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        boolean res = false;
        if (o instanceof Qbox) {
            res = ((Qbox)o).qbox == this.qbox;
        }
        return res;
    }

    public int hashCode() {
        return 123 * this.qbox;
    }
}

