/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Coo;
import java.text.ParseException;

public class Proj3 {
    protected byte type;
    private double[][] R;
    protected double clon;
    protected double clat;
    protected double X;
    protected double Y;
    protected Coo point;
    public static final int NONE = 0;
    public static final int TAN = 1;
    public static final int TAN2 = 2;
    public static final int SIN = 3;
    public static final int SIN2 = 4;
    public static final int ARC = 5;
    public static final int AITOFF = 6;
    public static final int SANSON = 7;
    public static final int MERCATOR = 8;
    public static final int LAMBERT = 9;
    public static final String[] name = new String[]{"-", "Gnomonic (TAN)", "Stereographic (TAN2)", "Orthographic (SIN)", "Zenithal Equal-area (SIN2)", "Schmidt (ARC)", "Aitoff", "Sanson", "Mercator", "Lambert"};

    public Proj3(Coo centre) {
        this(1, centre);
    }

    public Proj3(int type, Coo centre) {
        this.type = (byte)type;
        this.point = new Coo(centre);
        this.clon = this.point.getLon();
        this.clat = this.point.getLat();
        if (this.clon != 0.0 || this.clat != 0.0) {
            this.R = this.point.localMatrix();
        }
    }

    public Proj3(int type, double lon, double lat) {
        this(type, new Coo(lon, lat));
    }

    public Proj3(int type, String text) throws ParseException {
        this.point = new Coo(text);
        this.type = (byte)type;
        this.clon = this.point.lon;
        this.clat = this.point.lat;
        if (this.clon != 0.0 || this.clat != 0.0) {
            this.R = Coo.localMatrix(this.clon, this.clat);
        }
    }

    public Proj3(int type) {
        this(type, 0.0, 0.0);
    }

    public Proj3(double lon, double lat) {
        this(new Coo(lon, lat));
    }

    public final double getX() {
        return this.X;
    }

    public final double getY() {
        return this.Y;
    }

    public final Coo getCoo() {
        return new Coo(this.point);
    }

    public final double getLon() {
        return this.point.lon;
    }

    public final double getLat() {
        return this.point.lat;
    }

    public String toString() {
        return name[this.type] + " projection centered at " + this.clon + " " + this.clat + ": " + this.X + " " + this.Y;
    }

    public boolean set(Coo coo) {
        double z;
        double y;
        double x;
        if (this.point.equals(coo)) {
            return !Double.isNaN(this.X);
        }
        this.X = Double.NaN;
        this.Y = Double.NaN;
        if (this.R == null) {
            x = coo.x;
            y = coo.y;
            z = coo.z;
        } else {
            x = this.R[0][0] * coo.x + this.R[0][1] * coo.y + this.R[0][2] * coo.z;
            y = this.R[1][0] * coo.x + this.R[1][1] * coo.y + this.R[1][2] * coo.z;
            z = this.R[2][0] * coo.x + this.R[2][1] * coo.y + this.R[2][2] * coo.z;
        }
        switch (this.type) {
            case 1: {
                if (x <= 0.0) {
                    return false;
                }
                this.X = y / x;
                this.Y = z / x;
                break;
            }
            case 2: {
                double w = (1.0 + x) / 2.0;
                if (w <= 0.0) {
                    this.X = Double.NaN;
                    this.Y = Double.NaN;
                    return false;
                }
                this.X = y / w;
                this.Y = z / w;
                break;
            }
            case 3: {
                if (x <= 0.0) {
                    return false;
                }
                this.X = y;
                this.Y = z;
                break;
            }
            case 4: {
                double w = Math.sqrt((1.0 + x) / 2.0);
                if (w > 0.0) {
                    this.X = y / w;
                    this.Y = z / w;
                    break;
                }
                this.X = 2.0;
                this.Y = 0.0;
                break;
            }
            case 5: {
                if (x > -1.0) {
                    double r = Math.sqrt(y * y + z * z);
                    double w = x > 0.0 ? AstroMath.asinc(r) : Math.acos(x) / r;
                    this.X = y * w;
                    this.Y = z * w;
                    break;
                }
                this.X = Math.PI;
                this.Y = 0.0;
                break;
            }
            case 6: {
                double r = Math.sqrt(x * x + y * y);
                double w = Math.sqrt(r * (r + x) / 2.0);
                w = Math.sqrt((1.0 + w) / 2.0);
                this.X = Math.sqrt(2.0 * r * (r - x)) / w;
                this.Y = z / w;
                if (!(y < 0.0)) break;
                this.X = -this.X;
                break;
            }
            case 7: {
                double r = Math.sqrt(x * x + y * y);
                this.Y = Math.asin(z);
                if (r == 0.0) {
                    this.X = 0.0;
                    break;
                }
                this.X = Math.atan2(y, x) * r;
                break;
            }
            case 8: {
                double r = Math.sqrt(x * x + y * y);
                if (r == 0.0) {
                    return false;
                }
                this.X = Math.atan2(y, x);
                this.Y = AstroMath.atanh(z);
                break;
            }
            case 9: {
                double r = Math.sqrt(x * x + y * y);
                this.Y = z;
                if (r == 0.0) {
                    this.X = 0.0;
                    break;
                }
                this.X = Math.atan2(y, x);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Proj3: Invalid Projection type #" + this.type);
            }
        }
        this.point.set(coo);
        return true;
    }

    public boolean set(double px, double py) {
        double z;
        double y;
        double x;
        if (px == this.X && py == this.Y) {
            return this.point.x != 0.0 || this.point.y != 0.0 || this.point.z != 0.0;
        }
        this.X = px;
        this.Y = py;
        this.point.lat = Double.NaN;
        this.point.lon = Double.NaN;
        this.point.z = 0.0;
        this.point.y = 0.0;
        this.point.x = 0.0;
        switch (this.type) {
            case 1: {
                x = 1.0 / Math.sqrt(1.0 + this.X * this.X + this.Y * this.Y);
                y = this.X * x;
                z = this.Y * x;
                break;
            }
            case 2: {
                double r = (this.X * this.X + this.Y * this.Y) / 4.0;
                double w = 1.0 + r;
                x = (1.0 - r) / w;
                y = this.X / w;
                z = this.Y / w;
                break;
            }
            case 3: {
                double w = 1.0 - this.X * this.X - this.Y * this.Y;
                if (w < 0.0) {
                    if (w > -2.0E-16) {
                        w = 0.0;
                    } else {
                        return false;
                    }
                }
                x = Math.sqrt(w);
                y = this.X;
                z = this.Y;
                break;
            }
            case 4: {
                double r = (this.X * this.X + this.Y * this.Y) / 4.0;
                if (r > 1.0) {
                    return false;
                }
                double w = Math.sqrt(1.0 - r);
                x = 1.0 - 2.0 * r;
                y = w * this.X;
                z = w * this.Y;
                break;
            }
            case 5: {
                double r = Math.sqrt(this.X * this.X + this.Y * this.Y);
                if (r > Math.PI) {
                    return false;
                }
                double w = AstroMath.sinc(r);
                x = Math.cos(r);
                y = w * this.X;
                z = w * this.Y;
                break;
            }
            case 6: {
                double r = this.X * this.X / 8.0 + this.Y * this.Y / 2.0;
                if (r > 1.0) {
                    return false;
                }
                x = 1.0 - r;
                double w = Math.sqrt(1.0 - r / 2.0);
                y = this.X * w / 2.0;
                z = this.Y * w;
                r = Math.sqrt(x * x + y * y);
                if (!(r > 0.0)) break;
                w = x;
                x = (w * w - y * y) / r;
                y = 2.0 * w * y / r;
                break;
            }
            case 7: {
                z = Math.sin(this.Y);
                double r = 1.0 - z * z;
                if (r < 0.0) {
                    return false;
                }
                double w = (r = Math.sqrt(r)) == 0.0 ? 0.0 : this.X / r;
                x = r * Math.cos(w);
                y = r * Math.sin(w);
                break;
            }
            case 8: {
                double r = 1.0 / AstroMath.cosh(this.Y);
                z = AstroMath.tanh(this.Y);
                x = r * Math.cos(this.X);
                y = r * Math.sin(this.X);
                break;
            }
            case 9: {
                z = this.Y;
                double r = 1.0 - z * z;
                if (r < 0.0) {
                    return false;
                }
                r = Math.sqrt(r);
                x = r * Math.cos(this.X);
                y = r * Math.sin(this.X);
                break;
            }
            default: {
                throw new IllegalArgumentException("****Proj3: Invalid Projection type #" + this.type);
            }
        }
        if (this.R != null) {
            this.point.set(this.R[0][0] * x + this.R[1][0] * y + this.R[2][0] * z, this.R[0][1] * x + this.R[1][1] * y + this.R[2][1] * z, this.R[0][2] * x + this.R[1][2] * y + this.R[2][2] * z);
        } else {
            this.point.set(x, y, z);
        }
        return true;
    }

    public boolean moveCenter(double X2, double Y2) {
        if (this.X == X2 && this.Y == Y2) {
            return true;
        }
        double[][] M1 = this.point.localMatrix();
        if (!this.set(X2, Y2)) {
            return false;
        }
        double[][] M2 = this.point.localMatrix();
        M2 = AstroMath.m3p(M2, AstroMath.m3t(M1));
        this.R = this.R == null ? M2 : AstroMath.m3p(this.R, M2);
        this.point.set(this.R[0][0], this.R[0][1], this.R[0][2]);
        this.clon = this.point.getLon();
        this.clat = this.point.getLat();
        this.set(X2, Y2);
        return true;
    }
}

