/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroformat;
import cds.astro.Astrotime;
import java.text.ParseException;

public class Parsing
extends Astroformat {
    public char[] a;
    public int length;
    public int pos;
    private int flags;
    public String error_message;
    public static final int OK = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static int DEBUG = 0;
    private static final char[] sexa_letter = new char[]{':', 'm', 's'};
    private static final char[] sexa_symbol = new char[]{'\u00b0', '\'', '\"'};
    private static final char[] sexa_symb1 = new char[]{':', 'd', 'o', '\u00b0', 'h', 'm', 's', '\'', '\"'};
    private static final byte[] sexa_unit1 = new byte[]{2, 4, 4, 20, 6, 7, 15, 21, 29};
    private static final char[] brackets = "()[]{}<>".toCharArray();
    private static final String[] error_symb = new String[]{"+/-", "+", "-", "\u00b1", "["};

    public Parsing(String s) {
        this(s, 0);
    }

    public Parsing(String s, int offset) {
        this.length = s.length();
        this.a = s.toCharArray();
        this.pos = offset;
    }

    public final void set(int n) {
        this.pos = n;
        if (this.pos > this.a.length) {
            this.pos = this.a.length;
        }
        if (this.pos < 0) {
            this.pos = 0;
        }
    }

    public final void set(String text) {
        this.a = text.toCharArray();
        this.length = text.length();
        this.pos = 0;
    }

    public final void advance(int n) {
        this.set(this.pos + n);
    }

    public final char currentChar() {
        if (this.pos >= this.length) {
            return '\u0000';
        }
        return this.a[this.pos];
    }

    public final void gobbleSpaces() {
        while (this.pos < this.length && Character.isWhitespace(this.a[this.pos])) {
            ++this.pos;
        }
    }

    public final int lookup(char[] tSymbol) {
        if (this.pos >= this.length) {
            return -1;
        }
        char c = this.a[this.pos];
        for (int i = 0; i < tSymbol.length; ++i) {
            if (tSymbol[i] != c) continue;
            ++this.pos;
            return i;
        }
        return -1;
    }

    public final boolean match(char c) {
        int posini = this.pos;
        this.gobbleSpaces();
        if (this.pos < this.length && this.a[this.pos++] == c) {
            return true;
        }
        this.pos = posini;
        return false;
    }

    public final boolean match(String text) {
        int i;
        int posini = this.pos;
        int len = text.length();
        boolean matching = len + this.pos <= this.length;
        for (i = 0; matching && i < len; ++i) {
            matching = this.a[this.pos++] == text.charAt(i);
        }
        if (matching) {
            boolean bl = matching = i == len;
        }
        if (!matching) {
            this.pos = posini;
        }
        return matching;
    }

    public final int lookup(String[] tSymbol, int len) {
        if (this.flags > 0) {
            this.flags = 0;
        }
        if (this.pos + len <= this.length) {
            for (int i = 0; i < tSymbol.length; ++i) {
                int j;
                if (tSymbol[i].length() != len) continue;
                for (j = 0; j < len && tSymbol[i].charAt(j) == this.a[this.pos + j]; ++j) {
                }
                if (j < len) continue;
                this.pos += len;
                return i;
            }
        }
        return -1;
    }

    public final int lookup(String[] tSymbol) {
        int maxlen = this.length - this.pos;
        int symlen = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        for (int i = 0; i < tSymbol.length; ++i) {
            int j;
            symlen = tSymbol[i].length();
            if (symlen > maxlen) continue;
            for (j = 0; j < symlen && tSymbol[i].charAt(j) == this.a[this.pos + j]; ++j) {
            }
            if (j < symlen) continue;
            this.pos += symlen;
            return i;
        }
        return -1;
    }

    public final int lookupIgnoreCase(String[] tSymbol) {
        int maxlen = this.length - this.pos;
        int symlen = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        for (int i = 0; i < tSymbol.length; ++i) {
            int j;
            symlen = tSymbol[i].length();
            if (symlen > maxlen) continue;
            for (j = 0; j < symlen && Character.toLowerCase(tSymbol[i].charAt(j)) == Character.toLowerCase(this.a[this.pos + j]); ++j) {
            }
            if (j < symlen) continue;
            this.pos += symlen;
            return i;
        }
        return -1;
    }

    public final int matchingBracket() {
        int posini = this.pos;
        if (this.pos >= this.length) {
            return -1;
        }
        int i = this.lookup(brackets);
        if (i < 0) {
            return i;
        }
        this.pos = posini;
        char c = brackets[i];
        char o = brackets[i ^ 1];
        int depth = 1;
        int j = this.pos;
        if ((i & 1) == 0) {
            ++j;
            while (j < this.length) {
                if (this.a[j] == c) {
                    ++depth;
                } else if (this.a[j] == o) {
                    --depth;
                }
                if (depth != 0) {
                    ++j;
                    continue;
                }
                break;
            }
        } else {
            --j;
            while (j >= 0) {
                if (this.a[j] == c) {
                    ++depth;
                } else if (this.a[j] == o) {
                    --depth;
                }
                if (depth != 0) {
                    --j;
                    continue;
                }
                break;
            }
        }
        if (j >= this.length) {
            j = -1;
        }
        return j;
    }

    public final int matchingQuote() {
        int j;
        for (j = this.pos + 1; j < this.length && this.a[j] != this.a[this.pos]; ++j) {
        }
        if (j >= this.length) {
            j = -1;
        }
        return j;
    }

    public static final boolean isMinus(char c) {
        return c == '-' || c >= '\u2010' && c <= '\u2015' || c == '\u2012' || c == '\u00ad';
    }

    public static final boolean isSign(char c) {
        return c == '+' || Parsing.isMinus(c);
    }

    public final int parseSign() {
        if (this.pos < this.length) {
            char c;
            if ((c = this.a[this.pos++]) == '+') {
                return 1;
            }
            if (Parsing.isMinus(c)) {
                return -1;
            }
            --this.pos;
        }
        return 0;
    }

    private final int parseNum() {
        int i;
        int val = 0;
        for (i = this.pos; i < this.length && Character.isDigit(this.a[i]); ++i) {
        }
        if (i > this.pos) {
            val = Integer.parseInt(new String(this.a, this.pos, i - this.pos));
        }
        if (this.flags == 0) {
            this.flags = i - this.pos << 8;
            if (this.flags > 256 && this.a[this.pos] == '0' && Character.isDigit(this.a[this.pos + 1])) {
                this.flags |= 0x200000;
            }
        }
        this.pos = i;
        return val;
    }

    private final int parseNum(int nd) {
        int i;
        int val = 0;
        for (i = this.pos; nd > 0 && i < this.length; --nd, ++i) {
            if (Character.isDigit(this.a[i])) {
                val = val * 10 + (this.a[i] & 0xF);
                continue;
            }
            if (val != 0 || !Character.isWhitespace(this.a[i])) break;
        }
        if (this.flags == 0) {
            this.flags = i - this.pos << 8;
        }
        this.pos = i;
        return val;
    }

    private final long parseNum8() {
        int i;
        long val = 0L;
        for (i = this.pos; i < this.length && Character.isDigit(this.a[i]); ++i) {
        }
        if (i > this.pos) {
            val = Long.parseLong(new String(this.a, this.pos, i - this.pos));
        }
        if (this.flags == 0) {
            this.flags = i - this.pos << 8;
            if (this.flags > 256 && this.a[this.pos] == '0' && Character.isDigit(this.a[this.pos + 1])) {
                this.flags |= 0x200000;
            }
        }
        this.pos = i;
        return val;
    }

    public final boolean parseNaN() {
        int posini = this.pos;
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = posini;
            return false;
        }
        int postart = this.pos;
        for (int i = 0; i < this.nulls.length; ++i) {
            if (this.nulls[i] == null) continue;
            this.pos = postart;
            if (!this.match(this.nulls[i])) continue;
            char c = this.a[this.pos - 1];
            while (this.pos < this.length && this.a[this.pos] == c) {
                ++this.pos;
            }
            if (this.pos >= this.length || Character.isLetterOrDigit(c = this.a[this.pos]) || c == '.') continue;
            return true;
        }
        this.pos = posini;
        return false;
    }

    public final int parsePositiveInt() {
        int posini = this.pos;
        int val = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        while (this.pos < this.length && Character.isWhitespace(this.a[this.pos])) {
            ++this.pos;
        }
        if (this.pos >= this.length) {
            this.pos = posini;
            return val;
        }
        val = this.parseNum();
        if (this.flags == 0) {
            if (this.parseNaN()) {
                val = Integer.MIN_VALUE;
            } else {
                this.pos = posini;
            }
        }
        return val;
    }

    public final int parseInt() {
        int posini = this.pos;
        int val = 0;
        int pec = 0;
        int sign = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = posini;
            return val;
        }
        sign = this.parseSign();
        if (sign > 0) {
            pec = 16;
        }
        val = this.parseNum();
        if (sign < 0) {
            val = -val;
        }
        if (this.flags == 0) {
            if (this.parseNaN()) {
                val = Integer.MIN_VALUE;
            } else {
                this.pos = posini;
            }
        } else {
            this.flags |= pec << 16;
        }
        return val;
    }

    public final long parseLong() {
        int posini = this.pos;
        long val = 0L;
        int pec = 0;
        int sign = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = posini;
            return val;
        }
        sign = this.parseSign();
        if (sign > 0) {
            pec = 16;
        }
        val = this.parseNum8();
        if (sign < 0) {
            val = -val;
        }
        if (this.flags == 0) {
            if (this.parseNaN()) {
                val = Long.MIN_VALUE;
            } else {
                this.pos = posini;
            }
        } else {
            this.flags |= pec << 16;
        }
        return val;
    }

    private final double parseValue(int x10) {
        int nd;
        int i;
        int i1;
        double val = 1.0;
        int posini = this.pos;
        int hasexpo = 0;
        int e = 0;
        int pec = 0;
        char c = '\u0000';
        int sign = 0;
        if (this.flags > 0) {
            this.flags = 0;
        }
        if (this.pos >= this.length) {
            return val;
        }
        sign = this.parseSign();
        if (sign > 0) {
            pec |= 0x10;
        }
        for (i1 = this.pos; i1 < this.length && this.a[i1] == '0'; ++i1) {
        }
        for (i = i1; i < this.length && Character.isDigit(this.a[i]); ++i) {
        }
        if (i1 - this.pos > 0 && i - this.pos > 1) {
            pec |= 0x20;
        }
        if (i < this.length && this.a[i] == '.') {
            if (i1 == i) {
                ++i1;
                while (i1 < this.length && this.a[i1] == '0') {
                    ++i1;
                }
            } else {
                ++i1;
            }
            nd = ++i;
            while (i < this.length && Character.isDigit(this.a[i])) {
                ++i;
            }
            nd = i - nd;
        } else {
            nd = -1;
        }
        i1 = i - i1;
        if (i1 == 0) {
            i1 = 1;
        }
        if (i == this.pos) {
            this.pos = posini;
            if (this.parseNaN()) {
                val = Double.NaN;
            } else {
                this.pos = posini;
            }
            return val;
        }
        val = Double.valueOf(new String(this.a, this.pos, i - this.pos));
        if (sign < 0) {
            val = -val;
        }
        this.pos = i;
        if (this.flags == 0) {
            this.flags = nd + 1 | i1 << 8 | pec << 16;
        }
        if (i >= this.length - 1) {
            return val;
        }
        if (x10 == 0) {
            return val;
        }
        posini = this.pos;
        c = '\u0000';
        if (this.a[i] == 'e' || this.a[i] == 'E') {
            hasexpo = 1;
            ++i;
        } else if (x10 > 1) {
            if (nd < 0) {
                hasexpo = 2;
            }
            if ((this.a[i] == 'x' || this.a[i] == '\u2715') && i <= this.length - 4) {
                if (this.a[++i] == '1' && this.a[i + 1] == '0') {
                    i += 2;
                }
                hasexpo = 10;
            }
            if (this.a[i] == '^') {
                c = '^';
                ++i;
            } else if (!Parsing.isSign(this.a[i]) && !Character.isDigit(this.a[i])) {
                hasexpo = 0;
            }
        }
        if (hasexpo != 0) {
            this.pos = i;
            this.flags |= Integer.MIN_VALUE;
            e = this.parseInt();
            this.flags &= Integer.MAX_VALUE;
            if (this.pos == i) {
                hasexpo = 0;
            }
        }
        if (hasexpo == 0) {
            this.pos = posini;
        } else {
            if (hasexpo == 2) {
                hasexpo = (int)val;
                if (hasexpo < 0) {
                    hasexpo = -hasexpo;
                    val = -1.0;
                } else {
                    val = 1.0;
                }
                while (e > 0) {
                    val *= (double)hasexpo;
                    --e;
                }
                while (e < 0) {
                    val /= (double)hasexpo;
                    ++e;
                }
                hasexpo = 0;
            } else {
                val *= AstroMath.dexp(e);
            }
            this.flags |= hasexpo << 16;
            if (this.pos < this.length && this.a[this.pos] == c) {
                ++this.pos;
            }
        }
        return val;
    }

    public final double parseDecimal() {
        double value = this.parseValue(0);
        if ((this.flags & 0xFF00) == 0) {
            return Double.NaN;
        }
        return value;
    }

    public final double parseDouble() {
        double value = this.parseValue(1);
        if ((this.flags & 0xFF00) == 0) {
            return Double.NaN;
        }
        return value;
    }

    public final double parseFactor() {
        return this.parseValue(10);
    }

    private final double parse_sexa(int comp) {
        int i;
        int hms;
        double val = 0.0;
        double f = 1.0;
        int sign = 0;
        int components = 0;
        int upmost_component = 2;
        int unit = 0;
        int error = 0;
        int pec = 0;
        int posini = this.pos;
        if (this.flags > 0) {
            this.flags = 0;
            this.error_message = null;
        }
        if (comp > 0) {
            this.gobbleSpaces();
        }
        if (this.pos >= this.length) {
            this.pos = posini;
            return Double.NaN;
        }
        if (DEBUG > 0) {
            System.out.print("parse_sexa(" + comp + "): " + this);
        }
        if ((sign = this.parseSign()) > 0) {
            pec = 16;
        }
        if (comp > 0) {
            while (this.pos < this.length && this.a[this.pos] == ' ') {
                ++this.pos;
            }
        }
        int n = hms = comp > 0 ? this.parseNum() : this.parseNum(2);
        if (DEBUG > 0) {
            System.out.print("; hms=" + hms + ", flags=" + this.flags);
        }
        if (this.flags == 0) {
            this.pos = posini;
            if (!this.parseNaN()) {
                this.pos = posini;
            }
            return Double.NaN;
        }
        this.flags |= pec << 16;
        val = hms;
        int local_flags = this.flags;
        if (this.pos < this.length && this.a[this.pos] == '.') {
            ++this.pos;
            upmost_component = 0;
            if (this.pos < this.length && Character.isDigit(this.a[this.pos])) {
                --this.pos;
                val += this.parseDecimal();
                local_flags += this.flags;
            } else {
                local_flags |= 1;
            }
            if (DEBUG > 0) {
                System.out.print("=>" + local_flags);
            }
        }
        if (comp > 0 && this.pos < this.length) {
            for (i = 0; i < sexa_symb1.length; ++i) {
                if (this.a[this.pos] != sexa_symb1[i]) continue;
                unit = sexa_unit1[i];
                break;
            }
            if (unit != 0) {
                if ((unit & 9) != 0) {
                    val /= 60.0;
                    f /= 60.0;
                    ++components;
                    if ((unit & 8) != 0) {
                        val /= 60.0;
                        f /= 60.0;
                        ++components;
                    }
                    unit &= 0xFFFFFFF6;
                }
                ++this.pos;
            }
        }
        if (comp > 1 && components == 0 && upmost_component > 0) {
            i = this.pos;
            while (i < this.length) {
                if (this.a[i] == ':') {
                    ++i;
                    continue;
                }
                if (this.a[i] == ' ') {
                    ++i;
                    continue;
                }
                if (Character.isDigit(this.a[i]) || this.a[i] == '.') {
                    ++components;
                    while (i < this.length && Character.isDigit(this.a[i])) {
                        ++i;
                    }
                    if (i < this.length && this.a[i] == '.') {
                        break;
                    }
                } else {
                    if (Parsing.isSign(this.a[i]) || this.a[i] == ',') break;
                    int j = this.pos;
                    this.pos = i;
                    boolean isaunit = this.lookup(sexa_symb1) >= 0;
                    this.pos = j;
                    if (!isaunit) break;
                    ++i;
                }
                if (components < 5) continue;
            }
            int n2 = upmost_component = i < this.length ? components : components / 2;
            if (upmost_component >= 3) {
                upmost_component = 2;
            }
            components = 0;
        }
        while (this.pos < this.length) {
            if (comp > 0) {
                if (this.a[this.pos] == sexa_letter[components]) {
                    ++this.pos;
                    continue;
                }
                if (this.a[this.pos] == sexa_symbol[components]) {
                    ++this.pos;
                    unit |= 0x10;
                    continue;
                }
                if (this.a[this.pos] == ':') {
                    ++this.pos;
                    continue;
                }
                if (this.a[this.pos] == ' ') {
                    ++this.pos;
                    continue;
                }
            }
            if (components >= upmost_component || !Character.isDigit(this.a[this.pos])) break;
            this.flags = 0;
            if (comp == 0) {
                hms = this.parseNum(2);
                i = this.flags & 0xFF00;
                if (i == 256) {
                    --this.pos;
                    break;
                }
            } else {
                hms = this.parseNum();
                i = this.flags & 0xFF00;
                if (i == 256) {
                    i = 512;
                }
            }
            local_flags += i;
            if (hms > 60) {
                error = 2;
                this.error_message = "component " + hms + ">60";
            }
            ++components;
            val += (f /= 60.0) * (double)hms;
        }
        if (components > 0 && hms == 60 && error == 0) {
            error = 1;
            this.error_message = "";
        }
        boolean has_decimals = false;
        if (this.pos < this.length) {
            if (this.a[this.pos] == '.') {
                ++this.pos;
                has_decimals = true;
            } else if (comp == 0 && Character.isDigit(this.a[this.pos])) {
                has_decimals = true;
                local_flags |= 0x400000;
            }
        }
        if ((this.flags & 0xFF) == 0) {
            if (this.pos < this.length && has_decimals && Character.isDigit(this.a[this.pos])) {
                i = --this.pos;
                char dot = this.a[i];
                this.a[i] = 46;
                double fraction = this.parseDecimal();
                this.a[i] = dot;
                val += f * fraction;
                if (error == 1 && fraction != 0.0) {
                    error = 2;
                    this.error_message = "component > 60" + fraction;
                }
                local_flags += this.flags;
            } else {
                local_flags |= 1;
            }
        }
        if (unit > 0 && this.pos < this.length) {
            if (this.a[this.pos] == sexa_letter[components]) {
                ++this.pos;
            } else if (this.a[this.pos] == sexa_symbol[components]) {
                ++this.pos;
            }
        }
        if (components == 0 && this.pos < this.length && comp > 0 && Character.toLowerCase(this.a[this.pos]) == 'e') {
            ++this.pos;
            i = this.parseInt();
            if (this.digits() == 0) {
                --this.pos;
            } else {
                val *= AstroMath.dexp(i);
                if ((i = (local_flags & 0xFF) - i) < 0) {
                    i = 0;
                }
                if (i >= 32) {
                    i = 31;
                }
                local_flags = local_flags & 0xFFFFFF00 | i | 0x10000;
            }
        }
        this.flags = local_flags;
        if (DEBUG > 0) {
            System.out.print("=>" + this.flags);
        }
        if (sign < 0) {
            val = -val;
        }
        if (error > 0) {
            String tag = error > 1 ? "****" : "++++";
            this.error_message = tag + "parseSexa(" + String.valueOf(this.a, posini, this.pos - posini) + ")" + this.error_message;
        }
        if (components > 0) {
            pec = components + 1 + unit;
            if ((pec & 0x10) != 0) {
                pec = (pec & 0xF) + 8;
            }
            this.flags |= pec << 16 | error << 24;
            if ((this.flags & 0xFF) == 0) {
                this.flags |= 1;
            }
            this.flags += components * 2;
        } else if (unit > 0) {
            pec = (unit & 0x10) != 0 ? 13 : (unit == 6 ? 12 : 11);
            this.flags |= pec << 16;
        }
        if (DEBUG > 0) {
            System.out.println("=>" + this.flags);
        }
        return val;
    }

    public final double parseSexa() {
        return this.parse_sexa(1);
    }

    public final double parseSexa2() {
        return this.parse_sexa(2);
    }

    public final double parseIAU() {
        return this.parse_sexa(0);
    }

    public final int parseDate() {
        int nc;
        int i;
        int[] datelem = new int[3];
        int[] datype = new int[3];
        int status = 0;
        int posini = this.pos;
        int sign = 0;
        int pec = 128;
        char sep = '\u0000';
        int nc_max = 3;
        if (this.flags > 0) {
            this.flags = 0;
        }
        this.gobbleSpaces();
        if (this.pos >= this.length) {
            this.pos = posini;
            return 0;
        }
        sign = this.parseSign();
        if (sign > 0) {
            pec = 16;
        }
        for (i = 0; i < nc_max; ++i) {
            if (i > 0) {
                char c = this.currentChar();
                if (sep == '\u0000' && i == 1 && (c == '-' || c == '.' || c == '/')) {
                    sep = c;
                }
                if (c == sep) {
                    ++this.pos;
                } else if (sep != '\u0000') break;
            }
            this.gobbleSpaces();
            if (this.pos >= this.length) break;
            int pos1 = this.pos;
            datelem[i] = this.parseNum();
            if (pos1 == this.pos) {
                if ((status & 2) != 0) break;
                datelem[i] = this.lookupIgnoreCase(month_list);
                if (datelem[i] < 0) break;
                pec |= 0x81;
                int n = i;
                datelem[n] = datelem[n] + 1;
                datype[i] = 2;
                while (Character.isLetter(this.currentChar())) {
                    ++this.pos;
                }
            } else {
                if (sign < 0 || this.pos - pos1 >= 4) {
                    if ((status & 4) != 0) break;
                    datype[i] = 4;
                } else if (this.pos - pos1 >= 3) {
                    int n = datype[i] = (status & 3) == 0 ? 1 : 4;
                    if (datype[i] == 1) {
                        nc_max = 2;
                    }
                }
                if (sign < 0) {
                    datelem[i] = -datelem[i];
                    sign = 0;
                }
            }
            status |= datype[i];
        }
        if ((nc = i) < 2) {
            this.pos = posini;
            return 0;
        }
        if (status == 0) {
            datype[0] = 4;
            if (nc == 2) {
                datype[1] = 1;
                status = 5;
            } else {
                datype[1] = 2;
                datype[2] = 1;
                status = 7;
            }
        }
        for (i = 0; i < nc; ++i) {
            if (datype[i] != 0) continue;
            datype[i] = (status & 4) == 0 ? 4 : ((status & 2) == 0 ? 2 : 1);
            status |= datype[i];
        }
        pec = status == 5 ? (pec |= datype[0] == 4 ? 132 : 134) : (status == 6 ? (pec |= datype[0] == 4 ? 128 : 130) : (datype[0] == 4 ? (pec |= datype[1] == 2 ? 136 : 135) : (datype[0] == 1 ? (pec |= datype[1] == 2 ? 138 : 133) : (pec |= datype[1] == 4 ? 142 : 140))));
        int day = 0;
        int month = 0;
        int year = 0;
        for (i = 0; i < nc; ++i) {
            if (datype[i] == 4) {
                year = datelem[i];
            }
            if (datype[i] == 2) {
                month = datelem[i] - 1;
            }
            if (datype[i] != 1) continue;
            day = datelem[i];
        }
        if (month * 30 + day > 367) {
            this.pos = posini;
            return 0;
        }
        int jd = (int)(Astrotime.YMD2JD(year, month, day) - 2400000.5);
        this.flags |= pec << 16;
        return jd;
    }

    public final double parseComplex(String pic) throws ParseException {
        int i;
        int[] comp6 = new int[6];
        int[] ipic6 = new int[6];
        char[] pic6 = new char[6];
        boolean check_century = false;
        char[] apic = pic.toCharArray();
        int ipic = 0;
        int epic = pic.length();
        int last_comp = 0;
        double value = Double.NaN;
        int posini = this.pos;
        int k = 0;
        int plen = 0;
        int sign = 0;
        int pec = 0;
        char c = '\u0000';
        int mixed = 0;
        StringBuffer mixed_buf = null;
        if (DEBUG > 0) {
            System.out.println("....cplx(" + pic + ")\tin=\"" + this.toString() + "\"");
        }
        if (this.flags > 0) {
            this.flags = 0;
            this.error_message = null;
        }
        comp6[5] = 0;
        comp6[4] = 0;
        comp6[3] = 0;
        comp6[2] = 0;
        comp6[1] = 0;
        comp6[0] = 0;
        ipic6[5] = 0;
        ipic6[4] = 0;
        ipic6[3] = 0;
        ipic6[2] = 0;
        ipic6[1] = 0;
        ipic6[0] = 0;
        pic6[5] = '\u0000';
        pic6[4] = '\u0000';
        pic6[3] = '\u0000';
        pic6[2] = '\u0000';
        pic6[1] = '\u0000';
        pic6[0] = '\u0000';
        if (apic[ipic] == '\"') {
            ++ipic;
        }
        if (this.pos < this.length && (sign = this.parseSign()) > 0) {
            pec = 16;
        }
        while (this.pos < this.length && ipic < epic) {
            if ((k = "YMDhmsymDdMS".indexOf(c = apic[ipic++])) < 0) {
                if (c == this.a[this.pos]) {
                    ++this.pos;
                    continue;
                }
                if (c == ':') continue;
                if (c == '.' || c == 'f' || c == '\"') break;
                this.error_message = "****parseComplex((" + pic + ")): what is '" + c + "'?";
                throw new ParseException(this.error_message, ipic);
            }
            k %= 6;
            if (Character.isLetter(this.a[this.pos])) {
                pec |= 0x81;
                i = this.lookupIgnoreCase(month_list);
                if (k == 4) {
                    k = 1;
                    mixed |= 1 << k;
                }
                if (k != 1 || pic6[1] != '\u0000' || i < 0) {
                    this.error_message = "****parseComplex(" + pic + "): month? " + this.toString();
                    throw new ParseException(this.error_message, ipic);
                }
                comp6[1] = i;
                pic6[1] = 97;
            } else if (pic6[k] != '\u0000') {
                i = 5 - k;
                if (k > 0 && i > 0 && pic6[i] == '\u0000') {
                    comp6[i] = comp6[k];
                    pic6[i] = pic6[k];
                    ipic6[i] = ipic6[k];
                    k = i;
                    mixed |= 1 << k;
                }
                if (pic6[k] != '\u0000') {
                    this.error_message = "****parseComplex((" + pic + ")): " + "duplicated component '" + "YMDhmsymDdMS".charAt(k) + "'";
                    throw new ParseException(this.error_message, ipic);
                }
            }
            ipic6[k] = ipic;
            last_comp = k;
            plen = 1;
            while (ipic < epic && apic[ipic] == c) {
                ++plen;
                ++ipic;
            }
            if (pic6[k] != '\u0000') continue;
            if (plen == 1) {
                this.gobbleSpaces();
                if (this.a[this.pos] == ':') {
                    ++this.pos;
                }
                this.gobbleSpaces();
                comp6[k] = this.parseNum();
                pic6[k] = c;
                if (k != 0 || c != 'y') continue;
                check_century = true;
                continue;
            }
            if (k == 0 && plen == 2) {
                check_century = true;
            }
            i = plen;
            while (i > 0 && this.pos < this.length) {
                if (this.a[this.pos] != ' ') {
                    if (Character.isDigit(this.a[this.pos])) {
                        comp6[k] = comp6[k] * 10 + Character.digit(this.a[this.pos], 10);
                    } else {
                        this.error_message = "****parseComplex(" + pic + "): " + this.toString();
                        throw new ParseException(this.error_message, ipic);
                    }
                }
                --i;
                ++this.pos;
            }
            pic6[k] = c;
        }
        if (DEBUG > 0) {
            System.out.print("....cplx[a]=");
            for (i = 0; i < 6; ++i) {
                System.out.print("(" + pic6[i] + ")" + comp6[i]);
            }
            System.out.println(",last_comp=" + last_comp + ", check_century=" + check_century);
        }
        if (Character.toUpperCase(pic6[1]) == 'M' && pic6[4] == '\u0000' && pic6[0] == '\u0000') {
            pic6[4] = pic6[1];
            pic6[1] = '\u0000';
            comp6[4] = comp6[1];
            comp6[1] = 0;
            mixed |= 2;
        } else if (pic6[1] == '\u0000' && pic6[4] != '\u0000' && pic6[0] != '\u0000' && pic6[5] == '\u0000') {
            pic6[1] = pic6[4];
            pic6[4] = '\u0000';
            comp6[1] = comp6[4];
            comp6[4] = 0;
            mixed |= 0x10;
        }
        if (pic6[3] == '\u0000' && pic6[2] != '\u0000' && pic6[0] == '\u0000' && pic6[1] == '\u0000') {
            pic6[3] = pic6[2];
            pic6[2] = '\u0000';
            comp6[3] = comp6[2];
            comp6[2] = 0;
            mixed |= 4;
        } else if (pic6[2] == '\u0000' && pic6[0] != '\u0000') {
            pic6[2] = pic6[3];
            pic6[3] = '\u0000';
            comp6[2] = comp6[3];
            comp6[3] = 0;
            mixed |= 8;
        }
        if (mixed != 0) {
            String mod_pic = new String(pic);
            char[] mpic = mod_pic.toCharArray();
            k = 0;
            while (mixed != 0) {
                if (mixed & true) {
                    i = ipic6[k] - 1;
                    char m = mpic[i];
                    char M = Character.toUpperCase(m);
                    if (M == m) {
                        M = Character.toLowerCase(m);
                    }
                    while (i < mpic.length && mpic[i] == m) {
                        mpic[i++] = M;
                    }
                }
                mixed >>= 1;
                ++k;
            }
            mixed_buf = new StringBuffer(100);
            mixed_buf.append("++++parseComplex(");
            mixed_buf.append(pic);
            mixed_buf.append(") interpreted as (");
            mixed_buf.append(mpic);
            mixed_buf.append(")");
        }
        if (pic6[1] != '\u0000' && pic6[1] != 'a' && comp6[1] > 0) {
            comp6[1] = comp6[1] - 1;
        }
        value = 0.0;
        double fraction_factor = 1.0;
        double factor = 1.0;
        if (DEBUG > 0) {
            System.out.print("....cplx[b]=");
            for (i = 0; i < 6; ++i) {
                System.out.print("(" + pic6[i] + ")" + comp6[i]);
            }
            System.out.println("");
        }
        if (pic6[0] != '\u0000') {
            pec |= 0x80;
            if (pic6[2] != '\u0000') {
                pec |= 0x84;
                if (pic6[1] != '\u0000') {
                    pec |= 0x88;
                }
            }
            if (check_century && comp6[0] < 200) {
                comp6[0] = comp6[0] + 1900;
                if (pic6[0] != 'Y' && comp6[0] < 1950) {
                    comp6[0] = comp6[0] + 100;
                }
                check_century = false;
            }
            if (sign < 0) {
                comp6[0] = -comp6[0];
                sign = 0;
            }
            if (DEBUG > 0) {
                System.out.print("....cplx[c]=");
                for (i = 0; i < 6; ++i) {
                    System.out.print("(" + pic6[i] + ")" + comp6[i]);
                }
                System.out.println("");
            }
            value = Astrotime.YMD2JD(comp6[0], comp6[1], comp6[2]) - 2400000.5;
            factor = 24.0;
        } else if (pic6[2] != '\u0000') {
            if (pic6[1] != '\u0000') {
                this.error_message = "****parseComplex((" + pic + ")): " + "month without year ? " + this.toString();
                throw new ParseException(this.error_message, ipic);
            }
            pec |= 0x85;
            value = comp6[2];
            factor = 24.0;
        } else if (Character.toLowerCase(pic6[3]) == 'h') {
            pec |= 9;
        }
        for (i = 3; i < 6; ++i) {
            if (pic6[i] != '\u0000') {
                if (DEBUG > 0) {
                    System.out.print("    value=" + value + " => ");
                }
                value += (double)comp6[i] / factor;
                if (DEBUG > 0) {
                    System.out.println(value);
                }
                if (i == last_comp) {
                    fraction_factor = factor;
                }
            }
            factor *= 60.0;
        }
        if (this.pos >= this.length) {
            ipic = epic;
            c = '\u0000';
        } else if (plen == 1 && this.a[this.pos] == '.') {
            value += this.parseValue(0) / fraction_factor;
        } else {
            while (c == 'f' && this.pos < this.length && Character.isDigit(this.a[this.pos])) {
                value += (double)Character.digit(this.a[this.pos], 10) / (fraction_factor *= 10.0);
                c = ipic < epic ? apic[ipic++] : (char)'\u0000';
                ++this.pos;
            }
        }
        if (c != '\"' && c != '\u0000') {
            this.error_message = "****parseComplex(" + pic + "): " + "mismatch from \"" + pic.substring(ipic - 1) + "\": " + this.toString();
            throw new ParseException(this.error_message, ipic);
        }
        if (mixed_buf != null) {
            this.error_message = mixed_buf.toString();
            this.flags |= 0x1000000;
        }
        this.flags |= pec << 16;
        if (sign < 0) {
            value = -value;
        }
        if (DEBUG > 0) {
            System.out.println("....parseComplex(" + pic + "): value=" + value + ", pec=" + pec + ", flags=" + this.flags);
        }
        return value;
    }

    public final int decimals() {
        return (this.flags & 0xFF) - 1;
    }

    public final int digits() {
        return this.flags >> 8 & 0xFF;
    }

    public final int format() {
        return this.flags >> 16 & 0xFF;
    }

    public final String form() {
        return Astroformat.explain(this.flags >> 16 & 0xFF);
    }

    public final boolean isSexa() {
        return Parsing.isSexa(this.flags >> 16);
    }

    public final boolean isDate() {
        return Parsing.isDate(this.flags >> 16);
    }

    public final boolean isDays() {
        return Parsing.isDays(this.flags >> 16);
    }

    public final boolean isTime() {
        return Parsing.isTime(this.flags >> 16);
    }

    public final boolean isAngle() {
        return Parsing.isAngle(this.flags >> 16);
    }

    public final boolean inError() {
        return (this.flags & 0x2000000) != 0;
    }

    public final int status() {
        return this.flags >> 24;
    }

    public final String getMessage() {
        if ((this.flags & 0x3000000) == 0) {
            return null;
        }
        return this.error_message;
    }

    public int parseArray(double[] vec, char sep) {
        int i;
        for (i = 0; i < vec.length; ++i) {
            vec[i] = Double.NaN;
        }
        for (i = 0; i < vec.length && this.pos < this.length; ++i) {
            int postart = this.pos;
            this.gobbleSpaces();
            if (this.currentChar() == sep) {
                if (i == 0) continue;
                this.advance(1);
                this.gobbleSpaces();
            }
            int ipos = this.pos;
            double x = this.parseDouble();
            if (this.pos == ipos) {
                this.pos = postart;
                break;
            }
            vec[i] = x;
        }
        return i;
    }

    public int parseArray(double[] vec) {
        return this.parseArray(vec, ' ');
    }

    public int parseWithError(double[] vec) {
        int i;
        boolean bracket = false;
        int type = 0;
        for (i = 0; i < vec.length; ++i) {
            vec[i] = Double.NaN;
        }
        int postart = this.pos;
        this.gobbleSpaces();
        int ipos = this.pos;
        double x = this.parseDouble();
        if (this.pos == ipos) {
            this.pos = postart;
            return 0;
        }
        vec[0] = x;
        int poserr = ipos;
        for (i = 1; i < vec.length && ipos < this.length; ++i) {
            postart = this.pos;
            type = this.lookup(error_symb);
            if (type < 0) break;
            bracket |= type == 4;
            ipos = this.pos;
            x = this.parseDouble();
            if (this.pos == ipos) {
                this.pos = postart;
                break;
            }
            if (type == 1 || type == 2) {
                vec[type] = x;
                continue;
            }
            vec[i] = x;
        }
        if (bracket) {
            this.gobbleSpaces();
            if (!this.match("]")) {
                ipos = poserr;
                for (i = 1; i < vec.length; ++i) {
                    vec[i] = Double.NaN;
                }
                i = 1;
            }
        }
        return i;
    }

    public final String toString() {
        return new String(this.a, this.pos, this.length - this.pos);
    }

    public final String toString(int len) {
        if (len + this.pos > this.length) {
            len = this.length - this.pos;
        }
        return new String(this.a, this.pos, len);
    }
}

