/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astroframe;
import cds.astro.Astrotime;
import cds.astro.Coo;
import java.text.ParseException;

public class ICRS
extends Astroframe {
    public static String class_name = "ICRS";

    public ICRS(double epoch) {
        this.precision = (byte)9;
        this.ICRSmatrix = Coo.Umatrix3;
        this.name = class_name;
        this.epoch = epoch;
        this.hms = true;
        this.ed_lon = (byte)37;
        this.ed_lat = (byte)53;
    }

    public ICRS() {
        this(2000.0);
    }

    public ICRS(String text) throws ParseException {
        this();
        Astrotime t = new Astrotime();
        int o = t.parse(text, 0);
        if (o > 0) {
            this.epoch = t.getJyr();
        }
        while (o < text.length() && Character.isWhitespace(text.charAt(o))) {
            ++o;
        }
        if (o < text.length()) {
            throw new ParseException("****Astroframe: '" + text + "'+" + o, o);
        }
    }

    @Override
    public double[][] toICRSmatrix() {
        return Coo.Umatrix3;
    }

    @Override
    public void toICRS(Coo coo) {
    }

    @Override
    public void fromICRS(Coo coo) {
    }

    @Override
    public void toICRS(double[] u) {
    }

    @Override
    public void fromICRS(double[] u) {
    }
}

