/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Equatorial;

public class FK5
extends Equatorial {
    private void initialize(double equinox, double epoch) {
        this.precision = (byte)7;
        this.equinox = equinox;
        this.epoch = epoch;
        this.name = "FK5(J" + equinox + ")";
        this.toBaseEquinox = Math.abs(equinox - 2000.0) > 3.0E-4 ? FK5.precessionMatrix(equinox, 2000.0) : Coo.Umatrix3;
        this.ICRSmatrix = this.toBaseEquinox;
    }

    public FK5(double equinox) {
        this.initialize(equinox, 2000.0);
    }

    public FK5() {
        this.initialize(2000.0, 2000.0);
    }

    static final double[][] precessionMatrix(double eq0, double eq1) {
        boolean reverse = false;
        double t0 = (eq0 - 2000.0) / 100.0;
        double dt = (eq1 - eq0) / 100.0;
        if (Math.abs(t0) > Math.abs(t0 + dt)) {
            reverse = true;
            t0 += dt;
            dt = -dt;
        }
        double w = 2306.2181 + (1.39656 - 1.39E-4 * t0) * t0;
        double zeta = (w + (0.30188 - 3.44E-4 * t0 + 0.017998 * dt) * dt) * dt / 3600.0;
        double z = (w + (1.09468 + 6.6E-5 * t0 + 0.018203 * dt) * dt) * dt / 3600.0;
        double theta = (2004.3109 + (-0.8533 - 2.17E-4 * t0) * t0 + (-0.42665 - 2.17E-4 * t0 - 0.041833 * dt) * dt) * dt / 3600.0;
        if (reverse) {
            return Coo.eulerMatrix(-zeta, -theta, -z);
        }
        return Coo.eulerMatrix(z, theta, zeta);
    }

    @Override
    public double[][] toICRSmatrix() {
        return this.ICRSmatrix;
    }
}

