/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Equatorial;

public class FK4
extends Equatorial {
    private static boolean DEBUG = false;
    private static double[] ev50 = FK4.eterm(1950.0);
    protected double[][] toBaseEquinox;
    protected double[] ev_eq;
    protected static double[] A = new double[]{-1.62557E-6, -3.1919E-7, -1.3843E-7, 0.001244, -0.001579, -6.6E-4};
    protected static double[][] EM = new double[][]{{0.9999256782, -0.0111820611, -0.0048579477, 2.42395018E-6, -2.710663E-8, -1.177656E-8}, {0.011182061, 0.9999374784, -2.71765E-5, 2.710663E-8, 2.42397878E-6, -6.587E-11}, {0.0048579479, -2.71474E-5, 0.9999881997, 1.177656E-8, -6.582E-11, 2.42410173E-6}, {-5.51E-4, -0.238565, 0.435739, 0.99994704, -0.01118251, -0.00485767}, {0.238514, -0.002667, -0.008541, 0.01118251, 0.99995883, -2.718E-5}, {-0.435623, 0.012254, 0.002117, 0.00485767, -2.714E-5, 1.00000956}};
    private static double[][] EM50 = new double[][]{{0.9999256795356672, -0.011181482799697, -0.0048590039655699}, {0.0111814828233251, 0.9999374848650175, -2.71557959449E-5}, {0.0048590038843768, -2.71771046587E-5, 0.9999881945682256}};
    protected static double[][] EM1 = new double[][]{{0.9999256795, 0.0111814829, 0.0048590038, -2.4238984E-6, -2.710545E-8, -1.177742E-8}, {-0.0111814828, 0.9999374849, -2.71771E-5, 2.710545E-8, -2.42392702E-6, 6.585E-11}, {-0.004859004, -2.71558E-5, 0.9999881946, 1.177742E-8, 6.585E-11, -2.42404995E-6}, {-5.5E-4, 0.238509, -0.435613, 0.99990432, 0.01118145, 0.00485852}, {-0.238559, -0.002668, 0.012254, -0.01118145, 0.99991613, -2.717E-5}, {0.43573, -0.008541, 0.002116, -0.00485852, -2.716E-5, 0.99996684}};
    static double[][] EM2 = null;

    private void initialize(double equinox, double epoch) {
        this.precision = (byte)6;
        this.base_epoch = Astrotime.B2J(1950.0);
        this.equinox = equinox;
        this.epoch = epoch;
        this.name = "FK4(B" + equinox + ")";
        this.ed_lon = (byte)37;
        this.ed_lat = (byte)53;
        if (Math.abs(equinox - 1950.0) > 3.0E-4) {
            this.toBaseEquinox = FK4.precessionMatrix(equinox, 1950.0);
            this.ev_eq = FK4.eterm(equinox);
        } else {
            this.toBaseEquinox = Coo.Umatrix3;
            this.ev_eq = ev50;
        }
    }

    public FK4(double equinox, double epoch) {
        this.initialize(equinox, Astrotime.B2J(epoch));
    }

    public FK4(double equinox) {
        this.initialize(equinox, Astrotime.B2J(equinox));
    }

    public FK4() {
        this.initialize(1950.0, this.base_epoch);
    }

    @Override
    public double[][] toICRSmatrix() {
        return null;
    }

    public static double[][] precessionMatrix(double eq0, double eq1) {
        boolean reverse = false;
        double t0 = eq0 - 1900.0;
        double dt = eq1 - eq0;
        if (Math.abs(t0) > Math.abs(t0 + dt)) {
            reverse = true;
            t0 += dt;
            dt = -dt;
        }
        double zeta = (dt /= 1000.0) * (23042.53 + (t0 /= 1000.0) * (139.73 + 0.06 * t0) + dt * (30.23 + 18.0 * dt - 0.27 * t0)) / 3600.0;
        double z = zeta + dt * dt * (79.27 + 0.66 * t0 + 0.32 * dt) / 3600.0;
        double theta = dt * (20046.85 - t0 * (85.33 + 0.37 * t0) - dt * (42.67 + 0.37 * t0 + 41.8 * dt)) / 3600.0;
        if (reverse) {
            return Coo.eulerMatrix(-zeta, -theta, -z);
        }
        return Coo.eulerMatrix(z, theta, zeta);
    }

    private static void pr6(double[] u6, String t1, String t2) {
        double[] v = new double[]{u6[0], u6[1], u6[2]};
        System.out.println(t1 + Coo.toString(v));
        v[0] = u6[3];
        v[1] = u6[4];
        v[2] = u6[5];
        System.out.println(t2 + Coo.toString(v));
    }

    public static final double[] eterm(double y) {
        double[] ev = new double[3];
        double t = (y - 1900.0) / 100.0;
        double eps = 23.452 - 0.013 * t;
        double e = 0.016751 - 4.2E-5 * t;
        double L = 281.221 + 1.719 * t;
        double cL = AstroMath.cosd(L);
        ev[0] = (e *= 9.936741208021049E-5) * AstroMath.sind(L);
        ev[1] = -e * cL * AstroMath.cosd(eps);
        ev[2] = -e * cL * AstroMath.sind(eps);
        if (DEBUG) {
            System.out.println(".... e-term(B" + y + "): " + Coo.toString(ev));
        }
        return ev;
    }

    public static void toFK5(Coo coo) {
        double[] u6 = new double[6];
        coo.copyUvector(u6);
        FK4.estimateFK4motion(u6);
        FK4.toFK5(u6);
        coo.set(u6[0], u6[1], u6[2]);
    }

    public static void toFK5(double[] u6) {
        int i;
        double[] v = new double[6];
        if (u6[0] == 0.0 && u6[1] == 0.0 && u6[2] == 0.0) {
            return;
        }
        v[0] = u6[0];
        v[1] = u6[1];
        v[2] = u6[2];
        v[3] = u6[3] * 2.0626480624709636E7;
        v[4] = u6[4] * 2.0626480624709636E7;
        v[5] = u6[5] * 2.0626480624709636E7;
        if (DEBUG) {
            FK4.pr6(v, "        toFK5(1) ", "                 ");
        }
        double w = v[0] * A[0] + v[1] * A[1] + v[2] * A[2];
        double wd = v[0] * A[3] + v[1] * A[4] + v[2] * A[5];
        v[0] = v[0] - (A[0] - w * u6[0]);
        v[1] = v[1] - (A[1] - w * u6[1]);
        v[2] = v[2] - (A[2] - w * u6[2]);
        v[3] = v[3] - (A[3] - wd * u6[0]);
        v[4] = v[4] - (A[4] - wd * u6[1]);
        v[5] = v[5] - (A[5] - wd * u6[2]);
        for (i = 0; i < 6; ++i) {
            w = 0.0;
            for (int j = 0; j < 6; ++j) {
                w += EM[i][j] * v[j];
            }
            u6[i] = w;
        }
        if (DEBUG) {
            FK4.pr6(u6, "        toFK5(2) ", "                 ");
        }
        u6[3] = u6[3] / 2.0626480624709636E7;
        u6[4] = u6[4] / 2.0626480624709636E7;
        u6[5] = u6[5] / 2.0626480624709636E7;
        w = Math.sqrt(u6[0] * u6[0] + u6[1] * u6[1] + u6[2] * u6[2]);
        i = 0;
        while (i < 6) {
            int n = i++;
            u6[n] = u6[n] / w;
        }
    }

    public static void fromFK5(Coo coo) {
        double[] u = new double[]{coo.x, coo.y, coo.z};
        double x = EM1[0][0] * u[0] + EM1[0][1] * u[1] + EM1[0][2] * u[2];
        double y = EM1[1][0] * u[0] + EM1[1][1] * u[1] + EM1[1][2] * u[2];
        double z = EM1[2][0] * u[0] + EM1[2][1] * u[1] + EM1[2][2] * u[2];
        double w = Math.sqrt(x * x + y * y + z * z);
        if (w == 0.0) {
            return;
        }
        x /= w;
        y /= w;
        z /= w;
        w = x * A[0] + y * A[1] + z * A[2];
        x += A[0] - w * x;
        y += A[1] - w * y;
        z += A[2] - w * z;
        w = Math.sqrt(x * x + y * y + z * z);
        coo.set(x /= w, y /= w, z /= w);
    }

    public static void fromFK5(double[] u6) {
        double w;
        int i;
        double[] v = new double[6];
        if (u6[0] * u6[0] + u6[1] * u6[1] + u6[2] * u6[2] < 1.0E-10) {
            return;
        }
        u6[3] = u6[3] * 2.0626480624709636E7;
        u6[4] = u6[4] * 2.0626480624709636E7;
        u6[5] = u6[5] * 2.0626480624709636E7;
        if (DEBUG) {
            FK4.pr6(u6, "        from5(1) ", "                 ");
        }
        for (i = 0; i < 6; ++i) {
            w = 0.0;
            for (int j = 0; j < 6; ++j) {
                w += EM1[i][j] * u6[j];
            }
            v[i] = w;
        }
        w = Math.sqrt(v[0] * v[0] + v[1] * v[1] + v[2] * v[2]);
        i = 0;
        while (i < 6) {
            int n = i++;
            v[n] = v[n] / w;
        }
        if (DEBUG) {
            FK4.pr6(v, "        from5(+) ", "                 ");
        }
        w = v[0] * A[0] + v[1] * A[1] + v[2] * A[2];
        double wd = v[0] * A[3] + v[1] * A[4] + v[2] * A[5];
        u6[3] = v[3] + A[3] - wd * v[0];
        u6[4] = v[4] + A[4] - wd * v[1];
        u6[5] = v[5] + A[5] - wd * v[2];
        u6[0] = v[0] + A[0] - w * v[0];
        u6[1] = v[1] + A[1] - w * v[1];
        u6[2] = v[2] + A[2] - w * v[2];
        w = Math.sqrt(u6[0] * u6[0] + u6[1] * u6[1] + u6[2] * u6[2]);
        i = 0;
        while (i < 6) {
            int n = i++;
            u6[n] = u6[n] / w;
        }
        if (DEBUG) {
            FK4.pr6(u6, "        from5(2) ", "                 ");
        }
        u6[3] = u6[3] / 2.0626480624709636E7;
        u6[4] = u6[4] / 2.0626480624709636E7;
        u6[5] = u6[5] / 2.0626480624709636E7;
    }

    public static void estimateFK4motion(double[] u6) {
        double w;
        int j;
        int i;
        double[] v1 = new double[6];
        if (EM2 == null) {
            double[][] tm = new double[6][6];
            for (i = 0; i < 6; ++i) {
                for (j = 0; j < 6; ++j) {
                    w = 0.0;
                    for (int k = 0; k < 3; ++k) {
                        w += EM1[i][k] * EM[k][j];
                    }
                    tm[i][j] = w;
                }
            }
            EM2 = tm;
        }
        for (i = 0; i < 6; ++i) {
            w = 0.0;
            for (j = 0; j < 3; ++j) {
                w += EM2[i][j] * u6[j];
            }
            v1[i] = w;
        }
        w = v1[0] * A[3] + v1[1] * A[4] + v1[2] * A[5];
        for (i = 3; i < 6; ++i) {
            int n = i;
            v1[n] = v1[n] + (A[i] - w * v1[i - 3]);
        }
        for (i = 3; i < 6; ++i) {
            u6[i] = v1[i] / 2.0626480624709636E7;
        }
    }

    @Override
    public void toICRS(double[] u6) {
        if (this.toBaseEquinox != Coo.Umatrix3) {
            double[] ev = new double[3];
            Coo.sub(u6, this.ev_eq);
            Coo.rotateVector(this.toBaseEquinox, u6);
            Coo.add(u6, ev50);
        }
        FK4.toFK5(u6);
    }

    @Override
    public void toICRS(Coo coo) {
        if (this.toBaseEquinox != Coo.Umatrix3) {
            double[] ev = new double[3];
            coo.sub(this.ev_eq);
            coo.rotate(this.toBaseEquinox);
            coo.add(ev50);
        }
        FK4.toFK5(coo);
    }

    @Override
    public void fromICRS(double[] u6) {
        FK4.fromFK5(u6);
        if (this.toBaseEquinox != Coo.Umatrix3) {
            double[] ev = new double[3];
            Coo.sub(u6, ev50);
            Coo.rotateVector_1(this.toBaseEquinox, u6);
            Coo.add(u6, this.ev_eq);
        }
    }

    @Override
    public void fromICRS(Coo coo) {
        double[] u = new double[6];
        coo.copyUvector(u);
        u[5] = 0.0;
        u[4] = 0.0;
        u[3] = 0.0;
        FK4.fromFK5(u);
        if (DEBUG) {
            FK4.pr6(u, "FK4from ", "FK4from.");
        }
        coo.set(u[0], u[1], u[2]);
        if (this.toBaseEquinox != null) {
            double[] ev = new double[3];
            coo.sub(ev50);
            coo.rotate_1(this.toBaseEquinox);
            coo.add(this.ev_eq);
        }
    }
}

