/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.Qbox;
import cds.astro.Region;

public class EllipticalRegion
extends Region {
    double a;
    double b;
    double pa;
    Coo f0;
    Coo f1;
    double sina;
    double cosa;
    double cos2a;
    double sin2_2a;
    double cosc;
    double e;

    EllipticalRegion(Astroframe frame, Coo c, double a, double b, double pa) {
        if (DEBUG) {
            System.out.println("#...new Ellipse(" + c + ", a=" + a + ", b=" + b + ", pa=" + pa + ")");
        }
        if (a >= 180.0 || b >= 180.0) {
            System.err.println("#+++Ellipse(" + c + ", a=" + a + ", b=" + b + "): sem-axises too large!");
            return;
        }
        if (c.x == 0.0 && c.y == 0.0 && c.z == 0.0) {
            this.centroid = null;
            return;
        }
        this.centroid = new Coo(c);
        if (a < b) {
            this.a = b / 2.0;
            this.b = a / 2.0;
            this.pa = pa + 90.0;
        } else {
            this.a = a / 2.0;
            this.b = b / 2.0;
            this.pa = pa;
        }
        this.minrad = this.b;
        this.maxrad = this.a;
        this.cosa = AstroMath.cosd(this.a);
        this.sina = AstroMath.sind(this.a);
        double cosb = AstroMath.cosd(this.b);
        double sinb = AstroMath.sind(this.b);
        this.cosc = this.cosa / cosb;
        double sinc = Math.sqrt((this.sina + sinb) * (this.sina - sinb)) / cosb;
        double cpa = AstroMath.cosd(this.pa);
        double spa = AstroMath.sind(this.pa);
        this.f0 = new Coo(this.cosc, sinc * spa, sinc * cpa);
        this.f1 = new Coo(this.f0.x, -this.f0.y, -this.f0.z);
        if (DEBUG) {
            System.out.println("#...foci(0) " + this.f0 + " " + this.f1);
        }
        double[][] Rl = this.centroid.localMatrix();
        this.f0.rotate_1(Rl);
        this.f1.rotate_1(Rl);
        if (DEBUG) {
            System.out.println("#...foci(1) " + this.f0 + " " + this.f1);
        }
        if (frame != null) {
            frame.toICRS(this.f0);
            frame.toICRS(this.f1);
            frame.toICRS(this.centroid);
        }
        this.cos2a = AstroMath.cosd(2.0 * this.a);
        this.sin2_2a = AstroMath.sind(2.0 * this.a);
        this.sin2_2a *= this.sin2_2a;
        this.e = sinc / this.sina;
        this.pa = this.centroid.posAngle(this.f0);
        while (this.pa >= 180.0) {
            this.pa -= 180.0;
        }
    }

    EllipticalRegion(Coo c, double a, double b) {
        this(null, c, a, b, 90.0);
    }

    @Override
    public String toString() {
        StringBuffer bed = new StringBuffer();
        if (this.centroid == null) {
            bed.append("*INVALID*");
        }
        bed.append("Ellipse(");
        if (this.centroid != null) {
            bed.append(this.centroid.toString());
        }
        bed.append(", " + 2.0 * this.a + "x" + 2.0 * this.b);
        if (this.pa >= 0.0) {
            bed.append(", pa=" + this.pa);
        }
        bed.append(")");
        return bed.toString();
    }

    @Override
    public double area() {
        double sr;
        double e2 = this.e * this.e;
        if (e2 < 1.0E-12 || this.a < 0.2) {
            double rho = 2.0 * AstroMath.sind(this.a / 2.0);
            sr = Math.PI * rho * rho;
            if (e2 > 0.0) {
                sr = sr * Math.sqrt(1.0 - e2) * (1.0 + 0.375 * e2 * rho * rho);
            }
        } else {
            sr = Math.PI * 2 - 4.0 * this.cosa * Math.sqrt(1.0 - e2) * AstroMath.ell3(e2, e2 * this.sina * this.sina);
        }
        return 3282.806350011744 * sr;
    }

    @Override
    public boolean checkCoo(Coo point) {
        double d1;
        if (this.centroid == null) {
            return false;
        }
        double d0 = point.dotprod(this.f0);
        return d0 * d0 + (d1 = point.dotprod(this.f1)) * d1 - 2.0 * this.cos2a * d0 * d1 >= this.sin2_2a;
    }

    private boolean intersects(double[] u0, double[] u1) {
        double disc;
        double s = Coo.dotprod(u0, u1);
        double s00 = this.f0.dotprod(u0);
        double s01 = this.f0.dotprod(u1);
        double s10 = this.f1.dotprod(u0);
        double s11 = this.f1.dotprod(u1);
        double a2 = s01 * s01 + s11 * s11 - 2.0 * this.cos2a * s01 * s11 - this.sin2_2a;
        double a0 = s00 * s00 + s10 * s10 - 2.0 * this.cos2a * s00 * s10 - this.sin2_2a;
        double a1 = s00 * s01 + s10 * s11 - this.cos2a * (s00 * s11 + s01 * s10) - this.sin2_2a * s;
        if (a2 == 0.0) {
            return a1 * a0 < 0.0;
        }
        a1 /= a2;
        a0 /= a2;
        if (DEBUG) {
            System.out.println("#...Einter: t^2 + 2.*" + a1 + "*t + " + a0 + ")");
        }
        if ((disc = a1 * a1 - a0) <= 0.0) {
            return false;
        }
        if (a1 < 0.0) {
            return true;
        }
        return a0 < 0.0;
    }

    @Override
    public int checkCircle(Coo point, double r) {
        if (this.centroid == null) {
            return 0;
        }
        if (DEBUG) {
            System.out.println("#...Ellipse.checkCoo(" + point + ")");
        }
        Coo c = new Coo(point);
        double rf = (point.distance(this.f0) + point.distance(this.f1)) / 2.0;
        if (rf - r >= this.a) {
            return 0;
        }
        if (rf + r <= this.a) {
            return -1;
        }
        return 1;
    }

    @Override
    public int checkQbox(int qbox) {
        if (this.centroid == null) {
            return 0;
        }
        Qbox abox = new Qbox();
        abox.set(qbox);
        int i = this.checkCircle(abox.center(), Qbox.maxRadius(qbox));
        if (i < 1) {
            return i;
        }
        double[][] u4 = new double[5][3];
        Qbox.ucorners(abox.qbox, u4);
        int nin = 0;
        int nut = 0;
        Coo point = new Coo();
        for (i = 0; i < 4; ++i) {
            point.set(u4[i][0], u4[i][1], u4[i][2]);
            if (this.checkCoo(point)) {
                ++nin;
                continue;
            }
            ++nut;
        }
        if (nin == 4) {
            return -1;
        }
        if (nin > 0) {
            return 1;
        }
        u4[4][0] = u4[0][0];
        u4[4][1] = u4[0][1];
        u4[4][2] = u4[0][2];
        for (i = 0; i < 4; ++i) {
            if (!this.intersects(u4[i], u4[i + 1])) continue;
            return 1;
        }
        return abox.inside(this.centroid) ? 3 : 0;
    }
}

