/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroformat;
import cds.astro.Astrotime;

public class Editing
extends Astroformat {
    public String inf_string;
    public static final boolean DEBUG = false;
    private static char[] sexachar = new char[]{'\u0000', ' ', ':', 'h', 'm', 's', 'd', '\u00b0', '\'', '\"'};
    private static double[] fac6 = new double[]{12.0, 30.0, 24.0, 60.0, 60.0};
    private static short[] sexadrive = new short[]{0, 0, 4352, 8464, 4608, 8736, 5696, 9797, 5696, 9029, 0, 1536, 768, 1792, 6016, 10121};
    private static int[] datedrive = new int[]{418, 19, 673, 49, 421, 421, 1489, 1489, 107172, 107428, 316113, 304033, 185537, 238785, 184740, 250276};
    private static char[] datesep = new char[]{'-', ' ', ',', '/'};

    public Editing() {
        this.inf_string = "Inf";
    }

    public Editing(String null_text) {
        this.setNaN(null_text);
        this.inf_string = "Inf";
    }

    public void setInfinite(String text) {
        this.inf_string = text;
    }

    private static void edN(StringBuffer buf, long value, int width, int opt) {
        char asig = '\u0000';
        String aval = Long.toString(value);
        int nb = width - aval.length();
        if ((opt & 0x80000010) != 0) {
            asig = (opt & Integer.MIN_VALUE) != 0 ? (char)'-' : '+';
            --nb;
        }
        if ((opt & 0x20) != 0) {
            if (asig != '\u0000') {
                buf.append(asig);
            }
            while (nb > 0) {
                buf.append('0');
                --nb;
            }
        } else {
            while (nb > 0) {
                buf.append(' ');
                --nb;
            }
            if (asig != '\u0000') {
                buf.append(asig);
            }
        }
        buf.append(aval);
    }

    private static boolean remove_zeroes(StringBuffer buf) {
        boolean removed_point = false;
        int i = buf.length() - 1;
        while (buf.charAt(i) == '0') {
            --i;
        }
        if (buf.charAt(i) == '.') {
            removed_point = true;
        } else {
            ++i;
        }
        buf.setLength(i);
        return removed_point;
    }

    public StringBuffer editFlags(StringBuffer buf, int flags, String[] symbols) {
        int n = symbols.length;
        int j = 0;
        for (int i = 0; i < n; ++i) {
            if ((flags & 1 << i) == 0) continue;
            if (j > 0) {
                buf.append(',');
            }
            buf.append(symbols[i]);
            ++j;
        }
        return buf;
    }

    public StringBuffer editNaN(StringBuffer buf, int width) {
        for (int nb = width - this.nulls[0].length(); nb > 0; --nb) {
            buf.append(' ');
        }
        buf.append(this.nulls[0]);
        return buf;
    }

    public StringBuffer editInfinite(StringBuffer buf, int width, int sign) {
        int nb = width - this.inf_string.length();
        if (sign != 0) {
            --nb;
        }
        while (--nb >= 0) {
            buf.append(' ');
        }
        if (sign < 0) {
            buf.append('-');
        } else if (sign != 0) {
            buf.append('+');
        }
        buf.append(this.inf_string);
        return buf;
    }

    public StringBuffer editLong(StringBuffer buf, long value, int width, int option) {
        int o = option;
        long val = value;
        if (val == Long.MIN_VALUE) {
            this.editNaN(buf, width);
        } else {
            if (val < 0L) {
                o |= Integer.MIN_VALUE;
                val = -val;
            }
            if (val == Long.MAX_VALUE) {
                this.editInfinite(buf, width, o & 0x80000010);
            } else {
                Editing.edN(buf, val, width, o);
            }
        }
        return buf;
    }

    public StringBuffer editInt(StringBuffer buf, int value, int width, int option) {
        int o = option;
        long val = value;
        if (value == Integer.MIN_VALUE) {
            this.editNaN(buf, width);
        } else {
            if (value < 0) {
                o |= Integer.MIN_VALUE;
                val = -val;
            }
            if (val == Integer.MAX_VALUE) {
                this.editInfinite(buf, width, o & 0x80000010);
            }
            Editing.edN(buf, val, width, o);
        }
        return buf;
    }

    public StringBuffer edit(StringBuffer buf, int value, int width) {
        this.editInt(buf, value, width, 0);
        return buf;
    }

    public StringBuffer editDecimal(StringBuffer buf, double value, int nint, int nd, int option) {
        boolean shortest_form = nd < -1;
        double val = value;
        int o = option;
        if (shortest_form) {
            nd = -nd;
        }
        if (Double.isNaN(value)) {
            int n = nint;
            if (nd >= 0) {
                ++n;
            }
            this.editNaN(buf, n);
            return buf;
        }
        if (value < 0.0) {
            o |= Integer.MIN_VALUE;
            val = -val;
        }
        if (Double.isInfinite(val)) {
            int n = nint;
            if (nd >= 0) {
                ++n;
            }
            this.editInfinite(buf, n, o & 0x80000010);
            return buf;
        }
        if (val >= 1.0E19) {
            return this.editDouble(buf, value, 2, nint + nd - 3, option);
        }
        if ((option & 0x80) != 0) {
            long int_part = (int)value;
            if (value < 0.0) {
                --int_part;
            }
            return this.editDate(buf, (int)int_part, option);
        }
        if (sexadrive[option & 0xF] != 0) {
            return this.editSexa(buf, value, nint, nd, option);
        }
        if ((option & 0x40) == 0) {
            val = nd <= 0 ? (val += 0.5) : (val += 0.5 / AstroMath.dexp(nd));
        }
        long int_part = (long)val;
        if (nint > 0 || int_part != 0L) {
            Editing.edN(buf, int_part, nint, o);
        }
        if (nd >= 0) {
            buf.append('.');
        }
        if (nd > 0) {
            val -= (double)int_part;
            int_part = (long)(val *= AstroMath.dexp(nd));
            Editing.edN(buf, int_part, nd, 32);
            if (shortest_form && Editing.remove_zeroes(buf)) {
                buf.append(".0");
            }
        }
        return buf;
    }

    public StringBuffer editDouble(StringBuffer buf, double value, int ndig, int nexp, int option) {
        boolean decimal_form;
        boolean shortest_form;
        String expo = (option & 0xA) != 0 ? "x10" : "e";
        int o = option;
        int posini = buf.length();
        double val = value;
        boolean bl = shortest_form = ndig <= 0;
        if (sexadrive[option & 0xF] != 0) {
            return this.editSexa(buf, value, ndig, nexp, option);
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            return this.editDecimal(buf, value, ndig + 2, expo.length(), option);
        }
        if (shortest_form) {
            ndig = 15;
        }
        if (value < 0.0) {
            o |= Integer.MIN_VALUE;
            val = -val;
        }
        boolean bl2 = decimal_form = (option & 1) == 0;
        if (decimal_form && val != 0.0) {
            boolean bl3 = decimal_form = val >= 0.1 && val < 1000.0;
        }
        if (decimal_form) {
            int n = 2;
            if (val >= 10.0) {
                ++n;
            }
            if (val >= 100.0) {
                ++n;
            }
            this.editDecimal(buf, value, shortest_form ? 1 : n, ndig - n + 1, option);
            if (shortest_form) {
                Editing.remove_zeroes(buf);
            } else {
                for (n = expo.length() + nexp; n > 0; --n) {
                    buf.append(' ');
                }
            }
            return buf;
        }
        int e = (int)(Double.doubleToLongBits(val) >> 52) - 1023;
        e = e * 3 / 10;
        double f = AstroMath.dexp(e);
        while (val < f) {
            f = AstroMath.dexp(--e);
        }
        while (val >= 10.0 * f) {
            f = AstroMath.dexp(++e);
        }
        val /= f;
        if ((option & 0x40) == 0 && ndig > 0 && (val += 5.0 / AstroMath.dexp(ndig)) >= 10.0) {
            f /= 10.0;
            ++e;
        }
        this.editDecimal(buf, val, shortest_form ? 1 : 2, ndig - 1, o & 0xFFFFFFDF | 0x40);
        if (shortest_form && Editing.remove_zeroes(buf)) {
            if ((option & 0xA) == 0) {
                buf.append('.');
            } else if (buf.length() == 1 + posini && buf.charAt(posini) == '1') {
                buf.setLength(posini);
                expo = "10";
            }
        }
        buf.append(expo);
        this.editInt(buf, e, nexp, 48);
        return buf;
    }

    public StringBuffer editDouble(StringBuffer buf, double value, int option) {
        return this.editDouble(buf, value, 0, 0, option);
    }

    public StringBuffer editSexa(StringBuffer buf, double value, int nint, int ndec, int option) {
        int n;
        int o = option;
        int nd = Math.abs(ndec);
        boolean remove_zeroes = ndec < 0;
        int form = option & 0xF;
        double val = value;
        if (form == 0) {
            form = 5;
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.editDecimal(buf, value, nint, nd, option);
            return buf;
        }
        if (((form = sexadrive[form]) & 0x1000) != 0) {
            nd -= 2;
        }
        if ((form & 0x2000) != 0) {
            nd -= 4;
        }
        while (nd < 0 && (form & 0xF000) != 0) {
            form = (short)(form - 4096);
            nd += 2;
            if ((form & 0xF000) != 0) {
                if ((form & 0xF) == 0) {
                    form = (short)(form & 0xFF00);
                }
                form = (short)(form & 0xFFF0);
                continue;
            }
            if ((form & 0xF0) == 0) {
                form = 0;
            }
            form = (short)(form & 0xFF00);
        }
        if ((form & 0xF000) == 0) {
            this.editDecimal(buf, value, nint, nd, o & 0x70);
            int n2 = form >> 8;
            if (n2 > 0) {
                buf.append(sexachar[n2]);
            }
            return buf;
        }
        if (nd < 0) {
            nd = 0;
        }
        if (value < 0.0) {
            o |= Integer.MIN_VALUE;
            val = -val;
        }
        if ((option & 0x40) == 0) {
            double f = (form & 0x2000) == 0 ? 60.0 : 3600.0;
            val += 0.5 / (f *= AstroMath.dexp(nd));
        }
        long part = (long)val;
        val -= (double)part;
        Editing.edN(buf, part, nint, o);
        char sep = sexachar[form >> 8 & 0xF];
        if ((form & 0xF000) != 0) {
            if (sep != '\u0000') {
                buf.append(sep);
            }
            sep = sexachar[form >> 4 & 0xF];
            val *= 60.0;
            if ((form & 0x2000) == 0) {
                if (nd == 0) {
                    nd = -1;
                }
                this.editDecimal(buf, val, 2, nd, 96);
            } else {
                n = (int)val;
                val -= (double)n;
                buf.append(Character.forDigit(n / 10, 10));
                buf.append(Character.forDigit(n % 10, 10));
            }
        }
        if ((form & 0x2000) != 0) {
            if (sep != '\u0000') {
                buf.append(sep);
            }
            sep = sexachar[form & 0xF];
            val *= 60.0;
            if (nd == 0) {
                n = (int)val;
                buf.append(Character.forDigit(n / 10, 10));
                buf.append(Character.forDigit(n % 10, 10));
            } else {
                this.editDecimal(buf, val, 2, nd, 96);
            }
        }
        if (sep != '\u0000') {
            buf.append(sep);
        }
        if (remove_zeroes) {
            for (n = buf.length() - 1; n > 1 && buf.charAt(n) == '0'; --n) {
            }
            if (buf.charAt(n) != '.') {
                ++n;
            }
            buf.setLength(n);
        }
        return buf;
    }

    private final void edate(StringBuffer buf, int mjd, int driver) {
        int[] ymd = new int[4];
        Astrotime.JD2YMD(2400000.5 + (double)mjd, ymd);
        block8: for (int form = driver; form != 0; form <<= 4) {
            int i = form >> 28 & 0xF;
            switch (i) {
                case 0: {
                    continue block8;
                }
                case 1: {
                    if (ymd[0] < 0) {
                        buf.append('-');
                        Editing.edN(buf, -ymd[0], 3, 32);
                        continue block8;
                    }
                    Editing.edN(buf, ymd[0], 4, 32);
                    continue block8;
                }
                case 2: {
                    Editing.edN(buf, ymd[1] + 1, 2, 32);
                    continue block8;
                }
                case 3: {
                    buf.append(month_list[ymd[1]]);
                    continue block8;
                }
                case 4: {
                    Editing.edN(buf, ymd[2], 2, 32);
                    continue block8;
                }
                case 5: {
                    Editing.edN(buf, ymd[3] + 1, 3, 32);
                    continue block8;
                }
                default: {
                    buf.append(datesep[i - 10]);
                }
            }
        }
    }

    public StringBuffer editDate(StringBuffer buf, int mjd) {
        this.edate(buf, mjd, datedrive[8]);
        return buf;
    }

    public StringBuffer editDate(StringBuffer buf, int mjd, int option) {
        if ((option & 0x80) == 0) {
            option = 136;
        }
        this.edate(buf, mjd, datedrive[option & 0xF]);
        return buf;
    }

    public StringBuffer editDate(StringBuffer buf, double mjd, int time_prec, int option) {
        if (Double.isNaN(mjd)) {
            if (time_prec < 2) {
                return this.editNaN(buf, time_prec < 0 ? 0 : 11);
            }
            return this.editSexa(buf, mjd, 13, time_prec - 2, 0);
        }
        if ((option & 0x80) == 0) {
            option = 136;
        }
        int j = (int)mjd;
        this.edate(buf, j, datedrive[option & 0xF]);
        if (mjd < 0.0) {
            --j;
        }
        double sec = (mjd - (double)j) * 86400.0;
        if (time_prec <= 0 && (time_prec >= -1 || sec == 0.0)) {
            return buf;
        }
        buf.append('T');
        j = time_prec - 2;
        if (time_prec < 0) {
            j -= 4;
        }
        this.editSexa(buf, sec / 3600.0, 2, j, option & 0x40 | 0x20 | 5);
        return buf;
    }

    public StringBuffer editComplex(StringBuffer buf, double mjd, String pic) {
        int len;
        int j;
        int i;
        char c;
        int k;
        int[] ymd = new int[4];
        byte[] len6 = new byte[6];
        byte[] elm6 = new byte[6];
        char[] apic = pic.toCharArray();
        int bpic = 0;
        int epic = pic.length();
        boolean minus = false;
        boolean mixed = false;
        double val = mjd;
        double round = 1.0E-11;
        int valunit = 2;
        if (Double.isNaN(val)) {
            return this.editSexa(buf, val, pic.length(), -1, 0);
        }
        len6[5] = 0;
        len6[4] = 0;
        len6[3] = 0;
        len6[2] = 0;
        len6[1] = 0;
        len6[0] = 0;
        elm6[5] = 0;
        elm6[4] = 0;
        elm6[3] = 0;
        elm6[2] = 0;
        elm6[1] = 0;
        elm6[0] = 0;
        val = val > 0.0 ? (val += 0.49 * round) : (val -= 0.49 * round);
        if (apic[0] == '\"') {
            bpic = 1;
            --epic;
        }
        int ielm = 0;
        int ipic = bpic;
        while (ipic < epic) {
            if ((k = "YMDhmsymDdMS".indexOf(c = apic[ipic++])) < 0) continue;
            if (len6[k %= 6] != 0) {
                i = 5 - k;
                if (k > 0 && i > 0 && len6[i] == 0) {
                    len6[i] = len6[k];
                    j = 0;
                    while (elm6[j] != k) {
                        ++j;
                    }
                    elm6[j] = (byte)i;
                    k = i;
                }
            }
            elm6[ielm++] = (byte)k;
            len = 1;
            while (ipic < epic && apic[ipic] == c) {
                ++len;
                ++ipic;
            }
            if (len6[k] == 0) {
                len6[k] = (byte)len;
            }
            if (ielm < 6) continue;
        }
        if (len6[1] != 0 && len6[0] == 0 && len6[4] == 0) {
            len6[4] = len6[1];
            len6[1] = 0;
            j = 0;
            while (elm6[j] != 1) {
                ++j;
            }
            elm6[j] = 4;
            mixed = true;
        } else if (len6[1] == 0 && len6[0] != 0 && len6[4] != 0 && len6[5] == 0) {
            len6[1] = len6[4];
            len6[4] = 0;
            j = 0;
            while (elm6[j] != 4) {
                ++j;
            }
            elm6[j] = 1;
            mixed = true;
        }
        if (len6[2] != 0 && len6[3] == 0 && len6[0] == 0 && len6[1] == 0) {
            len6[3] = len6[2];
            len6[2] = 0;
            j = 0;
            while (elm6[j] != 2) {
                ++j;
            }
            elm6[j] = 3;
            mixed = true;
        } else if (len6[3] != 0 && len6[0] != 0 && len6[2] == 0) {
            len6[2] = len6[3];
            len6[3] = 0;
            j = 0;
            while (elm6[j] != 3) {
                ++j;
            }
            elm6[j] = 2;
            mixed = true;
        }
        if (mixed) {
            // empty if block
        }
        if (len6[0] != 0) {
            Astrotime.JD2YMD(2400000.5 + val, ymd);
            val -= Math.floor(val);
        } else {
            if (val < 0.0) {
                minus = true;
                val = -val;
            }
            if (len6[2] > 0) {
                ymd[3] = (int)val;
                val -= (double)ymd[3];
            } else {
                valunit = 3;
            }
        }
        char p = '\u0000';
        c = '\u0000';
        k = 0;
        ielm = 0;
        ipic = bpic;
        while (ipic < epic) {
            p = c;
            c = apic[ipic];
            if (c == 'f') break;
            ++ipic;
            k = "YMDhmsymDdMS".indexOf(c);
            if (k < 0) {
                buf.append(c);
                continue;
            }
            i = k % 6;
            if (ielm < 6) {
                i = elm6[ielm++];
                len = len6[i];
            } else {
                len = 0;
            }
            if (len == 0) {
                len = 1;
                while (ipic < epic && apic[ipic] == c) {
                    ++len;
                    ++ipic;
                }
            }
            ipic += len - 1;
            if (minus) {
                buf.append('-');
                minus = false;
                --len;
            }
            while (valunit < i) {
                val *= fac6[valunit];
                round *= fac6[valunit];
                ++valunit;
            }
            switch (i) {
                case 0: {
                    j = ymd[0];
                    if (len6[0] == 2) {
                        j %= 100;
                    }
                    Editing.edN(buf, j, len, 32);
                    break;
                }
                case 1: {
                    if (len6[1] > 2) {
                        buf.append(month_list[ymd[1]]);
                        break;
                    }
                    Editing.edN(buf, ymd[1] + 1, 2, 32);
                    break;
                }
                case 2: {
                    if (len < 2) {
                        len = 2;
                    }
                    j = len6[1] == 0 ? ymd[3] : ymd[2];
                    Editing.edN(buf, j, len, len6[0] > 0 ? 32 : 0);
                    break;
                }
                case 3: {
                    if (len < 2) {
                        len = 2;
                    }
                    j = (int)val;
                    Editing.edN(buf, j, len, len6[2] > 0 ? 32 : 0);
                    val -= (double)j;
                    break;
                }
                case 4: {
                    if (len < 2) {
                        len = 2;
                    }
                    j = (int)val;
                    Editing.edN(buf, j, len, j < 60 ? 32 : 0);
                    val -= (double)j;
                    break;
                }
                case 5: {
                    if (len < 2) {
                        len = 2;
                    }
                    j = (int)val;
                    Editing.edN(buf, j, len, j < 60 ? 32 : 0);
                    val -= (double)j;
                }
            }
        }
        if (minus) {
            buf.append('-');
            minus = false;
        }
        len = 0;
        if (c == 'f') {
            while (ipic < epic && apic[ipic] == 'f') {
                ++len;
                ++ipic;
            }
        }
        if (len > 0 || val > round) {
            if (len == 0 && p != '.') {
                buf.append('.');
            }
            int n = i = len > 0 ? len : 9;
            while (--i >= 0) {
                round *= 10.0;
                j = (int)(val *= 10.0);
                val -= (double)j;
                buf.append(Character.forDigit(j, 10));
                if (!(val <= round) || len != 0) continue;
            }
        }
        while (ipic < epic) {
            buf.append(apic[ipic]);
            ++ipic;
        }
        return buf;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(64);
        b.append("null_text=");
        b.append(this.nulls[0]);
        b.append(", inf_text=");
        b.append(this.inf_string);
        return b.toString();
    }
}

