/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astroframe;
import cds.astro.FK5;

public class Ecliptic
extends Astroframe {
    protected double equinox;
    protected double[][] fromJ2000;

    private static double[][] Jmatrix(double equinox) {
        double[][] R = new double[3][3];
        double dt = (equinox - 2000.0) / 100.0;
        double eps = 84381.448 + (-46.815 + (-5.9E-4 + 0.001813 * dt) * dt) * dt;
        eps /= 3600.0;
        R[0][0] = 1.0;
        R[0][1] = 0.0;
        R[0][2] = 0.0;
        R[1][0] = 0.0;
        R[2][0] = 0.0;
        R[1][1] = AstroMath.cosd(eps);
        R[1][2] = AstroMath.sind(eps);
        R[2][1] = -R[1][2];
        R[2][2] = R[1][1];
        if (equinox != 2000.0) {
            R = AstroMath.m3p(R, FK5.precessionMatrix(2000.0, equinox));
        }
        return R;
    }

    private final void setJmatrix() {
        this.fromJ2000 = Ecliptic.Jmatrix(this.equinox);
        this.ICRSmatrix = AstroMath.m3t(this.fromJ2000);
    }

    public Ecliptic(double equinox) {
        this.precision = (byte)8;
        this.equinox = equinox;
        this.epoch = equinox;
        this.fromJ2000 = null;
        this.name = "Ecl(J" + equinox + ")";
    }

    public Ecliptic() {
        this(2000.0);
    }

    @Override
    public double[][] toICRSmatrix() {
        if (this.ICRSmatrix == null) {
            this.setJmatrix();
        }
        return this.ICRSmatrix;
    }

    public double getEquinox() {
        return this.equinox;
    }
}

