/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Editing;

public class Coocube
extends Coo {
    public byte face;
    public double X;
    public double Y;
    private static final byte[] axis6 = new byte[]{0, 2, 6, 2, 6, 3, 3, 0, 0, 4, 4, 1, 5, 1, 5, 0, 0, 1, 2, 3, 4, 5, 6, 0};
    private static Editing edition = new Editing();

    public static final int face(double[] u) {
        int n;
        int[] s = new int[]{0, 1, 2};
        if (u[1] < u[0]) {
            s[0] = 1;
            s[1] = 0;
        }
        if (u[2] < u[s[0]]) {
            s[2] = s[0];
            s[0] = 2;
        }
        if (u[s[2]] < u[s[1]]) {
            n = s[2];
            s[2] = s[1];
            s[1] = n;
        }
        n = u[s[2]] > -u[s[0]] ? 3 ^ s[2] : 4 ^ s[0];
        if (u[s[0]] >= -0.577 && u[s[2]] <= 0.577) {
            n = 0;
        }
        return n;
    }

    public static final int setXY(double[] u, double[] XY2) {
        double z;
        int face = Coocube.face(u);
        if (face == 0) {
            XY2[1] = 0.0;
            XY2[0] = 0.0;
            return face;
        }
        double d = z = (face & 4) == 0 ? u[3 ^ face] : -u[4 ^ face];
        if (z < 0.577) {
            XY2[1] = 0.0;
            XY2[0] = 0.0;
            return 0;
        }
        byte n = axis6[face];
        XY2[0] = (n & 4) == 0 ? u[3 ^ n] : -u[4 ^ n];
        n = axis6[8 | face];
        XY2[1] = (n & 4) == 0 ? u[3 ^ n] : -u[4 ^ n];
        XY2[0] = XY2[0] / z;
        XY2[1] = XY2[1] / z;
        return face;
    }

    public static final int setUvec(int face, double X, double Y, double[] u) {
        if (face < 1 || face > 6) {
            u[2] = 0.0;
            u[1] = 0.0;
            u[0] = 0.0;
            return 0;
        }
        double factor = 1.0 / Math.sqrt(1.0 + X * X + Y * Y);
        int n = face;
        if ((n & 4) == 0) {
            u[3 ^ n] = factor;
        } else {
            u[4 ^ n] = -factor;
        }
        n = axis6[face];
        if ((n & 4) == 0) {
            u[3 ^ n] = X * factor;
        } else {
            u[4 ^ n] = -X * factor;
        }
        n = axis6[8 | face];
        if ((n & 4) == 0) {
            u[3 ^ n] = Y * factor;
        } else {
            u[4 ^ n] = -Y * factor;
        }
        return face;
    }

    public final void set(double[] u) {
        double[] XY2 = new double[2];
        super.set(u[0], u[1], u[2]);
        this.face = (byte)Coocube.setXY(u, XY2);
        this.X = XY2[0];
        this.Y = XY2[1];
    }

    @Override
    public final void set(Coo coo) {
        double[] u = new double[]{coo.x, coo.y, coo.z};
        this.set(u);
    }

    public final void set(int face, double X, double Y) {
        double[] u = new double[3];
        if (face < 1 || face > 6) {
            u[2] = 0.0;
            u[1] = 0.0;
            u[0] = 0.0;
        } else {
            Coocube.setUvec(face, X, Y, u);
        }
        this.set(u);
    }

    public Coocube() {
        this.face = 0;
        this.X = 0.0;
        this.Y = 0.0;
    }

    public Coocube(Coo coo) {
        this.set(coo);
    }

    public Coocube(int face, double X, double Y) {
        this.set(face, X, Y);
    }

    @Override
    public StringBuffer edit(StringBuffer buf, int ndec) {
        buf.append(this.face);
        buf.append(":");
        if (this.face == 0) {
            return buf;
        }
        edition.editDecimal(buf, this.X, 2, ndec, 16);
        edition.editDecimal(buf, this.Y, 2, ndec, 16);
        return buf;
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer(20);
        this.edit(b, 6);
        b.append("(");
        super.edit(b, 4);
        b.append(")");
        return b.toString();
    }
}

