/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Editing;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Coo
implements Serializable,
Cloneable {
    public double x;
    public double y;
    public double z;
    protected double lon;
    protected double lat;
    public static Editing ed = new Editing("--");
    public static int decimals = -10;
    public static double[][] Umatrix3 = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};

    public Coo() {
        this.set();
    }

    public Coo(Coo coo) {
        this.set(coo);
    }

    public Coo(double lon, double lat) {
        this.set(lon, lat);
    }

    public Coo(double x, double y, double z) {
        this.set(x, y, z);
    }

    public Coo(String text) throws ParseException {
        this.set(text);
    }

    public Object clone() {
        Coo c = null;
        try {
            c = (Coo)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return c;
    }

    private final void computeLonLat() {
        double r2 = this.x * this.x + this.y * this.y;
        this.lon = 0.0;
        if (r2 == 0.0) {
            if (this.z == 0.0) {
                this.lon = Double.NaN;
                this.lat = Double.NaN;
            } else {
                this.lat = this.z > 0.0 ? 90.0 : -90.0;
            }
        } else {
            this.lon = AstroMath.atan2d(this.y, this.x);
            this.lat = AstroMath.atan2d(this.z, Math.sqrt(r2));
            if (this.lon < 0.0) {
                this.lon += 360.0;
            }
        }
    }

    public void set() {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.lon = Double.NaN;
        this.lat = Double.NaN;
    }

    public void set(Coo coo) {
        this.x = coo.x;
        this.y = coo.y;
        this.z = coo.z;
        this.lon = coo.lon;
        this.lat = coo.lat;
    }

    public static final void setUvec(double lon, double lat, double[] u) {
        u[0] = u[1] = AstroMath.cosd(lat);
        u[0] = u[0] * AstroMath.cosd(lon);
        u[1] = u[1] * AstroMath.sind(lon);
        u[2] = AstroMath.sind(lat);
        if (Double.isNaN(u[0])) {
            u[2] = 0.0;
            u[1] = 0.0;
            u[0] = 0.0;
        }
    }

    public void set(double lon, double lat) {
        double coslat = AstroMath.cosd(lat);
        this.lon = lon;
        this.lat = lat;
        if (Double.isNaN(lon) || Double.isNaN(lat)) {
            this.set();
            return;
        }
        this.x = coslat * AstroMath.cosd(lon);
        this.y = coslat * AstroMath.sind(lon);
        this.z = AstroMath.sind(lat);
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            this.z = 0.0;
            this.y = 0.0;
            this.x = 0.0;
        }
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        this.computeLonLat();
    }

    public static Coo perpendicular(Coo pos1, Coo pos2) {
        double[] u3 = new double[3];
        pos1.vecprod(pos2, u3);
        double norm = Math.sqrt(u3[0] * u3[0] + u3[1] * u3[1] + u3[2] * u3[2]);
        if (norm < 1.0E-15) {
            return new Coo();
        }
        return new Coo(u3[0] / norm, u3[1] / norm, u3[2] / norm);
    }

    public boolean parsing(Parsing acoo) {
        boolean f15 = false;
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        acoo.gobbleSpaces();
        this.lon = acoo.parseSexa2();
        if (acoo.inError()) {
            return false;
        }
        if (acoo.isTime()) {
            f15 = true;
        } else if (acoo.isAngle()) {
            f15 = false;
        }
        if (f15) {
            this.lon *= 15.0;
        }
        acoo.gobbleSpaces();
        if (acoo.currentChar() == ',') {
            acoo.advance(1);
            acoo.gobbleSpaces();
        }
        this.lat = acoo.parseSexa();
        if (acoo.inError()) {
            return false;
        }
        this.set(this.lon, this.lat);
        return true;
    }

    public int parse(String text, int offset) {
        Parsing acoo = new Parsing(text, offset);
        return this.parsing(acoo) ? acoo.pos : offset;
    }

    public void set(String text) throws ParseException {
        Parsing acoo = new Parsing(text);
        if (!this.parsing(acoo)) {
            throw new ParseException("****Coo: component larger than 60 in: " + text, acoo.pos);
        }
        acoo.gobbleSpaces();
        if (acoo.pos < acoo.length) {
            throw new ParseException("****Coo: '" + text + "'+" + acoo.pos, acoo.pos);
        }
        this.set(this.lon, this.lat);
    }

    public double getLon() {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        return this.lon;
    }

    public double getLat() {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        return this.lat;
    }

    public void copyAngles(double[] o) {
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        o[0] = this.lon;
        o[1] = this.lat;
    }

    public void copyUvector(double[] u) {
        u[0] = this.x;
        u[1] = this.y;
        u[2] = this.z;
    }

    public static final double distance(double lon1, double lat1, double lon2, double lat2) {
        double c1 = AstroMath.cosd(lat1);
        double c2 = AstroMath.cosd(lat2);
        double w = c1 * AstroMath.cosd(lon1) - c2 * AstroMath.cosd(lon2);
        double r2 = w * w;
        w = c1 * AstroMath.sind(lon1) - c2 * AstroMath.sind(lon2);
        r2 += w * w;
        w = AstroMath.sind(lat1) - AstroMath.sind(lat2);
        return 2.0 * AstroMath.asind(0.5 * Math.sqrt(r2 += w * w));
    }

    public final double dist2(Coo pos) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        if (pos.x == 0.0 && pos.y == 0.0 && pos.z == 0.0) {
            return Double.NaN;
        }
        double w = pos.x - this.x;
        double r2 = w * w;
        w = pos.y - this.y;
        r2 += w * w;
        w = pos.z - this.z;
        return r2 += w * w;
    }

    public final double dist2(double[] u) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        if (u[0] == 0.0 && u[1] == 0.0 && u[2] == 0.0) {
            return Double.NaN;
        }
        double w = u[0] - this.x;
        double r2 = w * w;
        w = u[1] - this.y;
        r2 += w * w;
        w = u[2] - this.z;
        return r2 += w * w;
    }

    public static final double dist2(double[] u, double[] v) {
        double w = u[0] - v[0];
        double r2 = w * w;
        w = u[1] - v[1];
        r2 += w * w;
        w = u[2] - v[2];
        return r2 += w * w;
    }

    public final double distance(Coo pos) {
        if (pos.x == 0.0 && pos.y == 0.0 && pos.z == 0.0) {
            return Double.NaN;
        }
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        return 2.0 * AstroMath.asind(0.5 * Math.sqrt(this.dist2(pos)));
    }

    public final double distc(Coo pos1, Coo pos2) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        double[] v = new double[3];
        pos1.vecprod(pos2, v);
        double n = Coo.normalize(v);
        if (n > 0.0) {
            return AstroMath.asind(Math.abs(this.dotprod(v)));
        }
        return Double.NaN;
    }

    public final double angle(Coo pos1, Coo pos2) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        double[] v1 = new double[3];
        double[] v2 = new double[3];
        this.vecprod(pos1, v1);
        Coo.normalize(v1);
        this.vecprod(pos2, v2);
        Coo.normalize(v2);
        return 90.0 - AstroMath.asind(Coo.dotprod(v1, v2));
    }

    public final double posAngle(Coo pos) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return Double.NaN;
        }
        double Z = pos.z * (this.x * this.x + this.y * this.y) - this.z * (this.x * pos.x + this.y * pos.y);
        double Y = this.x * pos.y - this.y * pos.x;
        double pa = 90.0 - AstroMath.atan2d(Z, Y);
        if (pa < 0.0) {
            pa += 360.0;
        }
        return pa;
    }

    public static final double dotprod(double[] v1, double[] v2) {
        return v1[0] * v2[0] + v1[1] * v2[1] + v1[2] * v2[2];
    }

    public final double dotprod(double[] v) {
        return this.x * v[0] + this.y * v[1] + this.z * v[2];
    }

    public final double dotprod(Coo pos) {
        return this.x * pos.x + this.y * pos.y + this.z * pos.z;
    }

    public static final double norm2(double[] v1) {
        return Coo.dotprod(v1, v1);
    }

    public static final void vecprod(double[] v1, double[] v2, double[] r) {
        r[0] = v1[1] * v2[2] - v1[2] * v2[1];
        r[1] = v1[2] * v2[0] - v1[0] * v2[2];
        r[2] = v1[0] * v2[1] - v1[1] * v2[0];
    }

    public final void vecprod(double[] v, double[] r) {
        r[0] = this.y * v[2] - this.z * v[1];
        r[1] = this.z * v[0] - this.x * v[2];
        r[2] = this.x * v[1] - this.y * v[0];
    }

    public final void vecprod(Coo pos, double[] r) {
        r[0] = this.y * pos.z - this.z * pos.y;
        r[1] = this.z * pos.x - this.x * pos.z;
        r[2] = this.x * pos.y - this.y * pos.x;
    }

    static double det(double[] v1, double[] v2, double[] v3) {
        double[] v = new double[3];
        Coo.vecprod(v1, v2, v);
        return Coo.dotprod(v, v3);
    }

    public static final void rotateVector(double[][] R, double[] v) {
        if (R == Umatrix3) {
            return;
        }
        for (int i = 0; i < v.length; i += 3) {
            double x = v[i];
            double y = v[i + 1];
            double z = v[i + 2];
            v[i + 0] = R[0][0] * x + R[0][1] * y + R[0][2] * z;
            v[i + 1] = R[1][0] * x + R[1][1] * y + R[1][2] * z;
            v[i + 2] = R[2][0] * x + R[2][1] * y + R[2][2] * z;
        }
    }

    public static final void rotateVector_1(double[][] R, double[] v) {
        if (R == Umatrix3) {
            return;
        }
        for (int i = 0; i < v.length; i += 3) {
            double x = v[i];
            double y = v[i + 1];
            double z = v[i + 2];
            v[i + 0] = R[0][0] * x + R[1][0] * y + R[2][0] * z;
            v[i + 1] = R[0][1] * x + R[1][1] * y + R[2][1] * z;
            v[i + 2] = R[0][2] * x + R[1][2] * y + R[2][2] * z;
        }
    }

    public void rotate(double[][] R) {
        if (R == Umatrix3) {
            return;
        }
        double X = R[0][0] * this.x + R[0][1] * this.y + R[0][2] * this.z;
        double Y = R[1][0] * this.x + R[1][1] * this.y + R[1][2] * this.z;
        double Z = R[2][0] * this.x + R[2][1] * this.y + R[2][2] * this.z;
        this.x = X;
        this.y = Y;
        this.z = Z;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public void rotate_1(double[][] R) {
        if (R == Umatrix3) {
            return;
        }
        double X = R[0][0] * this.x + R[1][0] * this.y + R[2][0] * this.z;
        double Y = R[0][1] * this.x + R[1][1] * this.y + R[2][1] * this.z;
        double Z = R[0][2] * this.x + R[1][2] * this.y + R[2][2] * this.z;
        this.x = X;
        this.y = Y;
        this.z = Z;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public static double[][] eulerMatrix(double z, double theta, double zeta) {
        double[][] R = new double[3][3];
        R[0][2] = AstroMath.cosd(z);
        R[1][2] = AstroMath.sind(z);
        R[2][2] = AstroMath.cosd(theta);
        double w = AstroMath.sind(theta);
        R[2][0] = AstroMath.cosd(zeta);
        R[2][1] = AstroMath.sind(zeta);
        R[0][0] = R[2][0] * R[2][2] * R[0][2] - R[2][1] * R[1][2];
        R[1][0] = R[2][0] * R[2][2] * R[1][2] + R[2][1] * R[0][2];
        R[0][1] = -R[2][1] * R[2][2] * R[0][2] - R[2][0] * R[1][2];
        R[1][1] = -R[2][1] * R[2][2] * R[1][2] + R[2][0] * R[0][2];
        R[2][0] = R[2][0] * w;
        R[2][1] = -R[2][1] * w;
        R[0][2] = -w * R[0][2];
        R[1][2] = -w * R[1][2];
        return R;
    }

    public static final double[][] localMatrix(double lon, double lat) {
        double[][] R = new double[3][3];
        R[2][2] = AstroMath.cosd(lat);
        R[0][2] = AstroMath.sind(lat);
        R[1][1] = AstroMath.cosd(lon);
        R[1][0] = -AstroMath.sind(lon);
        R[1][2] = 0.0;
        R[0][0] = R[2][2] * R[1][1];
        R[0][1] = -R[2][2] * R[1][0];
        R[2][0] = -R[0][2] * R[1][1];
        R[2][1] = R[0][2] * R[1][0];
        return R;
    }

    public final void localMatrix(double[][] R) {
        double r = Math.sqrt(this.x * this.x + this.y * this.y);
        R[0][0] = this.x;
        R[0][1] = this.y;
        R[0][2] = this.z;
        if (r == 0.0) {
            R[1][0] = 0.0;
            R[1][1] = 1.0;
        } else {
            R[1][0] = -this.y / r;
            R[1][1] = this.x / r;
        }
        R[1][2] = 0.0;
        R[2][0] = -this.z * R[1][1];
        R[2][1] = this.z * R[1][0];
        R[2][2] = r;
    }

    public final double[][] localMatrix() {
        double[][] R = new double[3][3];
        this.localMatrix(R);
        return R;
    }

    public final double[][] moveMatrix(Coo coo2) {
        double[][] R = new double[3][3];
        double[][] R1 = this.localMatrix();
        double[][] R2 = coo2.localMatrix();
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = R2[0][i] * R1[0][j] + R2[1][i] * R1[1][j] + R2[2][i] * R1[2][j];
            }
        }
        return R;
    }

    public static final double normalize(double[] u) {
        double n = Math.sqrt(u[0] * u[0] + u[1] * u[1] + u[2] * u[2]);
        if (n > 0.0) {
            u[0] = u[0] / n;
            u[1] = u[1] / n;
            u[2] = u[2] / n;
            if (u.length > 3) {
                u[3] = u[3] / n;
                u[4] = u[4] / n;
                u[5] = u[5] / n;
            }
        }
        return n;
    }

    public double normalize() {
        double n = this.x * this.x + this.y * this.y + this.z * this.z;
        if (n > 0.0) {
            n = Math.sqrt(n);
            this.x /= n;
            this.y /= n;
            this.z /= n;
        }
        return n;
    }

    public static final double add(double[] u, double[] du) {
        u[0] = u[0] + du[0];
        u[1] = u[1] + du[1];
        u[2] = u[2] + du[2];
        return Coo.normalize(u);
    }

    public static final double sub(double[] u, double[] du) {
        u[0] = u[0] - du[0];
        u[1] = u[1] - du[1];
        u[2] = u[2] - du[2];
        return Coo.normalize(u);
    }

    public final double add(double[] du) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return 0.0;
        }
        this.x += du[0];
        this.y += du[1];
        this.z += du[2];
        this.lon = Double.NaN;
        this.lat = Double.NaN;
        return this.normalize();
    }

    public final double sub(double[] du) {
        if (this.x == 0.0 && this.y == 0.0 && this.z == 0.0) {
            return 0.0;
        }
        this.x -= du[0];
        this.y -= du[1];
        this.z -= du[2];
        this.lon = Double.NaN;
        this.lat = Double.NaN;
        return this.normalize();
    }

    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof Coo) {
            Coo c = (Coo)o;
            res = c.x == this.x && c.y == this.y && c.z == this.z;
        }
        return res;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.x);
        int hcode = (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.y);
        hcode = 123 * hcode + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.z);
        hcode = 123 * hcode + (int)(l ^ l >>> 32);
        return hcode;
    }

    public final StringBuffer editCoo(StringBuffer b, int nd) {
        int o = b.length();
        if (Double.isNaN(this.lat)) {
            this.computeLonLat();
        }
        ed.editDecimal(b, this.lon, 3, nd, 32);
        if (b.charAt(o) == '3' && b.charAt(o + 1) == '6') {
            String pb = b.substring(o + 2);
            b.setLength(o);
            b.append("00");
            b.append(pb);
        }
        ed.editDecimal(b, this.lat, 3, nd, 48);
        return b;
    }

    public StringBuffer edit(StringBuffer b, int nd) {
        return this.editCoo(b, nd);
    }

    public static int setDecimals(int nd) {
        int ret = decimals;
        decimals = nd;
        return ret;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        this.editCoo(b, decimals);
        return b.toString();
    }

    private static final StringBuffer ed3(StringBuffer buf, double[] u, int offset) {
        ed.editDecimal(buf, u[offset + 0], 2, 15, 16);
        buf.append(' ');
        ed.editDecimal(buf, u[offset + 1], 2, 15, 16);
        buf.append(' ');
        ed.editDecimal(buf, u[offset + 2], 2, 15, 16);
        return buf;
    }

    protected static final String toString(double[] u) {
        return Coo.toString("", u);
    }

    protected static final String toString(String title, double[] u) {
        StringBuffer b = new StringBuffer(title);
        int n = title.length();
        Coo.ed3(b, u, 0);
        for (int o = 3; o < u.length; o += 3) {
            b.append('\n');
            for (int i = 0; i < n; ++i) {
                b.append(' ');
            }
            Coo.ed3(b, u, o);
        }
        return b.toString();
    }

    protected static final String toString(String title, double[][] m) {
        StringBuffer b = new StringBuffer(title);
        int n = title.length();
        if (m == null) {
            b.append(" (3x3matrix)(nil)");
        } else {
            for (int j = 0; j < m.length; ++j) {
                if (j > 0) {
                    b.append('\n');
                    for (int i = 0; i < n; ++i) {
                        b.append(' ');
                    }
                }
                Coo.ed3(b, m[j], 0);
            }
        }
        return b.toString();
    }

    public void dump(String title) {
        StringBuffer b = new StringBuffer(256);
        int i = title.length();
        b.append(title);
        b.append("  ");
        this.editCoo(b, 12);
        b.append("\n");
        while (--i >= 0) {
            b.append(' ');
        }
        ed.editDecimal(b, this.x, 2, 15, 16);
        b.append(' ');
        ed.editDecimal(b, this.y, 2, 15, 16);
        b.append(' ');
        ed.editDecimal(b, this.z, 2, 15, 16);
        System.out.println(b.toString());
    }
}

