/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Qbox;
import cds.astro.Region;

public class ConvexRegion
extends Region {
    boolean direct;
    int nvert = 0;
    Coo[] vert;
    double[][] vecs;
    double dim1 = 0.0;
    double dim2 = 0.0;
    double pa = 0.0;

    ConvexRegion(Coo[] points) {
        int i;
        if (points.length < 3) {
            System.err.println("#+++Convex(" + points.length + "points) requires at least 3 points!");
            return;
        }
        this.nvert = points.length;
        this.vert = new Coo[this.nvert + 1];
        this.centroid = new Coo();
        for (i = 0; i < this.nvert; ++i) {
            if (points[i].x == 0.0 && points[i].y == 0.0 && points[i].x == 0.0) {
                System.err.println("#+++Convex(" + points.length + "points) has invalid point#" + i);
                this.nvert = 0;
                return;
            }
            this.vert[i] = points[i];
            this.centroid.x += points[i].x;
            this.centroid.y += points[i].y;
            this.centroid.z += points[i].z;
        }
        this.vert[this.nvert] = this.vert[0];
        this.centroid.normalize();
        this.vecs = new double[this.nvert][3];
        for (i = 0; i < this.nvert; ++i) {
            this.vert[i].vecprod(this.vert[i + 1], this.vecs[i]);
            Coo.normalize(this.vecs[i]);
        }
        this.minrad = 100.0;
        this.maxrad = 0.0;
        for (i = 0; i < this.nvert; ++i) {
            double d = this.centroid.dotprod(this.vecs[i]);
            if (i == 0) {
                this.direct = d >= 0.0;
            } else if (d > 0.0 ^ this.direct) {
                System.err.println("#+++Convex(" + points.length + "points) not convex at point#" + i + "=" + this.vert[i] + "; direct=" + this.direct + ", d=" + d);
                this.nvert = 0;
                return;
            }
            d = Math.abs(AstroMath.asind(d));
            if (d < this.minrad) {
                this.minrad = d;
            }
            if (d > this.maxrad) {
                this.maxrad = d;
            }
            if ((d = this.centroid.distance(this.vert[i])) < this.minrad) {
                this.minrad = d;
            }
            if (!(d > this.maxrad)) continue;
            this.maxrad = d;
        }
        if (DEBUG) {
            System.out.println("#...Created: " + this.toString() + " dist=" + this.minrad + "/" + this.maxrad);
        }
    }

    final void setBox(double dim1, double dim2, double pa) {
        if (this.nvert != 4 || dim1 <= 0.0 || dim2 <= 0.0) {
            System.err.println("#***setBox(" + dim1 + "," + dim2 + "," + pa + ") -- not a box:");
            System.err.println("#   " + this);
            return;
        }
        if (dim1 < dim2) {
            this.dim1 = dim2;
            this.dim2 = dim1;
            this.pa = pa + 90.0;
        } else {
            this.dim1 = dim1;
            this.dim2 = dim2;
            this.pa = pa;
        }
        while (this.pa < 0.0) {
            this.pa += 180.0;
        }
        while (this.pa >= 180.0) {
            this.pa -= 180.0;
        }
    }

    @Override
    public final String toString() {
        StringBuffer b = new StringBuffer();
        if (this.nvert < 3) {
            b.append("*INVALID*");
        }
        if (this.dim1 > 0.0) {
            b.append("Box(" + this.centroid);
            b.append(", " + this.dim1 + "x" + this.dim2);
            if (this.pa >= 0.0) {
                b.append(", pa=" + this.pa);
            }
        } else {
            b.append("Convex[");
            b.append(this.nvert);
            b.append("]");
            String sep = "(";
            for (int i = 0; i < this.nvert; ++i) {
                b.append(sep);
                b.append(this.vert[i].toString());
                sep = ", ";
            }
        }
        b.append(")");
        return b.toString();
    }

    @Override
    public double area() {
        if (this.nvert < 3) {
            return Double.NaN;
        }
        double S = (double)(2 - this.nvert) * 180.0;
        S += this.vert[0].angle(this.vert[this.nvert - 1], this.vert[1]);
        for (int i = 1; i < this.nvert; ++i) {
            S += this.vert[i].angle(this.vert[i - 1], this.vert[i + 1]);
        }
        return 57.29577951308232 * S;
    }

    @Override
    public boolean checkCoo(Coo point) {
        if (this.nvert < 3) {
            return false;
        }
        if (DEBUG) {
            System.out.println("#...Convex.checkCoo(" + point + ")");
        }
        for (int i = 0; i < this.nvert; ++i) {
            double r = point.dotprod(this.vecs[i]);
            if (!(r > 0.0 ^ this.direct)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int checkCircle(Coo point, double r) {
        int st;
        if (this.centroid == null) {
            return 0;
        }
        if (DEBUG) {
            System.out.println("#...Convex.checkCircle(" + point + ", r=" + r + ")");
        }
        if ((st = this.check1(point, r)) != 1) {
            return st;
        }
        int nin = 0;
        int nut = 0;
        double sh2 = 2.0 * AstroMath.sind(r / 2.0);
        sh2 *= sh2;
        double sinr = AstroMath.sind(r);
        for (int i = 0; i < this.nvert; ++i) {
            double s1;
            double s0;
            double ps;
            double d2 = point.dist2(this.vert[i]);
            if (d2 < sh2) {
                ++nin;
                if (nut > 0) {
                    return 1;
                }
            }
            if (d2 > sh2) {
                ++nut;
                if (nin > 0) {
                    return 1;
                }
            }
            if (((ps = this.vert[i].dotprod(this.vert[i + 1])) * (s0 = point.dotprod(this.vert[i])) - (s1 = point.dotprod(this.vert[i + 1]))) * (ps * s1 - s0) <= 0.0 || !(Math.abs(point.dotprod(this.vecs[i])) < sinr)) continue;
            return 1;
        }
        if (DEBUG) {
            System.out.print("    nin=" + nin + ", nut=" + nut);
        }
        if (nin > 0) {
            return 3;
        }
        return this.checkCoo(point) ? -1 : 0;
    }

    @Override
    public int checkQbox(int qbox) {
        int i;
        if (this.centroid == null) {
            return 0;
        }
        Qbox abox = new Qbox();
        abox.set(qbox);
        Coocube cc = abox.center();
        double rb = abox.radius();
        int stat1 = this.checkCircle(cc, rb);
        if (stat1 != 1) {
            if (DEBUG) {
                System.out.println("#-->" + stat1);
            }
            return stat1;
        }
        if (DEBUG) {
            System.out.print("#...convex next");
        }
        double[][] u4 = new double[5][3];
        Qbox.ucorners(abox.qbox, u4);
        u4[4][0] = u4[0][0];
        u4[4][1] = u4[0][1];
        u4[4][2] = u4[0][2];
        double[][] v4 = new double[4][3];
        double[] ps = new double[4];
        double[] vm = new double[3];
        for (i = 0; i < 4; ++i) {
            Coo.vecprod(u4[i], u4[i + 1], v4[i]);
            Coo.normalize(v4[i]);
            ps[i] = Coo.dotprod(u4[i], u4[i + 1]);
        }
        for (i = 0; i < this.nvert; ++i) {
            double s01 = this.vert[i].dotprod(this.vert[i + 1]);
            for (int j = 0; j < 4; ++j) {
                if (DEBUG) {
                    System.out.print(" (" + i + "," + j + ")");
                }
                Coo.vecprod(this.vecs[i], v4[j], vm);
                Coo.normalize(vm);
                if (this.vert[i].dotprod(vm) < s01) {
                    if (DEBUG) {
                        System.out.print(" (-)");
                    }
                    vm[0] = -vm[0];
                    vm[1] = -vm[1];
                    vm[2] = -vm[2];
                }
                if (!(this.vert[i].dotprod(vm) > s01) || !(this.vert[i + 1].dotprod(vm) > s01) || !(Coo.dotprod(u4[j], vm) > ps[j]) || !(Coo.dotprod(u4[j + 1], vm) > ps[j])) continue;
                if (DEBUG) {
                    System.out.println("");
                }
                return 1;
            }
        }
        if (DEBUG) {
            System.out.println(" (no intersection)");
        }
        if (this.checkCoo(cc)) {
            return -1;
        }
        return 0;
    }
}

