/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Unit;
import java.text.ParseException;

public class Converter {
    public Unit source;
    public Unit target;
    public double factor;
    static char SEP = (char)10238;

    public Converter(String source_unit, String target_unit) {
        try {
            this.source = new Unit(source_unit);
        }
        catch (Exception e) {
            System.err.println(e);
            this.source = null;
        }
        try {
            this.target = new Unit(target_unit);
        }
        catch (Exception e) {
            System.err.println(e);
            this.target = null;
        }
        this.source.setUnit();
        this.target.setUnit();
        this.factor = this.source.factor / this.target.factor;
    }

    public Converter(String source_unit, String target_unit, double factor) {
        try {
            this.source = new Unit(source_unit);
            this.source.setUnit();
        }
        catch (Exception e) {
            System.err.println(e);
            this.source = null;
        }
        try {
            this.target = new Unit(target_unit);
            this.target.setUnit();
        }
        catch (Exception e) {
            System.err.println(e);
            this.target = null;
        }
        this.factor = factor;
        Unit.registerConverter(source_unit, target_unit, this);
    }

    public void dump(String title) {
        System.out.println(title + "(factor=" + this.factor + ")");
        this.source.dump("source_unit ");
        this.target.dump("target_unit ");
    }

    public double convert(double value) throws ArithmeticException {
        this.source.setValue(value);
        if (this.factor == this.factor) {
            this.target.setValue(value * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.value;
    }

    public double convert(String value) throws ParseException, ArithmeticException {
        this.source.setValue(value);
        if (this.factor == this.factor) {
            this.target.setValue(this.source.value * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.value;
    }

    public String transform(String value) throws ParseException, ArithmeticException {
        this.source.setValue(value);
        if (this.factor == this.factor) {
            this.target.setValue(this.source.value * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.editedValue();
    }

    public String transform(double value) throws ArithmeticException {
        this.source.setValue(value);
        if (this.factor == this.factor) {
            this.target.setValue(value * this.factor);
        } else {
            Unit.convert(this.source, this.target);
        }
        return this.target.editedValue();
    }

    public String toString() {
        return this.source.symbol + "=>" + this.target.symbol + "(x" + this.factor + ")";
    }
}

