/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Qbox;
import cds.astro.Region;

public class CircularRegion
extends Region {
    double sh2;
    double s2r;

    CircularRegion(Coo c, double r) {
        if (DEBUG) {
            System.out.println("#...new Circle(" + c + ", r=" + r + ")");
        }
        this.centroid = new Coo(c);
        this.minrad = this.maxrad = r;
        if (r >= 180.0) {
            System.err.println("#+++Circle(" + c + ", r=" + r + "): radius set to 180deg!");
            this.maxrad = 180.0;
            this.minrad = 180.0;
        }
        this.s2r = AstroMath.sind(r);
        this.s2r *= this.s2r;
        this.sh2 = 2.0 * AstroMath.sind(r / 2.0);
        this.sh2 *= this.sh2;
        if (this.centroid.x == 0.0 && this.centroid.y == 0.0 && this.centroid.z == 0.0) {
            this.centroid = null;
            this.sh2 = -1.0;
            this.s2r = -1.0;
        }
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        if (this.centroid == null) {
            b.append("*INVALID*");
        }
        b.append("Circle(");
        if (this.centroid != null) {
            b.append(this.centroid.toString());
        }
        b.append(", r=" + this.minrad + ")");
        return b.toString();
    }

    @Override
    public double area() {
        if (this.centroid == null) {
            return Double.NaN;
        }
        return 32400.0 * this.sh2 / Math.PI;
    }

    @Override
    public boolean checkCoo(Coo point) {
        if (this.centroid == null) {
            return false;
        }
        return this.centroid.dist2(point) <= this.sh2;
    }

    @Override
    public int checkCircle(Coo centre, double radius) {
        if (this.centroid == null) {
            return 0;
        }
        return this.check1(centre, radius);
    }

    @Override
    public int checkQbox(int qbox) {
        int i;
        if (this.centroid == null) {
            return 0;
        }
        Qbox abox = new Qbox();
        abox.set(qbox);
        Coocube cc = abox.center();
        double r = Qbox.maxRadius(qbox);
        int stat1 = this.check1(cc, r);
        if (DEBUG) {
            System.out.println("#...CheckQbox(" + qbox + "=" + abox + "[" + cc + "]" + "\n    in Region " + this + " => " + stat1);
        }
        if (stat1 == 3) {
            stat1 = this.check1(cc, Qbox.minRadius(qbox));
            if (DEBUG) {
                System.out.println("#   [minRad?] " + this + " => " + stat1);
            }
            if (stat1 != 3) {
                stat1 = 1;
            }
        }
        if (stat1 != 1) {
            return stat1;
        }
        double[][] u4 = new double[5][3];
        Qbox.ucorners(abox.qbox, u4);
        int inside = 0;
        for (i = 0; i < 4; ++i) {
            if (!(this.centroid.dist2(u4[i]) <= this.sh2)) continue;
            ++inside;
        }
        if (DEBUG) {
            System.out.println("#...inside=" + inside);
        }
        if (inside == 4) {
            return -1;
        }
        if (inside > 0) {
            return 1;
        }
        double[] v = new double[3];
        Qbox.ucorners(abox.qbox, u4);
        if (DEBUG) {
            System.out.println(Coo.toString("#corners ", u4));
        }
        u4[4][0] = u4[0][0];
        u4[4][1] = u4[0][1];
        u4[4][2] = u4[0][2];
        for (i = 0; i < 4; ++i) {
            Coo.vecprod(u4[i], u4[i + 1], v);
            r = this.centroid.dotprod(v);
            if (r >= 0.0) {
                ++inside;
            }
            if (DEBUG) {
                System.out.println("#   i=" + i + ", r=" + r + ", ||v||=" + Coo.norm2(v));
            }
            if (!(r * r <= this.s2r * Coo.norm2(v))) continue;
            return 1;
        }
        return inside == 4 ? 3 : 0;
    }
}

