/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Editing;
import cds.astro.Parsing;
import java.text.ParseException;

public class Astrotime {
    protected double mjd;
    protected byte unit;
    protected byte precision;
    public static Editing ed = new Editing("--");
    public static final double Byr = 365.242198781;
    public static final double Jyr = 365.25;
    public static final double JD_J2000 = 2451545.0;
    public static final double JD_B1900 = 2415020.31352;
    public static final double JD_1970 = 2440587.5;
    public static final double JD_MJD0 = 2400000.5;
    public static final String[] prefix = new String[]{"\"date\"", "MJD", "JD", "J", "B", "ms"};
    private static final double[] factor = new double[]{1.0, 1.0, 1.0, 0.0027378507871321013, 0.0027379092649685915, 8.64E7};
    private static final String[] is_now = new String[]{"now", "."};
    public static final double[] offset = new double[]{0.0, 0.0, 2400000.5, 1858.8788501026695, 1858.8771134054919, -3.5067168E12};
    private static final byte[] ilen = new byte[]{10, 5, 7, 4, 4, 12};
    private static final double[] C_teq = new double[]{24110.54841, 8640184.812866, 0.093104, -6.2E-6};

    public static final double J2JD(double y) {
        return 2451545.0 + (y - 2000.0) * 365.25;
    }

    public static final double B2JD(double y) {
        return 2415020.31352 + (y - 1900.0) * 365.242198781;
    }

    public static final double YMD2JD(int year, int month, int day) {
        int jdi;
        int i;
        if (year <= -4712) {
            i = 1 + (year + 4712) / 400;
            jdi = -i * 146097;
            i = year + 400 * i;
        } else {
            jdi = 0;
            i = year;
        }
        if (day <= 0) {
            day = 1;
        }
        if (month < 0 || month > 11) {
            month = 0;
        }
        double jd = jdi += 1461 * ((i -= (11 - month) / 10) + 4712) / 4 + (306 * ((month + 10) % 12) + 5) / 10 - 3 * ((i + 4900) / 100) / 4 + day + 96;
        return jd + 0.5;
    }

    public static final void JD2YMD(double jd, int[] ymd) {
        int j = (int)(jd + 0.5);
        int year = -4712;
        while (j <= 4480) {
            j += 146097;
            year -= 400;
        }
        int n4 = 4 * (j + (2 * ((4 * j - 17918) / 146097) * 3 / 4 + 1) / 2 - 37);
        int nd10 = 10 * ((n4 - 237) % 1461 / 4) + 5;
        ymd[0] = year + n4 / 1461;
        if (ymd.length > 1) {
            ymd[1] = (nd10 / 306 + 2) % 12;
            ymd[2] = nd10 % 306 / 10 + 1;
        }
        if (ymd.length != 3) {
            n4 = (j + 32104) % 146097;
            if (n4 >= 36525) {
                n4 += (n4 - 366) / 36524;
            }
            if ((n4 %= 1461) >= 731) {
                n4 += (n4 - 366) / 365;
            }
            j = 1 + n4 % 366;
            if (ymd.length == 2) {
                ymd[1] = j;
            } else {
                ymd[3] = j;
            }
        }
    }

    public static final double ms2JD(long ms) {
        return 2440587.5 + (double)ms / 8.64E7;
    }

    public static final double MJD2JD(double mjd) {
        return 2400000.5 + mjd;
    }

    public static final double JD2J(double jd) {
        return 2000.0 + (jd - 2451545.0) / 365.25;
    }

    public static final double JD2B(double jd) {
        return 1900.0 + (jd - 2415020.31352) / 365.242198781;
    }

    public static final long JD2ms(double jd) {
        return (long)((jd - 2440587.5) * 8.64E7);
    }

    public static final double JD2MJD(double jd) {
        return jd - 2400000.5;
    }

    public static final double B2J(double y) {
        return Astrotime.JD2J(Astrotime.B2JD(y));
    }

    public static final double J2B(double y) {
        return Astrotime.JD2B(Astrotime.J2JD(y));
    }

    public Astrotime() {
        this.mjd = Double.NaN;
        this.unit = 0;
        this.precision = (byte)8;
    }

    public Astrotime(String text) throws ParseException {
        this.set(text);
    }

    public final void dump(String title) {
        System.out.println(title + " unit=" + this.unit + ", precision=" + this.precision + ", mjd=" + this.mjd);
    }

    public boolean parsing(Parsing t) {
        double x;
        int posini = t.pos;
        t.gobbleSpaces();
        int prec = 0;
        int k = t.lookup(prefix);
        int pos1 = t.pos;
        if (t.pos == t.length || t.lookupIgnoreCase(is_now) >= 0) {
            this.set(System.currentTimeMillis());
            return true;
        }
        if (k <= 0) {
            int pdate = t.parseDate();
            boolean sexatime = false;
            x = 0.0;
            if (t.pos > pos1) {
                k = 0;
                int pos2 = t.pos;
                prec = t.format() & 0xFFFFFF7E;
                prec = prec == 128 || prec == 130 ? 0 : 1;
                if (prec == 1) {
                    char c = t.currentChar();
                    if (c == '.') {
                        x = t.parseDecimal();
                        sexatime = t.match(':');
                        if (sexatime) {
                            t.set(pos2);
                        } else {
                            prec = 1 + t.decimals();
                        }
                    } else {
                        boolean bl = sexatime = c == 'T' || c == ':' || c == ' ';
                    }
                    if (sexatime) {
                        t.advance(1);
                        x = t.parseSexa();
                        if (t.pos - pos2 > 1) {
                            x /= 24.0;
                            prec = 2 + t.decimals();
                        } else {
                            t.set(pos2);
                            x = 0.0;
                        }
                    }
                }
                x += (double)pdate;
            }
        } else {
            x = t.parseDouble();
            prec = 1 + t.decimals();
        }
        if (t.pos == pos1) {
            t.set(posini);
            return false;
        }
        this.precision = (byte)prec;
        if (k < 0) {
            k = t.lookup(prefix);
        }
        if (k < 0) {
            k = 3;
        }
        this.mjd = (x - offset[k]) / factor[k];
        return true;
    }

    public int parse(String text, int offset) {
        Parsing t = new Parsing(text, offset);
        return this.parsing(t) ? t.pos : offset;
    }

    public void set(double mjd) {
        this.mjd = mjd;
        this.unit = 1;
        this.precision = (byte)8;
    }

    public void set(long ms) {
        this.mjd = 40587.0 + (double)ms / 8.64E7;
        this.unit = 0;
        this.precision = (byte)8;
    }

    public void set(String text) throws ParseException {
        Parsing t = new Parsing(text);
        if (this.parsing(t)) {
            t.gobbleSpaces();
        }
        if (t.pos != t.length) {
            throw new ParseException("****Astrotime: argument '" + text + "'", t.pos);
        }
    }

    public double getMJD() {
        return this.mjd;
    }

    public double getJyr() {
        return 2000.0 + (this.mjd + -51544.5) / 365.25;
    }

    public double getByr() {
        return 1900.0 + (this.mjd + -15019.81351999985) / 365.242198781;
    }

    public double getJD() {
        return this.mjd + 2400000.5;
    }

    public long getTime() {
        return (long)((this.mjd + -40587.0) * 8.64E7);
    }

    public double getLST() {
        double j0h = Math.floor(this.mjd);
        double tcj = (j0h - 51544.5) / 36525.0;
        double tsg = ((C_teq[3] * tcj + C_teq[2]) * tcj + C_teq[1]) * tcj + C_teq[0];
        tsg -= 86400.0 * Math.floor(tsg / 86400.0);
        if ((tsg += 86636.55536784 * (this.mjd - j0h)) >= 86400.0) {
            tsg -= 86400.0;
        }
        return tsg;
    }

    public double getLST(double lon) {
        double tsl = this.getLST() + lon * 240.0;
        if (tsl < 0.0) {
            tsl += 86400.0;
        } else if (tsl > 86400.0) {
            tsl -= 86400.0;
        }
        return tsl;
    }

    private final void edit(StringBuffer b, int i, double v) {
        if (i > 0) {
            b.append(prefix[i]);
        }
        if (Double.isNaN(v) || i > 0) {
            ed.editDecimal(b, v, ilen[i], this.precision - 1, 0);
            return;
        }
        int iv = (int)v;
        double dv = v - (double)iv;
        if (dv < -1.0E-11) {
            --iv;
            dv += 1.0;
        } else if (dv < 0.0) {
            dv = 0.0;
        }
        ed.editDate(b, iv);
        if (this.precision == 0) {
            b.setLength(b.length() - 3);
        }
        if (this.precision <= 1) {
            return;
        }
        b.append('T');
        ed.editSexa(b, dv * 24.0, 2, this.precision - 2, 37);
    }

    public String toString(String unit) {
        int i;
        StringBuffer b = new StringBuffer(32);
        for (i = 0; i < prefix.length && !unit.equals(prefix[i]); ++i) {
        }
        if (i == prefix.length) {
            i = this.unit;
        }
        double v = this.mjd * factor[i] + offset[i];
        this.edit(b, i, v);
        return b.toString();
    }

    public String toString() {
        double v = this.mjd * factor[this.unit] + offset[this.unit];
        StringBuffer b = new StringBuffer(32);
        this.edit(b, this.unit, v);
        return b.toString();
    }
}

