/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.AstroMath;
import cds.astro.Astrocoo;
import cds.astro.Astroframe;
import cds.astro.Coo;
import cds.astro.FK4;
import cds.astro.ICRS;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Astropos
extends Astrocoo
implements Serializable {
    private static boolean DEBUG = false;
    protected double xd;
    protected double yd;
    protected double zd;
    private double[][] R;
    protected double epocho;
    public double plx;
    public double rv;
    public double e_plx;
    public double e_rv;
    private byte permanent;
    private byte specified;
    private boolean ready;
    private static String[] partnames = new String[]{"plx", "rv", "pm", "meanEp", "cov.pos", "cov.pm", "cov.from.prec", "epoch"};
    protected double[][] cov;
    private static double[] def_err = new double[]{6.48E8, 7560000.0, 756000.0, 126000.0, 12600.0, 2100.0, 210.0, 21.0, 2.1, 0.21000000000000002, 0.021, 0.0021000000000000003};

    private static final void tr3(double[][] m) {
        double v = m[0][1];
        m[0][1] = m[1][0];
        m[1][0] = v;
        v = m[0][2];
        m[0][2] = m[2][0];
        m[2][0] = v;
        v = m[1][2];
        m[1][2] = m[2][1];
        m[2][1] = v;
    }

    private final void rot2local(double[] u, double[] v) {
        v[0] = this.R[0][0] * u[0] + this.R[0][1] * u[1] + this.R[0][2] * u[2];
        v[1] = this.R[1][0] * u[0] + this.R[1][1] * u[1];
        v[2] = this.R[2][0] * u[0] + this.R[2][1] * u[1] + this.R[2][2] * u[2];
    }

    private final void rot2fixed(double[] v, double[] u) {
        u[0] = this.R[0][0] * v[0] + this.R[1][0] * v[1] + this.R[2][0] * v[2];
        u[1] = this.R[0][1] * v[0] + this.R[1][1] * v[1] + this.R[2][1] * v[2];
        u[2] = this.R[0][2] * v[0] + this.R[2][2] * v[2];
    }

    private final void rot3(double[][] R, double[] v) {
        double x = v[0];
        double y = v[1];
        double z = v[2];
        for (int i = 0; i < 3; ++i) {
            v[i] = R[i][0] * x + R[i][1] * y + R[i][2] * z;
        }
    }

    private static final void rotate_cov(double[][] R, double[][] cov) {
        int l;
        int k;
        double t;
        int j;
        int i;
        if (cov == null) {
            return;
        }
        double[][] t3 = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                t3[i][j] = cov[i][j];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                t = 0.0;
                for (k = 0; k < 3; ++k) {
                    for (l = 0; l < 3; ++l) {
                        t += R[i][k] * R[j][l] * t3[k][l];
                    }
                }
                cov[i][j] = t;
            }
        }
        if (cov[0].length == 3) {
            return;
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                t3[i][j] = cov[i + 3][j + 3];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                t = 0.0;
                for (k = 0; k < 3; ++k) {
                    for (l = 0; l < 3; ++l) {
                        t += R[i][k] * R[j][l] * t3[k][l];
                    }
                }
                cov[i + 3][j + 3] = t;
            }
        }
        k = 0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                t3[i][j] = cov[i][j + 3];
                if (t3[i][j] == 0.0) continue;
                ++k;
            }
        }
        if (k != 0) {
            for (i = 0; i < 3; ++i) {
                for (j = 0; j < 3; ++j) {
                    t = 0.0;
                    for (k = 0; k < 3; ++k) {
                        for (l = 0; l < 3; ++l) {
                            t += R[i][k] * R[j][l] * t3[k][l];
                        }
                    }
                    double d = t;
                    cov[i + 3][j] = d;
                    cov[i][j + 3] = d;
                }
            }
        }
    }

    private final double getVar(int i1, int i2) {
        if (this.cov == null || this.R == null) {
            return Double.NaN;
        }
        int o1 = 3 * (i1 / 3);
        int o2 = 3 * (i2 / 3);
        int k1 = i1 % 3;
        int k2 = i2 % 3;
        double t = 0.0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                t += this.R[k1][i] * this.R[k2][j] * this.cov[o1 + i][o2 + j];
            }
        }
        return t;
    }

    private static final void propagate_error(double[][] var, double t) {
        int i;
        int j;
        for (j = 0; j < 3; ++j) {
            for (i = 0; i < 6; ++i) {
                double[] dArray = var[i];
                int n = j;
                dArray[n] = dArray[n] + t * var[i][j + 3];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 6; ++j) {
                double[] dArray = var[i];
                int n = j;
                dArray[n] = dArray[n] + t * var[i + 3][j];
            }
        }
    }

    private static final void rot6(double[][] R, double[] u, double[] v) {
        for (int i = 0; i < 3; ++i) {
            v[i] = R[i][0] * u[0] + R[i][1] * u[1] + R[i][2] * u[2];
            v[i + 3] = R[i][0] * u[3] + R[i][1] * u[4] + R[i][2] * u[5];
        }
    }

    @Override
    public double normalize() {
        double norm = this.x * this.x + this.y * this.y + this.z * this.z;
        if (norm <= 0.0) {
            return norm;
        }
        if (norm == 1.0) {
            return norm;
        }
        if (this.cov != null) {
            for (int i = 0; i < 6; ++i) {
                int j = 0;
                while (j < 6) {
                    double[] dArray = this.cov[i];
                    int n = j++;
                    dArray[n] = dArray[n] / norm;
                }
            }
        }
        norm = Math.sqrt(norm);
        this.x /= norm;
        this.y /= norm;
        this.z /= norm;
        this.xd /= norm;
        this.yd /= norm;
        this.zd /= norm;
        this.plx /= norm;
        this.e_plx /= norm;
        if (this.R != null) {
            double[] dArray = this.R[0];
            dArray[0] = dArray[0] / norm;
            double[] dArray2 = this.R[0];
            dArray2[1] = dArray2[1] / norm;
            double[] dArray3 = this.R[0];
            dArray3[2] = dArray3[2] / norm;
            double[] dArray4 = this.R[2];
            dArray4[0] = dArray4[0] / norm;
            double[] dArray5 = this.R[2];
            dArray5[1] = dArray5[1] / norm;
            double[] dArray6 = this.R[2];
            dArray6[2] = dArray6[2] / norm;
        }
        return norm;
    }

    @Override
    public final void rotate(double[][] R) {
        double[] v = new double[3];
        super.rotate(R);
        v[0] = this.xd;
        v[1] = this.yd;
        v[2] = this.zd;
        this.xd = R[0][0] * v[0] + R[0][1] * v[1] + R[0][2] * v[2];
        this.yd = R[1][0] * v[0] + R[1][1] * v[1] + R[1][2] * v[2];
        this.zd = R[2][0] * v[0] + R[2][1] * v[1] + R[2][2] * v[2];
        if (this.cov != null) {
            Astropos.rotate_cov(R, this.cov);
        }
    }

    public static final void varianceToErrorEllipse(double[] var, double[] ee3) {
        double t = (var[0] - var[1]) / 2.0;
        double delta = Math.sqrt(t * t + var[2] * var[2]);
        t = (var[0] + var[1]) / 2.0;
        double a2 = t + delta;
        double b2 = t - delta;
        ee3[0] = Math.sqrt(a2);
        ee3[1] = Math.sqrt(b2);
        ee3[2] = var[0] == var[1] ? 90.0 : (var[2] == 0.0 ? (var[0] <= var[1] ? 0.0 : 90.0) : AstroMath.atand((a2 - var[1]) / var[2]));
        if (ee3[2] < 0.0) {
            ee3[2] = ee3[2] + 180.0;
        }
    }

    public static final void errorEllipseToVariance(double[] ee3, double[] var) {
        double a2 = ee3[0] * ee3[0];
        double b2 = ee3[1] * ee3[1];
        double ct = AstroMath.cosd(ee3[2]);
        double st = AstroMath.sind(ee3[2]);
        var[0] = a2 * st * st + b2 * ct * ct;
        var[1] = a2 * ct * ct + b2 * st * st;
        var[2] = ct * st * (a2 - b2);
    }

    public static boolean parseErrorEllipse(Parsing txt, double[] ee3) {
        int posini = txt.pos;
        ee3[1] = Double.NaN;
        ee3[0] = Double.NaN;
        ee3[2] = 90.0;
        txt.gobbleSpaces();
        int n = txt.parseArray(ee3);
        if (n == 0) {
            return false;
        }
        if (Double.isNaN(ee3[2])) {
            ee3[2] = 90.0;
        }
        if (Double.isNaN(ee3[1])) {
            ee3[1] = ee3[0];
        }
        return true;
    }

    private final void pru6(String title) {
        double[] u = new double[3];
        String tit2 = "                                           ";
        u[0] = this.x;
        u[1] = this.y;
        u[2] = this.z;
        System.out.println(Coo.toString(title, u));
        u[0] = this.xd;
        u[1] = this.yd;
        u[2] = this.zd;
        System.out.println(Coo.toString(tit2.substring(0, title.length()), u));
    }

    private static final void pr_cov(String title, double[][] cov) {
        StringBuffer b = new StringBuffer(256);
        int len0 = title.length();
        b.append(title);
        for (int i = 0; i < 6; ++i) {
            int j;
            for (j = 0; j < 6; ++j) {
                ed.editDouble(b, cov[i][j], 4, 3, 0);
                b.append(' ');
            }
            System.out.println(b.toString());
            b.setLength(len0);
            if (i != 0) continue;
            b.setLength(0);
            for (j = 0; j < len0; ++j) {
                b.append(' ');
            }
        }
    }

    private final void compute() {
        int j;
        int i;
        double[] u6 = null;
        double[] v = new double[3];
        if (this.ready) {
            return;
        }
        if (DEBUG) {
            this.dump("<<compute: ");
        }
        if (((this.specified | this.permanent) & 0x80) == 0) {
            this.epoch = this.frame.epoch;
        }
        if (((this.specified | this.permanent) & 8) == 0) {
            this.epocho = this.epoch;
        }
        if (((this.specified | this.permanent) & 1) == 0) {
            this.plx = 0.0;
            this.e_plx = 0.0;
        }
        if (Double.isNaN(this.e_plx)) {
            this.e_plx = this.plx;
            if (this.e_plx < 5.0) {
                this.e_plx = 5.0;
            }
        }
        if (((this.specified | this.permanent) & 2) == 0) {
            this.rv = 0.0;
            this.e_rv = 0.0;
        }
        if (Double.isNaN(this.e_rv)) {
            this.e_rv = Math.abs(this.rv) / 2.0;
            if (this.e_rv > 300.0) {
                this.e_rv = 300.0;
            }
            if (this.e_rv < 10.0) {
                this.e_rv = 10.0;
            }
        }
        if (((this.specified | this.permanent) & 4) == 0) {
            if (this.frame instanceof FK4) {
                if (u6 == null) {
                    u6 = new double[6];
                }
                u6[0] = this.x;
                u6[1] = this.y;
                u6[2] = this.z;
                FK4.estimateFK4motion(u6);
                this.xd = u6[3];
                this.yd = u6[4];
                this.zd = u6[5];
            } else {
                this.zd = 0.0;
                this.yd = 0.0;
                this.xd = 0.0;
            }
            if (this.cov != null) {
                for (i = 3; i < 6; ++i) {
                    for (j = 3; j < 6; ++j) {
                        this.cov[i][j] = 0.0;
                    }
                }
            }
        }
        double mu2 = this.xd * this.xd + this.yd * this.yd + this.zd * this.zd;
        if (((this.specified | this.permanent) & 3) == 3) {
            double mu0 = this.plx * this.rv / 4.740470446 / 2.0626480624709636E8;
            if (this.cov != null) {
                this.cov[3][3] = this.e_plx * this.e_rv / 4.740470446;
            }
            if (mu0 * mu0 >= 0.5 * mu2) {
                mu0 = 0.0;
                if (this.cov != null) {
                    double[] dArray = this.cov[3];
                    dArray[3] = dArray[3] + mu0 * mu0;
                }
            } else {
                this.xd += this.x * mu0;
                this.yd += this.y * mu0;
                this.zd += this.z * mu0;
            }
        }
        if (DEBUG) {
            this.pru6("   u+du(1) ");
        }
        if ((this.specified & 0x50) == 0 && this.dlon > 0 && this.dlat > 0 && (this.permanent & 0x10) == 0) {
            i = this.dlon;
            if (i >= def_err.length) {
                i = def_err.length - 1;
            }
            if ((j = (int)this.dlat) >= def_err.length) {
                j = def_err.length - 1;
            }
            this.setErrorEllipse(def_err[i], def_err[j], 90.0, Double.NaN);
            this.specified = (byte)(this.specified ^ 0x50);
        }
        if ((this.specified & 0x20) == 0) {
            // empty if block
        }
        if (this.epoch != this.epocho) {
            if (DEBUG) {
                Astropos.pr_cov("   cov6(0) ", this.cov);
            }
            Astropos.propagate_error(this.cov, this.epoch - this.epocho);
            if (DEBUG) {
                Astropos.pr_cov("   cov6(t) ", this.cov);
            }
        }
        if (this.R != null) {
            Astropos.tr3(this.R);
            Astropos.rotate_cov(this.R, this.cov);
            Astropos.tr3(this.R);
        }
        if (DEBUG) {
            this.dump(" >compute: ");
        }
        this.ready = true;
    }

    public Astropos() {
        super(new ICRS());
        this.cov = null;
        this.permanent = 0;
        this.epocho = Double.NaN;
        this.reset();
    }

    public Astropos(Astroframe frame) {
        super(frame);
        this.cov = null;
        this.permanent = 0;
        this.epocho = Double.NaN;
        this.reset();
    }

    public Astropos(Astroframe frame, double lon, double lat) {
        super(frame);
        this.cov = null;
        this.permanent = 0;
        this.epocho = Double.NaN;
        this.reset();
        this.set(lon, lat);
    }

    public Astropos(Astroframe frame, double lon, double lat, double epoch, double mu1, double mu2) {
        super(frame);
        this.set(lon, lat, epoch, null, mu1, mu2, epoch, null, null, null);
    }

    public Astropos(Astrocoo coo) {
        this.set(coo);
    }

    public Astropos(Astroframe frame, String text) throws ParseException {
        super(frame);
        this.epocho = Double.NaN;
        this.set(text);
    }

    public Astropos(String text) throws ParseException {
        Parsing txt = new Parsing(text);
        char c = txt.currentChar();
        if (Astroframe.isIAU(c) && text.indexOf(32) < 0 && text.indexOf(58) < 0) {
            this.frame = null;
            if (super.parseIAU(txt)) {
                txt.gobbleSpaces();
                if (txt.pos >= txt.length) {
                    return;
                }
            }
            this.frame = null;
        }
        this.frame = Astroframe.parse(txt);
        if (this.frame == null) {
            throw new ParseException("****Astropos: argument '" + text + "' (no frame)", txt.pos);
        }
        this.epocho = Double.NaN;
        this.set(txt.toString());
    }

    @Override
    public Object clone() {
        Astropos c = (Astropos)super.clone();
        return c;
    }

    public Astropos(Astroframe frame, double lon, double lat, double epoch, double[] eepos, double mu1, double mu2, double epocho, double[] eepm, double[] plx2, double[] rv2) {
        super(frame);
        this.set(lon, lat, epoch, eepos, mu1, mu2, epocho, eepm, plx2, rv2);
    }

    @Override
    public void dump(String title) {
        int len0;
        StringBuffer b = new StringBuffer(256);
        int i = len0 = title.length();
        while (--i >= 0) {
            b.append(' ');
        }
        String blanks = b.toString();
        b.setLength(0);
        super.dump(title);
        b.setLength(0);
        b.append(blanks);
        ed.editDecimal(b, this.xd, 2, 15, 16);
        b.append(' ');
        ed.editDecimal(b, this.yd, 2, 15, 16);
        b.append(' ');
        ed.editDecimal(b, this.zd, 2, 15, 16);
        b.append(' ');
        b.append("(dot)");
        if ((this.specified & 4) == 0) {
            b.append("::");
        }
        System.out.println(b.toString());
        b.setLength(len0);
        System.out.println(Coo.toString(b.toString(), this.R));
        b.setLength(len0);
        b.append("    Epoch=J");
        b.append(this.epoch);
        i = len0 + 20;
        while (b.length() < i) {
            b.append(" ");
        }
        b.append("specified=0x");
        b.append(Integer.toHexString(this.specified & 0xFF));
        b.append('(');
        ed.editFlags(b, this.specified, partnames);
        b.append(')');
        System.out.println(b);
        b.setLength(len0);
        b.append("MeanEpoch=J");
        b.append(this.epocho);
        i = len0 + 20;
        while (b.length() < i) {
            b.append(" ");
        }
        b.append("permanent=0x");
        b.append(Integer.toHexString(this.permanent & 0xFF));
        b.append('(');
        ed.editFlags(b, this.permanent, partnames);
        b.append(')');
        System.out.println(b);
        b.setLength(len0);
        b.append("pm(mas/yr) ");
        ed.editDecimal(b, this.getProperMotionLon(), 6, 5, 16);
        b.append(" ");
        ed.editDecimal(b, this.getProperMotionLat(), 6, 5, 16);
        b.append(" ");
        ed.editDecimal(b, this.plx, 4, 5, 0);
        b.append("mas");
        ed.editDecimal(b, this.rv, 6, 5, 16);
        b.append("km/s");
        System.out.println(b.toString());
        b.setLength(len0);
        b.append("----6x6 Covariance Matrix ");
        if (this.cov == null) {
            b.append("(NULL) [");
            if (!this.ready) {
                b.append("NOT ");
            }
            b.append("ready]");
            System.out.println(b.toString());
        } else {
            b.append("(mas , yr) [");
            if (!this.ready) {
                b.append("NOT ");
            }
            b.append("ready]");
            System.out.println(b.toString());
            b.setLength(len0);
            Astropos.pr_cov(b.toString(), this.cov);
        }
    }

    private static final double[] dup(double[] v) {
        double[] w = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            w[i] = v[i];
        }
        return w;
    }

    @Override
    public boolean parsing(Parsing txt) {
        double mu2;
        double mu1;
        double val;
        double[] v3 = new double[3];
        double[] v2 = new double[2];
        double[] eepos = null;
        double[] eepm = null;
        double[] plx = null;
        double[] rv = null;
        int posini = txt.pos;
        if (DEBUG) {
            System.out.println("....Parsing(0): " + txt);
        }
        this.reset();
        if (!super.parsing(txt)) {
            return false;
        }
        this.ready = false;
        double epo = this.epocho;
        double ep = this.epoch;
        if (DEBUG) {
            System.out.println("....astrocoo => " + super.toString());
        }
        if (DEBUG) {
            System.out.println("....Parsing(1): " + txt);
        }
        txt.gobbleSpaces();
        boolean bracketed = txt.match("[");
        if (bracketed) {
            txt.gobbleSpaces();
            if (Astropos.parseErrorEllipse(txt, v3)) {
                eepos = Astropos.dup(v3);
                txt.gobbleSpaces();
                val = Astropos.getEpoch(txt);
                if (!Double.isNaN(val)) {
                    epo = val;
                }
            }
            txt.gobbleSpaces();
            if (!txt.match("]")) {
                txt.set(posini);
                return false;
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(2): " + txt);
        }
        if (DEBUG) {
            System.out.println("           epo= " + epo);
        }
        txt.gobbleSpaces();
        val = Astropos.getEpoch(txt);
        if (!Double.isNaN(val)) {
            if (Double.isNaN(ep)) {
                ep = val;
            } else {
                epo = val;
            }
        }
        txt.gobbleSpaces();
        if (Double.isNaN(epo) && txt.currentChar() == '[') {
            posini = txt.pos;
            txt.match('[');
            val = Astropos.getEpoch(txt);
            if (Double.isNaN(val)) {
                txt.set(posini);
            } else if (txt.match(']')) {
                epo = val;
            } else {
                txt.set(posini);
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(3): " + txt);
        }
        if (DEBUG) {
            System.out.println("           epo= " + epo);
        }
        int pos = txt.pos;
        txt.gobbleSpaces();
        int n = txt.parseArray(v2);
        if (n == 2) {
            mu1 = v2[0];
            mu2 = v2[1];
        } else {
            mu2 = Double.NaN;
            mu1 = Double.NaN;
            txt.set(pos);
        }
        if (DEBUG) {
            System.out.println("....Parsing(4): " + txt);
        }
        if (Double.isNaN(epo) && txt.pos < txt.length) {
            epo = Astropos.getEpoch(txt);
        }
        if (DEBUG) {
            System.out.println("           epo= " + epo);
        }
        pos = txt.pos;
        txt.gobbleSpaces();
        bracketed = txt.match("[");
        if (bracketed) {
            txt.gobbleSpaces();
            if (Astropos.parseErrorEllipse(txt, v3)) {
                eepm = Astropos.dup(v3);
            }
            if (!txt.match("]")) {
                txt.set(posini);
                return false;
            }
        }
        if (Double.isNaN(epo) && txt.pos < txt.length) {
            epo = Astropos.getEpoch(txt);
        }
        if (DEBUG) {
            System.out.println("....Parsing(5): " + txt);
        }
        if (DEBUG) {
            System.out.println("           epo= " + epo);
        }
        if ((n = txt.parseWithError(v2)) > 0) {
            txt.gobbleSpaces();
            if (txt.match("km/s")) {
                plx = rv;
                rv = Astropos.dup(v2);
            } else {
                plx = Astropos.dup(v2);
                txt.match("mas");
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(p): " + txt);
        }
        if (DEBUG) {
            System.out.println("           epo= " + epo);
        }
        if ((n = txt.parseWithError(v2)) > 0) {
            txt.gobbleSpaces();
            if (txt.match("mas")) {
                plx = Astropos.dup(v2);
            } else {
                rv = Astropos.dup(v2);
                txt.match("km/s");
            }
        }
        if (DEBUG) {
            System.out.println("....Parsing(V): " + txt);
        }
        if (DEBUG) {
            System.out.println("           epo= " + epo);
        }
        this.set(this.lon, this.lat, ep, eepos, mu1, mu2, epo, eepm, plx, rv);
        return true;
    }

    @Override
    public int parse(String txt, int offset) {
        Parsing t = new Parsing(txt, offset);
        if (this.parsing(t)) {
            return t.pos;
        }
        return offset;
    }

    private final void reset() {
        this.specified = 0;
        this.zd = 0.0;
        this.yd = 0.0;
        this.xd = 0.0;
        this.ready = false;
    }

    @Override
    public void set() {
        super.set();
        this.reset();
    }

    @Override
    public void set(Coo coo) {
        this.reset();
        super.set(coo);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    @Override
    public void set(Astrocoo coo) {
        this.reset();
        super.set(coo);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    @Override
    public void set(Coo coo, double epoch) {
        this.reset();
        super.set(coo, epoch);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    @Override
    public void set(double lon, double lat) {
        this.reset();
        super.set(lon, lat);
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    @Override
    public void set(double lon, double lat, double epoch) {
        this.set(lon, lat);
        if (Double.isNaN(epoch)) {
            return;
        }
        this.specified = (byte)(this.specified | 0x80);
        this.epoch = epoch;
    }

    public void set(double lon, double lat, double epoch, double mu1, double mu2) {
        this.set(lon, lat, epoch);
        if (!Double.isNaN(mu1) && !Double.isNaN(mu2)) {
            this.setProperMotion(mu1, mu2);
        }
        if (this.R == null) {
            this.R = super.localMatrix();
        } else {
            super.localMatrix(this.R);
        }
        this.ready = false;
    }

    public void set(double lon, double lat, double epoch, double[] eepos, double mu1, double mu2, double epocho, double[] eepm, double[] plx2, double[] rv2) {
        this.set(lon, lat, epoch, mu1, mu2);
        this.setProperMotion(mu1, mu2);
        if (eepos != null) {
            this.setErrorEllipse(eepos[0], eepos[1], eepos[2], epocho);
        }
        if (eepm != null) {
            this.setErrorProperMotion(eepm[0], eepm[1], eepm[2]);
        }
        if (plx2 != null) {
            this.setParallax(plx2[0], plx2[1]);
        }
        if (rv2 != null) {
            this.setRadialVelocity(rv2[0], rv2[1]);
        }
    }

    @Override
    public void set(String text) throws ParseException {
        Parsing t = new Parsing(text);
        this.reset();
        if (this.parsing(t)) {
            t.gobbleSpaces();
        }
        if (t.pos != t.length) {
            throw new ParseException("****Astropos: argument '" + text + "'+" + t.pos, t.pos);
        }
    }

    public void set(String text, boolean equatorial) throws ParseException {
        this.set(text);
    }

    public void setFrameEpoch() {
        if (!Double.isNaN(this.epoch)) {
            this.frame.setFrameEpoch(this.epoch);
        }
    }

    public void setDefaultMeanEpoch(double epocho) {
        this.epocho = epocho;
        this.permanent = Double.isNaN(epocho) ? (byte)(this.permanent & 0xFFFFFFF7) : (byte)(this.permanent | 8);
    }

    @Override
    public boolean setEpoch(double epoch) {
        if (this.ready) {
            return false;
        }
        this.specified = Double.isNaN(epoch) ? (byte)(this.specified & 0xFFFFFF7F) : (byte)(this.specified | 0x80);
        this.epoch = epoch;
        return true;
    }

    public boolean setErrorEllipse(double e_maj, double e_min, double pa) {
        return this.setErrorEllipse(e_maj, e_min, pa, Double.NaN);
    }

    public boolean setErrorEllipse(double e_maj, double e_min, double pa, double epocho) {
        double[] ell = new double[3];
        double[] var = new double[3];
        if (this.ready) {
            return false;
        }
        if (!Double.isNaN(epocho)) {
            this.epocho = epocho;
            this.specified = (byte)(this.specified | 8);
        }
        ell[0] = e_maj;
        ell[1] = e_min;
        ell[2] = pa;
        Astropos.errorEllipseToVariance(ell, var);
        if (this.cov == null) {
            this.cov = new double[6][6];
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = i; j < 6; ++j) {
                this.cov[j][i] = 0.0;
                this.cov[i][j] = 0.0;
            }
        }
        this.cov[1][1] = var[0];
        this.cov[2][2] = var[1];
        double d = var[2];
        this.cov[1][2] = d;
        this.cov[2][1] = d;
        this.specified = (byte)(this.specified | 0x10);
        return true;
    }

    public boolean setProperMotion(double mu1, double mu2) {
        if (this.ready) {
            return false;
        }
        if (Double.isNaN(mu1) || Double.isNaN(mu2)) {
            this.specified = (byte)(this.specified & 0xFFFFFFFB);
            return true;
        }
        double[] v = new double[3];
        double[] d = new double[3];
        v[0] = 0.0;
        v[1] = mu1 / 2.0626480624709636E8;
        v[2] = mu2 / 2.0626480624709636E8;
        this.rot2fixed(v, d);
        this.xd = d[0];
        this.yd = d[1];
        this.zd = d[2];
        this.specified = (byte)(this.specified | 4);
        return true;
    }

    public boolean setErrorProperMotion(double e_mu1, double e_mu2) {
        return this.setErrorProperMotion(e_mu1, e_mu2, 90.0);
    }

    public boolean setErrorProperMotion(double e_maj, double e_min, double pa) {
        if (this.ready) {
            return false;
        }
        double[] ell = new double[3];
        double[] var = new double[3];
        ell[0] = e_maj;
        ell[1] = e_min;
        ell[2] = pa;
        Astropos.errorEllipseToVariance(ell, var);
        if (this.cov == null) {
            this.cov = new double[6][6];
        }
        this.cov[4][4] = var[0];
        this.cov[5][5] = var[1];
        double d = var[2];
        this.cov[4][5] = d;
        this.cov[5][4] = d;
        this.specified = (byte)(this.specified | 0x20);
        return true;
    }

    public boolean setRadialVelocity(double rv, double err) {
        if (this.ready) {
            return false;
        }
        if (Double.isNaN(rv)) {
            return false;
        }
        this.rv = rv;
        this.e_rv = err;
        this.specified = (byte)(this.specified | 2);
        return true;
    }

    public boolean setParallax(double plx, double err) {
        if (this.ready) {
            return false;
        }
        if (Double.isNaN(plx)) {
            return false;
        }
        this.plx = plx;
        this.e_plx = err;
        this.specified = (byte)(this.specified | 1);
        return true;
    }

    public boolean copyErrorEllipse(double[] ee3) {
        double[] var = new double[3];
        if (!this.ready) {
            this.compute();
        }
        var[0] = this.getVar(1, 1);
        var[1] = this.getVar(2, 2);
        var[2] = this.getVar(1, 2);
        Astropos.varianceToErrorEllipse(var, ee3);
        return (this.specified & 0x10) != 0;
    }

    public double sigmaLon() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(1, 1));
    }

    public double sigmaLat() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(2, 2));
    }

    public boolean copyProperMotion(double[] pm) {
        if (this.R == null) {
            pm[1] = Double.NaN;
            pm[0] = Double.NaN;
        } else {
            pm[0] = (this.R[1][0] * this.xd + this.R[1][1] * this.yd) * 180.0 * 3600000.0 / Math.PI;
            pm[1] = (this.R[2][0] * this.xd + this.R[2][1] * this.yd + this.R[2][2] * this.zd) * 180.0 * 3600000.0 / Math.PI;
        }
        return (this.specified & 4) != 0;
    }

    public double getProperMotionLon() {
        if (this.R == null) {
            return 0.0;
        }
        return (this.R[1][0] * this.xd + this.R[1][1] * this.yd) * 180.0 * 3600000.0 / Math.PI;
    }

    public double getProperMotionLat() {
        if (this.R == null) {
            return 0.0;
        }
        return (this.R[2][0] * this.xd + this.R[2][1] * this.yd + this.R[2][2] * this.zd) * 180.0 * 3600000.0 / Math.PI;
    }

    public boolean copyProperMotionErrorEllipse(double[] ee3) {
        double[] var = new double[3];
        if (!this.ready) {
            this.compute();
        }
        var[0] = this.getVar(4, 4);
        var[1] = this.getVar(5, 5);
        var[2] = this.getVar(4, 5);
        Astropos.varianceToErrorEllipse(var, ee3);
        return (this.specified & 0x20) != 0;
    }

    public double sigmaProperMotionLon() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(4, 4));
    }

    public double sigmaProperMotionLat() {
        if (!this.ready) {
            this.compute();
        }
        return Math.sqrt(this.getVar(5, 5));
    }

    public boolean copyParallax(double[] valerr) {
        if (!this.ready) {
            this.compute();
        }
        valerr[0] = this.plx;
        valerr[1] = this.e_plx;
        return (this.specified & 1) != 0;
    }

    public boolean copyVelocity(double[] valerr) {
        if (!this.ready) {
            this.compute();
        }
        valerr[0] = this.rv;
        valerr[1] = this.e_rv;
        return (this.specified & 2) != 0;
    }

    @Override
    public boolean equals(Object o) {
        boolean res = false;
        if (!(o instanceof Astropos)) {
            return res;
        }
        Astropos a = (Astropos)o;
        if (!super.equals((Coo)o)) {
            return res;
        }
        res = this.xd == a.xd && this.yd == a.yd && this.zd == a.zd && this.epocho == a.epocho;
        return res;
    }

    @Override
    public int hashCode() {
        int hcode = super.hashCode();
        long l = Double.doubleToLongBits(this.xd);
        hcode = hcode * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.yd);
        hcode = hcode * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.zd);
        hcode = hcode * 123 + (int)(l ^ l >>> 32);
        l = Double.doubleToLongBits(this.epocho);
        hcode = hcode * 123 + (int)(l ^ l >>> 32);
        return hcode;
    }

    private final StringBuffer ed1(StringBuffer buf, int opt) {
        super.edit(buf, opt);
        return buf;
    }

    @Override
    public String toString() {
        return this.toString(this.editing);
    }

    @Override
    public String toString(int opt) {
        int nd;
        int o;
        double[] ee3 = new double[3];
        double[] pm = new double[2];
        StringBuffer buf = new StringBuffer(200);
        int n = o = (this.precision & 0x80) != 0 ? 3 : 0;
        if (!this.ready) {
            this.compute();
        }
        if (!this.ready) {
            this.compute();
        }
        super.edit(buf, o | opt);
        boolean isactual = this.copyErrorEllipse(ee3);
        if (isactual) {
            nd = this.precision - 6;
            if (nd <= 0) {
                nd = -1;
            }
            buf.append(" [");
            ed.editDecimal(buf, ee3[0], 0, nd, 0);
            if (isactual) {
                buf.append(' ');
            } else {
                buf.append(": ");
            }
            ed.editDecimal(buf, ee3[1], 0, nd, 0);
            buf.append(' ');
            if (isactual) {
                buf.append(' ');
            } else {
                buf.append(": ");
            }
            ed.editDecimal(buf, ee3[2], 0, -2, 0);
            if ((this.specified & 8) != 0 || (this.editing & 0x800) != 0) {
                buf.append(" (");
                this.editEpoch(buf, this.epocho);
                buf.append(")");
            }
            buf.append(']');
        }
        if (isactual = this.copyProperMotion(pm)) {
            buf.append(" ");
            ed.editDecimal(buf, pm[0], 0, -6, 16);
            buf.append(" ");
            ed.editDecimal(buf, pm[1], 0, -6, 16);
            isactual = this.copyProperMotionErrorEllipse(ee3);
            if (isactual) {
                nd = -2;
                buf.append(" [");
                ed.editDecimal(buf, ee3[0], 0, nd, 0);
                if (isactual) {
                    buf.append(' ');
                } else {
                    buf.append(": ");
                }
                ed.editDecimal(buf, ee3[1], 0, nd, 0);
                buf.append(' ');
                if (isactual) {
                    buf.append(' ');
                } else {
                    buf.append(": ");
                }
                ed.editDecimal(buf, ee3[2], 0, -2, 0);
                buf.append(']');
            }
        }
        if ((this.specified & 2) != 0) {
            buf.append(" ");
            ed.editDecimal(buf, this.rv, 0, -6, 16);
            buf.append('[');
            ed.editDecimal(buf, this.e_rv, 0, -6, 0);
            buf.append("]km/s");
        }
        if ((this.specified & 1) != 0) {
            buf.append(" ");
            ed.editDecimal(buf, this.plx, 0, -6, 0);
            buf.append('[');
            ed.editDecimal(buf, this.e_plx, 0, -6, 0);
            buf.append("]");
        }
        return buf.toString();
    }

    public void toEpoch(double Jyr) {
        double t = Jyr - this.epoch;
        if (DEBUG) {
            System.out.println("....toEpoch(" + this.epoch + ") => " + Jyr);
        }
        if (t == 0.0) {
            return;
        }
        if (!this.ready) {
            this.compute();
        }
        this.x += t * this.xd;
        this.y += t * this.yd;
        this.z += t * this.zd;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        if (this.cov != null) {
            Astropos.propagate_error(this.cov, t);
        }
        this.epoch = Jyr;
        this.normalize();
    }

    @Override
    public void convertTo(Astroframe new_frame) {
        double t;
        double inflation = 1.0;
        double[][] Rmov = null;
        double[] u = null;
        if (!this.ready) {
            this.compute();
        }
        double new_epoch = new_frame.epoch;
        if (DEBUG) {
            System.out.println("....Astropos convert from " + this.getFrame() + ",Ep=" + this.epoch + " to " + new_frame + ",Ep=" + new_epoch);
        }
        if (this.frame.equals(new_frame)) {
            if (DEBUG) {
                System.out.println("....(identical frames)");
            }
            if (new_epoch != this.epoch) {
                this.toEpoch(new_epoch);
            }
            return;
        }
        if (DEBUG) {
            System.out.println("....Astropos.convert via ICRS:  " + this.frame + " => ICRS => " + new_frame);
        }
        u = new double[]{this.x, this.y, this.z, this.xd, this.yd, this.zd};
        if (DEBUG) {
            System.out.println(Coo.toString(".... convert(1): ", u));
        }
        if ((t = this.frame.base_epoch - this.epoch) != 0.0) {
            if (DEBUG) {
                System.out.println("     Change epoch: " + this.epoch + " to " + this.frame.base_epoch + " on " + this.frame);
            }
            u[0] = u[0] + u[3] * t;
            u[1] = u[1] + u[4] * t;
            u[2] = u[2] + u[5] * t;
            inflation *= Coo.normalize(u);
            if (DEBUG) {
                System.out.println(Coo.toString(".... base_ep(2): ", u));
            }
        }
        this.frame.toICRS(u);
        if (DEBUG) {
            System.out.println(Coo.toString(".... in.ICRS(3): ", u));
        }
        new_frame.fromICRS(u);
        if (DEBUG) {
            System.out.println(Coo.toString(".... baseNew(4): ", u));
        }
        if ((t = new_epoch - new_frame.base_epoch) != 0.0) {
            if (DEBUG) {
                System.out.println("     Change epoch: " + new_frame.base_epoch + " to " + new_epoch + " on " + new_frame);
            }
            u[0] = u[0] + u[3] * t;
            u[1] = u[1] + u[4] * t;
            u[2] = u[2] + u[5] * t;
            inflation *= Coo.normalize(u);
            if (DEBUG) {
                System.out.println(Coo.toString(".... finalEp(5): ", u));
            }
        }
        if (this.cov != null) {
            Coo tcoo = new Coo(u[0], u[1], u[2]);
            Astropos.propagate_error(this.cov, new_epoch - this.epoch);
            Rmov = this.moveMatrix(tcoo);
        }
        if (DEBUG) {
            System.out.println(Coo.toString(".... convEnd(6): ", u));
        }
        this.lat = Double.NaN;
        this.lon = Double.NaN;
        this.x = u[0];
        this.y = u[1];
        this.z = u[2];
        this.xd = u[3];
        this.yd = u[4];
        this.zd = u[5];
        this.epoch = new_epoch;
        this.frame = new_frame;
        inflation *= this.normalize();
        if (DEBUG) {
            System.out.println(".... Total inflation=" + inflation);
        }
        this.plx /= inflation;
        this.e_plx /= inflation;
        if (Rmov != null) {
            Astropos.rotate_cov(Rmov, this.cov);
        }
        this.localMatrix(this.R);
    }
}

