/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Ecliptic;
import cds.astro.Editing;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Parsing;
import cds.astro.Supergal;
import java.io.Serializable;

public abstract class Astroframe
implements Serializable {
    private static final boolean DEBUG = false;
    private static Editing edframe = new Editing("?frame?");
    public static String IAUframes = "JGBISE";
    public String name = "*undefined*";
    public double base_epoch = 2000.0;
    public double epoch = 2000.0;
    public double[][] ICRSmatrix = null;
    public boolean hms = false;
    public byte precision = (byte)8;
    public byte ed_lon = (byte)32;
    public byte ed_lat = (byte)48;

    public static Astroframe parse(Parsing txt) {
        Astrotime t;
        int posini = txt.pos;
        Astroframe frame = null;
        boolean has_par = false;
        boolean has_epoch = false;
        boolean is_ok = true;
        txt.gobbleSpaces();
        boolean bracketed = txt.match("(");
        char c = Character.toUpperCase(txt.currentChar());
        if (c == 'I') {
            is_ok = txt.match("ICRS");
            if (is_ok) {
                frame = new ICRS();
            }
        } else if (c == 'G') {
            while (Character.isLetter(txt.currentChar())) {
                txt.advance(1);
            }
            frame = new Galactic();
        } else if (c == 'S') {
            while (Character.isLetter(txt.currentChar())) {
                txt.advance(1);
            }
            frame = new Supergal();
        } else if (c == 'F') {
            if (txt.match("FK4")) {
                has_par = txt.match('(');
                frame = has_par ? new FK4(txt.parseDecimal()) : new FK4();
            } else if (txt.match("FK5")) {
                has_par = txt.match('(');
                frame = has_par ? new FK5(txt.parseDecimal()) : new FK5();
            } else {
                is_ok = false;
            }
        } else if (c == 'B') {
            txt.match('B');
            if (Character.isDigit(txt.currentChar())) {
                frame = new FK4(txt.parseDecimal());
            } else {
                is_ok = false;
            }
        } else if (c == 'J') {
            txt.match('J');
            if (Character.isDigit(txt.currentChar())) {
                frame = new FK5(txt.parseDecimal());
            } else {
                is_ok = false;
            }
        } else if (c == 'E') {
            while (Character.isLetter(txt.currentChar())) {
                txt.advance(1);
            }
            has_par = txt.match('(');
            frame = has_par ? ((t = new Astrotime()).parsing(txt) ? new Ecliptic(t.getJyr()) : new Ecliptic()) : (Character.isDigit(txt.currentChar()) ? new Ecliptic(txt.parseDecimal()) : new Ecliptic());
        } else {
            is_ok = false;
        }
        if (!is_ok) {
            txt.set(posini);
            return null;
        }
        posini = txt.pos;
        is_ok = true;
        txt.gobbleSpaces();
        if (has_par) {
            txt.match(',');
        } else {
            has_par = txt.match('(');
        }
        txt.gobbleSpaces();
        if (Character.toUpperCase(txt.currentChar()) == 'E') {
            txt.advance(1);
            if (Character.toLowerCase(txt.currentChar()) == 'p') {
                while (Character.isLetter(txt.currentChar())) {
                    txt.advance(1);
                }
                is_ok = txt.match('=');
                has_epoch = true;
            } else {
                is_ok = false;
            }
        } else if ((has_par || bracketed) && Character.isLetterOrDigit(txt.currentChar())) {
            has_epoch = true;
        }
        if (has_epoch && (is_ok = (t = new Astrotime()).parsing(txt))) {
            frame.setFrameEpoch(t.getJyr());
        }
        if (has_par && is_ok) {
            is_ok = txt.match(')');
        }
        if (bracketed && is_ok) {
            is_ok = txt.match(')');
        }
        if (is_ok) {
            txt.match(':');
        }
        if (!is_ok) {
            txt.set(posini);
        }
        return frame;
    }

    public static Astroframe create(String name) {
        Parsing text = new Parsing(name);
        Astroframe frame = Astroframe.parse(text);
        text.gobbleSpaces();
        if (text.pos < text.length) {
            System.err.println("#+++Astroframe(" + name + "): " + text);
            return null;
        }
        return frame;
    }

    public static final boolean isIAU(char sym) {
        return IAUframes.indexOf(Character.toUpperCase(sym)) >= 0;
    }

    public static Astroframe create(char sym) {
        switch (Character.toUpperCase(sym)) {
            case 'J': {
                return new FK5();
            }
            case 'G': {
                return new Galactic();
            }
            case 'B': {
                return new FK4();
            }
            case 'I': {
                return new ICRS();
            }
            case 'S': {
                return new Supergal();
            }
            case 'E': {
                return new Ecliptic();
            }
        }
        return null;
    }

    public boolean equals(char sym) {
        switch (Character.toUpperCase(sym)) {
            case 'I': 
            case 'J': {
                return this instanceof ICRS || this.name.equals("FK5(J2000.0)");
            }
            case 'G': {
                return this instanceof Galactic;
            }
            case 'B': {
                return this.name.equals("FK4(B1950.0)");
            }
            case 'S': {
                return this instanceof Supergal;
            }
            case 'E': {
                return this instanceof Ecliptic;
            }
        }
        return false;
    }

    public String toString() {
        if (this.base_epoch == this.epoch) {
            return this.name;
        }
        return this.toString(this.epoch);
    }

    public String toString(double epoch) {
        StringBuffer b = new StringBuffer(this.name);
        int i = this.name.length() - 1;
        if (b.charAt(i) == ')') {
            b.setLength(i);
            b.append(',');
        } else {
            b.append('(');
        }
        b.append("Ep=J");
        i = b.length();
        b.append(epoch);
        if (b.length() - i > 6) {
            b.setLength(i - 1);
            b.append('B');
            edframe.editDecimal(b, Astrotime.J2B(epoch), 4, -3, 0);
        }
        if (b.length() - i > 6) {
            b.setLength(i - 1);
            b.append('J');
            edframe.editDecimal(b, epoch, 4, -3, 0);
        }
        b.append(')');
        return b.toString();
    }

    public final void setICRSmatrix() {
        if (this.ICRSmatrix == null && this.toICRSmatrix() == null) {
            System.err.println("****Astroframe " + this + ": linkage to ICRS undefined!");
        }
    }

    public void setFrameEpoch(double epoch) {
        this.epoch = epoch;
    }

    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof Astroframe) {
            Astroframe a = (Astroframe)o;
            res = this.epoch == a.epoch && this.name.equals(a.name);
        }
        return res;
    }

    public int hashCode() {
        int hcode = this.name.hashCode();
        long l = Double.doubleToLongBits(this.epoch);
        hcode = hcode * 123 + (int)(l ^ l >>> 32);
        return hcode;
    }

    public abstract double[][] toICRSmatrix();

    public void toICRS(Coo coo) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        coo.rotate(this.ICRSmatrix);
    }

    public void fromICRS(Coo coo) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        coo.rotate_1(this.ICRSmatrix);
    }

    public void toICRS(double[] u6) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        Coo.rotateVector(this.ICRSmatrix, u6);
    }

    public void fromICRS(double[] u6) {
        if (this.ICRSmatrix == null) {
            this.setICRSmatrix();
        }
        Coo.rotateVector_1(this.ICRSmatrix, u6);
    }

    public double getEpoch() {
        return this.epoch;
    }
}

