/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

public class Astroformat {
    public String[] nulls;
    public static final int DECIMAL = 0;
    public static final int EFORMAT = 1;
    public static final int FACTOR = 10;
    public static final int SEXA2 = 2;
    public static final int SEXA3 = 3;
    public static final int SEXA2c = 4;
    public static final int SEXA3c = 5;
    public static final int SEXA2d = 6;
    public static final int SEXA3d = 7;
    public static final int SEXA2h = 8;
    public static final int SEXA3h = 9;
    public static final int SEXA1d = 11;
    public static final int SEXA1h = 12;
    public static final int SEXA1o = 13;
    public static final int SEXA2o = 14;
    public static final int SEXA3o = 15;
    public static final int DATE = 128;
    public static final int DATE_alpha = 129;
    public static final int DATE_YM = 128;
    public static final int DATE_MY = 130;
    public static final int DATE_YD = 132;
    public static final int DATE_DY = 134;
    public static final int DATE_YMD = 136;
    public static final int DATE_DMY = 138;
    public static final int DATE_MDY = 140;
    public static final int DATE_MYD = 142;
    public static final int DATE_DIFF = 133;
    public static final int SIGN_EDIT = 16;
    public static final int ZERO_FILL = 32;
    public static final int TRUNCATE = 64;
    public static final int DATE_COMP = 128;
    protected static final String pic1 = "YMDhmsymDdMS";
    protected static final String[] pic1_explain = new String[]{"Year", "Month", "Day", "hour", "minute", "second", "year", "month", "day", "degree", "Minute", "Second"};
    public static String[] month_list = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private static final byte[] properties = new byte[]{0, 0, 16, 16, 16, 16, 18, 18, 17, 17, 0, 2, 1, 2, 18, 18};
    private static final String[] explain_form = new String[]{"decimal", "E-format", "sexa(h,m)", "sexa(h,m,s)", "sexa(h:m)", "sexa(h:m:s)", "sexa_d_m", "sexa_d_m_s", "sexa_h_m", "sexa_h_m_s", "x10-format", "decimal_d", "decimal_h", "decimal_\u00b0", "sexa_\u00b0_'", "sexa_\u00b0_'_\""};
    private static final String[] explain_date = new String[]{"date(YM)", "date(Ymon)", "date(MY)", "date(monY)", "date(YD)", "#mjd-5#", "date(DY)", "#mjd-7#", "date(YMD)", "date(YmonD)", "date(DMY)", "date(DmonY)", "date(MDY)", "date(monDY)", "date(MYD)", "date(monYD)"};
    private static final String[] explain_pec = new String[]{"", ",signed", ",zero-filled", ",signed,zero-filled"};

    public static final String explain(int bin_form) {
        int k = bin_form & 0xFF;
        String s = (k & 0x80) != 0 ? explain_date[k & 0xF] : explain_form[k & 0xF];
        return s + explain_pec[k >> 4 & 3];
    }

    public static final boolean isSexa(int bin_form) {
        return (properties[bin_form & 0xF] & 0x10) != 0;
    }

    public static final boolean isDate(int bin_form) {
        return (bin_form & 0x80) != 0 && !Astroformat.isDays(bin_form);
    }

    public static final boolean isDays(int bin_form) {
        return (bin_form & 0x8F) == 133;
    }

    public static final boolean isTime(int bin_form) {
        return (properties[bin_form & 0xF] & 1) != 0;
    }

    public static final boolean isAngle(int bin_form) {
        return (properties[bin_form & 0xF] & 2) != 0;
    }

    public static final String explainComplex(String pic) {
        int len;
        char c;
        int k;
        StringBuffer buf = new StringBuffer(128);
        char[] typ6 = new char[6];
        char[] apic = pic.toCharArray();
        int epic = pic.length();
        int ipic = 0;
        typ6[5] = '\u0000';
        typ6[4] = '\u0000';
        typ6[3] = '\u0000';
        typ6[2] = '\u0000';
        typ6[1] = '\u0000';
        typ6[0] = '\u0000';
        while (ipic < epic) {
            if ((k = pic1.indexOf(c = apic[ipic++])) < 0) continue;
            len = 1;
            while (ipic < epic && apic[ipic] == c) {
                ++len;
                ++ipic;
            }
            typ6[k % 6] = Character.toLowerCase(c);
        }
        buf.append("Complex ");
        if (typ6[0] != '\u0000') {
            buf.append("date");
        } else if (typ6[2] != '\u0000' || typ6[3] == 'h') {
            buf.append("time");
        } else {
            buf.append("angle");
        }
        buf.append(" made of:");
        ipic = 0;
        while (ipic < epic) {
            if ((k = pic1.indexOf(c = apic[ipic++])) < 0 && c != 'f') continue;
            buf.append(' ');
            if (k < 0) {
                buf.append("and fraction");
            } else {
                buf.append(pic1_explain[k]);
            }
            len = 1;
            while (ipic < epic && apic[ipic] == c) {
                ++len;
                ++ipic;
            }
        }
        return buf.toString();
    }

    public Astroformat() {
        this.setNaN("---");
    }

    public Astroformat(String default_null) {
        this.setNaN(default_null);
    }

    public void setNaN(String default_null) {
        this.nulls = new String[2];
        this.nulls[0] = default_null;
        this.nulls[1] = null;
    }

    public void acceptAsNaN(String representation) {
        int i = this.nulls.length - 1;
        if (this.nulls[i] != null) {
            String[] array = new String[++i + 2];
            System.arraycopy(this.nulls, 0, array, 0, i);
            this.nulls = array;
            this.nulls[i + 1] = null;
        }
        this.nulls[i] = representation;
    }
}

