/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Astroformat;
import cds.astro.Astroframe;
import cds.astro.Astrotime;
import cds.astro.Coo;
import cds.astro.Editing;
import cds.astro.Equatorial;
import cds.astro.FK4;
import cds.astro.FK5;
import cds.astro.Galactic;
import cds.astro.ICRS;
import cds.astro.Parsing;
import java.io.Serializable;
import java.text.ParseException;

public class Astrocoo
extends Coo
implements Serializable {
    public static boolean DEBUG = false;
    public Astroframe frame;
    public double epoch;
    protected byte dlon;
    protected byte dlat;
    protected byte precision;
    protected byte formRA;
    protected short editing;
    public static final byte NONE = 0;
    public static final byte DEG = 1;
    public static final byte ARCMIN = 3;
    public static final byte ARCSEC = 5;
    public static final byte MAS = 8;
    public static final short EDIT_FRAME = 256;
    public static final short EDIT_2NUMBERS = 512;
    public static final short EDIT_EPOCH = 1024;
    public static final short EDIT_MEAN_EPOCH = 2048;
    public static final short EDIT_FULL = 4096;
    public static final short EDIT_DEFAULT = 3328;
    private static final String[] explain_precision = new String[]{"unknown", "1degree", "0.1degree", "1arcmin", "0.1arcmin", "1arcsec", "0.1arcsec", "10mas", "1mas", "0.1mas", "10\u00b5as", "1\u00b5as", "0.1\u00b5as"};
    private static final String[] explain_edition = new String[]{"frame", "separate_components", "epoch", "meanEpoch", "full_precision"};
    static final char[] editing_options = new char[]{'s', 'd', ':', 'u', 'f', 'F', '2', 'E', 'M'};
    static final String string_options = new String(editing_options);
    static final short[] Editing_options = new short[]{3, 0, 5, 9, 256, 4096, 512, 1024, 2048};

    public static final String explain(int editing) {
        String xplain1 = Astroformat.explain(editing);
        int flags = editing >> 8;
        if (flags == 0) {
            return xplain1;
        }
        StringBuffer buf = new StringBuffer(xplain1);
        int i = 0;
        while (flags != 0) {
            if ((flags & 1) != 0) {
                if (buf.length() > 0) {
                    buf.append(',');
                }
                buf.append(explain_edition[i]);
            }
            ++i;
            flags >>= 1;
        }
        return buf.toString();
    }

    public Astrocoo() {
        this(new ICRS());
    }

    public Astrocoo(Astroframe frame) {
        this.frame = frame;
        this.epoch = Double.NaN;
        this.precision = 0;
        this.dlat = 0;
        this.dlon = 0;
        this.setEditing();
    }

    public Astrocoo(Astroframe frame, double lon, double lat) {
        this(frame, lon, lat, Double.NaN);
    }

    public Astrocoo(Astroframe frame, double lon, double lat, double epoch) {
        this.frame = frame;
        this.setEditing();
        this.epoch = epoch;
        this.precision = 0;
        this.dlat = 0;
        this.dlon = 0;
        super.set(lon, lat);
    }

    public Astrocoo(Astroframe frame, String text) throws ParseException {
        this.frame = frame;
        this.set(text);
    }

    public Astrocoo(String text) throws ParseException {
        Parsing txt = new Parsing(text);
        if (text.indexOf(32) < 0 && text.indexOf(58) < 0) {
            char c = txt.currentChar();
            txt.advance(1);
            if (Astroframe.isIAU(c)) {
                this.frame = Astroframe.create(c);
                this.editing = (short)(this.frame.ed_lon | 0x100 | 0x400);
                while (txt.pos < txt.length) {
                    c = txt.currentChar();
                    txt.advance(1);
                    if (Character.isDigit(c) || c == '.') continue;
                }
                if (this.frame != null && Parsing.isSign(c)) {
                    this.setIAU(text);
                    return;
                }
            }
        }
        this.frame = Astroframe.parse(txt);
        if (DEBUG) {
            System.out.println("#---Astrocoo(" + text + ") => frame=" + this.frame);
        }
        if (this.frame == null) {
            throw new ParseException("****Astrocoo: argument '" + text + "' (no frame)", txt.pos);
        }
        this.editing = (short)(this.frame.ed_lon | 0xD00);
        this.set(txt.toString());
    }

    @Override
    public Object clone() {
        Astrocoo c = (Astrocoo)super.clone();
        return c;
    }

    public static double getEpoch(Parsing txt) {
        Astrotime t = new Astrotime();
        int posini = txt.pos;
        double epoch = Double.NaN;
        txt.gobbleSpaces();
        boolean bracketed = txt.match("(");
        if (bracketed) {
            txt.gobbleSpaces();
        } else if (!Character.isLetter(txt.currentChar())) {
            txt.set(posini);
            return Double.NaN;
        }
        boolean has_epoch = t.parsing(txt);
        if (has_epoch) {
            epoch = t.getJyr();
            if (bracketed) {
                has_epoch = txt.match(")");
            }
        }
        if (!has_epoch) {
            epoch = Double.NaN;
            txt.set(posini);
        }
        return epoch;
    }

    private boolean parse2(Parsing txt, int option) {
        double lat;
        double lon;
        boolean f15 = this.frame.hms;
        this.dlat = 0;
        this.dlon = 0;
        this.precision = 0;
        int posini = txt.pos;
        this.set();
        this.epoch = Double.NaN;
        if (DEBUG) {
            System.out.print("#...parse2(" + txt + "," + option + "), frame=" + this.frame + ", edit=(" + this.frame.ed_lon + "," + this.frame.ed_lat + ")");
        }
        if (option == 1 && f15) {
            lon = txt.parseIAU();
        } else {
            txt.gobbleSpaces();
            lon = txt.parseSexa2();
        }
        this.dlon = (byte)(1 + txt.decimals());
        if (txt.inError() || this.dlon == 0) {
            txt.set(posini);
            return false;
        }
        boolean sexa = txt.isSexa();
        this.formRA = (byte)txt.format();
        if (option != 1) {
            if (txt.isTime()) {
                f15 = true;
            } else if (txt.isAngle()) {
                f15 = false;
            } else if (!sexa && this.dlon > 0) {
                f15 = false;
            }
        }
        if (f15) {
            lon *= 15.0;
            if (this.dlon > 0) {
                this.dlon = (byte)(this.dlon - 1);
            }
        }
        if (option == 1 && f15) {
            lat = txt.parseIAU();
        } else {
            txt.gobbleSpaces();
            lat = txt.parseSexa();
        }
        this.dlat = (byte)(1 + txt.decimals());
        if (txt.inError() || this.dlat == 0) {
            txt.set(posini);
            return false;
        }
        sexa |= txt.isSexa();
        this.precision = this.dlon > this.dlat ? this.dlon : this.dlat;
        super.set(lon, lat);
        if (DEBUG) {
            System.out.println(" (ok for lon/lat)");
        }
        if (option == 1) {
            return true;
        }
        int pos = txt.pos;
        txt.gobbleSpaces();
        if (txt.pos < txt.length) {
            boolean has_epoch;
            Astrotime t = new Astrotime();
            boolean bracketed = txt.match("(");
            if (bracketed) {
                txt.gobbleSpaces();
            }
            if (has_epoch = t.parsing(txt)) {
                this.epoch = t.getJyr();
                if (bracketed) {
                    has_epoch = txt.match(")");
                }
            }
            if (!has_epoch) {
                this.epoch = Double.NaN;
                txt.set(pos);
            }
        }
        return true;
    }

    @Override
    public boolean parsing(Parsing txt) {
        return this.parse2(txt, 0);
    }

    public boolean parseIAU(Parsing txt) {
        boolean st;
        int posini = txt.pos;
        char c = txt.currentChar();
        if (Astroframe.isIAU(c)) {
            if (DEBUG) {
                System.out.println("#...parseIAU(" + txt + "): frame=" + this.frame);
            }
            if (this.frame == null) {
                this.frame = Astroframe.create(c);
                this.setEditing();
            }
            if (this.frame.equals(c)) {
                txt.advance(1);
            } else {
                return false;
            }
        }
        if (!(st = this.parse2(txt, 1))) {
            txt.set(posini);
        }
        return st;
    }

    @Override
    public int parse(String txt, int offset) {
        Parsing t = new Parsing(txt, offset);
        if (this.parsing(t)) {
            return t.pos;
        }
        return offset;
    }

    public void set(Astrocoo coo) {
        super.set(coo);
        this.frame = coo.frame;
        this.epoch = coo.epoch;
        this.dlon = coo.dlon;
        this.dlat = coo.dlat;
        this.precision = coo.precision;
    }

    @Override
    public void set(String text) throws ParseException {
        Parsing t = new Parsing(text);
        if (this.parse2(t, 0)) {
            t.gobbleSpaces();
        }
        if (t.pos != t.length) {
            throw new ParseException("****Astrocoo: argument '" + text + "'", t.pos);
        }
    }

    public void setIAU(String text) throws ParseException {
        Parsing t = new Parsing(text);
        char c = t.currentChar();
        if (Astroframe.isIAU(c)) {
            if (this.frame.equals(c)) {
                t.advance(1);
            } else {
                throw new ParseException("****Astrocoo: setIAU(" + c + "...) for " + this.frame, t.pos);
            }
        }
        if (DEBUG) {
            System.out.println("#...setIAU(" + text + "), editing=0x" + Integer.toHexString(this.editing));
        }
        if (this.parse2(t, 1)) {
            t.gobbleSpaces();
        } else if (this.parse2(t, 0)) {
            t.gobbleSpaces();
        }
        if (t.pos != t.length) {
            throw new ParseException("****Astrocoo: setIAU '" + text + "'", t.pos);
        }
    }

    public void set(Coo coo, double epoch) {
        this.epoch = epoch;
        super.set(coo);
    }

    public void setPrecision(int precision) {
        this.precision = (byte)precision;
    }

    public void setPrecision(int dlon, int dlat) {
        this.dlon = (byte)dlon;
        this.dlat = (byte)dlat;
        this.precision = this.dlon > this.dlat ? this.dlon : this.dlat;
    }

    public void setEditing(int edit_option) {
        this.editing = (short)(edit_option & 0xFFFF);
        if ((edit_option & 0x1000) != 0) {
            this.setPrecision(12);
        }
    }

    public void setEditing(String options) {
        this.setEditing(Astrocoo.editingOptions(options));
    }

    public void setEditing() {
        int o = 3328;
        if (this.frame != null) {
            o |= this.frame.ed_lon;
        }
        this.setEditing(o);
    }

    public boolean setEpoch(double epoch) {
        this.epoch = epoch;
        return true;
    }

    public final Astroframe getFrame() {
        return this.frame;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public byte getLonPrec() {
        return this.dlon;
    }

    public byte getLatPrec() {
        return this.dlat;
    }

    public final int getEditing() {
        return this.editing;
    }

    @Override
    public void dump(String title) {
        StringBuffer b = new StringBuffer(256);
        int i = title.length();
        while (--i >= 0) {
            b.append(' ');
        }
        String blanks = b.toString();
        b.setLength(0);
        b.append(title);
        b.append("Astroframe=");
        b.append(this.frame);
        b.append(", def.Ep=J");
        b.append(this.frame.base_epoch);
        b.append('\n');
        b.append(blanks);
        b.append("editing=0x");
        b.append(Integer.toHexString(this.editing));
        b.append('=');
        b.append(Astrocoo.explain(this.editing));
        b.append('\n');
        b.append(blanks);
        b.append("precision=");
        b.append(this.precision);
        b.append(", dlon=");
        b.append(this.dlon);
        b.append(", dlat=");
        b.append(this.dlat);
        b.append(", formRA=0x");
        b.append(Integer.toHexString(this.formRA));
        b.append('(');
        b.append(Astroformat.explain(this.formRA));
        b.append(')');
        b.append('\n');
        b.append(blanks);
        b.append("  ");
        super.editCoo(b, 12);
        b.append("  Epoch=J");
        b.append(this.epoch);
        System.out.println(b.toString());
        super.dump(blanks);
    }

    @Override
    public boolean equals(Object o) {
        boolean res = false;
        if (o instanceof Astrocoo) {
            Astrocoo a = (Astrocoo)o;
            res = this.frame.equals(a.frame) && super.equals(a);
        }
        return res;
    }

    @Override
    public int hashCode() {
        int hcode = this.frame.hashCode();
        hcode = hcode * 123 + super.hashCode();
        return hcode;
    }

    public static int editingOptions(String text) throws IllegalArgumentException {
        char[] b = text.toCharArray();
        int o = 0;
        for (int i = 0; i < b.length; ++i) {
            int j;
            if (b[i] == '*') {
                o |= 0xD00;
                continue;
            }
            for (j = 0; j < editing_options.length && b[i] != editing_options[j]; ++j) {
            }
            if (j == editing_options.length) {
                throw new IllegalArgumentException("****Astrocoo: '" + text + "'; accepted=" + string_options);
            }
            if (Editing_options[j] < 16) {
                o &= 0xFFFFFFF0;
            }
            o |= Editing_options[j];
        }
        return o;
    }

    protected final StringBuffer editEpoch(StringBuffer buf, double Jyr) {
        double ep = this.epoch;
        if (Double.isNaN(ep)) {
            buf.append(' ');
        } else if (this.frame instanceof FK4) {
            buf.append('B');
            ep = Astrotime.J2B(this.epoch);
        } else {
            buf.append('J');
        }
        ed.editDecimal(buf, ep, 4, -3, 32);
        return buf;
    }

    @Override
    public final StringBuffer edit(StringBuffer buf, int opt) {
        return this.edit(buf, opt, this.precision & 0xF);
    }

    public final StringBuffer edit(StringBuffer buf, int opt, int prec) {
        boolean f15 = false;
        if (prec == 0) {
            prec = this.frame.precision;
        } else if (prec > this.frame.precision) {
            prec = this.frame.precision;
        }
        int o = opt & 0xFFFFEEFF;
        if (DEBUG) {
            System.out.println("....edit(opt=0x" + Integer.toHexString(opt) + "), epoch=" + this.epoch + ", precision=0x" + Integer.toHexString(this.precision) + ", dlon=" + this.dlon + ", dlat=" + this.dlat + ", lon=" + this.lon + ", lat=" + this.lat);
        }
        if ((opt & 0x1000) != 0) {
            prec = 12;
        }
        if ((opt & 0x100) != 0) {
            buf.append(this.frame.toString());
            buf.append(' ');
        }
        double x = this.getLon();
        int nint = 3;
        int nd = prec;
        if (Astroformat.isSexa(o)) {
            f15 = this.frame.hms;
        }
        if (f15) {
            --nint;
            x /= 15.0;
            if (nd > 0) {
                if (++nd < 3) {
                    nd = 3;
                }
            } else if (--nd > -3) {
                nd = -3;
            }
        }
        ed.editDecimal(buf, x, nint, nd - 1, 0x20 | o);
        if ((opt & 0x200) != 0) {
            buf.append(' ');
        }
        if (Astroformat.isTime(o)) {
            o = Astroformat.isSexa(o) ? (o -= 2) : ++o;
        }
        ed.editDecimal(buf, this.getLat(), 3, prec - 1, 0x30 | o);
        if ((opt & 0x400) != 0 && !Double.isNaN(this.epoch)) {
            buf.append(" (");
            this.editEpoch(buf, this.epoch);
            buf.append(')');
        }
        return buf;
    }

    public String toString(int edit_option) {
        StringBuffer buf = new StringBuffer(80);
        this.edit(buf, edit_option);
        return buf.toString();
    }

    public String toString(String options) throws IllegalArgumentException {
        StringBuffer buf = new StringBuffer(80);
        this.edit(buf, Astrocoo.editingOptions(options));
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(80);
        this.edit(buf, this.editing);
        return buf.toString();
    }

    public String toIAU(String IAUtemplate) throws ParseException {
        Equatorial f;
        Astrocoo position = this;
        Editing ed = new Editing();
        char letter = IAUtemplate.charAt(0);
        Astroframe frame = null;
        if (letter == 'J') {
            if (this.frame instanceof ICRS) {
                frame = this.frame;
            } else if (this.frame instanceof FK5) {
                f = (FK5)this.frame;
                if (((FK5)f).equinox == 2000.0) {
                    frame = this.frame;
                }
            }
            if (frame == null) {
                frame = new ICRS();
            }
        } else if (letter == 'B') {
            if (this.frame instanceof FK4) {
                f = (FK4)this.frame;
                if (f.equinox == 1950.0) {
                    frame = this.frame;
                }
            }
            if (frame == null) {
                frame = new FK4();
            }
        } else if (letter == 'G') {
            if (this.frame instanceof Galactic) {
                frame = this.frame;
            }
            if (frame == null) {
                frame = new Galactic();
            }
        } else {
            throw new ParseException("****Astrocoo.toIAU: template does not start with J|B|G", 0);
        }
        if (frame != this.frame) {
            position = new Astrocoo(frame);
            Astrocoo.convert(this, position);
        }
        char[] b = IAUtemplate.toCharArray();
        StringBuffer bed = new StringBuffer();
        bed.append(letter);
        double value = position.lon;
        int k = 0;
        int sexa = 0;
        int nd = 0;
        int nint = 0;
        boolean bad = false;
        boolean has_point = false;
        int opt = 96;
        int i = 1;
        while (i < b.length && k < 2) {
            if (b[i] == '+') {
                opt |= 0x10;
                ++i;
                ++nint;
                continue;
            }
            letter = b[i];
            char Letter = Character.toUpperCase(letter);
            if (Letter == 'H' && k == 0) {
                bad = !frame.hms;
                value /= 15.0;
            } else if (Letter == 'L') {
                bad = frame.hms || k != 0;
            } else if (Letter == 'B') {
                bad = frame.hms || k == 0;
            } else if (Letter != 'D') {
                bad = true;
            }
            if (bad) {
                throw new ParseException("***Astrocoo.toIAU: '" + letter + "' invalid", i);
            }
            has_point = false;
            while (i < b.length && b[i] == letter) {
                ++i;
                ++nint;
            }
            while (!(i >= b.length || bad || b[i] == '+' && k == 0)) {
                if (b[i] == '.') {
                    has_point = true;
                    ++i;
                    continue;
                }
                char M = Character.toUpperCase(b[i]);
                if (M == Letter || b[i] == 'f') {
                    letter = b[i];
                    while (i < b.length && b[i] == letter) {
                        ++i;
                        ++nd;
                    }
                    break;
                }
                if (M == 'M' && (Letter == 'D' || Letter == 'H')) {
                    letter = b[i];
                    Letter = M;
                    while (i < b.length && b[i] == letter) {
                        ++i;
                        ++nd;
                    }
                    sexa = 2;
                    continue;
                }
                if (M == 'S' && Letter == 'M') {
                    letter = b[i];
                    Letter = M;
                    while (i < b.length && b[i] == letter) {
                        ++i;
                        ++nd;
                    }
                    sexa = 3;
                    continue;
                }
                bad = true;
            }
            if (bad) {
                throw new ParseException("***Astrocoo.toIAU: '" + b[i] + "' invalid", i);
            }
            int j = bed.length();
            if (DEBUG) {
                System.out.print("# Edition(nint=" + nint + ",nd=" + nd + ",opt=" + opt + "): " + bed);
            }
            ed.editDecimal(bed, value, nint, nd, opt | sexa);
            if (sexa != 0 || !has_point) {
                while (j < bed.length()) {
                    letter = bed.charAt(j);
                    if (letter == ' ') {
                        bed.deleteCharAt(j);
                        continue;
                    }
                    if (letter == '.' && !has_point) {
                        bed.deleteCharAt(j);
                        continue;
                    }
                    ++j;
                }
            }
            if (DEBUG) {
                System.out.println(" => " + bed);
            }
            sexa = 0;
            nd = 0;
            nint = 0;
            bad = false;
            has_point = false;
            opt = 96;
            value = position.lat;
            ++k;
        }
        if (i < b.length || k != 2) {
            throw new ParseException("***Astrocoo.toIAU: '" + b[i] + "' invalid", i);
        }
        return bed.toString();
    }

    public void convertTo(Astroframe new_frame) {
        if (this.frame.equals(new_frame)) {
            if (DEBUG) {
                System.out.println("....Frame " + this.frame + "=" + new_frame);
            }
            return;
        }
        if (DEBUG) {
            System.out.println("....Astrocoo.convert: via ICRS:  " + this.frame + " => ICRS => " + new_frame);
        }
        this.frame.toICRS(this);
        if (DEBUG) {
            this.dump("#ICRS: ");
        }
        new_frame.fromICRS(this);
        if (DEBUG) {
            this.dump("#NewF: ");
        }
        this.frame = new_frame;
        this.lat = Double.NaN;
        this.lon = Double.NaN;
    }

    public static void convert(Astrocoo source, Astrocoo target) {
        Astrocoo coo = target;
        coo.set((Coo)source);
        if (target.frame.equals(source.frame)) {
            if (DEBUG) {
                System.out.println("....Astrocoo.convert: Frame " + source.frame + "=" + target.frame);
            }
            return;
        }
        source.frame.toICRS(coo);
        if (DEBUG) {
            target.dump("#ICRS: ");
        }
        target.frame.fromICRS(coo);
        if (DEBUG) {
            target.dump("#NewF: ");
        }
    }
}

