/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

public class AstroMath {
    public static final double[] powers = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    public static final double DEG = 57.29577951308232;
    public static final double DEG2 = 3282.806350011744;
    public static final double ARCSEC = 206264.80624709636;
    static final double ln10 = Math.log(10.0);
    static final double ellEPS = 5.0E-16;

    public static final double cosd(double x) {
        return Math.cos(x / 57.29577951308232);
    }

    public static final double sind(double x) {
        return Math.sin(x / 57.29577951308232);
    }

    public static final double tand(double x) {
        return Math.tan(x / 57.29577951308232);
    }

    public static final double asind(double x) {
        return Math.asin(x) * 57.29577951308232;
    }

    public static final double atand(double x) {
        return Math.atan(x) * 57.29577951308232;
    }

    public static final double atan2d(double y, double x) {
        return Math.atan2(y, x) * 57.29577951308232;
    }

    public static final double cosh(double x) {
        double ex = Math.exp(x);
        return 0.5 * (ex + 1.0 / ex);
    }

    public static final double tanh(double x) {
        double ex = Math.exp(x);
        double ex1 = 1.0 / ex;
        return (ex - ex1) / (ex + ex1);
    }

    public static final double atanh(double x) {
        return 0.5 * Math.log((1.0 + x) / (1.0 - x));
    }

    public static final double sinc(double x) {
        double y;
        double ax = Math.abs(x);
        if (ax <= 1.0E-4) {
            ax *= ax;
            y = 1.0 - ax * (1.0 - ax / 20.0) / 6.0;
        } else {
            y = Math.sin(ax) / ax;
        }
        return y;
    }

    public static final double asinc(double x) {
        double y;
        double ax = Math.abs(x);
        if (ax <= 1.0E-4) {
            ax *= ax;
            y = 1.0 + ax * (1.0 + ax * 0.45) / 6.0;
        } else {
            y = Math.asin(ax) / ax;
        }
        return y;
    }

    public static final double dexp(int n) {
        int i = n;
        int m = powers.length - 1;
        double x = 1.0;
        boolean inv = false;
        if (n < 0) {
            inv = true;
            i = -n;
        }
        while (i > m) {
            x *= powers[m];
            i -= m;
        }
        x *= powers[i];
        if (inv) {
            x = 1.0 / x;
        }
        return x;
    }

    public static final double dexp(double x) {
        return Math.exp(x * ln10);
    }

    public static final double log(double x) {
        return Math.log(x) / ln10;
    }

    public static final double ell1(double a, double b) {
        double a0 = a;
        double b0 = b;
        if (a < b) {
            a0 = b;
            b0 = a;
        }
        int i = 50;
        while (--i >= 0 && a0 - b0 > 5.0E-16) {
            double a1 = (a0 + b0) / 2.0;
            double b1 = Math.sqrt(a0 * b0);
            a0 = a1;
            b0 = b1;
        }
        if (i < 0) {
            System.err.println("#+++AstroMath.ell1(" + a + "," + b + ") did not converge!");
        }
        return Math.PI / (a0 + b0);
    }

    public static final double ell1(double m) {
        return AstroMath.ell1(1.0, Math.sqrt(1.0 - m));
    }

    public static final double ell2(double a, double b) {
        double a0 = a;
        double b0 = b;
        double f2 = 1.0;
        if (a < b) {
            a0 = b;
            b0 = a;
        }
        double S = (a0 * a0 + b0 * b0) / 2.0;
        int i = 50;
        while (--i >= 0 && a0 - b0 > 5.0E-16) {
            double d2 = (a0 - b0) / 2.0;
            S -= f2 * d2 * d2;
            f2 *= 2.0;
            double a1 = (a0 + b0) / 2.0;
            double b1 = Math.sqrt(a0 * b0);
            a0 = a1;
            b0 = b1;
        }
        if (i < 0) {
            System.err.println("#+++AstroMath.ell2(" + a + "," + b + ") did not converge!");
        }
        return Math.PI * S / (a0 + b0);
    }

    public static final double ell2(double m) {
        return AstroMath.ell2(1.0, Math.sqrt(1.0 - m));
    }

    public static final double ell3(double n, double m) {
        double a0 = 1.0;
        double b0 = Math.sqrt(1.0 - m);
        double delta = (1.0 - n) / b0;
        double eps0 = n / (1.0 - n);
        double zeta = 0.0;
        int i = 50;
        while (--i >= 0 && (a0 - b0 > 5.0E-16 || Math.abs(delta - 1.0) > 5.0E-16)) {
            double eps1 = (delta * eps0 + zeta) / (1.0 + delta);
            zeta = (eps0 + zeta) / 2.0;
            double a1 = (a0 + b0) / 2.0;
            double b1 = Math.sqrt(a0 * b0);
            delta = 0.25 * b1 / a1 * (2.0 + delta + 1.0 / delta);
            a0 = a1;
            b0 = b1;
            eps0 = eps1;
        }
        if (i < 0) {
            System.err.println("#+++AstroMath.ell3(" + n + "," + m + ") did not converge!");
        }
        return Math.PI * (1.0 + zeta) / (a0 + b0);
    }

    public static final double[][] m3p(double[][] A, double[][] B) {
        double[][] R = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = A[i][0] * B[0][j] + A[i][1] * B[1][j] + A[i][2] * B[2][j];
            }
        }
        return R;
    }

    public static final double[][] m3t(double[][] A) {
        double[][] R = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                R[i][j] = A[j][i];
            }
        }
        return R;
    }
}

