/*
 * Decompiled with CFR 0.152.
 */
package cds.astro;

import cds.astro.Coo;
import cds.astro.Coocube;
import cds.astro.Qbox;
import java.io.Serializable;

public abstract class AbstractRegion
implements Serializable {
    static boolean DEBUG = false;
    public static final int DISJOINT = 0;
    public static final int INTERSECTS = 1;
    public static final int INCLUDES = -1;
    public static final int IS_PARTOF = 3;
    public Coo centroid = null;
    public double minrad;
    public double maxrad;

    public abstract String toString();

    public abstract double area();

    public abstract boolean checkCoo(Coo var1);

    public abstract int checkCircle(Coo var1, double var2);

    public final int check1(Coo centre, double radius) {
        double d = this.centroid.distance(centre);
        if (d >= radius + this.maxrad) {
            return 0;
        }
        if (this.minrad >= d + radius) {
            return -1;
        }
        if (radius >= d + this.maxrad) {
            return 3;
        }
        return 1;
    }

    public int checkQbox(int qbox) {
        if (this.centroid == null) {
            return 0;
        }
        Qbox abox = new Qbox();
        abox.set(qbox);
        Coocube cc = abox.center();
        double rb = abox.radius();
        return this.checkCircle(cc, rb);
    }
}

