/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Coord;
import cds.allsky.BuilderTiles;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.allsky.MyInputStreamCached;
import cds.allsky.MyInputStreamCachedException;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.healpix.Healpix;
import cds.healpix.HealpixNestedFast;
import cds.tools.pixtools.Util;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public final class ThreadBuilderTile {
    private Context context;
    protected BuilderTiles builderTiles;
    protected BuilderTiles.ThreadBuilder threadBuilder;
    private int bitpix;
    private Mode coaddMode;
    private double max;
    private boolean hasAlternateBlank;
    private double blankOrig;
    private double blank;
    private boolean flagColor;
    private boolean flagGauss;
    private double bScale;
    private double bZero;
    private boolean fading;
    private String hpxFinderPath = null;
    private double[] cutOrig;
    private double[] cut;
    private int[] borderSize;
    private Shape globalShape;
    private ArrayList<SrcFile> downFiles;
    private boolean mixing;
    private int tileSide;
    protected static int nbThreadsToStop = 0;
    protected static HashMap<File, Shape> hasShape = null;
    private Object objRel = new Object();
    static long statOnePass = 0L;
    static long statMultiPass = 0L;
    static int statMaxOverlays = 0;
    private static final double toDeg = 57.29577951308232;
    private static final double PI2 = 1.5707963267948966;
    public static int I = 0;
    private static final double OVERLAY_PROPORTION = 0.16666666666666666;
    int n = 0;

    public ThreadBuilderTile(Context context, BuilderTiles builderTiles) {
        this.context = context;
        this.builderTiles = builderTiles;
        this.bitpix = context.getBitpix();
        this.coaddMode = context.getMode();
        this.max = Fits.getMax(context.getBitpixOrig());
        this.flagColor = context.isColor();
        this.flagGauss = context.gaussFilter;
        this.mixing = context.mixing;
        if (!this.flagColor) {
            this.bZero = context.getBZero();
            this.bScale = context.getBScale();
            try {
                this.cutOrig = context.getCutOrig();
                this.cut = context.getCut();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.blankOrig = context.getBlankOrig();
            this.hasAlternateBlank = context.hasAlternateBlank();
            this.blank = context.getBlank();
        } else {
            this.blank = 0.0;
        }
        this.fading = context.getFading();
        this.borderSize = context.getBorderSize();
        this.globalShape = context.globalShape;
        this.hpxFinderPath = context.getHpxFinderPath();
        this.tileSide = context.getTileSide();
        this.downFiles = new ArrayList(10);
    }

    public long getMem() {
        long mem = 118L;
        for (SrcFile f : this.downFiles) {
            mem += f.fitsfile.getMem();
        }
        return mem;
    }

    private boolean needMem(long rqMem) {
        long mem = CacheFits.getFreeMem();
        return mem - 0x2800000L < rqMem;
    }

    protected boolean requiredMem(long nbProgen, int nbThreads) throws Exception {
        long rqMem = 4L * nbProgen * (long)Constante.ORIGCELLWIDTH * (long)Constante.ORIGCELLWIDTH * (long)this.context.getNpixOrig();
        return this.needMem((long)nbThreads * (rqMem += (long)(2 * this.tileSide * this.tileSide * this.context.getNpix())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMem(int nbProgen, long rqMem, boolean monopass) throws Exception {
        rqMem += (long)(2 * this.tileSide * this.tileSide * this.context.getNpix());
        if (nbProgen > 10) {
            rqMem += (long)(2 * this.tileSide * this.tileSide * 8);
        }
        if (!this.needMem(rqMem)) {
            return;
        }
        Object object = this.objRel;
        synchronized (object) {
            if (!this.needMem(rqMem)) {
                return;
            }
            long sizeReleaseBitmap = this.builderTiles.releaseBitmap();
            if (sizeReleaseBitmap > 0L) {
                System.gc();
                cds.tools.Util.pause(100);
                ThreadBuilderTile threadBuilderTile = this;
                if (threadBuilderTile.context.getVerbose() > 3) {
                    this.context.info("Need more RAM: output Fits bitmap release => " + cds.tools.Util.getUnitDisk(sizeReleaseBitmap));
                }
                if (!this.needMem(rqMem)) {
                    return;
                }
            }
            if (this.builderTiles.getNbThreadRunning() <= 1) {
                this.context.cacheFits.forceClean();
                ThreadBuilderTile threadBuilderTile = this;
                if (threadBuilderTile.context.getVerbose() > 3) {
                    this.context.warning(Thread.currentThread().getName() + " needs " + cds.tools.Util.getUnitDisk(rqMem) + " but can not stop (last thread running) !");
                }
                return;
            }
            try {
                if (!this.builderTiles.arret(this, "not enough free RAM => thread temporary suspended by ThreadBuilder.checkMem(nbProgen=" + nbProgen + ",rqMem=" + cds.tools.Util.getUnitDisk(rqMem) + ",monopass=" + monopass + ")")) {
                    ThreadBuilderTile threadBuilderTile = this;
                    if (threadBuilderTile.context.getVerbose() > 3) {
                        this.context.warning(Thread.currentThread().getName() + " needs " + cds.tools.Util.getUnitDisk(rqMem) + " but can not stop (sub thread) !");
                    }
                    return;
                }
                ThreadBuilderTile threadBuilderTile = this;
                if (threadBuilderTile.context.getVerbose() > 3) {
                    this.context.info(Thread.currentThread().getName() + " suspended");
                }
                while (this.needMem(rqMem)) {
                    block25: {
                        try {
                            ThreadBuilderTile threadBuilderTile2 = this;
                            if (threadBuilderTile2.context.getVerbose() > 3) {
                                this.context.info(Thread.currentThread().getName() + " is waiting more memory (need " + cds.tools.Util.getUnitDisk(rqMem) + ")...");
                            }
                            cds.tools.Util.pause((int)(1000.0 * (1.0 + Math.random() * 5.0)));
                            this.context.cacheFits.forceClean();
                            if (this.builderTiles.getNbThreadRunning() > 0) break block25;
                            ThreadBuilderTile threadBuilderTile3 = this;
                            if (threadBuilderTile3.context.getVerbose() > 3) {
                                this.context.warning(Thread.currentThread().getName() + " resumes (last thread)");
                            }
                            break;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (!this.context.isTaskAborting()) continue;
                    throw new Exception("Task abort !");
                }
            }
            finally {
                if (this.builderTiles.reprise(this)) {
                    ThreadBuilderTile threadBuilderTile = this;
                    if (threadBuilderTile.context.getVerbose() > 3) {
                        this.context.info(Thread.currentThread().getName() + " restarted");
                    }
                }
            }
        }
    }

    protected long getReqMem(ArrayList<SrcFile> downFiles, int deb, int n) {
        long mem = 0L;
        for (int i = 0; i < n && deb < downFiles.size(); ++i, ++deb) {
            SrcFile file = downFiles.get(deb);
            mem += file.cellMem;
        }
        return mem;
    }

    Fits buildHealpix(BuilderTiles bt, String path, int order, long npix_file, int z) throws Exception {
        Fits out;
        ArrayList<SrcFile> downFiles;
        block24: {
            downFiles = null;
            out = null;
            try {
                downFiles = new ArrayList<SrcFile>(20);
                if (!this.askLocalFinder(bt, downFiles, this.hpxFinderPath, order, npix_file, this.blank)) {
                    return null;
                }
                int n = downFiles.size();
                if (n > statMaxOverlays) {
                    statMaxOverlays = n;
                }
                if (!(this.context.live || this.mixing && n >= 10 && this.requiredMem(this.mixing ? (long)n : 1L, 1))) {
                    ++statOnePass;
                    long mem = this.getReqMem(downFiles, 0, n);
                    this.checkMem(this.mixing ? n : 1, mem, true);
                    this.threadBuilder.setInfo("createLeavveHpx onepass memOk " + order + "/" + npix_file + "...");
                    out = this.buildHealpix1(bt, order, npix_file, z, downFiles, 0, n, null);
                    break block24;
                }
                ++statMultiPass;
                double[] weight = null;
                double[] fWeight = this.coaddMode == Mode.ADD ? null : new double[this.tileSide * this.tileSide];
                for (int deb = 0; deb < n; deb += 10) {
                    int fin = deb + 10;
                    if (fin >= n) {
                        fin = n;
                    }
                    long mem = this.getReqMem(downFiles, deb, fin);
                    this.checkMem(fin - deb, mem, false);
                    this.threadBuilder.setInfo("createLeavveHpx multipass memOk " + order + "/" + npix_file + "...");
                    Fits f = this.buildHealpix1(bt, order, npix_file, z, downFiles, deb, fin, fWeight);
                    if (f != null) {
                        if (out == null) {
                            out = f;
                            weight = fWeight;
                            fWeight = this.coaddMode == Mode.ADD ? null : new double[this.tileSide * this.tileSide];
                        } else if (this.coaddMode == Mode.ADD) {
                            out.coadd(f, false);
                        } else {
                            out.coadd(f, weight, fWeight);
                        }
                    }
                    for (int i = deb; i < fin; ++i) {
                        SrcFile f1 = downFiles.get(i);
                        try {
                            if (f1 != null) {
                                f1.release();
                            }
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        downFiles.set(i, null);
                    }
                }
                if (out != null && this.bitpix != this.context.getBitpixOrig()) {
                    Fits out1 = new Fits(out.width, out.height, this.bitpix);
                    out1.setBlank(this.blank);
                    out1.setBzero(this.bZero);
                    out1.setBscale(this.bScale);
                    for (int y = 0; y < out.height; ++y) {
                        for (int x = 0; x < out.width; ++x) {
                            double pixelFinal = out.getPixelDouble(x, y);
                            pixelFinal = Double.isNaN(pixelFinal) ? this.blank : (pixelFinal <= this.cutOrig[2] ? this.cut[2] : (pixelFinal >= this.cutOrig[3] ? this.cut[3] : (pixelFinal - this.cutOrig[2]) * this.context.coef + this.cut[2]));
                            out1.setPixelDouble(x, y, pixelFinal);
                        }
                    }
                    out = out1;
                    out1 = null;
                }
                if (out != null && this.context.live) {
                    String file = Util.getFilePath(path, order, npix_file, z);
                    ThreadBuilderTile.writeWeight(file, weight, this.tileSide);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (int i = downFiles.size() - 1; i >= 0; --i) {
            SrcFile f1 = (SrcFile)downFiles.get(i);
            try {
                if (f1 == null) continue;
                f1.release();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        this.threadBuilder.setInfo("createLeavveHpx done " + path + "...");
        return out;
    }

    public static void writeWeight(String file, double[] weight, int w) throws Exception {
        if (weight == null) {
            return;
        }
        Fits fits = new Fits(w, w, -32);
        int i = 0;
        for (int y = 0; y < fits.height; ++y) {
            for (int x = 0; x < fits.width; ++x) {
                fits.setPixelDouble(x, y, weight[i++]);
            }
        }
        fits.writeFITS(file + "_w.fits");
    }

    public static double[] loadWeight(String file, int w, double defaultWeight) throws Exception {
        double[] weight = new double[w * w];
        String filename = file + "_w.fits";
        if (!new File(filename).exists()) {
            for (int i = 0; i < weight.length; ++i) {
                weight[i] = defaultWeight;
            }
            return weight;
        }
        Fits fits = new Fits();
        fits.loadFITS(filename);
        int i = 0;
        for (int y = 0; y < fits.height; ++y) {
            for (int x = 0; x < fits.width; ++x) {
                weight[i++] = fits.getPixelDouble(x, y);
            }
        }
        return weight;
    }

    Fits buildHealpix1(BuilderTiles bt, int order, long npix_file, int z, ArrayList<SrcFile> downFiles, int deb, int fin, double[] weight) throws Exception {
        Fits out;
        boolean empty;
        block59: {
            empty = true;
            double[] radec = new double[2];
            Coord coo = new Coord();
            SrcFile file = null;
            out = null;
            int bitpix = this.bitpix;
            double blank = this.blank;
            double bScale = this.bScale;
            double bZero = this.bZero;
            int tileSide = this.context.getTileSide();
            try {
                boolean flagModifBitpix;
                long min = npix_file * (long)tileSide * (long)tileSide;
                boolean bl = flagModifBitpix = bitpix != this.context.getBitpixOrig();
                if (flagModifBitpix && weight != null) {
                    bitpix = this.context.getBitpixOrig();
                    blank = bitpix < 0 ? Double.NaN : this.blankOrig;
                    flagModifBitpix = false;
                }
                out = new Fits(tileSide, tileSide, bitpix);
                if (!this.flagColor) {
                    out.setBlank(blank);
                    out.setBzero(bZero);
                    out.setBscale(bScale);
                } else if (this.context.targetColorMode == 0) {
                    for (int i = 0; i < out.rgb.length; ++i) {
                        out.rgb[i] = -16777216;
                    }
                }
                int overlay = fin - deb;
                double[] pixvalG = null;
                double[] pixvalB = null;
                double[] pixval = new double[overlay];
                double[] pixcoef = new double[overlay];
                if (this.flagColor) {
                    pixvalG = new double[overlay];
                    pixvalB = new double[overlay];
                }
                int orderPix = order + this.context.getTileOrder();
                boolean gal2ICRS = this.context.getFrame() != 0;
                HealpixNestedFast hn = Healpix.getNestedFast(orderPix);
                for (int y = 0; y < out.height; ++y) {
                    for (int x = 0; x < out.width; ++x) {
                        long index = min + (long)this.context.xy2hpx(y * out.width + x);
                        hn.center(index, radec);
                        if (gal2ICRS) {
                            radec[0] = radec[0] * 57.29577951308232;
                            radec[1] = radec[1] * 57.29577951308232;
                            radec = this.context.gal2ICRSIfRequired(radec);
                            coo.al = radec[0];
                            coo.del = radec[1];
                        } else {
                            coo.al = radec[0] * 57.29577951308232;
                            coo.del = radec[1] * 57.29577951308232;
                        }
                        int nbPix = 0;
                        double totalCoef = 0.0;
                        int removed = 0;
                        for (int i = deb; i < fin; ++i) {
                            try {
                                file = downFiles.get(i);
                                if (file.flagRemoved) continue;
                                try {
                                    file.open(z, this.flagGauss);
                                }
                                catch (Exception e) {
                                    System.err.println("Error on open:");
                                    e.printStackTrace();
                                    this.context.addFileRemoveList(file.name);
                                    String msg = e.getMessage();
                                    if (msg != null && msg.indexOf("space") >= 0) {
                                        this.context.taskAbort();
                                        throw e;
                                    }
                                    file.flagRemoved = true;
                                    if (++removed < fin - deb) continue;
                                    return null;
                                }
                                try {
                                    file.fitsfile.calib.GetXY(coo, false);
                                }
                                catch (Exception e) {
                                    System.err.println("Problem on calib: " + file.name + " => exception " + e.getMessage());
                                    continue;
                                }
                                coo.y = (double)file.fitsfile.height - coo.y - 1.0;
                                coo.x -= 1.0;
                                if (this.flagColor) {
                                    int pix = this.getBilinearPixelRGB(file, coo);
                                    if (pix == 0) continue;
                                    pixval[nbPix] = 0xFF & pix >> 16;
                                    pixvalG[nbPix] = 0xFF & pix >> 8;
                                    pixvalB[nbPix] = 0xFF & pix;
                                } else {
                                    double pix = this.getBilinearPixel(file, coo, z, file.blank);
                                    if (Double.isNaN(pix)) continue;
                                    pixval[nbPix] = pix;
                                }
                                pixcoef[nbPix] = this.getCoef(file.fitsfile, coo);
                                totalCoef += pixcoef[nbPix];
                                ++nbPix;
                                if (this.mixing) continue;
                                break;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (this.flagColor) {
                            int pixelFinal = 0;
                            if (nbPix != 0) {
                                int i;
                                double b;
                                double g;
                                if (totalCoef == 0.0) {
                                    pixelFinal = 0xFF000000 | ((int)pixval[0] & 0xFF) << 16 | ((int)pixvalG[0] & 0xFF) << 8 | (int)pixvalB[0] & 0xFF;
                                } else if (this.coaddMode == Mode.ADD) {
                                    double r = 0.0;
                                    g = 0.0;
                                    b = 0.0;
                                    for (i = 0; i < nbPix; ++i) {
                                        r += pixval[i];
                                        g += pixvalG[i];
                                        b += pixvalB[i];
                                    }
                                    if (r > 255.0) {
                                        r = 255.0;
                                    }
                                    if (g > 255.0) {
                                        g = 255.0;
                                    }
                                    if (b > 255.0) {
                                        b = 255.0;
                                    }
                                    pixelFinal = 0xFF000000 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
                                } else {
                                    double r = 0.0;
                                    g = 0.0;
                                    b = 0.0;
                                    for (i = 0; i < nbPix; ++i) {
                                        r += pixval[i] * pixcoef[i] / totalCoef;
                                        g += pixvalG[i] * pixcoef[i] / totalCoef;
                                        b += pixvalB[i] * pixcoef[i] / totalCoef;
                                    }
                                    if (r > 255.0) {
                                        r = 255.0;
                                    } else if (r < 0.0) {
                                        r = 0.0;
                                    }
                                    if (g > 255.0) {
                                        g = 255.0;
                                    } else if (g < 0.0) {
                                        g = 0.0;
                                    }
                                    if (b > 255.0) {
                                        b = 255.0;
                                    } else if (b < 0.0) {
                                        b = 0.0;
                                    }
                                    pixelFinal = 0xFF000000 | ((int)r & 0xFF) << 16 | ((int)g & 0xFF) << 8 | (int)b & 0xFF;
                                }
                                empty = false;
                            }
                            out.setPixelRGBJPG(x, y, pixelFinal);
                        } else {
                            double pixelFinal = 0.0;
                            if (nbPix == 0) {
                                pixelFinal = Double.NaN;
                            } else if (this.coaddMode == Mode.ADD) {
                                empty = false;
                                for (int i = 0; i < nbPix; ++i) {
                                    if (pixelFinal / 2.0 + pixval[i] / 2.0 > this.max / 2.0) {
                                        pixelFinal = this.max;
                                        break;
                                    }
                                    pixelFinal += pixval[i];
                                }
                            } else if (totalCoef == 0.0) {
                                empty = false;
                                pixelFinal = pixval[0];
                            } else {
                                empty = false;
                                for (int i = 0; i < nbPix; ++i) {
                                    pixelFinal += pixval[i] * pixcoef[i] / totalCoef;
                                }
                            }
                            if (flagModifBitpix) {
                                double d = Double.isNaN(pixelFinal) ? blank : (pixelFinal <= this.cutOrig[2] ? this.cut[2] : (pixelFinal = pixelFinal >= this.cutOrig[3] ? this.cut[3] : (pixelFinal - this.cutOrig[2]) * this.context.coef + this.cut[2]));
                                if (bitpix > 0 && (double)((long)pixelFinal) == blank && pixelFinal != blank) {
                                    pixelFinal += 0.5;
                                }
                            } else if (Double.isNaN(pixelFinal)) {
                                pixelFinal = blank;
                            }
                            out.setPixelDouble(x, y, pixelFinal);
                        }
                        if (weight == null) continue;
                        weight[y * tileSide + x] = totalCoef;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                empty = true;
                if (weight == null) break block59;
                for (int i = 0; i < weight.length; ++i) {
                    weight[i] = 0.0;
                }
            }
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        return !empty ? out : null;
    }

    private boolean isIn(SrcFile srcFile, Coord coo) {
        Fits f = srcFile.fitsfile;
        if (coo.x < (double)this.borderSize[1] - 1.5 || coo.x > (double)(f.width - this.borderSize[3])) {
            return false;
        }
        if (coo.y < (double)this.borderSize[0] - 1.5 || coo.y > (double)(f.height - this.borderSize[2])) {
            return false;
        }
        if (this.context.scanFov) {
            if (this.globalShape != null && !this.globalShape.contains(coo.x, coo.y)) {
                return false;
            }
            if (srcFile.shape != null && !srcFile.shape.contains(coo.x, coo.y)) {
                return false;
            }
        }
        return true;
    }

    private double getCoef(Fits f, Coord coo) {
        int x1 = (int)coo.x;
        int y1 = (int)coo.y;
        double div = 1.0;
        if (x1 > 0 && x1 < f.width && (coo.x <= (double)f.xCell || coo.x >= (double)(f.xCell + f.widthCell - 1))) {
            div *= 2.0;
        }
        if (y1 > 0 && y1 < f.height && (coo.y <= (double)f.yCell || coo.y >= (double)(f.yCell + f.heightCell - 1))) {
            div *= 2.0;
        }
        if (!this.fading) {
            return 1.0 / div;
        }
        double c = 0.0;
        try {
            double width = f.width - (this.borderSize[1] + this.borderSize[3]);
            double height = f.height - (this.borderSize[0] + this.borderSize[2]);
            double mx = width * 0.16666666666666666;
            double my = height * 0.16666666666666666;
            double x = coo.x - (double)this.borderSize[1];
            double y = coo.y - (double)this.borderSize[0];
            double coefx = 1.0;
            double coefy = 1.0;
            if (x < mx) {
                coefx = x / mx;
            } else if (x > width - mx) {
                coefx = (width - x) / mx;
            }
            if (y < my) {
                coefy = y / my;
            } else if (y > height - my) {
                coefy = (height - y) / my;
            }
            c = coefx * coefy;
        }
        catch (Exception e) {
            c = 0.0;
        }
        return c / div;
    }

    private double getBilinearPixel(SrcFile srcFile, Coord coo, int z, double myBlank) {
        boolean b3;
        Fits f = srcFile.fitsfile;
        if (!this.isIn(srcFile, coo)) {
            return Double.NaN;
        }
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int ox1 = x1;
        int oy1 = y1;
        int ox2 = x2;
        int oy2 = y2;
        if (x2 < f.xCell || y2 < f.yCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell || z < 0 || z >= f.depth) {
            return Double.NaN;
        }
        if (ox1 == f.xCell - 1) {
            ++ox1;
        }
        if (oy1 == f.yCell - 1) {
            ++oy1;
        }
        if (ox2 == f.xCell + f.widthCell) {
            --ox2;
        }
        if (oy2 == f.yCell + f.heightCell) {
            --oy2;
        }
        double a0 = f.getPixelDouble(ox1, oy1, z);
        double a1 = f.getPixelDouble(ox2, oy1, z);
        double a2 = f.getPixelDouble(ox1, oy2, z);
        double a3 = f.getPixelDouble(ox2, oy2, z);
        boolean b0 = Double.isNaN(a0) || a0 == myBlank;
        boolean b1 = Double.isNaN(a1) || a1 == myBlank;
        boolean b2 = Double.isNaN(a2) || a2 == myBlank;
        boolean bl = b3 = Double.isNaN(a3) || a3 == myBlank;
        if (b0 && b1 && b2 && b3) {
            return Double.NaN;
        }
        if (b0 || b1 || b2 || b3) {
            double a;
            double d = !b0 ? a0 : (!b1 ? a1 : (a = !b2 ? a2 : a3));
            if (b0) {
                a0 = a;
            }
            if (b1) {
                a1 = a;
            }
            if (b2) {
                a2 = a;
            }
            if (b3) {
                a3 = a;
            }
        }
        return this.bilineaire(x1, y1, x2, y2, x, y, a0, a1, a2, a3);
    }

    private int getBilinearPixelRGB(SrcFile srcFile, Coord coo) {
        boolean c3;
        Fits f = srcFile.fitsfile;
        if (!this.isIn(srcFile, coo)) {
            return 0;
        }
        double x = coo.x;
        double y = coo.y;
        int x1 = (int)x;
        int y1 = (int)y;
        int x2 = x1 + 1;
        int y2 = y1 + 1;
        int ox1 = x1;
        int oy1 = y1;
        int ox2 = x2;
        int oy2 = y2;
        if (x2 < f.xCell || y2 < f.yCell || x1 >= f.xCell + f.widthCell || y1 >= f.yCell + f.heightCell) {
            return 0;
        }
        if (ox1 == f.xCell - 1) {
            ++ox1;
        }
        if (oy1 == f.yCell - 1) {
            ++oy1;
        }
        if (ox2 == f.xCell + f.widthCell) {
            --ox2;
        }
        if (oy2 == f.yCell + f.heightCell) {
            --oy2;
        }
        int b0 = f.getPixelRGBJPG(ox1, oy1);
        int b1 = f.getPixelRGBJPG(ox2, oy1);
        int b2 = f.getPixelRGBJPG(ox1, oy2);
        int b3 = f.getPixelRGBJPG(ox2, oy2);
        boolean c0 = (b0 & 0xFF000000) == 0;
        boolean c1 = (b1 & 0xFF000000) == 0;
        boolean c2 = (b2 & 0xFF000000) == 0;
        boolean bl = c3 = (b3 & 0xFF000000) == 0;
        if (c0 && c1 && c2 && c3) {
            return 0;
        }
        if (c0 || c1 || c2 || c3) {
            int a;
            int n = !c0 ? b0 : (!c1 ? b1 : (a = !c2 ? b2 : b3));
            if (c0) {
                b0 = a;
            }
            if (c1) {
                b1 = a;
            }
            if (c2) {
                b2 = a;
            }
            if (c3) {
                b3 = a;
            }
        }
        int pix = 255;
        for (int i = 16; i >= 0; i -= 8) {
            double a0 = 0xFF & b0 >> i;
            double a1 = 0xFF & b1 >> i;
            double a2 = 0xFF & b2 >> i;
            double a3 = 0xFF & b3 >> i;
            int p = (int)(this.bilineaire(x1, y1, x2, y2, x, y, a0, a1, a2, a3) + 0.5);
            if (p < 0) {
                p = 0;
            } else if (p > 255) {
                p = 255;
            }
            pix = pix << 8 | p;
        }
        return pix;
    }

    private double bilineaire(int x1, int y1, int x2, int y2, double x, double y, double a0, double a1, double a2, double a3) {
        double d3;
        double d2;
        double d1;
        double d0;
        if (x == (double)x1) {
            d0 = 1.0;
            d1 = 0.0;
        } else if (x == (double)x2) {
            d0 = 0.0;
            d1 = 1.0;
        } else {
            d0 = 1.0 / (x - (double)x1);
            d1 = 1.0 / ((double)x2 - x);
        }
        if (y == (double)y1) {
            d2 = 1.0;
            d3 = 0.0;
        } else if (y == (double)y2) {
            d2 = 0.0;
            d3 = 1.0;
        } else {
            d2 = 1.0 / (y - (double)y1);
            d3 = 1.0 / ((double)y2 - y);
        }
        double pA = (a0 * d0 + a1 * d1) / (d0 + d1);
        double pB = (a2 * d0 + a3 * d1) / (d0 + d1);
        return (pA * d2 + pB * d3) / (d2 + d3);
    }

    public void get(String theUrl, String filename) throws IOException {
        try {
            String inputLine;
            URL gotoUrl = new URL(theUrl);
            InputStreamReader isr = new InputStreamReader(gotoUrl.openStream());
            BufferedReader in = new BufferedReader(isr);
            StringBuffer sb = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                sb.append(inputLine + "\r\n");
            }
            ThreadBuilderTile.createAFile(filename, sb.toString());
        }
        catch (MalformedURLException mue) {
            mue.printStackTrace();
        }
        catch (IOException ioe) {
            throw ioe;
        }
    }

    private static void createAFile(String outfile, String content) throws IOException {
        FileOutputStream fileoutputstream = new FileOutputStream(outfile);
        DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);
        dataoutputstream.writeBytes(content);
        dataoutputstream.flush();
        dataoutputstream.close();
    }

    private String getPath(String s) throws Exception {
        if (s.charAt(0) != '{') {
            return s;
        }
        int o = s.indexOf("path");
        int o1 = s.indexOf(58, o);
        int o2 = s.indexOf(34, o1 + 1);
        int o3 = s.indexOf(34, o2 + 1);
        return s.substring(o2 + 1, o3);
    }

    private long getCellMem(String s) throws Exception {
        int o = s.indexOf("cellmem");
        if (s.charAt(0) == '{' && o > -1) {
            int o1 = s.indexOf(58, o);
            int o2 = s.indexOf(34, o1 + 1);
            int o3 = s.indexOf(34, o2 + 1);
            try {
                return Integer.parseInt(s.substring(o2 + 1, o3));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return Constante.ORIGCELLWIDTH * Constante.ORIGCELLWIDTH * (this.context.bitpixOrig == 0 ? 32 : Math.abs(this.context.bitpixOrig) / 8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean askLocalFinder(BuilderTiles bt, ArrayList<SrcFile> downFiles, String path, int order, long npix, double blank) {
        String hpxfilename = path + cds.tools.Util.FS + Util.getFilePath("", order, npix);
        File f = new File(hpxfilename);
        String line = null;
        String fitsfilename = null;
        if (f.exists()) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(f));
                int n = 0;
                while ((line = reader.readLine()) != null) {
                    fitsfilename = this.getPath(line);
                    long cellMem = this.getCellMem(line);
                    try {
                        Fits fitsfile = new Fits();
                        fitsfile.setFilename(fitsfilename);
                        SrcFile file = new SrcFile(fitsfilename, cellMem);
                        file.fitsfile = fitsfile;
                        downFiles.add(file);
                    }
                    catch (Exception e) {
                        System.err.println("Erreur de chargement de : " + fitsfilename);
                        e.printStackTrace();
                    }
                    ++n;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {}
                }
            }
            return true;
        }
        return false;
    }

    private Shape getShape(Fits fits) {
        Shape sh = null;
        try {
            File parent = new File(this.context.getInputPath()).getParentFile();
            String last = parent == null ? null : parent.getCanonicalPath();
            for (File dir = new File(fits.getFilename()); sh == null && dir != null && !dir.getCanonicalPath().equals(last); dir = dir.getParentFile()) {
                sh = this.getShape(dir);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Shape getShape(File dir) {
        Shape sh = null;
        if (hasShape.containsKey(dir)) {
            return hasShape.get(dir);
        }
        HashMap<File, Shape> hashMap = hasShape;
        synchronized (hashMap) {
            File f;
            String file;
            if (hasShape.containsKey(dir)) {
                return hasShape.get(dir);
            }
            if (dir.isDirectory()) {
                file = dir.getAbsoluteFile() + ".fov";
            } else {
                String parent;
                String name = dir.getName();
                int dot = name.lastIndexOf(46);
                if (dot > 0) {
                    name = name.substring(0, dot);
                }
                file = (parent = dir.getParent()) == null ? null : parent + Util.FS + name + ".fov";
            }
            File file2 = f = file == null ? null : new File(file);
            if (f != null && f.isFile()) {
                FileInputStream fr = null;
                try {
                    String s;
                    fr = new FileInputStream(f);
                    InputStreamReader in = new InputStreamReader(fr);
                    BufferedReader dis = new BufferedReader(in);
                    StringBuilder res = new StringBuilder();
                    while ((s = dis.readLine()) != null) {
                        if (res.length() > 0) {
                            res.append(' ');
                        }
                        res.append(s.trim());
                    }
                    dis.close();
                    in.close();
                    sh = Context.createFov(res.toString());
                    if (sh != null) {
                        this.context.info("FoV detected: " + f.getName() + " => " + this.shape2String(sh));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (fr != null) {
                        try {
                            fr.close();
                        }
                        catch (Exception e1) {}
                    }
                }
            }
            hasShape.put(dir, sh);
            return sh;
        }
    }

    private String shape2String(Shape shape) {
        StringBuilder rep = new StringBuilder();
        if (shape instanceof Polygon) {
            int i;
            Polygon pol = (Polygon)shape;
            for (i = 0; i < pol.npoints && i < 5; ++i) {
                if (i > 0) {
                    rep.append(' ');
                }
                rep.append(pol.xpoints[i] + "," + pol.ypoints[i]);
            }
            if (i < pol.npoints) {
                rep.append("...");
            }
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D ell = (Ellipse2D)shape;
            rep.append("circle(" + ell.getCenterX() + "," + ell.getCenterY() + "," + ell.getWidth() / 2.0 + ")");
        }
        return rep.toString();
    }

    class SrcFile {
        Fits fitsfile;
        long cellMem;
        int isOpened = -1;
        String name = null;
        double blank;
        Shape shape = null;
        boolean flagRemoved = false;

        SrcFile(String name, long cellMem) {
            this.name = name;
            this.cellMem = cellMem;
        }

        public String toString() {
            return this.fitsfile.getFilename();
        }

        protected void open(int frame) throws Exception {
            this.open(frame, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void open(int frame, boolean gauss) throws Exception {
            if (this.isOpened == frame) {
                return;
            }
            SrcFile srcFile = this;
            synchronized (srcFile) {
                int mode;
                if (this.isOpened != -1) {
                    this.fitsfile.rmUser();
                }
                int n = this.name.endsWith(".hhh") || this.name.indexOf(".hhh[") > 0 ? 4 : (this.name.endsWith(".jpg") || this.name.indexOf(".jpg[") > 0 ? 1 : (mode = this.name.endsWith(".png") || this.name.indexOf(".png[") > 0 ? 2 : 0));
                if (mode == 0 && ThreadBuilderTile.this.bitpix == 0) {
                    this.fitsfile.loadFITS(this.name, true, true);
                } else {
                    if (((ThreadBuilderTile)ThreadBuilderTile.this).context.depth > 1 || frame > 0) {
                        this.name = this.addFrameToName(this.name, frame);
                    }
                    try {
                        this.fitsfile = ((ThreadBuilderTile)ThreadBuilderTile.this).context.cacheFits.getFits(this.name, mode, true, false);
                    }
                    catch (MyInputStreamCachedException e) {
                        ThreadBuilderTile.this.context.taskAbort();
                        throw new Exception();
                    }
                }
                if (((ThreadBuilderTile)ThreadBuilderTile.this).context.scanFov) {
                    this.shape = ThreadBuilderTile.this.getShape(this.fitsfile);
                }
                this.fitsfile.addUser();
                MyInputStreamCached.incActiveFile(this.name);
                this.blank = !ThreadBuilderTile.this.hasAlternateBlank ? this.fitsfile.blank : ThreadBuilderTile.this.blankOrig;
                this.isOpened = frame;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void release() {
            if (this.isOpened == -1) {
                return;
            }
            SrcFile srcFile = this;
            synchronized (srcFile) {
                this.fitsfile.rmUser();
                MyInputStreamCached.decActiveFile(this.name);
                this.isOpened = -1;
            }
        }

        String addFrameToName(String name, int frame) throws Exception {
            Fits tmp = new Fits();
            tmp.loadHeaderFITS(name);
            tmp.zCell = frame;
            tmp.depthCell = 1;
            return tmp.getFileNameExtended();
        }
    }
}

