/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.PlanBG;
import cds.aladin.PlanImage;
import cds.aladin.prop.PropPanel;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.MainPanel;
import cds.allsky.Task;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.ColorModel;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class TabJpg
extends JPanel
implements ActionListener {
    private String CUT_MAX = "Max";
    private String CUT_MIN = "Min";
    private JTextField tCutMin = new JTextField(10);
    private JTextField tCutMax = new JTextField(10);
    private JLabel label;
    private JRadioButton radioManual;
    private JRadioButton radioAllsky;
    private JLabel labelMethod;
    private JRadioButton radioMediane;
    private JRadioButton radioMoyenne;
    private JLabel labelFormat;
    private JRadioButton jpegFormat;
    private JRadioButton pngFormat;
    private JLabel currentCM;
    private JLabel warning;
    private JButton start;
    private JButton abort;
    private JButton pause;
    private JButton next;
    private JButton previous;
    private JButton moc;
    private JProgressBar progressJpg = new JProgressBar(0, 100);
    private final MainPanel mainPanel;
    private Context context;
    private JLabel tileStat;
    private JLabel timeStat;

    private String getString(String k) {
        MainPanel mainPanel = this.mainPanel;
        return mainPanel.aladin.getChaine().getString(k);
    }

    public TabJpg(MainPanel mainPanel) {
        super(new BorderLayout());
        JLabel l;
        JRadioButton rb;
        JLabel lab;
        this.mainPanel = mainPanel;
        this.context = mainPanel.context;
        ButtonGroup bg = new ButtonGroup();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = 17;
        c.fill = 0;
        c.gridwidth = 0;
        JPanel pCenter = new JPanel();
        pCenter.setLayout(new GridBagLayout());
        pCenter.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 25));
        this.warning = new JLabel(" ");
        this.warning.setFont(this.warning.getFont().deriveFont(1));
        this.warning.setForeground(Color.red);
        c.gridheight = 2;
        c.insets.bottom = 20;
        pCenter.add((Component)this.warning, c);
        c.insets.bottom = 5;
        ++c.gridy;
        ++c.gridy;
        this.label = lab = new JLabel(Util.fold(this.getString("JPEGINFOALLSKY"), 80, true));
        lab.setFont(lab.getFont().deriveFont(2));
        c.gridheight = 5;
        pCenter.add((Component)lab, c);
        c.insets.bottom = 0;
        ++c.gridy;
        ++c.gridy;
        ++c.gridy;
        ++c.gridy;
        ++c.gridy;
        c.gridheight = 1;
        this.currentCM = new JLabel();
        boolean manualSelected = !this.updateCurrentCM();
        c.gridx = 0;
        ++c.gridy;
        this.radioManual = rb = new JRadioButton(this.getString("JPEGMCUTALLSKY"));
        rb.setSelected(manualSelected);
        this.tCutMin.setEnabled(manualSelected);
        this.tCutMax.setEnabled(manualSelected);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = TabJpg.this.radioManual.isSelected();
                TabJpg.this.tCutMin.setEnabled(enable);
                TabJpg.this.tCutMax.setEnabled(enable);
            }
        });
        rb.setFont(rb.getFont().deriveFont(1));
        bg.add(rb);
        pCenter.add((Component)rb, c);
        ++c.gridx;
        c.gridwidth = 0;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPJPEGMCUTALLSKY")), c);
        c.gridwidth = 2;
        c.gridx = 0;
        ++c.gridy;
        JPanel minmax = new JPanel(new FlowLayout());
        lab = new JLabel(this.CUT_MIN);
        minmax.add(lab);
        minmax.add(this.tCutMin);
        lab = new JLabel(this.CUT_MAX);
        minmax.add(lab);
        minmax.add(this.tCutMax);
        pCenter.add((Component)minmax, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        int m = c.insets.top;
        c.insets.top = 20;
        this.radioAllsky = rb = new JRadioButton(this.getString("JPEGCUTALLSKY"));
        rb.setSelected(!manualSelected);
        rb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enable = TabJpg.this.radioManual.isSelected();
                TabJpg.this.tCutMin.setEnabled(enable);
                TabJpg.this.tCutMax.setEnabled(enable);
            }
        });
        rb.setFont(rb.getFont().deriveFont(1));
        rb.setSelected(true);
        bg.add(rb);
        pCenter.add((Component)rb, c);
        ++c.gridx;
        c.gridwidth = 0;
        pCenter.add((Component)Util.getHelpButton(this, this.getString("HELPJPEGCUTALLSKY")), c);
        c.insets.top = m;
        c.gridx = 0;
        ++c.gridy;
        pCenter.add((Component)this.currentCM, c);
        c.gridx = 0;
        ++c.gridy;
        m = c.insets.top;
        c.insets.top = 20;
        JPanel p = new JPanel();
        this.labelFormat = l = new JLabel(this.getString("FORMATTILES"));
        l.setFont(l.getFont().deriveFont(1));
        p.add(l);
        ButtonGroup bg1 = new ButtonGroup();
        this.jpegFormat = rb = new JRadioButton("JPEG");
        bg1.add(rb);
        p.add(rb);
        this.pngFormat = rb = new JRadioButton("PNG");
        rb.setSelected(true);
        bg1.add(rb);
        p.add(rb);
        pCenter.add((Component)p, c);
        c.insets.top = m;
        c.gridx = 0;
        ++c.gridy;
        p = new JPanel();
        this.labelMethod = l = new JLabel(this.getString("METHODJPG"));
        l.setFont(l.getFont().deriveFont(1));
        p.add(l);
        bg1 = new ButtonGroup();
        this.radioMediane = rb = new JRadioButton(this.getString("MEDIANJPG"));
        rb.setSelected(true);
        bg1.add(rb);
        p.add(rb);
        this.radioMoyenne = rb = new JRadioButton(this.getString("AVERAGEJPG"));
        bg1.add(rb);
        p.add(rb);
        pCenter.add((Component)p, c);
        this.progressJpg.setStringPainted(true);
        c.fill = 2;
        c.gridwidth = 0;
        ++c.gridy;
        c.gridx = 0;
        JPanel pProgress = new JPanel(new BorderLayout());
        pProgress.setBorder(new EmptyBorder(0, 55, 15, 55));
        pProgress.add((Component)this.progressJpg, "Center");
        pProgress.add((Component)this.createStatPanel(), "South");
        JPanel fin = new JPanel(new BorderLayout());
        JPanel pBtn = new JPanel();
        pBtn.setLayout(new BoxLayout(pBtn, 0));
        pBtn.add(Box.createHorizontalGlue());
        this.previous = new JButton(this.getString("PREVIOUS"));
        this.previous.addActionListener(this);
        this.previous.addActionListener(this);
        pBtn.add(this.previous);
        this.moc = new JButton(this.getString("LOADMOCP"));
        this.moc.addActionListener(this);
        pBtn.add(this.moc);
        this.start = new JButton(this.getString("JPEGBUILDALLSKY"));
        this.start.addActionListener(this);
        pBtn.add(this.start);
        this.pause = new JButton(this.getString("PAUSE"));
        this.pause.addActionListener(this);
        pBtn.add(this.pause);
        this.abort = new JButton(this.getString("ABORT"));
        this.abort.addActionListener(this);
        pBtn.add(this.abort);
        pBtn.add(Box.createRigidArea(new Dimension(10, 0)));
        this.next = new JButton(this.getString("NEXT"));
        this.next.addActionListener(this);
        this.next.addActionListener(this);
        pBtn.add(this.next);
        pBtn.add(Box.createHorizontalGlue());
        fin.add((Component)pProgress, "North");
        fin.add((Component)pBtn, "Center");
        this.add((Component)pCenter, "Center");
        this.add((Component)fin, "South");
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.start) {
            if (!this.radioManual.isSelected()) {
                try {
                    PlanBG p = (PlanBG)this.mainPanel.aladin.calque.getPlanBase();
                    if (!p.isTruePixels()) {
                        throw new Exception();
                    }
                }
                catch (Exception e1) {
                    Aladin cfr_ignored_0 = this.mainPanel.aladin;
                    Aladin.error(this.mainPanel, "<html>There is no current view,<br>or the current view is not an all-sky view in true pixel mode");
                    return;
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.context.setJpegMethod(this.getMethod());
            this.context.setProgressBar(this.progressJpg);
            Action action = this.getTileFormat() == 0 ? Action.PNG : Action.JPEG;
            this.context.setValidateCut(false);
            try {
                new Task(this.context, action, false);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        } else if (e.getSource() == this.abort) {
            this.abort();
        } else if (e.getSource() == this.pause) {
            this.pause();
        } else if (e.getSource() == this.next) {
            this.mainPanel.showPubTab();
        } else if (e.getSource() == this.previous) {
            this.mainPanel.showBuildTab();
        } else if (e.getSource() == this.moc) {
            this.loadMoc();
        }
        this.resumeWidgets();
    }

    private void pause() {
        if (this.context.isTaskPause()) {
            this.context.setTaskPause(false);
            this.pause.setText(this.getString("PAUSE"));
        } else {
            this.context.setTaskPause(true);
            this.pause.setText(this.getString("RESUME"));
        }
    }

    private void abort() {
        if (!Aladin.confirmation(this.mainPanel, "Do you really want to abort the compressed tile computation ?")) {
            return;
        }
        this.context.taskAbort();
    }

    private void loadMoc() {
        String mocFile = this.context.getOutputPath() + Util.FS + "Moc.fits";
        this.mainPanel.aladin.execAsyncCommand("load " + mocFile);
    }

    private JPanel createStatPanel() {
        GridBagLayout g = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(2, 10, 2, 2);
        JPanel p = new JPanel(g);
        this.tileStat = new JLabel("--");
        PropPanel.addCouple(p, ".Tiles: ", this.tileStat, g, c);
        this.timeStat = new JLabel("--");
        PropPanel.addCouple(p, ".Time: ", this.timeStat, g, c);
        return p;
    }

    protected void setStat(String sTile, String sTime) {
        this.tileStat.setText(sTile);
        this.timeStat.setText(sTime);
    }

    public void setCutMin(String s) {
        this.tCutMin.setText(s);
    }

    public void setCutMax(String s) {
        this.tCutMax.setText(s);
    }

    public String getCutMin() {
        return this.tCutMin.getText().trim();
    }

    public String getCutMax() {
        return this.tCutMax.getText().trim();
    }

    private boolean isExistingMoc() {
        String moc = this.context.getOutputPath() + Util.FS + "Moc.fits";
        return moc != null && new File(moc).exists();
    }

    public boolean isCutFromPlanBase() {
        return !this.radioManual.isSelected();
    }

    public ColorModel getCM() {
        if (this.radioManual.isSelected()) {
            return null;
        }
        return ((PlanImage)this.mainPanel.aladin.calque.getPlanBase()).getCM();
    }

    public Context.JpegMethod getMethod() {
        if (this.radioMediane.isSelected()) {
            return Context.JpegMethod.MEDIAN;
        }
        return Context.JpegMethod.MEAN;
    }

    public int getTileFormat() {
        if (this.pngFormat.isSelected()) {
            return 0;
        }
        return 1;
    }

    protected void resumeWidgets() {
        block2: {
            try {
                boolean readyToDo = this.context.isExistingDir() || this.context.isExistingAllskyDir();
                boolean isRunning = this.context.isTaskRunning();
                boolean isColor = this.context.isColor();
                this.moc.setEnabled(this.isExistingMoc());
                this.previous.setEnabled(readyToDo && !isRunning);
                this.next.setEnabled(readyToDo && !isRunning);
                this.tCutMin.setEnabled(readyToDo && !isColor);
                this.tCutMax.setEnabled(readyToDo && !isColor);
                this.radioManual.setEnabled(readyToDo && !isColor);
                this.labelMethod.setEnabled(readyToDo && !isColor);
                this.radioAllsky.setEnabled(readyToDo && !isColor);
                this.radioMediane.setEnabled(readyToDo && !isRunning && !isColor);
                this.radioMoyenne.setEnabled(readyToDo && !isRunning && !isColor);
                this.labelFormat.setEnabled(readyToDo && !isColor);
                this.jpegFormat.setEnabled(readyToDo && !isColor);
                this.pngFormat.setEnabled(readyToDo && !isColor);
                this.progressJpg.setEnabled(readyToDo && !isRunning && !isColor);
                this.start.setEnabled(readyToDo && !isRunning && !isColor);
                this.pause.setEnabled(isRunning);
                this.abort.setEnabled(isRunning);
                this.setCursor(isRunning ? Cursor.getPredefinedCursor(3) : Cursor.getPredefinedCursor(0));
                this.warning.setText(isColor ? Util.fold(this.getString("MNOPOST"), 60, true) : "");
                this.label.setEnabled(!isColor);
            }
            catch (Exception e) {
                if (Aladin.levelTrace < 3) break block2;
                e.printStackTrace();
            }
        }
    }

    public void clearForms() {
        this.tCutMin.setText("");
        this.tCutMax.setText("");
        this.radioManual.setSelected(true);
        this.radioMediane.setSelected(true);
        this.progressJpg.setValue(0);
        this.jpegFormat.setSelected(true);
    }

    public void setStartEnabled(boolean enabled) {
        this.start.setEnabled(enabled);
        this.next.setEnabled(enabled);
    }

    @Override
    public void show() {
        this.updateCurrentCM();
        this.resumeWidgets();
        super.show();
    }

    public boolean updateCurrentCM() {
        String s;
        boolean rep = true;
        try {
            PlanImage p = (PlanImage)this.mainPanel.aladin.calque.getPlanBase();
            if (!p.hasAvailablePixels()) {
                throw new Exception();
            }
            s = "<html><i>Pixels:<b> " + p.getPixelMinInfo() + " .. " + p.getPixelMaxInfo() + "</b> from " + p.getDataMinInfo() + " .. " + p.getDataMaxInfo() + " - " + "Transfert function: <b>" + p.getTransfertFctInfo() + "</b></i>";
        }
        catch (Exception e1) {
            s = "<html><i>No compatible image/survey presently displayed !</i>";
            rep = false;
        }
        this.currentCM.setText(s);
        return rep;
    }
}

