/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.allsky.BuilderLint;
import cds.allsky.Context;
import cds.mocmulti.MultiMoc;
import cds.tools.Util;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class HipsLint {
    static boolean flagColor = false;
    private static boolean TERM = false;

    private void check(String hipsListUrl) throws Exception {
        boolean mocServerReading = true;
        Context context = new Context();
        boolean flagError = false;
        boolean flagWarning = false;
        boolean flagException = false;
        context.info(Context.getTitle("CHECKING HiPSserver [" + hipsListUrl + "]", '='));
        InputStreamReader in = new InputStreamReader((InputStream)Util.openAnyStream(hipsListUrl, false, false, BuilderLint.TIMEOUT), "UTF-8");
        while (mocServerReading) {
            try {
                context = new Context();
                if (flagColor) {
                    context.setTerm(TERM);
                }
                MyProperties prop = new MyProperties();
                mocServerReading = prop.loadRecord(in);
                String id = MultiMoc.getID(prop);
                if (prop.size() == 0 || id == null) continue;
                context.run(Context.getTitle("Checking HiPSList record [" + id + "]"));
                String s = prop.get("creator_did");
                if (s == null) {
                    context.error("Lint[5.2] HiPSList \"creator_did\" keyword is mandatory");
                    flagError = true;
                }
                if ((s = prop.get("hips_release_date")) == null) {
                    context.error("Lint[5.2] HiPSList \"hips_release_date\" keyword is mandatory");
                    flagError = true;
                } else {
                    context.info("Lint: \"hips_release_date\" [" + s + "]");
                    if (!BuilderLint.checkDate(s)) {
                        context.error("Lint[4.4.1] HiPSList not ISO 8601 date [" + s + "]");
                        flagError = true;
                    }
                }
                s = prop.get("hips_status");
                if (s == null) {
                    context.error("Lint[5.2] HiPSList \"hips_status\" keyword is mandatory");
                    flagError = true;
                } else {
                    context.info("Lint: \"hips_status\" [" + s + "]");
                    StringBuilder statusUnref = null;
                    boolean flagPub = false;
                    boolean flagMirror = false;
                    boolean flagClone = false;
                    StringTokenizer tok = new StringTokenizer(s, " ");
                    while (tok.hasMoreTokens()) {
                        String s1 = tok.nextToken();
                        int i = Util.indexInArrayOf(s1, BuilderLint.STATUS_PUB);
                        if (i >= 0) {
                            if (flagPub) {
                                context.error("Lint[4.4.1] hips_status error redundant definition [private/public]");
                                flagError = true;
                            } else {
                                flagPub = true;
                            }
                        } else {
                            i = Util.indexInArrayOf(s1, BuilderLint.STATUS_MIRROR);
                            if (i >= 0) {
                                if (flagMirror) {
                                    context.error("Lint[4.4.1] hips_status error redundant definition [master/mirror/partial]");
                                    flagError = true;
                                } else {
                                    flagMirror = true;
                                }
                            } else {
                                i = Util.indexInArrayOf(s1, BuilderLint.STATUS_CLONE);
                                if (i >= 0) {
                                    if (flagClone) {
                                        context.error("Lint[4.4.1] hips_status error redundant definition [clonable/unclonable/clonableOnce]");
                                        flagError = true;
                                    } else {
                                        flagClone = true;
                                    }
                                } else if (s1.indexOf(",") > 0) {
                                    context.error("Lint[4.4.1] hips_status comma separator error [" + s1 + "]");
                                    flagError = true;
                                } else if (statusUnref == null) {
                                    statusUnref = new StringBuilder(s1);
                                } else {
                                    statusUnref.append("," + s1);
                                }
                            }
                        }
                        if (statusUnref == null) continue;
                        context.warning("Lint: unreferenced hips_status keywords [" + statusUnref + "]");
                    }
                }
                String u = s = prop.get("hips_service_url");
                if (s == null) {
                    context.error("Lint[5.2] HiPSList \"hips_service_url\" keyword is mandatory");
                    flagError = true;
                }
                context.info(Context.getTitle("Checking HiPS [" + id + "]"));
                context.setOutputPath(u);
                BuilderLint builderLint = new BuilderLint(context);
                try {
                    int rep = builderLint.lint();
                    if (rep == 0) {
                        flagError = true;
                        continue;
                    }
                    if (rep != -1) continue;
                    flagWarning = true;
                }
                catch (Exception e) {
                    flagException = true;
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        in.close();
        if (flagException) {
            context.info("!!! [" + hipsListUrl + "] has not been fully checked => partial validation");
        }
        if (flagError) {
            context.info("*** [" + hipsListUrl + "] is not IVOA HiPS 1.0 compatible");
        } else if (flagWarning) {
            context.info("!!! [" + hipsListUrl + "] is IVOA HiPS 1.0 compatible but with warnings !");
        } else {
            context.info("*** [" + hipsListUrl + "] is fully IVOA HiPS 1.0 compatible");
        }
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("-h")) {
            System.out.println("Usage: java -jar Hipslint [-color|-nocolor] http://hips.server/hipslist [hipslisturl2 ...]");
            System.out.println("       HiPS server compatibility checker (IVOA HiPS 1.0 standard)");
            System.exit(0);
        }
        if (args.length > 1) {
            String[] args1 = new String[args.length - 1];
            int i = 0;
            int j = 0;
            while (i < args.length) {
                if (args[i].equalsIgnoreCase("-color")) {
                    TERM = true;
                    --j;
                    flagColor = true;
                } else if (args[i].equalsIgnoreCase("-nocolor")) {
                    TERM = false;
                    --j;
                    flagColor = true;
                } else if (j < args1.length) {
                    args1[j] = args[i];
                }
                ++i;
                ++j;
            }
            if (flagColor) {
                args = args1;
            }
        }
        try {
            HipsLint lint = new HipsLint();
            for (String hipsListUrl : args) {
                lint.check(hipsListUrl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

