/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.allsky.MyInputStreamCached;
import cds.allsky.Task;
import cds.moc.SMoc;
import cds.tools.Util;
import cds.tools.pixtools.CDSHealpix;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.Vector;

public class HipsGen {
    private File file;
    private boolean force = false;
    private boolean flagMode = false;
    private boolean flagConcat = false;
    private boolean flagMirror = false;
    private boolean flagZip = false;
    private boolean flagUpdate = false;
    private boolean flagLint = false;
    private boolean flagTMoc = false;
    private boolean flagTIndex = false;
    private boolean flagMocError = false;
    private boolean flagProp = false;
    private boolean flagMethod = false;
    private boolean flagRGB = false;
    private boolean flagGunzip = false;
    private boolean flagMapFits = false;
    private boolean flagAbort = false;
    private boolean flagPause = false;
    private boolean flagResume = false;
    public Context context = new Context();
    public boolean endOfWork = true;
    private String cache = null;
    private long cacheSize = -1L;
    private boolean cacheRemoveOnExit = true;
    public String launcher = "Aladin.jar -hipsgen";
    private Vector<Action> actions = new Vector();
    public static SimpleDateFormat SDF = new SimpleDateFormat("dd/MM/yy HH:mm:ss");

    private void parseConfig() throws Exception {
        MyProperties properties = new MyProperties();
        InputStreamReader reader = new InputStreamReader(new BufferedInputStream(new FileInputStream(this.file)));
        properties.load(reader);
        for (String opt : properties.getKeys()) {
            if (opt.startsWith("#")) continue;
            String val = properties.getProperty(opt);
            try {
                this.setContextFromOptions(opt, val);
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        reader.close();
    }

    private String obsolete(String s) {
        if (s.equalsIgnoreCase("ivorn")) {
            return "creator_did";
        }
        if (s.equalsIgnoreCase("id")) {
            return "creator_did";
        }
        if (s.equalsIgnoreCase("input")) {
            return "in";
        }
        if (s.equalsIgnoreCase("output")) {
            return "out";
        }
        if (s.equalsIgnoreCase("pixel")) {
            return "mode";
        }
        if (s.equalsIgnoreCase("moc")) {
            return "region";
        }
        if (s.equalsIgnoreCase("blocking")) {
            return "partitioning";
        }
        if (s.equalsIgnoreCase("cutting")) {
            return "partitioning";
        }
        if (s.equalsIgnoreCase("polygon")) {
            return "fov";
        }
        if (s.equalsIgnoreCase("jpegMethod")) {
            return "method";
        }
        if (s.equalsIgnoreCase("dataCut")) {
            return "hips_data_range";
        }
        if (s.equalsIgnoreCase("pixelRange")) {
            return "hips_data_range";
        }
        if (s.equalsIgnoreCase("pixelCut")) {
            return "hips_pixel_cut";
        }
        if (s.equalsIgnoreCase("histoPercent")) {
            return "skyval";
        }
        if (s.equalsIgnoreCase("publisher")) {
            return "creator";
        }
        if (s.equalsIgnoreCase("label")) {
            return "obs_title";
        }
        if (s.equalsIgnoreCase("publisher")) {
            return "hips_creator";
        }
        if (s.equalsIgnoreCase("creator")) {
            return "hips_creator";
        }
        if (s.equalsIgnoreCase("pixel")) {
            return "mode";
        }
        if (s.equalsIgnoreCase("status")) {
            return "hips_status";
        }
        if (s.equalsIgnoreCase("order")) {
            return "hips_order";
        }
        if (s.equalsIgnoreCase("minOrder")) {
            return "hips_min_order";
        }
        if (s.equalsIgnoreCase("frame")) {
            return "hips_frame";
        }
        if (s.equalsIgnoreCase("bitpix")) {
            return "hips_pixel_bitpix";
        }
        return null;
    }

    private void setContextFromOptions(String opt, String val) throws Exception {
        if (val != null) {
            val = val.replace("'", "");
            val = val.replace("\"", "");
        }
        System.out.println("OPTION: " + opt + "=" + (val == null ? "null" : val));
        String alt = this.obsolete(opt);
        if (alt != null) {
            this.context.warning("Deprecated parameter, use \"" + alt + "\"");
            opt = alt;
        }
        if (opt.equalsIgnoreCase("h")) {
            HipsGen.usage(this.launcher);
        } else if (opt.equalsIgnoreCase("cache")) {
            this.cache = val;
        } else if (opt.equalsIgnoreCase("cacheSize")) {
            this.cacheSize = Long.parseLong(val);
        } else if (opt.equalsIgnoreCase("cacheRemoveOnExit")) {
            this.cacheRemoveOnExit = Boolean.parseBoolean(val);
        } else if (opt.equalsIgnoreCase("hhh")) {
            this.generateHHH(val);
        } else if (opt.equalsIgnoreCase("split")) {
            this.context.setSplit(val);
        } else if (opt.equalsIgnoreCase("verbose")) {
            Context.setVerbose(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("pilot")) {
            this.context.setPilot(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("blank")) {
            this.context.setBlankOrig(Double.parseDouble(val));
        } else if (opt.equalsIgnoreCase("hips_order")) {
            this.context.setOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("mocOrder")) {
            this.context.setMocOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("nside")) {
            this.context.setMapNside(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("tileOrder")) {
            this.context.setTileOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("hips_tile_width")) {
            this.context.setTileOrder((int)CDSHealpix.log2(Integer.parseInt(val)));
        } else if (opt.equalsIgnoreCase("hips_pixel_bitpix")) {
            this.context.setBitpix(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("hips_frame")) {
            this.context.setFrameName(val);
        } else if (opt.equalsIgnoreCase("maxThread")) {
            this.context.setMaxNbThread(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("skyval")) {
            this.context.setSkyval(val);
        } else if (opt.equalsIgnoreCase("skyvalues")) {
            this.context.setSkyValues(val);
        } else if (opt.equalsIgnoreCase("exptime")) {
            this.context.setExpTime(val);
        } else if (opt.equalsIgnoreCase("fading")) {
            this.context.setFading(val);
        } else if (opt.equalsIgnoreCase("mixing")) {
            this.context.setMixing(val);
        } else if (opt.equalsIgnoreCase("color")) {
            this.context.setColor(val);
        } else if (opt.equalsIgnoreCase("inRed")) {
            this.context.setRgbInput(val, 0);
            this.flagRGB = true;
        } else if (opt.equalsIgnoreCase("inGreen")) {
            this.context.setRgbInput(val, 1);
            this.flagRGB = true;
        } else if (opt.equalsIgnoreCase("inBlue")) {
            this.context.setRgbInput(val, 2);
            this.flagRGB = true;
        } else if (opt.equalsIgnoreCase("cmRed")) {
            this.context.setRgbCmParam(val, 0);
        } else if (opt.equalsIgnoreCase("cmGreen")) {
            this.context.setRgbCmParam(val, 1);
        } else if (opt.equalsIgnoreCase("cmBlue")) {
            this.context.setRgbCmParam(val, 2);
        } else if (opt.equalsIgnoreCase("luptonQ")) {
            this.context.setRgbLuptonQ(val);
        } else if (opt.equalsIgnoreCase("luptonM")) {
            this.context.setRgbLuptonM(val);
        } else if (opt.equalsIgnoreCase("luptonS")) {
            this.context.setRgbLuptonS(val);
        } else if (opt.equalsIgnoreCase("img")) {
            this.context.setImgEtalon(val);
        } else if (opt.equalsIgnoreCase("fitskeys")) {
            this.context.setIndexFitskey(val);
        } else if (opt.equalsIgnoreCase("hips_status")) {
            this.context.setStatus(val);
        } else if (opt.equalsIgnoreCase("target")) {
            this.context.setTarget(val);
        } else if (opt.equalsIgnoreCase("targetRadius")) {
            this.context.setTargetRadius(val);
        } else if (opt.equalsIgnoreCase("obs_title")) {
            this.context.setLabel(val);
        } else if (opt.equalsIgnoreCase("filter")) {
            this.context.setFilter(val);
        } else if (opt.equalsIgnoreCase("hdu")) {
            this.context.setHDU(val);
        } else if (opt.equalsIgnoreCase("hips_creator")) {
            this.context.setCreator(val);
        } else if (opt.equalsIgnoreCase("creator_did")) {
            this.context.setHipsId(val);
        } else if (opt.equalsIgnoreCase("debug")) {
            if (Boolean.parseBoolean(val)) {
                Context.setVerbose(4);
            }
        } else if (opt.equalsIgnoreCase("in")) {
            this.context.setInputPath(val);
        } else if (opt.equalsIgnoreCase("out")) {
            this.context.setOutputPath(val);
        } else if (opt.equalsIgnoreCase("mode")) {
            this.context.setMode(Mode.valueOf(val.toUpperCase()));
            this.flagMode = true;
        } else if (opt.equalsIgnoreCase("partitioning")) {
            this.context.setPartitioning(val);
        } else if (opt.equalsIgnoreCase("tileTypes")) {
            this.context.setTileFormat(val);
        } else if (opt.equalsIgnoreCase("shape")) {
            this.context.setShape(val);
        } else if (opt.equalsIgnoreCase("method")) {
            this.context.setMethod(val);
            this.flagMethod = true;
        } else if (opt.equalsIgnoreCase("histoPercent")) {
            this.context.setHistoPercent(val);
        } else if (opt.equalsIgnoreCase("pixelGood")) {
            this.context.setPixelGood(val);
        } else if (opt.equalsIgnoreCase("hips_pixel_cut")) {
            this.context.setPixelCut(val);
        } else if (opt.equalsIgnoreCase("hips_data_range")) {
            this.context.setDataCut(val);
        } else if (opt.equalsIgnoreCase("hips_min_order")) {
            this.context.setMinOrder(Integer.parseInt(val));
        } else if (opt.equalsIgnoreCase("region")) {
            if (val.endsWith("fits")) {
                SMoc moc = new SMoc();
                moc.read(val);
                this.context.setMocArea(moc);
            } else {
                this.context.setMocArea(val);
            }
        } else if (opt.equalsIgnoreCase("maxRatio")) {
            try {
                this.context.setMaxRatio(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (opt.equalsIgnoreCase("fov")) {
            try {
                this.context.setFov(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else if (opt.equalsIgnoreCase("border")) {
            try {
                this.context.setBorderSize(val);
            }
            catch (ParseException e) {
                throw new Exception(e.getMessage());
            }
        } else {
            throw new Exception("Option unknown [" + opt + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHHH(String s1) throws Exception {
        int origLon = -1;
        boolean flagLonInverse = true;
        Tok tok = new Tok(s1);
        String s = tok.nextToken();
        int i = s.lastIndexOf(File.separator);
        String path = i == -1 ? "" : s.substring(0, i + 1);
        int j = s.lastIndexOf(46);
        if (j == -1) {
            j = s.length();
        }
        String name = s.substring(i + 1, j);
        String ext = s.substring(j);
        s = tok.nextToken();
        i = s.indexOf(120);
        if (i > 0) {
            int ncol;
            int nlig;
            int hCell;
            int wCell;
            int width = Integer.parseInt(s.substring(0, i));
            int height = Integer.parseInt(s.substring(i + 1));
            if (tok.hasMoreTokens()) {
                s = tok.nextToken();
                i = s.indexOf(120);
                wCell = Integer.parseInt(s.substring(0, i));
                hCell = Integer.parseInt(s.substring(i + 1));
                if (tok.hasMoreTokens()) {
                    s = tok.nextToken();
                    origLon = Integer.parseInt(s);
                }
            } else {
                wCell = width;
                hCell = height;
            }
            boolean flagUniq = false;
            if (width == wCell && height == hCell) {
                flagUniq = true;
                nlig = 1;
                ncol = 1;
            } else {
                ncol = (int)Math.ceil((double)width / (double)wCell);
                nlig = (int)Math.ceil((double)height / (double)hCell);
            }
            double cd = 360.0 / (double)width;
            this.context.info("Generation of .hhh files for CAR " + ncol + "x" + nlig + " image(s) orig=" + origLon);
            int index = 0;
            for (int lig = 0; lig < nlig; ++lig) {
                int col = 0;
                while (col < ncol) {
                    String suffix = flagUniq ? "" : "-" + index;
                    String filename = path + name + suffix + ext;
                    File f = new File(filename);
                    if (!f.exists()) {
                        this.context.warning("Missing file => " + filename);
                    }
                    String filehhh = path + name + suffix + ".hhh";
                    int w = col == ncol - 1 ? width - col * wCell : wCell;
                    int h = lig == nlig - 1 ? height - lig * hCell : hCell;
                    int crpix1 = w / 2;
                    int crpix2 = h / 2;
                    int xc = col * wCell + crpix1;
                    int yc = lig * hCell + crpix2;
                    int deltaX = (origLon == -1 ? width / 2 : origLon) - xc;
                    int deltaY = height / 2 - yc;
                    double crval1 = (double)(-deltaX) * cd + (flagLonInverse ? -cd / 2.0 : cd / 2.0);
                    double crval2 = (double)deltaY * cd - cd / 2.0;
                    if (crval1 <= -180.0) {
                        crval1 += 360.0;
                    }
                    if (crval1 > 180.0) {
                        crval1 -= 360.0;
                    }
                    try (BufferedWriter t = null;){
                        t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filehhh)));
                        t.write("NAXIS1  = " + w);
                        t.newLine();
                        t.write("NAXIS2  = " + h);
                        t.newLine();
                        t.write("CRPIX1  = " + crpix1);
                        t.newLine();
                        t.write("CRPIX2  = " + crpix2);
                        t.newLine();
                        t.write("CRVAL1  = " + crval1);
                        t.newLine();
                        t.write("CRVAL2  = " + crval2);
                        t.newLine();
                        t.write("CTYPE1  = RA---CAR");
                        t.newLine();
                        t.write("CTYPE2  = DEC--CAR");
                        t.newLine();
                        t.write("CD1_1   = " + (flagLonInverse ? cd : -cd));
                        t.newLine();
                        t.write("CD1_2   = 0");
                        t.newLine();
                        t.write("CD2_1   = 0");
                        t.newLine();
                        t.write("CD2_2   = " + cd);
                        t.newLine();
                    }
                    ++col;
                    ++index;
                }
            }
        } else {
            int width = Integer.parseInt(s);
            double radius = Double.parseDouble(tok.nextToken());
            double cd = 2.0 * Math.tan(Math.toRadians((90.0 - radius) / 2.0)) * 114.59155902616465 / (double)width;
            double crval1 = flagLonInverse ? -cd / 2.0 : cd / 2.0;
            for (int k = 0; k < 2; ++k) {
                double crval2 = (double)(k == 0 ? 90 : -90) - cd / 2.0;
                String suffix = k == 0 ? "-N" : "-S";
                String filename = path + name + suffix + ext;
                File f = new File(filename);
                if (!f.exists()) {
                    this.context.warning("Missing file => " + filename);
                }
                String filehhh = path + name + suffix + ".hhh";
                try (BufferedWriter t = null;){
                    t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filehhh)));
                    t.write("NAXIS1  = " + width);
                    t.newLine();
                    t.write("NAXIS2  = " + width);
                    t.newLine();
                    t.write("CRPIX1  = " + width / 2);
                    t.newLine();
                    t.write("CRPIX2  = " + width / 2);
                    t.newLine();
                    t.write("CRVAL1  = " + crval1);
                    t.newLine();
                    t.write("CRVAL2  = " + crval2);
                    t.newLine();
                    t.write("CTYPE1  = RA---STG");
                    t.newLine();
                    t.write("CTYPE2  = DEC--STG");
                    t.newLine();
                    t.write("CD1_1   = " + (flagLonInverse ? cd : -cd));
                    t.newLine();
                    t.write("CD1_2   = 0");
                    t.newLine();
                    t.write("CD2_1   = 0");
                    t.newLine();
                    t.write("CD2_2   = " + cd);
                    t.newLine();
                }
                String filefov = path + name + suffix + ".fov";
                try {
                    t = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filefov)));
                    double xc = (double)width / 2.0;
                    double yc = (double)width / 2.0;
                    double r = (double)width / 2.0;
                    t.write(xc + " " + yc + " " + r);
                    t.newLine();
                    continue;
                }
                finally {
                    if (t != null) {
                        t.close();
                    }
                }
            }
            this.context.info("Generation of .hhh & .fov files for STG North and South image");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String[] args) {
        boolean all;
        block107: {
            int length = args.length;
            boolean first = true;
            if (length == 0) {
                HipsGen.usage(this.launcher);
                return;
            }
            for (String arg : args) {
                String param = "-param=";
                if (arg.startsWith(param)) {
                    try {
                        this.setConfigFile(arg.substring(param.length()));
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return;
                    }
                }
                if (arg.equalsIgnoreCase("-skygen") || arg.equalsIgnoreCase("-hipsgen")) continue;
                if (arg.equalsIgnoreCase("-h") || arg.equalsIgnoreCase("-help")) {
                    HipsGen.usage(this.launcher);
                    return;
                }
                if (first) {
                    first = false;
                    this.context.info("Starting HipsGen " + SDF.format(new Date()) + " (based on Aladin " + "v11.024" + ")...");
                }
                String q = Tok.quote(arg);
                this.context.scriptCommand = this.context.scriptCommand == null ? q : this.context.scriptCommand + " " + q;
                if (arg.equalsIgnoreCase("-debug") || arg.equalsIgnoreCase("-d")) {
                    Context.setVerbose(4);
                    continue;
                }
                if (arg.equalsIgnoreCase("-fast")) {
                    this.context.mixing = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-force") || arg.equalsIgnoreCase("-f")) {
                    this.force = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-nice")) {
                    this.context.mirrorDelay = 500;
                    continue;
                }
                if (arg.equalsIgnoreCase("-notouch")) {
                    this.context.notouch = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-nocolor")) {
                    this.context.setTerm(false);
                    continue;
                }
                if (arg.equalsIgnoreCase("-color")) {
                    this.context.setTerm(true);
                    continue;
                }
                if (arg.equalsIgnoreCase("-clone")) {
                    this.context.testClonable = false;
                    continue;
                }
                if (arg.equalsIgnoreCase("-live")) {
                    this.context.setLive(true);
                    continue;
                }
                if (arg.equalsIgnoreCase("-n")) {
                    this.context.fake = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-cds")) {
                    this.context.cdsLint = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("-check")) {
                    this.context.setMirrorCheck(true);
                    continue;
                }
                if (arg.contains("=")) {
                    String[] opts = arg.split("=");
                    try {
                        opts[0] = opts[0].substring(opts[0].indexOf(45) + 1);
                        this.setContextFromOptions(opts[0], opts[1]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.context.error(e.getMessage());
                        return;
                    }
                }
                try {
                    Action a = Action.valueOf(arg.toUpperCase());
                    if (a == Action.FINDER) {
                        a = Action.INDEX;
                    }
                    if (a == Action.PROGEN) {
                        a = Action.DETAILS;
                    }
                    if (a == Action.MIRROR) {
                        this.flagMirror = true;
                    }
                    if (a == Action.ZIP) {
                        this.flagZip = true;
                    }
                    if (a == Action.UPDATE) {
                        this.flagUpdate = true;
                    }
                    if (a == Action.GUNZIP) {
                        this.flagGunzip = true;
                    }
                    if (a == Action.LINT) {
                        this.flagLint = true;
                    }
                    if (a == Action.TMOC) {
                        this.flagTMoc = true;
                    }
                    if (a == Action.TINDEX) {
                        this.flagTIndex = true;
                    }
                    if (a == Action.PROP) {
                        this.flagProp = true;
                    }
                    if (a == Action.MOCERROR) {
                        this.flagMocError = true;
                    }
                    if (a == Action.CONCAT) {
                        this.flagConcat = true;
                        if (!this.flagMode) {
                            this.context.setMode(Mode.AVERAGE);
                        }
                    }
                    if (a == Action.ABORT) {
                        this.flagAbort = true;
                    }
                    if (a == Action.PAUSE) {
                        this.flagPause = true;
                    }
                    if (a == Action.RESUME) {
                        this.flagResume = true;
                    }
                    this.actions.add(a);
                }
                catch (Exception e) {
                    this.context.error("Unknown parameter [" + arg + "] !");
                    return;
                }
            }
            if (this.flagAbort) {
                try {
                    this.context.taskAbort();
                }
                catch (Exception e) {
                    this.context.error(e.getMessage());
                }
                return;
            }
            if (this.flagPause) {
                try {
                    this.context.setTaskPause(true);
                }
                catch (Exception e) {
                    this.context.error(e.getMessage());
                }
                return;
            }
            if (this.flagResume) {
                try {
                    this.context.setTaskPause(false);
                }
                catch (Exception e) {
                    this.context.error(e.getMessage());
                }
                return;
            }
            all = false;
            if (this.actions.size() == 0 && this.context.getInputPath() != null) {
                all = true;
                if (this.flagRGB) {
                    this.actions.add(Action.RGB);
                } else {
                    this.flagMapFits = false;
                    File f = new File(this.context.getInputPath());
                    if (!f.isDirectory() && f.exists()) {
                        try {
                            MyInputStream in = new MyInputStream(new FileInputStream(f));
                            in = in.startRead();
                            this.flagMapFits = (in.getType() & 0x100000000L) != 0L;
                            in.close();
                            this.context.setMap(this.flagMapFits);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (this.flagMapFits) {
                        this.actions.add(Action.MAPTILES);
                    } else {
                        this.actions.add(Action.INDEX);
                        this.actions.add(Action.TILES);
                    }
                    if (!this.context.isColor()) {
                        this.actions.add(Action.PNG);
                        if (!this.flagMapFits) {
                            this.actions.add(Action.DETAILS);
                        }
                    }
                }
            }
            try {
                if (this.context.hipsId == null && this.context.getOutputPath() != null) {
                    try {
                        String propFile = this.context.getOutputPath() + Util.FS + "properties";
                        MyProperties prop = new MyProperties();
                        File f = new File(propFile);
                        if (f.exists()) {
                            InputStreamReader in = new InputStreamReader(new BufferedInputStream(new FileInputStream(propFile)));
                            prop.load(in);
                            in.close();
                            String s = prop.getProperty("creator_did");
                            if (s != null) {
                                this.context.setHipsId(s);
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (!(this.flagConcat || this.flagMirror || this.flagZip || this.flagUpdate || this.flagLint || this.flagGunzip || this.flagMocError || this.flagProp || this.flagTMoc || this.flagTIndex)) {
                    String s = this.context.checkHipsId(this.context.hipsId);
                    this.context.setHipsId(s);
                    break block107;
                }
                if (!this.flagMirror) break block107;
                try (InputStreamReader in1 = null;){
                    MyProperties prop = new MyProperties();
                    in1 = new InputStreamReader((InputStream)Util.openAnyStream(this.context.getInputPath() + "/properties"), "UTF-8");
                    prop.load(in1);
                    this.context.setHipsId(this.context.getIdFromProp(prop));
                }
            }
            catch (Exception e) {
                this.context.error(e.getMessage());
                return;
            }
        }
        if (this.flagRGB && !this.flagMode) {
            this.context.setMode(Mode.REPLACETILE);
        }
        if (this.context.isColor() && !this.flagMethod) {
            this.context.setJpegMethod(Context.JpegMethod.MEDIAN);
        }
        if (this.context.getMode() == Mode.ADD) {
            this.context.setFading(false);
            this.context.setLive(false);
            this.context.setPartitioning("false");
            this.context.setMixing("true");
            this.context.info("Pixel mode=ADD => fading, partitioning, no-mixing and live parameter ignored");
        }
        if (this.force) {
            this.context.setIgnoreStamp(true);
            if (all) {
                this.actions.add(0, Action.CLEAN);
            } else {
                for (int i = 0; i < this.actions.size(); ++i) {
                    Action a = this.actions.get(i);
                    if (a == Action.INDEX) {
                        this.actions.add(i, Action.CLEANINDEX);
                        ++i;
                        continue;
                    }
                    if (a == Action.TINDEX) {
                        this.actions.add(i, Action.CLEANTINDEX);
                        ++i;
                        continue;
                    }
                    if (a == Action.MIRROR) {
                        this.actions.add(i, Action.CLEANALL);
                        ++i;
                        continue;
                    }
                    if (a == Action.DETAILS) {
                        this.actions.add(i, Action.CLEANDETAILS);
                        ++i;
                        continue;
                    }
                    if (a == Action.TILES) {
                        this.actions.add(i, Action.CLEANTILES);
                        ++i;
                        continue;
                    }
                    if (a == Action.MAPTILES) {
                        this.actions.add(i, Action.CLEANTILES);
                        ++i;
                        continue;
                    }
                    if (a == Action.JPEG) {
                        this.actions.add(i, Action.CLEANJPEG);
                        ++i;
                        continue;
                    }
                    if (a == Action.PNG) {
                        this.actions.add(i, Action.CLEANPNG);
                        ++i;
                        continue;
                    }
                    if (a == Action.RGB) {
                        this.actions.add(i, Action.CLEAN);
                        ++i;
                        continue;
                    }
                    if (a != Action.CUBE) continue;
                    this.actions.add(i, Action.CLEAN);
                    ++i;
                }
            }
        }
        if (this.context.fake) {
            this.context.warning("NO RUN MODE (option -n), JUST PRINT INFORMATION !!!");
        }
        for (Action a : this.actions) {
            this.context.info("Action => " + (Object)((Object)a) + ": " + a.doc());
            if (this.flagMapFits || a != Action.MAPTILES) continue;
            this.flagMapFits = true;
        }
        if (!this.flagRGB && !this.flagMapFits) {
            this.setDefaultFrame();
        }
        try {
            this.endOfWork = false;
            MyInputStreamCached.context = this.context;
            if (this.cache != null || this.cacheSize != -1L) {
                MyInputStreamCached.setCache(this.cache == null ? null : new File(this.cache), this.cacheSize);
            }
            long t = System.currentTimeMillis();
            new Task(this.context, this.actions, true);
            if (this.context.isTaskAborting()) {
                this.context.abort(Context.getTitle("(aborted after " + Util.getTemps(System.currentTimeMillis() - t), '='));
            } else {
                if (this.cacheRemoveOnExit) {
                    MyInputStreamCached.removeCache();
                }
                if (!(this.flagMirror || this.flagLint || this.flagZip)) {
                    String id = this.context.getHipsId();
                    if (id == null || id.startsWith("ivo://UNK.AUT")) {
                        this.context.warning("a valid HiPS IVOID identifier is strongly recommended" + (id == null ? "" : " => in the meantime, assuming " + id));
                    }
                    if (this.context.nbPilot > 0) {
                        this.context.warning("Pilot test limited to " + this.context.nbPilot + " images => partial HiPS");
                    } else {
                        this.context.info("Tip: Edit the \"properties\" file for describing your HiPS (full description, copyright, ...)");
                    }
                }
                this.context.removeListReport();
                this.context.done(Context.getTitle("THE END (done in " + Util.getTemps(System.currentTimeMillis() - t), '='));
            }
        }
        catch (Exception e) {
            HipsGen hipsGen = this;
            if (hipsGen.context.getVerbose() > 0) {
                e.printStackTrace();
            }
            if (this.cacheRemoveOnExit && this.cache != null) {
                MyInputStreamCached.removeCache();
            }
            this.context.error(e.getMessage());
            this.context.removeListReport();
        }
        finally {
            this.endOfWork = true;
        }
    }

    private void setDefaultFrame() {
        if (this.context.hasFrame()) {
            return;
        }
        String path = this.context.getOutputPath();
        String frame = null;
        try {
            String propFile = path + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                InputStreamReader in = new InputStreamReader(new BufferedInputStream(new FileInputStream(propFile)));
                prop.load(in);
                in.close();
                String s = prop.getProperty("hips_frame");
                if (s == null) {
                    s = prop.getProperty("coordsys");
                }
                frame = s != null && s.length() > 0 ? s : (this.force ? "equatorial" : "galactic");
            } else {
                frame = this.context.isExistingAllskyDir() ? (this.force ? "equatorial" : "galactic") : "equatorial";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.context.setFrameName(frame);
    }

    public void executeAsync(String[] args) {
        new ExecuteAsyncThread(args);
    }

    private static void usage(String launcher) {
        System.out.println("Usage: java -jar " + launcher + " in=file|dir [otherParams ... ACTIONs ...]");
        System.out.println("       java -jar " + launcher + " -param=configfile\n");
        System.out.println("The config file must contain these following options, or use them\ndirectly on the comand line :\n");
        System.out.println("Required parameter:\n   in=dir                  Source image directory (FITS or JPEG|PNG +hhh or HiPS),\n                           unique image or HEALPix map file\n\nBasic optional parameters:\n   out=dir             HiPS target directory (default ./+\"AUTHORITY_internalID\")\n   obs_title=name      Name of the survey (by default, input directory name)\n   creator_did=id      HiPS identifier (syntax: [ivo://]AUTHORITY/internalID)\n   hips_creator=name   Name of the person|institute who builds the HiPS\n   hips_status=xx      HiPS status (private|public clonable|clonableOnce|unclonable)\n                       (default: public clonableOnce)\n   hdu=n1,n2-n3,...|all List of HDU numbers (0 is the primary HDU - default is 0)\n   blank=nn            Specifical BLANK value\n   skyval=key|auto|%info|%min %max   Fits key to use for removing a sky background, or auto\n                       detection or percents of pixel histogram kept (central ex 99, or\n                       min max ex 0.3 99.7)\n   color=jpeg|png      The source images are colored images (jpg or png) and the tiles\n                       will be produced in jpeg (resp. png)\n   shape=...           Shape of the observations (ellipse|rectangle)\n   border=...          Margins (in pixels) to ignore in the original observations\n                       (top left bottom right or constant)\n   fov=true|x1,y1..    Observed regions by files.fov or global polygon (in FITS convention).\n   pilot=nnn           Pilot test limited to the nnn first original images.\n   verbose=n           Debug information from -1 (nothing) to 4 (a lot)\n   -live               incremental HiPS (keep weight associated to each HiPS pixel)\n   -f                  clear previous computations\n   -n                  Just print process information, but do not execute it.\n\nAdvanced optional parameters:\n   hips_order=nn       Specifical HEALPix order - by default, adapted to the original\n                       resolution\n   hips_pixel_bitpix=nn Specifical target bitpix (-64|-32|8|16|32|64)\n   hips_pixel_cut=min max Specifical pixel cut and/or transfert function for PNG/JPEG 8 bits\n                       conversion - ex: \"120 140 log\")\n   hips_data_range=min max Specifical pixel value range (required for bitpix\n                       conversion, or for removing bad pixels - ex: \"-5 110\")\n   pixelGood=min [max] Range of pixel values kept\n   img=file            Specifical reference image for default initializations \n                       (BITPIX,BSCALE,BZERO,BLANK,order,pixelCut,pixelRange)\n   mode=xx             Coadd mode when restart: pixel level(OVERWRITE|KEEP|ADD|AVERAGE) \n                       or tile level (REPLACETILE|KEEPTILE) - (default OVERWRITE)\n                       Or LINK|COPY for CUBE action (default COPY)\n   fading=true|false   False to avoid fading effect on overlapping original images \n                       (default is false)\n   mixing=true|false   False to avoid mixing (and fading) effect on overlapping original\n                       images (default is true)\n   partitioning=true|false|nnn True for cutting large original images in blocks of nnn x nnn \n                       (default is true, nnn=512 )\n   region=moc          Specifical HEALPix region to compute (ex: 3/34-38 50 53)\n                       or Moc.fits file (all sky by default)\n   maxRatio=nn         Max height/width pixel ratio tolerated for original obs \n                       (default 2, 0 for removing the test)\n   fitskeys=list       Fits key list (blank separator) designing metadata FITS keyword value \n                       to memorized in the HiPS index\n   hips_min_order=nn   Specifical HEALPix min order (only for DETAILS action)\n   method=m            Method (MEDIAN|MEAN|FIRST) (default MEDIAN) for aggregating colored \n                       compressed tiles (JPEG|PNG)\n   hips_frame          Target coordinate frame (equatorial|galactic)\n   hips_tile_width=nn  Specifical tile width (pow of 2) - default 512\n   mocOrder=nn         Specifical HEALPix MOC order (only for MOC action) - by default \n                       auto-adapted to the HiPS\n   nside=nn            HEALPix map NSIDE (only for MAP action) - by default 2048\n   exptime=key         Fits key to use for adjusting variation of exposition\n   cache=dir           Directory name for an alternative cache disk location\n   cacheSize=nn        Alternative cache disk size limit (in MB - default 1024\n   cacheRemoveOnExit=true|false Remove or not the cache disk at the end - default true\n   inRed               HiPS red path component, possibly suffixed by cube index (ex: [1])\n   inGreen             HiPS green path component, possibly suffixed by cube index (ex: [1])\n   inBlue              HiPS blue path component, possibly suffixed by cube index (ex: [1])\n   cmRed               Colormap parameters for HiPS red component (min [mid] max [fct])\n   cmGreen             Colormap parameters for HiPS green component (min [mid] max [fct])\n   cmBlue              Colormap parameters for HiPS blue component (min [mid] max [fct])\n   luptonQ=x           Q coef Lupton RGB builder (default auto)\n   luptonS=x/x/x       scale coefs Lupton RGB builder (default auto)\n   luptonM=x/x/x       m coefs Lupton RGB builder (default auto)\n   filter=gauss        Gaussian filter applied on the 3 input HiPS (RGB action)\n   tileTypes           List of tile format to copy (MIRROR action)\n   split='size;altPath]' Split information for MIRROR action (ex: 300g;/hips/part2)\n   maxThread=nn        Max number of computing threads\n   target=ra +dec      Default HiPS target (ICRS deg)\n   targetRadius=rad    Default HiPS radius view (deg)\n   -check              Force to fully check date&size of local tiles for MIRROR action\n   -notouch            Do not touch the hips_release_date\n   -color              Colorized console log messages\n   -nice               Slow download for avoiding to overload remote http server (dedicated \n                       to MIRROR action)\n");
        System.out.println("\nSpecifical actions (by default: \"INDEX TILES PNG DETAILS\"):\n   INDEX      " + Action.INDEX.doc() + "\n" + "   TILES      " + Action.TILES.doc() + "\n" + "   JPEG       " + Action.JPEG.doc() + "\n" + "   PNG        " + Action.PNG.doc() + "\n" + "   RGB        " + Action.RGB.doc() + "\n" + "   MOC        " + Action.MOC.doc() + "\n" + "   ALLSKY     " + Action.ALLSKY.doc() + "\n" + "   TREE       " + Action.TREE.doc() + "\n" + "   MAPTILES   " + Action.MAPTILES.doc() + "\n" + "   APPEND     " + Action.APPEND.doc() + "\n" + "   CONCAT     " + Action.CONCAT.doc() + "\n" + "   CUBE       " + Action.CUBE.doc() + "\n" + "   CLEANFITS  " + Action.CLEANFITS.doc() + "\n" + "   DETAILS    " + Action.DETAILS.doc() + "\n" + "   MAP        " + Action.MAP.doc() + "\n" + "   MIRROR     " + Action.MIRROR.doc() + "\n" + "   UPDATE     " + Action.UPDATE.doc() + "\n" + "   LINT       " + Action.LINT.doc() + "\n");
        System.out.println("\nEx: java -jar " + launcher + " in=/MyImg    => Do all the job." + "\n    java -jar " + launcher + " in=/MyImg hips_pixel_bitpix=16 hips_pixel_cut=\"-1 100 log\"" + "\n           The FITS tiles will be coded in short integers, the preview tiles" + "\n           will map the physical values [-1..100] with a log function contrast in [0..255]." + "\n    java -jar " + launcher + " in=/MyImg blank=0 border=\"100 50 100 50\" mode=REPLACETILE   " + "\n" + "           => recompute tiles. The original pixels in the border or null will be ignored." + "\n    java -jar " + launcher + " in=HiPS1 out=HiPS2 CONCAT => Concatenate HiPS1 to HiPS2");
        System.out.println("\n(c) Universit\u00e9 de Strasbourg/CNRS 2018 - " + launcher + " based on Aladin " + "v11.024" + " from CDS");
    }

    private void setConfigFile(String configfile) throws Exception {
        this.file = new File(configfile);
        this.parseConfig();
    }

    public static void main(String[] args) {
        HipsGen generator = new HipsGen();
        generator.launcher = "HipsGen";
        generator.execute(args);
    }

    static {
        SDF.setTimeZone(TimeZone.getDefault());
    }

    class ExecuteAsyncThread
    extends Thread {
        String[] args;

        public ExecuteAsyncThread(String[] args) {
            this.args = args;
            this.start();
        }

        @Override
        public void run() {
            HipsGen.this.execute(this.args);
        }
    }
}

