/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.prop.PropPanel;
import cds.allsky.Context;
import cds.tools.Util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.io.RandomAccessFile;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FrameGlu
extends JFrame
implements KeyListener {
    private static final int REQUIRED = 0;
    private static final int LABEL = 1;
    private static final int FIELD = 2;
    private static final int KEY = 3;
    private static final int VALUE = 4;
    private static final int INFO = 5;
    private static String[][] GLUPARAM = new String[][]{{"*", "Survey ID", "Id", "", "", "One word survey identifier (ex: P/DSS/2)"}, {"*", "Name", "Description", "", "", "Survey name (ex: DSS blue"}, {"*", "Url access", "Url", "", "http://...", "Url for accessing the Healpix data (a Healpix FITS file map or a Healpix Aladin directory)"}, {"-", "Category", "Aladin.Tree", "client_category", "Test", "Aladin tree menu category - use / as separator (ex: Image/Test)"}, {"-", "Description", "Description", "obs_title", "", "Short description"}, {"-", "Full descript.", "VerboseDescr", "obs_description", "", "Full data description (can be a long paragraph)"}, {"-", "Web info", "Doc.User", "", "", "Web page describing the data"}, {"-", "Institute", "Institute", "", "", "Institute/origin of the data"}, {"-", "Copyright", "Copyright", "obs_copyright", "", "Copyright mention (ex: (c) Institute of ....)"}, {"-", "Web site", "Copyright.url", "obs_copyright_url", "", "Web link for copyright mention"}};
    private JTextField[] field;
    private Aladin aladin;
    Context context;
    private JButton test;
    private JButton save;

    public FrameGlu(Aladin aladin, Context c) {
        this.aladin = aladin;
        this.context = c;
        JPanel panel = new JPanel(new BorderLayout(5, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)this.getInfo(), "North");
        panel.add((Component)this.getForm(), "Center");
        panel.add((Component)this.getButton(), "South");
        this.getContentPane().add(panel);
        this.pack();
        this.setLocation(200, 200);
        this.setVisible(true);
    }

    private JPanel getInfo() {
        JPanel panel = new JPanel();
        JLabel message = new JLabel("<html><center>Fill up these fields and test your survey description<br>in your Aladin session. Since is ok, send the generated parameter GLU file<br>to your collaborators, or even send it to the CDS team in order to offer<br>a full access to your data.</center></html>");
        panel.add(message);
        return panel;
    }

    private JPanel getButton() {
        JButton b;
        JPanel panel = new JPanel();
        this.test = b = new JButton("Test it locally");
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameGlu.this.test();
            }
        });
        this.add(b);
        panel.add(b);
        this.save = b = new JButton("Save it (for distributing)");
        b.setEnabled(false);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrameGlu.this.save();
            }
        });
        this.add(b);
        panel.add(b);
        return panel;
    }

    private JPanel getForm() {
        GridBagLayout g = new GridBagLayout();
        JPanel panel = new JPanel(g);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.field = new JTextField[GLUPARAM.length];
        for (int i = 0; i < GLUPARAM.length; ++i) {
            JTextField f;
            String[] glup = GLUPARAM[i];
            JLabel l = new JLabel(glup[1]);
            if (glup[0].length() == 0) continue;
            if (glup[0].charAt(0) == '*') {
                l.setFont(l.getFont().deriveFont(1));
            }
            String value = glup[4];
            if (glup[2].equals("Description")) {
                value = this.context.getLabel();
            }
            this.field[i] = f = new JTextField(value);
            f.addKeyListener(this);
            f.setMinimumSize(new Dimension(300, f.getMinimumSize().height));
            f.setPreferredSize(new Dimension(300, f.getPreferredSize().height));
            PropPanel.addCouple(this, panel, l, glup[5], f, g, c, 13);
        }
        return panel;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        this.activeButtonIfPossible();
    }

    private void activeButtonIfPossible() {
        boolean ok = this.isReady();
        this.test.setEnabled(ok);
        this.save.setEnabled(ok);
    }

    private boolean isReady() {
        return this.missingField() == -1;
    }

    private int missingField() {
        for (int i = 0; i < GLUPARAM.length; ++i) {
            if (!GLUPARAM[i][0].equals("*") || this.field[i].getText().trim().length() != 0) continue;
            return i;
        }
        return -1;
    }

    private void test() {
        try {
            String glu = this.getGluRecord();
            File f = this.aladin.createTempFile("GluHealpix", ".dic");
            RandomAccessFile rf = new RandomAccessFile(f, "rw");
            rf.writeBytes(glu);
            rf.close();
            this.aladin.execCommand("load " + f.getAbsolutePath());
            f.deleteOnExit();
            this.aladin.dialog.show("Allsky");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateProperties();
    }

    private void save() {
        String glu = this.getGluRecord();
        if (!Aladin.confirmation(this, "Your data corresponds to this following registry description (GLU record) and can be saved on your disk as small text file for distributing to your collaborators.Simply by loading this file in Aladin, your collaborators will immediately see your data and will be able to access them.\n\nYou can also send this file to the CDS team (cds-question@unistra.fr) in order to expose your data to the whole astronomical community:\n \n" + glu + "\n \n" + "Generate this file ?")) {
            return;
        }
        FileDialog fd = new FileDialog((Frame)this.aladin.dialog, "GLU Data record", 1);
        fd.setVisible(true);
        String dir = fd.getDirectory();
        String name = fd.getFile();
        if (name == null) {
            return;
        }
        try {
            if (name.trim().length() == 0) {
                return;
            }
            File f = new File(dir, name);
            RandomAccessFile rf = new RandomAccessFile(f, "rw");
            rf.writeBytes(glu);
            rf.close();
            Aladin.trace(3, "Glu record Allsky saved [" + f.getAbsolutePath() + "] !");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateProperties();
    }

    private void updateProperties() {
        try {
            this.context.writeMetaFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getGluRecord() {
        StringBuffer s = new StringBuffer();
        String id = this.field[0].getText().trim().replace('/', '_');
        s.append(Util.align("%ActionName", 15) + " " + id + ".htx" + Util.CR);
        for (int i = 0; i < GLUPARAM.length; ++i) {
            String[] glup = GLUPARAM[i];
            String value = this.field[i].getText().trim();
            if (value.length() == 0) continue;
            s.append(Util.align("%" + glup[2], 15) + " " + value + Util.CR);
            if (glup[3].length() <= 0) continue;
            this.context.setPropriete(glup[3], value);
        }
        s.append(Util.align("%Aladin.XLabel", 15) + " " + this.field[1].getText().trim() + Util.CR);
        s.append(Util.align("%Aladin.Profile", 15) + " >6.1" + Util.CR);
        s.append(Util.align("%Aladin.HpxParam", 15) + " " + this.getHpxParam() + Util.CR);
        this.context.setPropriete("obs_title", id);
        return s.toString();
    }

    private String getHpxParam() {
        return this.context.getOrder() + " " + this.context.getAvailableTileFormats();
    }
}

