/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class BuilderZip
extends Builder {
    static final int ENTRYSIZE = 50;

    public BuilderZip(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.GZIP;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
    }

    @Override
    public void run() throws Exception {
        try {
            this.zip();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    protected void zip() throws Exception {
        String path = this.context.getOutputPath();
        int maxOrder = Util.getMaxOrderByPath(path);
        for (int order = 0; order <= maxOrder; ++order) {
            File[] dirs;
            File nOrder = new File(path + "/Norder" + order);
            if (!nOrder.isDirectory()) continue;
            for (File dir : dirs = nOrder.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    if (!name.startsWith("Dir")) {
                        return false;
                    }
                    try {
                        Integer.parseInt(name.substring(3));
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            })) {
                this.zip(dir.getCanonicalPath());
            }
        }
    }

    private void zip(String dir) throws Exception {
        File[] files = new File(dir).listFiles();
        if (files == null) {
            return;
        }
        File zip = new File(dir + ".zip");
        if (zip.exists()) {
            zip.delete();
        }
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(zip));
        out.setMethod(0);
        ArrayList<IndexEntry> index = new ArrayList<IndexEntry>();
        BigInteger offset = new BigInteger("0");
        for (File f : files) {
            offset = offset.add(new BigInteger("" + f.length()));
            index.add(new IndexEntry(f.getName(), offset));
        }
        int indexSize = index.size() * 50;
        byte[] indexBuf = new byte[indexSize];
        int pos = 0;
        for (IndexEntry e : index) {
            e.offset = e.offset.add(new BigInteger("" + indexSize));
            pos = e.write(indexBuf, pos);
        }
        ZipEntry e = new ZipEntry("00INDEX.LIST");
        CRC32 crc = new CRC32();
        crc.update(indexBuf);
        e.setSize(indexSize);
        e.setCompressedSize(indexSize);
        e.setCrc(crc.getValue());
        out.putNextEntry(e);
        out.write(indexBuf);
        out.closeEntry();
        for (File f : files) {
            e = new ZipEntry(f.getName());
            RandomAccessFile rf = new RandomAccessFile(f, "r");
            long size = rf.length();
            byte[] buf = new byte[(int)size];
            int taille = (int)size;
            pos = 0;
            while (taille > 0) {
                int n = rf.read(buf, pos, taille);
                taille -= n;
                pos += n;
            }
            crc.reset();
            crc.update(buf);
            e.setSize(size);
            e.setCompressedSize(size);
            e.setCrc(crc.getValue());
            out.putNextEntry(e);
            out.write(buf);
            rf.close();
            out.closeEntry();
        }
        out.close();
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
    }

    class IndexEntry {
        String name;
        BigInteger offset;

        IndexEntry(String name, BigInteger offset) {
            this.name = name;
            this.offset = offset;
        }

        int write(byte[] buf, int pos) {
            String s = String.format("%-18s%30d\r\n", this.name, this.offset);
            System.arraycopy(s.getBytes(), 0, buf, pos, 50);
            return pos + 50;
        }
    }
}

