/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderGunzip;
import cds.allsky.BuilderMirror;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTree;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.tools.Util;
import java.io.File;

public class BuilderUpdate
extends Builder {
    private Builder b = null;
    private String[] OLD = new String[]{"properties", "index.html"};

    public BuilderUpdate(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.UPDATE;
    }

    @Override
    public void run() throws Exception {
        this.keepOldCopy();
        this.fillupContext();
        if (!this.context.isTaskAborting()) {
            this.builderMoc();
        }
        if (!this.context.isTaskAborting()) {
            this.builderGunzip();
        }
        if (!this.context.isTaskAborting()) {
            this.builderHighOrder();
        }
        if (!this.context.isTaskAborting()) {
            this.builderAllsky();
        }
    }

    private void fillupContext() throws Exception {
        int[] minmax;
        boolean live;
        boolean color;
        this.context.loadProperties();
        String s = this.context.prop.getProperty("dataproduct_subtype");
        boolean bl = color = s != null && s.indexOf("color") >= 0;
        if (color) {
            this.context.setColor("true");
        }
        boolean bl2 = live = s != null && s.indexOf("live") >= 0;
        if (live) {
            this.context.setLive(live);
        }
        if ((minmax = this.context.findMinMaxOrder())[0] == -1) {
            throw new Exception("No HiPS found in target dir [" + this.context.getOutputPath() + "] !");
        }
        this.context.setOrder(minmax[1]);
        int depth = 1;
        s = this.context.prop.getProperty("hips_cube_depth");
        try {
            depth = Integer.parseInt(s);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.context.setDepth(depth);
        s = this.context.prop.getProperty("hips_frame");
        try {
            int frame = Context.getFrameVal(s);
            this.context.setFrame(frame);
        }
        catch (Exception e) {
            // empty catch block
        }
        s = this.context.prop.getProperty("hips_status");
        if (s != null) {
            this.context.setStatus(s);
        }
        this.context.initRegion();
    }

    private void keepOldCopy() throws Exception {
        String path = this.context.getOutputPath();
        for (String f : this.OLD) {
            this.keepOldCopy(path + Util.FS + f);
        }
    }

    private void keepOldCopy(String f) throws Exception {
        if (!new File(f).exists()) {
            return;
        }
        File max = new File(f + ".9");
        if (max.exists()) {
            max.delete();
        }
        for (int i = 9; i > 1; --i) {
            File fo = new File(f + (i == 1 ? "" : "." + (i - 1)));
            if (!fo.exists()) continue;
            fo.renameTo(new File(f + "." + i));
        }
        BuilderMirror.copyLocal(f, f + ".1");
    }

    private void builderGunzip() throws Exception {
        this.context.info("Scanning and gunzipping required tiles (order<=5)...");
        this.b = new BuilderGunzip(this.context);
        this.b.run();
        if (((BuilderGunzip)this.b).nbFile == 0) {
            this.context.info("Nothing gzipped");
        } else {
            this.context.done("Gunzip done");
        }
        this.b = null;
    }

    private void builderMoc() throws Exception {
        try {
            this.context.loadMoc();
            if (this.context.moc.getMocOrder() == 29) {
                this.context.info("Suspicious MOC order (29) !");
                this.keepOldCopy("Moc.fits");
            }
        }
        catch (Exception e) {
            this.context.info("Regenerating MOC from low rhombs...");
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.context.done("MOC regenerated from low rhombs");
            this.context.loadMoc();
            this.b = null;
        }
    }

    private void builderAllsky() throws Exception {
        for (int z = 0; z < this.context.depth; ++z) {
            String filename = BuilderAllsky.getFileName(this.context.getOutputPath(), 3, z);
            String s = this.context.prop.getProperty("hips_tile_format");
            Tok tok = new Tok(s);
            while (tok.hasMoreTokens()) {
                File f;
                String fmt = tok.nextToken();
                if (fmt.equals("jpeg")) {
                    fmt = "jpg";
                }
                if ((f = new File(filename + "." + fmt)).exists()) continue;
                this.context.done("Regenerating Allsky file(s) from Norder3 tiles");
                this.b = new BuilderAllsky(this.context);
                this.b.run();
                this.context.done("Allsky file(s) regenerated");
                return;
            }
        }
        this.b = new BuilderAllsky(this.context);
        ((BuilderAllsky)this.b).postJob();
    }

    private void builderHighOrder() throws Exception {
        int[] minmax = this.context.findMinMaxOrder();
        if (minmax[0] == 0) {
            return;
        }
        if (this.context.getMinOrder() == minmax[0]) {
            return;
        }
        boolean flagFits = false;
        int bitpixOrig = this.context.getBitpixOrig();
        this.context.setMode(Mode.KEEPTILE);
        int order = this.context.getOrder();
        this.context.setOrder(3);
        this.validateTileSide(this.context.getOutputPath());
        this.context.info("Building Norder0,1 and 2...");
        String s = this.context.prop.getProperty("hips_tile_format");
        Tok tok = new Tok(s);
        while (tok.hasMoreTokens()) {
            String fmt = tok.nextToken();
            if (fmt.equals("fits")) {
                flagFits = true;
                continue;
            }
            this.context.info("Building Norder0,1 and 2 for " + fmt + " tiles...");
            this.context.setColor(fmt);
            this.b = new BuilderTree(this.context);
            this.b.build();
        }
        this.context.bitpixOrig = bitpixOrig;
        this.context.order = order;
        if (flagFits && bitpixOrig != 0) {
            this.context.info("Building Norder0,1 and 2 for fits tiles...");
            this.b = new BuilderTree(this.context);
            this.b.build();
        }
        this.context.setMinOrder(0);
        this.context.done("Norder0,1 and 2 built");
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (this.context.hipsId != null) {
            this.context.setHipsId(this.context.hipsId);
        } else {
            this.context.loadProperties();
            this.context.setHipsId(null);
        }
    }
}

