/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderMirror;
import cds.allsky.BuilderMoc;
import cds.allsky.Constante;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.allsky.Mode;
import cds.allsky.ThreadBuilderTile;
import cds.fits.CacheFits;
import cds.fits.Fits;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;

public class BuilderTiles
extends Builder {
    private boolean isColor;
    protected int bitpix;
    protected double bzero;
    protected double bscale;
    protected double blank;
    private Context.JpegMethod method;
    protected ArrayList<ThreadBuilder> threadList = new ArrayList();
    private Mode coaddMode = Mode.REPLACETILE;
    protected int ordermin = 3;
    protected int ordermax;
    protected long nummin = 0L;
    protected long nummax = 0L;
    protected LinkedList<Item> fifo;
    protected double automin = 0.0;
    protected double automax = 0.0;
    public static boolean DEBUG = true;
    public static String FS = System.getProperty("file.separator");
    protected int statNbTile;
    protected long statMinTime;
    protected long statMaxTime;
    protected long statTotalTime;
    protected long statAvgTime;
    protected int statEmptyTile;
    protected int statNodeTile;
    protected long statNodeTotalTime;
    protected long statNodeAvgTime;
    protected long startTime;
    protected long totalTime;
    long lastTime = 0L;
    long lastNbTile = 0L;
    Hashtable<Thread, ArrayList<Fits>> memPerThread;
    private static final long MAXCHECKTIME = 180000L;
    private long lastCheckTime = -1L;
    private double lastProgress = -1.0;
    static final String[] MODE = new String[]{"START", "WAIT", "EXEC", "DIED", "SUSPEND"};
    protected Object lockStop = new Object();
    private Object lockObj = new Object();
    private int threadId = 0;

    public BuilderTiles(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TILES;
    }

    @Override
    public void run() throws Exception {
        this.context.info("Creating " + this.context.getTileExt() + " tiles and allsky (max depth=" + this.context.getOrder() + ")...");
        this.context.info("sky area to process: " + this.context.getNbLowCells() + " low level HEALPix cells");
        if (!this.context.isColor()) {
            int b1;
            int b0 = this.context.getBitpixOrig();
            if (b0 != (b1 = this.context.getBitpix())) {
                this.context.info("BITPIX conversion from " + this.context.getBitpixOrig() + " to " + this.context.getBitpix());
                double[] cutOrig = this.context.getCutOrig();
                double[] cut = this.context.getCut();
                this.context.info("Map original raw pixel range [" + cutOrig[2] + " .. " + cutOrig[3] + "] to [" + cut[2] + " .. " + cut[3] + "]");
            } else {
                this.context.info("BITPIX = " + b1 + " (no conversion)");
            }
            double bs = this.context.getBScale();
            double bz = this.context.getBZero();
            if (bs != 1.0 || bz != 0.0) {
                this.context.info("BSCALE=" + bs + " BZERO=" + bz);
            }
            double bl0 = this.context.getBlankOrig();
            double bl1 = this.context.getBlank();
            if (this.context.hasAlternateBlank()) {
                this.context.info("BLANK conversion from " + (Double.isNaN(bl0) ? "NaN" : Double.valueOf(bl0)) + " to " + (Double.isNaN(bl1) ? "NaN" : Double.valueOf(bl1)));
            } else {
                this.context.info("BLANK=" + (Double.isNaN(bl1) ? "NaN" : Double.valueOf(bl1)));
            }
            if (this.context.good != null) {
                this.context.info("Good pixel values [" + this.ip(this.context.good[0], bz, bs) + " .. " + this.ip(this.context.good[1], bz, bs) + "] => other values are ignored");
            }
            this.context.info("Tile aggregation method=" + (Object)((Object)Context.JpegMethod.MEAN));
            if (this.context.live) {
                this.context.info("Live HiPS => Weight tiles saved for potential future additions");
            }
        }
        this.build();
        if (!this.context.isColor()) {
            if (this.context.bitpix != -1) {
                this.context.setPropriete("hips_pixel_bitpix", this.context.bitpix + "");
            }
            if (this.context.bitpixOrig != -1) {
                this.context.setPropriete("data_pixel_bitpix", this.context.bitpixOrig + "");
            }
            this.context.setPropriete("hips_sampling", this.context.isMap() ? "none" : "bilinear");
            if (this.context.skyvalName != null) {
                this.context.setPropriete("hips_skyval_method", this.context.skyvalName);
                StringBuilder s1 = null;
                double[] cutOrig = this.context.getCutOrig();
                for (int i = 0; i < 4; ++i) {
                    double x = cutOrig[i];
                    if (s1 == null) {
                        s1 = new StringBuilder("" + x);
                        continue;
                    }
                    s1.append(" " + x);
                }
                this.context.setPropriete("hips_skyval_value", s1.toString());
            }
        }
        this.context.setPropriete("hips_overlay", this.context.isMap() ? "none" : (this.context.mode == Mode.ADD ? "add" : (this.context.fading ? "border_fading" : (this.context.mixing ? "mean" : "first"))));
        this.context.setPropriete("hips_hierarchy", this.context.getJpegMethod().toString().toLowerCase());
        if (!this.context.isTaskAborting()) {
            new BuilderAllsky(this.context).run();
            this.context.done("ALLSKY file done");
        }
        if (!this.context.isTaskAborting()) {
            this.b = new BuilderMoc(this.context);
            this.b.run();
            this.b = null;
        }
        this.context.removeListReport();
    }

    @Override
    public void validateContext() throws Exception {
        if (this.context instanceof ContextGui) {
            this.context.setProgressBar(((ContextGui)this.context).mainPanel.getProgressBarTile());
        }
        this.validateInput();
        this.validateOutput();
        try {
            this.validateOrder(this.context.getHpxFinderPath());
        }
        catch (Exception e) {
            if (Aladin.levelTrace >= 3) {
                e.printStackTrace();
            }
            this.context.warning(e.getMessage());
            this.validateOrder(this.context.getOutputPath());
        }
        String img = this.context.getImgEtalon();
        if (img == null) {
            img = this.context.justFindImgEtalon(this.context.getInputPath());
        }
        double[] memoCutOrig = this.context.getCutOrig();
        boolean hasAlternateBlank = this.context.hasAlternateBlank();
        double blankOrig = this.context.getBlankOrig();
        int bitpixOrig = this.context.getBitpixOrig();
        if (img == null) {
            throw new Exception("No source image found in " + this.context.getInputPath());
        }
        this.context.info("Reference image: " + img);
        try {
            this.context.setImgEtalon(img);
        }
        catch (Exception e) {
            this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
        }
        if (!this.context.isColor()) {
            double[] cutOrigBefore;
            if (bitpixOrig == -1) {
                this.context.info("BITPIX found in the reference image => " + this.context.getBitpixOrig());
            } else if (bitpixOrig != this.context.getBitpixOrig()) {
                this.context.warning("The provided BITPIX (" + bitpixOrig + ") is different than the original one (" + this.context.getBitpixOrig() + ") => bitpix conversion will be applied");
                this.context.setBitpixOrig(bitpixOrig);
            }
            if (this.context.depth > 1) {
                this.context.info("Original images are cubes (depth=" + this.context.depth + ")");
            }
            if ((cutOrigBefore = this.context.getPixelRangeCut()) != null) {
                memoCutOrig = new double[4];
                for (int i = 0; i < 4; ++i) {
                    if (Double.isNaN(cutOrigBefore[i])) continue;
                    memoCutOrig[i] = (cutOrigBefore[i] - this.context.bZeroOrig) / this.context.bScaleOrig;
                }
            }
            double[] cutOrig = this.context.getCutOrig();
            double bs = this.context.bScaleOrig;
            double bz = this.context.bZeroOrig;
            if (memoCutOrig != null) {
                if (memoCutOrig[0] != 0.0 || memoCutOrig[1] != 0.0) {
                    cutOrig[0] = memoCutOrig[0];
                    cutOrig[1] = memoCutOrig[1];
                }
                if (memoCutOrig[2] != 0.0 || memoCutOrig[3] != 0.0) {
                    cutOrig[2] = memoCutOrig[2];
                    cutOrig[3] = memoCutOrig[3];
                }
                this.context.setCutOrig(cutOrig);
            }
            if (cutOrig[0] == cutOrig[1]) {
                this.context.warning("BAD PIXEL CUT: [" + this.ip(cutOrig[0], bz, bs) + " .. " + this.ip(cutOrig[1], bz, bs) + "] => YOU WILL HAVE TO CHANGE/EDIT THE properties FILE VALUES");
            }
            this.context.setValidateCut(true);
            if (hasAlternateBlank) {
                this.context.setBlankOrig(blankOrig);
            }
            this.context.initParameters();
            this.context.info("Data range [" + this.ip(cutOrig[2], bz, bs) + " .. " + this.ip(cutOrig[3], bz, bs) + "], pixel cut [" + this.ip(cutOrig[0], bz, bs) + " .. " + this.ip(cutOrig[1], bz, bs) + "]");
        } else {
            this.context.initParameters();
        }
        if (!this.context.verifCoherence()) {
            throw new Exception("Uncompatible pre-existing HiPS survey");
        }
        if (!this.context.isColor() && this.context.getBScale() == 0.0) {
            throw new Exception("Big bug => BSCALE=0 !! please contact CDS");
        }
        Mode m = this.context.getMode();
        if (!this.context.isColor() || m == Mode.KEEPTILE || m == Mode.REPLACETILE) {
            this.context.info("mode=" + Mode.getExplanation(m));
        }
        this.context.info("HiPS coordinate frame => " + this.context.getFrameName());
        this.validateSplit();
    }

    private void validateSplit() throws Exception {
        String splitCmd = this.context.getSplit();
        if (splitCmd == null) {
            return;
        }
        String outputPath = this.context.getOutputPath();
        int bitpix = this.context.getBitpix();
        int tileWidth = this.context.getTileSide();
        int order = this.context.getOrder();
        int depth = this.context.getDepth();
        String format = this.context.isColor() ? "jpeg" : "fits png";
        SMoc moc = (SMoc)this.context.mocIndex.clone();
        if (moc == null) {
            throw new Exception("No MOC available => splitting action not possible");
        }
        if (!this.outputIsFree(outputPath, order)) {
            this.context.warning("HiPS output dir not empty => split function ignored");
            return;
        }
        this.validateSplit(outputPath, splitCmd, moc, order, bitpix, tileWidth, depth, format);
    }

    private boolean outputIsFree(String outputPath, int order) {
        String path = cds.tools.Util.concatDir(outputPath, "Norder" + order);
        File dir = new File(path);
        File[] fs = dir.listFiles();
        if (fs == null) {
            return true;
        }
        for (File f : fs) {
            if (!f.isDirectory() || !f.getName().startsWith("Dir")) continue;
            try {
                Integer.parseInt(f.getName().substring(3));
                return false;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void showStatistics() {
        if (this.b != null) {
            this.b.showStatistics();
            return;
        }
        int statNbThreadRunning = this.getNbThreadRunning();
        int statNbThread = this.getNbThreads();
        if (statNbThreadRunning == 0 || this.statNbTile == 0) {
            return;
        }
        long now = System.currentTimeMillis();
        this.totalTime = now - this.startTime;
        long deltaTime = now - this.lastTime;
        long deltaNbTile = (long)this.statNbTile - this.lastNbTile;
        this.lastTime = now;
        this.lastNbTile = this.statNbTile;
        this.context.showTilesStat(statNbThreadRunning, statNbThread, this.totalTime, this.statNbTile, this.statEmptyTile, this.statNodeTile, this.statMinTime, this.statMaxTime, this.statAvgTime, this.statNodeAvgTime, 0L, deltaTime, deltaNbTile);
        if (Aladin.levelTrace >= 3) {
            String s = this.showMem();
            if (s.length() > 0) {
                this.context.stat(s);
            }
            this.showDebugInfo();
        }
    }

    private void initStat(int nbThread) {
        this.statNodeTile = 0;
        this.statNbTile = 0;
        this.statNodeTotalTime = 0L;
        this.statTotalTime = 0L;
        this.startTime = System.currentTimeMillis();
        this.totalTime = 0L;
        this.memPerThread = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rmThread(Thread t) {
        Long key = new Long(t.hashCode());
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            ArrayList<Fits> m = this.memPerThread.get(key);
            if (m != null) {
                for (Fits f : m) {
                    f.free();
                }
            }
            this.memPerThread.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFits(Thread t, Fits f) {
        if (f == null) {
            return;
        }
        if (f.width == 0) {
            try {
                throw new Exception();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            ArrayList<Fits> m = this.memPerThread.get(t);
            if (m == null) {
                m = new ArrayList();
                this.memPerThread.put(t, m);
            }
            m.add(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rmFits(Thread t, Fits f) {
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            ArrayList<Fits> m = this.memPerThread.get(t);
            if (m == null) {
                return;
            }
            m.remove(f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long releaseBitmap() {
        long size = 0L;
        Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
        synchronized (hashtable) {
            for (Thread t : this.memPerThread.keySet()) {
                ArrayList<Fits> m = this.memPerThread.get(t);
                for (Fits f : m) {
                    try {
                        if (!f.isReleasable()) continue;
                        size += f.releaseBitmap();
                    }
                    catch (Exception e) {}
                }
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getUsedMem() {
        long mem = 0L;
        try {
            Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
            synchronized (hashtable) {
                for (Thread t : this.memPerThread.keySet()) {
                    ArrayList<Fits> m = this.memPerThread.get(t);
                    mem += this.getUsedMem(m);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String showMem() {
        try {
            StringBuffer s = new StringBuffer();
            Hashtable<Thread, ArrayList<Fits>> hashtable = this.memPerThread;
            synchronized (hashtable) {
                for (Thread t : this.memPerThread.keySet()) {
                    ArrayList<Fits> m = this.memPerThread.get(t);
                    if (s.length() > 0) {
                        s.append(", ");
                    }
                    s.append(t.getName() + ":" + m.size() + "tiles" + "/" + cds.tools.Util.getUnitDisk(this.getUsedMem(m)));
                }
            }
            return s.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    private long getUsedMem(ArrayList<Fits> m) {
        if (m == null) {
            return 0L;
        }
        long mem = 0L;
        try {
            for (Fits f : m) {
                mem += f.getMem();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return mem;
    }

    protected void updateStat(int deltaNbThread, int deltaTile, int deltaEmptyTile, long timeTile, int deltaNodeTile, long timeNodeTile) {
        this.statNbTile += deltaTile;
        this.statNodeTile += deltaNodeTile;
        this.statEmptyTile += deltaEmptyTile;
        if (timeTile > 0L) {
            if (this.statNbTile == 1 || timeTile < this.statMinTime) {
                this.statMinTime = timeTile;
            }
            if (this.statNbTile == 1 || timeTile > this.statMaxTime) {
                this.statMaxTime = timeTile;
            }
            if (deltaTile == 1) {
                this.statTotalTime += timeTile;
                this.statAvgTime = this.statTotalTime / (long)this.statNbTile;
            }
        }
        if (timeNodeTile > 0L && deltaNodeTile == 1) {
            this.statNodeTotalTime += timeNodeTile;
            this.statNodeAvgTime = this.statNodeTotalTime / (long)this.statNodeTile;
        }
    }

    protected int getBitpix0() {
        return this.context.getBitpix();
    }

    @Override
    protected void build() throws Exception {
        this.ordermax = this.context.getOrder();
        long t = System.currentTimeMillis();
        SMoc moc = new SMoc();
        SMoc m = this.context.getRegion();
        if (m == null) {
            m = new SMoc("0/1-11");
        }
        moc.add(m);
        int minorder = 0;
        this.context.setMinOrder(minorder);
        moc.setMocOrder(minorder);
        int depth = this.context.getDepth();
        this.fifo = new LinkedList();
        for (int z = 0; z < depth; ++z) {
            Iterator<Long> it = moc.pixelIterator();
            while (it.hasNext()) {
                long npix = it.next();
                this.fifo.add(new Item(minorder, npix, z, null, true));
            }
        }
        this.isColor = this.context.isColor();
        this.bitpix = this.getBitpix0();
        this.coaddMode = this.context.getMode();
        this.method = this.context.getJpegMethod();
        if (!this.isColor) {
            this.bzero = this.context.getBZero();
            this.bscale = this.context.getBScale();
            this.blank = this.context.getBlank();
        }
        int nbProc = Runtime.getRuntime().availableProcessors();
        long size = this.context.getMem();
        long bufMem = 4L * (long)Constante.ORIGCELLWIDTH * (long)Constante.ORIGCELLWIDTH * (long)this.context.getNpixOrig();
        long oneRhomb = this.context.getTileSide() * this.context.getTileSide() * this.context.getNpix();
        long maxMemPerThread = 4L * oneRhomb + bufMem;
        if (this.isColor) {
            maxMemPerThread += oneRhomb * (long)(this.ordermax - this.ordermin);
        }
        int nbThread = this instanceof BuilderMirror ? 16 : (int)(size / maxMemPerThread);
        int maxNbThread = this.context.getMaxNbThread();
        if (maxNbThread > 0 && nbThread > maxNbThread) {
            nbThread = maxNbThread;
        }
        if (nbThread == 0) {
            nbThread = 1;
        }
        if (nbThread > nbProc && !(this instanceof BuilderMirror)) {
            nbThread = nbProc;
        }
        Aladin.trace(4, "BuildController.build(): Found " + nbProc + " processor(s) for " + size / 0x100000L + "MB RAM => Launch " + nbThread + " thread(s)");
        this.context.info("Starts with " + nbThread + " thread" + (nbThread > 1 ? "s" : ""));
        this.activateCache(size, 2L * size / 3L);
        this.launchThreadBuilderHpx(nbThread);
        while (!this.fifo.isEmpty() || this.stillWorking()) {
            cds.tools.Util.pause(1000);
            this.infoInCaseOfProblem();
        }
        this.destroyThreadBuilderHpx();
        if (!this.context.isTaskAborting()) {
            if (ThreadBuilderTile.statMaxOverlays > 0) {
                this.context.stat("Tile overlay stats : max overlays=" + ThreadBuilderTile.statMaxOverlays + ", " + ThreadBuilderTile.statOnePass + " in one step, " + ThreadBuilderTile.statMultiPass + " in multi steps");
            }
            if (this.context.cacheFits != null) {
                Aladin.trace(3, "Cache FITS status: " + this.context.cacheFits);
            }
            Aladin.trace(3, "Healpix survey build in " + cds.tools.Util.getTemps(System.currentTimeMillis() - t));
        }
        if (this.context.cacheFits != null) {
            this.context.cacheFits.reset();
        }
    }

    private void infoInCaseOfProblem() {
        long t;
        block7: {
            block6: {
                t = System.currentTimeMillis();
                if (t == -1L) {
                    this.lastCheckTime = t;
                    return;
                }
                if (t - this.lastCheckTime < 180000L) break block6;
                BuilderTiles builderTiles = this;
                if (builderTiles.context.getVerbose() < 3 || t - this.lastCheckTime >= 20000L) break block7;
            }
            return;
        }
        this.lastCheckTime = t;
        if (this.lastProgress == -1.0) {
            this.lastProgress = this.context.progress;
            return;
        }
        if (this.context.progress != this.lastProgress) {
            this.lastProgress = this.context.progress;
            return;
        }
        this.context.warning("Nothing done since a while. Here a short report to understand the problem:");
        this.showDebugInfo();
    }

    protected void showDebugInfo() {
        CacheFits cache;
        this.context.warning("DEBUG REPORT !!! (fifosize=" + this.fifo.size() + ")");
        int nbDied = 0;
        for (ThreadBuilder tb : this.threadList) {
            String info = tb.getInfo();
            if (tb.isDied()) {
                ++nbDied;
            }
            this.context.warning(".thread " + tb.getName() + ": " + tb.getMode() + (info != null ? " => " + info : ""));
        }
        if (nbDied > 0) {
            this.context.warning(".and " + nbDied + " threads DIED");
        }
        if ((cache = this.context.getCache()) != null) {
            this.context.warning(cache.toString());
        } else {
            this.context.warning("No cache. FreeRAM=" + cds.tools.Util.getUnitDisk(CacheFits.getFreeMem()));
        }
    }

    protected void activateCache(long size, long sizeCache) {
        this.context.setCache(new CacheFits(sizeCache));
        this.context.info("Available RAM: " + cds.tools.Util.getUnitDisk(size) + " => Cache size: " + cds.tools.Util.getUnitDisk(sizeCache));
    }

    private Fits createHpx(ThreadBuilderTile hpx, String path, int order, long npix, int z) throws Exception {
        int i;
        Fits oldOut;
        String file = Util.getFilePath(path, order, npix, z);
        if (!this.context.isInMocTree(order, npix)) {
            return this.findLeaf(file);
        }
        if (this.coaddMode == Mode.KEEPTILE && (oldOut = this.findLeaf(file)) != null) {
            SMoc moc = this.context.getRegion();
            moc = (SMoc)moc.intersection(new SMoc(order + "/" + npix));
            int nbTiles = (int)moc.getNbCells();
            this.updateStat(0, 0, nbTiles, 0L, nbTiles / 4, 0L);
            return oldOut;
        }
        Fits f = null;
        if (order == this.ordermax) {
            hpx.threadBuilder.setInfo("createLeavveHpx " + file + "...");
            try {
                f = this.createLeaveHpx(hpx, file, path, order, npix, z);
            }
            catch (Exception e) {
                hpx.threadBuilder.setInfo("createLeavveHpx error " + file + "...");
                System.err.println("BuilderTiles.createLeave error: " + file);
                e.printStackTrace();
                return null;
            }
        }
        Fits[] fils = new Fits[4];
        Item[] item = new Item[4];
        for (int i2 = 0; i2 < 4; ++i2) {
            item[i2] = new Item();
        }
        int nbDelegate = 0;
        for (i = 0; i < 4; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (nbDelegate < 3 && this.fifo.isEmpty() && this.oneWaiting()) {
                item[i] = this.addNpix(order + 1, npix * 4L + (long)i, z, Thread.currentThread());
                ++nbDelegate;
                this.wakeUp();
                continue;
            }
            hpx.threadBuilder.setInfo("CreateHpx go to next order => " + (order + 1) + "/" + (npix * 4L + (long)i) + "...");
            fils[i] = this.createHpx(hpx, path, order + 1, npix * 4L + (long)i, z);
        }
        while (!(item[0].isReady() && item[1].isReady() && item[2].isReady() && item[3].isReady())) {
            hpx.threadBuilder.setWaitingChildren(true);
            StringBuilder t = new StringBuilder();
            for (int i3 = 0; i3 < item.length; ++i3) {
                t.append(item[i3].isReady() ? "." : (item[i3].hasBeenUsed() ? "x" : "o"));
            }
            hpx.threadBuilder.setInfo("CreateHpx still waiting children of " + order + "/" + npix + " [" + t + "]...");
            try {
                Thread.currentThread();
                Thread.sleep(300L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!this.context.isTaskAborting()) continue;
            throw new Exception("Task abort !");
        }
        hpx.threadBuilder.setWaitingChildren(false);
        for (i = 0; i < 4; ++i) {
            if (!item[i].hasBeenUsed()) continue;
            fils[i] = item[i].getFits();
        }
        hpx.threadBuilder.setInfo("createNodeHpx " + file + "...");
        try {
            f = this.createNodeHpx(file, path, order, npix, fils, z);
        }
        catch (Exception e) {
            System.err.println("BuilderTiles.createNodeHpx error: " + file);
            e.printStackTrace();
            return null;
        }
        return f;
    }

    protected void setProgressBar(int npix) {
        this.context.setProgressLastNorder3(npix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item getNextNpix() {
        Item pix = null;
        Object object = this.lockObj;
        synchronized (object) {
            if (this.fifo.isEmpty()) {
                return null;
            }
            pix = this.fifo.removeLast();
        }
        return pix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Item addNpix(int order, long npix, int z, Thread th) {
        Item item = new Item(order, npix, z, th, false);
        Object object = this.lockObj;
        synchronized (object) {
            this.fifo.add(item);
        }
        return item;
    }

    private void launchThreadBuilderHpx(int nbThreads) throws Exception {
        this.initStat(nbThreads);
        this.context.createHealpixOrder(this.context.getTileOrder());
        ThreadBuilderTile.hasShape = new HashMap();
        for (int i = 0; i < nbThreads; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
            ThreadBuilder t = new ThreadBuilder("Builder" + this.threadId++, threadBuilderTile);
            this.threadList.add(t);
            t.start();
            if (i != 0) continue;
            cds.tools.Util.pause(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addThreadBuilderHpx(int nbThreads) throws Exception {
        if (ThreadBuilderTile.nbThreadsToStop > 0) {
            return false;
        }
        this.context.info("Probably not enough threads => ask to launch " + nbThreads + " thread(s) asap...");
        Object object = this.lockObj;
        synchronized (object) {
            int i;
            for (i = 0; nbThreads > 0 && i < this.threadList.size(); ++i) {
                ThreadBuilder tb = this.threadList.get(i);
                if (!tb.isDied()) continue;
                ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
                ThreadBuilder t = new ThreadBuilder(tb.getName(), threadBuilderTile);
                this.threadList.set(i, t);
                t.start();
                --nbThreads;
            }
            if (nbThreads == 0) {
                return true;
            }
            for (i = 0; i < nbThreads; ++i) {
                if (this.context.isTaskAborting()) {
                    throw new Exception("Task abort !");
                }
                ThreadBuilderTile threadBuilderTile = new ThreadBuilderTile(this.context, this);
                ThreadBuilder t = new ThreadBuilder("Builder" + this.threadId++, threadBuilderTile);
                this.threadList.add(t);
                t.start();
            }
        }
        return true;
    }

    protected int getNbThreads() {
        int nb = 0;
        try {
            for (ThreadBuilder tb : this.threadList) {
                if (tb.isDied()) continue;
                ++nb;
            }
        }
        catch (Exception e) {
            return -1;
        }
        return nb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeThreadBuilderHpx(int nbThreads) {
        if (ThreadBuilderTile.nbThreadsToStop > 0) {
            return false;
        }
        Object object = this.lockObj;
        synchronized (object) {
            ThreadBuilderTile.nbThreadsToStop = nbThreads;
            this.context.info("Probably too many threads => ask to stop " + nbThreads + " thread(s) asap...");
        }
        return true;
    }

    void destroyThreadBuilderHpx() {
        for (ThreadBuilder tb : this.threadList) {
            tb.tue();
        }
    }

    boolean arret(ThreadBuilderTile tbt, String info) {
        for (ThreadBuilder tb : this.threadList) {
            if (tb.threadBuilderTile != tbt) continue;
            return tb.arret(info);
        }
        return false;
    }

    boolean reprise(ThreadBuilderTile tbt) {
        for (ThreadBuilder tb : this.threadList) {
            if (tb.threadBuilderTile != tbt) continue;
            return tb.reprise();
        }
        return false;
    }

    int getNbThreadRunning() {
        int n = 0;
        for (ThreadBuilder tb : this.threadList) {
            if (!tb.isExec()) continue;
            ++n;
        }
        return n;
    }

    boolean stillWorking() {
        for (ThreadBuilder tb : this.threadList) {
            if (!tb.isExec() && !tb.isSuspend()) continue;
            return true;
        }
        return false;
    }

    boolean oneWaiting() {
        try {
            Iterator<ThreadBuilder> it = this.threadList.iterator();
            while (it.hasNext()) {
                if (!it.next().isWaitingAndUsable(true)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    void wakeUp() {
        try {
            for (ThreadBuilder tb : this.threadList) {
                if (!tb.isWaitingAndUsable(false)) continue;
                tb.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Fits createNodeHpx(String file, String path, int order, long npix, Fits[] fils, int z) throws Exception {
        Fits oldOut;
        long t = System.currentTimeMillis();
        int w = this.context.getTileSide();
        double[] px = new double[4];
        boolean inTree = this.context.isInMocTree(order, npix);
        if (!inTree || fils[0] == null && fils[1] == null && fils[2] == null && fils[3] == null) {
            if (this.isColor) {
                return null;
            }
            Fits f = this.findLeaf(file);
            this.addFits(Thread.currentThread(), f);
            return f;
        }
        for (Fits f : fils) {
            if (f == null) continue;
            f.reloadBitmap();
        }
        Fits out = new Fits(w, w, this.bitpix);
        if (!this.isColor) {
            out.setBlank(this.blank);
            out.setBzero(this.bzero);
            out.setBscale(this.bscale);
        }
        for (int dg = 0; dg < 2; ++dg) {
            for (int hb = 0; hb < 2; ++hb) {
                int quad = dg << 1 | hb;
                int offX = dg * w >>> 1;
                int offY = (1 - hb) * w >>> 1;
                Fits in = fils[quad];
                for (int y = 0; y < w; y += 2) {
                    for (int x = 0; x < w; x += 2) {
                        if (this.isColor) {
                            int pix = 0;
                            if (in != null) {
                                int alpha;
                                int p;
                                int gy;
                                int gx;
                                int i;
                                int nbPix;
                                if (this.method == Context.JpegMethod.MEAN) {
                                    int pixR = 0;
                                    int pixG = 0;
                                    int pixB = 0;
                                    nbPix = 0;
                                    for (i = 0; i < 4; ++i) {
                                        gx = i == 1 || i == 3 ? 1 : 0;
                                        p = in.getPixelRGBJPG(x + gx, y + (gy = i > 1 ? 1 : 0));
                                        alpha = p >> 24 & 0xFF;
                                        if (alpha == 0) continue;
                                        ++nbPix;
                                        pixR += p >> 16 & 0xFF;
                                        pixG += p >> 8 & 0xFF;
                                        pixB += p & 0xFF;
                                    }
                                    if (nbPix != 0) {
                                        pix = 0xFF000000 | pixR / nbPix << 16 | pixG / nbPix << 8 | pixB / nbPix;
                                    }
                                } else if (this.method == Context.JpegMethod.MEDIAN) {
                                    int[] pixR = new int[4];
                                    int[] pixG = new int[4];
                                    int[] pixB = new int[4];
                                    nbPix = 0;
                                    for (i = 0; i < 4; ++i) {
                                        gx = i == 1 || i == 3 ? 1 : 0;
                                        p = in.getPixelRGBJPG(x + gx, y + (gy = i > 1 ? 1 : 0));
                                        alpha = p >> 24 & 0xFF;
                                        if (alpha == 0) continue;
                                        ++nbPix;
                                        pixR[i] = p >> 16 & 0xFF;
                                        pixG[i] = p >> 8 & 0xFF;
                                        pixB[i] = p & 0xFF;
                                    }
                                    if (nbPix != 0) {
                                        int pR = pixR[0] > pixR[1] && (pixR[0] < pixR[2] || pixR[0] < pixR[3]) || pixR[0] < pixR[1] && (pixR[0] > pixR[2] || pixR[0] > pixR[3]) ? pixR[0] : (pixR[1] > pixR[0] && (pixR[1] < pixR[2] || pixR[1] < pixR[3]) || pixR[1] < pixR[0] && (pixR[1] > pixR[2] || pixR[1] > pixR[3]) ? pixR[1] : (pixR[2] > pixR[0] && (pixR[2] < pixR[1] || pixR[2] < pixR[3]) || pixR[2] < pixR[0] && (pixR[2] > pixR[1] || pixR[2] > pixR[3]) ? pixR[2] : pixR[3]));
                                        int pG = pixG[0] > pixG[1] && (pixG[0] < pixG[2] || pixG[0] < pixG[3]) || pixG[0] < pixG[1] && (pixG[0] > pixG[2] || pixG[0] > pixG[3]) ? pixG[0] : (pixG[1] > pixG[0] && (pixG[1] < pixG[2] || pixG[1] < pixG[3]) || pixG[1] < pixG[0] && (pixG[1] > pixG[2] || pixG[1] > pixG[3]) ? pixG[1] : (pixG[2] > pixG[0] && (pixG[2] < pixG[1] || pixG[2] < pixG[3]) || pixG[2] < pixG[0] && (pixG[2] > pixG[1] || pixG[2] > pixG[3]) ? pixG[2] : pixG[3]));
                                        int pB = pixB[0] > pixB[1] && (pixB[0] < pixB[2] || pixB[0] < pixB[3]) || pixB[0] < pixB[1] && (pixB[0] > pixB[2] || pixB[0] > pixB[3]) ? pixB[0] : (pixB[1] > pixB[0] && (pixB[1] < pixB[2] || pixB[1] < pixB[3]) || pixB[1] < pixB[0] && (pixB[1] > pixB[2] || pixB[1] > pixB[3]) ? pixB[1] : (pixB[2] > pixB[0] && (pixB[2] < pixB[1] || pixB[2] < pixB[3]) || pixB[2] < pixB[0] && (pixB[2] > pixB[1] || pixB[2] > pixB[3]) ? pixB[2] : pixB[3]));
                                        pix = 0xFF000000 | pR << 16 | pG << 8 | pB;
                                    }
                                } else {
                                    pix = in.getPixelRGBJPG(x, y);
                                }
                            }
                            out.setPixelRGBJPG(offX + (x >>> 1), offY + (y >>> 1), pix);
                            continue;
                        }
                        double pix = this.blank;
                        int nbPix = 0;
                        if (in != null) {
                            int i;
                            for (i = 0; i < 4; ++i) {
                                int gx = i == 1 || i == 3 ? 1 : 0;
                                int gy = i > 1 ? 1 : 0;
                                px[i] = in.getPixelDouble(x + gx, y + gy);
                                if (in.isBlankPixel(px[i])) continue;
                                ++nbPix;
                            }
                            if (nbPix == 0) {
                                pix = this.blank;
                            } else {
                                pix = 0.0;
                                for (i = 0; i < 4; ++i) {
                                    if (in.isBlankPixel(px[i])) continue;
                                    pix += px[i] / (double)nbPix;
                                }
                            }
                        }
                        out.setPixelDouble(offX + (x >>> 1), offY + (y >>> 1), pix);
                    }
                }
            }
        }
        if (!this.isColor && this.coaddMode != Mode.REPLACETILE && this.coaddMode != Mode.KEEPTILE && (oldOut = this.findLeaf(file)) != null) {
            out.mergeOnNaN(oldOut);
        }
        this.context.updateHeader(out, order, npix);
        this.write(file, out);
        long duree = System.currentTimeMillis() - t;
        if (npix % 10L == 0L || DEBUG) {
            Aladin.trace(4, Thread.currentThread().getName() + ".createNodeHpx(" + order + "/" + npix + ") " + (Object)((Object)this.coaddMode) + " in " + duree + "ms");
        }
        this.updateStat(0, 0, 0, 0L, 1, duree);
        for (int i = 0; i < 4; ++i) {
            if (fils[i] == null) continue;
            this.rmFits(Thread.currentThread(), fils[i]);
            fils[i].free();
            fils[i] = null;
        }
        this.addFits(Thread.currentThread(), out);
        return out;
    }

    protected void write(String file, Fits out) throws Exception {
        String filename = file + this.context.getTileExt();
        if (this.isColor) {
            out.writeCompressed(filename, 0.0, 0.0, null, Constante.TILE_MODE[this.context.targetColorMode]);
        } else {
            out.writeFITS(filename);
        }
    }

    protected Fits createLeaveHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        long t = System.currentTimeMillis();
        Fits oldOut = null;
        boolean isInList = this.context.isInMoc(order, npix);
        if (!(isInList || this.coaddMode == Mode.REPLACETILE || (oldOut = this.findLeaf(file)) == null && this.context.isMocDescendant(order, npix))) {
            this.addFits(Thread.currentThread(), oldOut);
            return oldOut;
        }
        Fits out = hpx.buildHealpix(this, path, order, npix, z);
        if (out != null && this.coaddMode != Mode.REPLACETILE) {
            if (oldOut == null) {
                oldOut = this.findLeaf(file);
            }
            if (oldOut != null && this.coaddMode == Mode.KEEPTILE) {
                out = null;
                this.addFits(Thread.currentThread(), oldOut);
                return oldOut;
            }
            if (oldOut != null) {
                if (oldOut.bitpix > 0 && Double.isNaN(oldOut.blank)) {
                    oldOut.setBlank(this.blank);
                }
                if (this.coaddMode == Mode.AVERAGE) {
                    out.coadd(oldOut, true);
                } else if (this.coaddMode == Mode.ADD) {
                    out.coadd(oldOut, false);
                } else if (this.coaddMode == Mode.OVERWRITE) {
                    out.mergeOnNaN(oldOut);
                } else if (this.coaddMode == Mode.KEEP) {
                    oldOut.mergeOnNaN(out);
                    out = oldOut;
                    oldOut = null;
                }
            }
        }
        if (out != null) {
            this.context.updateHeader(out, order, npix);
            this.write(file, out);
            hpx.threadBuilder.setInfo("createLeavveHpx write done " + file + "...");
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 1, 0, duree, 0, 0L);
        } else {
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 0, 1, duree, 0, 0L);
        }
        this.addFits(Thread.currentThread(), out);
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Fits findLeaf(String file) throws Exception {
        String filename = file + this.context.getTileExt();
        File f = new File(filename);
        if (!f.exists()) {
            return null;
        }
        Fits out = new Fits();
        try (MyInputStream is = null;){
            is = new MyInputStream(new FileInputStream(f));
            if (this.isColor) {
                out.loadPreview(is, true);
            } else {
                out.loadFITS(is);
            }
            out.setFilename(filename);
        }
        return out;
    }

    public class ThreadBuilder
    extends Thread {
        static final int START = 0;
        static final int WAIT = 1;
        static final int EXEC = 2;
        static final int DIED = 3;
        static final int SUSPEND = 4;
        ThreadBuilderTile threadBuilderTile;
        private int mode;
        private String info;
        private boolean encore;
        protected Item item;
        private boolean waitingChildren;
        private boolean suspendable;

        public ThreadBuilder(String name, ThreadBuilderTile threadBuilderTile) {
            super(name);
            this.mode = 0;
            this.encore = true;
            this.item = null;
            this.waitingChildren = false;
            this.suspendable = true;
            this.threadBuilderTile = threadBuilderTile;
            threadBuilderTile.threadBuilder = this;
            Aladin.trace(3, "Creating " + this.getName());
        }

        public String getInfo() {
            return this.info;
        }

        public String getMode() {
            return MODE[this.mode];
        }

        public boolean isDied() {
            return this.mode == 3;
        }

        public boolean isExec() {
            return this.mode == 2;
        }

        public boolean isSuspend() {
            return this.mode == 4;
        }

        public void setWaitingChildren(boolean flag) {
            this.waitingChildren = flag;
        }

        public boolean isWaitingChildren() {
            return this.waitingChildren;
        }

        public boolean isWait() {
            return this.mode == 1;
        }

        public boolean isWaitingAndUsable(boolean checkMem) {
            if (this.mode != 1) {
                return false;
            }
            if (checkMem) {
                try {
                    return !this.threadBuilderTile.requiredMem(10L, 1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }

        public void setInfo(String info) {
            this.info = info;
        }

        public boolean arret(String info) {
            if (!this.suspendable) {
                return false;
            }
            this.mode = 4;
            this.info = info;
            return true;
        }

        public boolean reprise() {
            if (this.mode != 4) {
                return false;
            }
            this.mode = 2;
            this.info = null;
            BuilderTiles.this.wakeUp();
            return true;
        }

        public void tue() {
            this.encore = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.encore) {
                this.item = null;
                if (ThreadBuilderTile.nbThreadsToStop > 0) {
                    Object object = BuilderTiles.this.lockStop;
                    synchronized (object) {
                        if (ThreadBuilderTile.nbThreadsToStop > 0) {
                            --ThreadBuilderTile.nbThreadsToStop;
                            break;
                        }
                    }
                }
                while (this.encore && this.mode == 4) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {}
                }
                while (this.encore && (this.item = BuilderTiles.this.getNextNpix()) == null) {
                    this.mode = 1;
                    this.info = "No more HEALPix cell branch to compute => thread by waiting another task";
                    try {
                        Thread.currentThread();
                        Thread.sleep(100L);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (!BuilderTiles.this.context.isTaskAborting()) continue;
                    this.encore = false;
                    break;
                }
                if (!this.encore) continue;
                this.suspendable = this.item.suspendable;
                this.mode = 2;
                this.info = null;
                try {
                    Aladin.trace(4, Thread.currentThread().getName() + " process HEALPix cell branch " + this.item.order + "/" + this.item.npix + "...");
                    if (BuilderTiles.this.context.isTaskAborting()) break;
                    Fits fits = BuilderTiles.this.createHpx(this.threadBuilderTile, BuilderTiles.this.context.getOutputPath(), this.item.order, this.item.npix, this.item.z);
                    this.setInfo("Tile ready");
                    this.item.setFits(fits);
                    BuilderTiles.this.rmFits(Thread.currentThread(), fits);
                    if (this.item.order != 3 || this.item.z != 0) continue;
                    BuilderTiles.this.setProgressBar((int)this.item.npix);
                }
                catch (Throwable e) {
                    try {
                        this.item.setFits(null);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Aladin.trace(1, "*** " + Thread.currentThread().getName() + " exception !!! (" + e.getMessage() + ")");
                    e.printStackTrace();
                    BuilderTiles.this.context.taskAbort();
                }
            }
            this.mode = 3;
            this.info = "Thread died";
            BuilderTiles.this.rmThread(Thread.currentThread());
        }
    }

    class Item {
        int order;
        long npix;
        int z;
        Fits fits;
        boolean ready;
        Thread th;
        boolean suspendable;

        Item() {
            this.ready = true;
            this.order = -1;
        }

        Item(int order, long npix, int z, Thread th, boolean suspendable) {
            this.order = order;
            this.npix = npix;
            this.z = z;
            this.th = th;
            this.ready = false;
            this.suspendable = suspendable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean hasBeenUsed() {
            LinkedList<Item> linkedList = BuilderTiles.this.fifo;
            synchronized (linkedList) {
                return this.order != -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isReady() {
            LinkedList<Item> linkedList = BuilderTiles.this.fifo;
            synchronized (linkedList) {
                return this.ready;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Fits getFits() {
            LinkedList<Item> linkedList = BuilderTiles.this.fifo;
            synchronized (linkedList) {
                return this.fits;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setFits(Fits fits) throws Exception {
            LinkedList<Item> linkedList = BuilderTiles.this.fifo;
            synchronized (linkedList) {
                this.ready = true;
                this.fits = fits;
            }
            if (this.th == null) {
                return;
            }
            this.th.interrupt();
        }

        public String toString() {
            return this.order + "/" + this.npix + (this.z > 0 ? "-" + this.z : "") + (this.isReady() ? "R" : "") + (this.suspendable ? "s" : "");
        }
    }
}

