/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.HealpixProgen;
import cds.aladin.HealpixProgenItem;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.moc.SMoc;
import cds.moc.TMoc;
import cds.tools.Astrodate;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;

public class BuilderTMoc
extends Builder {
    public static final int MINORDER = 3;
    protected int maxOrder;
    protected int statNbFile;
    protected long startTime;
    protected long totalTime;
    private static final int UNKNOWN = 0;
    private static final int TMINMAX = 1;
    private static final int MJDEXPTIME = 2;
    private static final int DATEOBS = 3;
    private int mode = 0;
    private TMoc tmoc = null;

    public BuilderTMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.TMOC;
    }

    @Override
    public void run() throws Exception {
        this.build();
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.validateIndex();
        int o = this.context.getOrder();
        if (o == -1) {
            this.maxOrder = Util.getMaxOrderByPath(this.context.getHpxFinderPath());
            if (this.maxOrder == -1) {
                throw new Exception("HpxFinder seems to be not yet ready ! (order=-1)");
            }
            this.context.info("Order retrieved from HpxFinder => " + this.maxOrder);
            this.context.setOrder(this.maxOrder);
        } else {
            this.maxOrder = o;
        }
        this.context.mocIndex = null;
        this.context.initRegion();
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile, this.totalTime, 0, 0);
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        String output = this.context.getOutputPath();
        String hpxFinder = this.context.getHpxFinderPath();
        SMoc moc = new SMoc();
        moc.read(hpxFinder + Util.FS + "Moc.fits");
        moc.setMocOrder(this.maxOrder);
        long progress = 0L;
        this.context.setProgressMax(moc.getNbCells());
        this.initIt();
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long npix = it.next();
            String file = Util.getFilePath(hpxFinder, this.maxOrder, npix);
            HealpixProgen out = this.createLeave(file);
            if (out == null) {
                this.context.warning("Missing HpxFinder tile " + this.maxOrder + "/" + npix + " => ignored (" + file + ")");
                continue;
            }
            for (String key : out) {
                String json = ((HealpixProgenItem)out.get(key)).getJson();
                try {
                    double tmax;
                    double tmin;
                    String s;
                    if (this.mode == 0) {
                        this.mode = this.detectMode(json);
                    }
                    if (this.mode == 1) {
                        s = cds.tools.Util.extractJSON("T_MIN", json);
                        if (s == null) continue;
                        tmin = Double.parseDouble(s);
                        s = cds.tools.Util.extractJSON("T_MAX", json);
                        if (s == null) continue;
                        tmax = Double.parseDouble(s);
                    } else if (this.mode == 3) {
                        s = cds.tools.Util.extractJSON("DATEOBS1", json);
                        if (s == null) continue;
                        tmin = Astrodate.JDToMJD(Astrodate.parseTime(s, 15));
                        s = cds.tools.Util.extractJSON("DATEOBS2", json);
                        if (s == null) continue;
                        tmax = Astrodate.JDToMJD(Astrodate.parseTime(s, 15));
                        if (Double.isNaN(tmax)) {
                            tmax = tmin;
                        }
                    } else {
                        s = cds.tools.Util.extractJSON("MJD-OBS", json);
                        if (s == null) continue;
                        tmin = Double.parseDouble(s);
                        s = cds.tools.Util.extractJSON("EXPTIME", json);
                        if (s == null) continue;
                        double exptime = Double.parseDouble(s);
                        tmax = tmin + exptime;
                    }
                    double jdtmin = tmin + 2400000.5;
                    double jdtmax = tmax + 2400000.5;
                    this.addIt(this.maxOrder, npix, jdtmin, jdtmax);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.context.warning("parsing error => " + json);
                }
            }
            this.context.setProgress(progress++);
        }
        this.writeIt();
    }

    protected void initIt() {
        this.tmoc = new TMoc();
    }

    protected void addIt(int order, long npix, double jdtmin, double jdtmax) {
        this.tmoc.add(jdtmin, jdtmax);
    }

    protected void writeIt() throws Exception {
        String file = this.context.getOutputPath() + Util.FS + "TMoc.fits";
        this.tmoc.toMocSet();
        this.tmoc.write(file);
    }

    private int detectMode(String json) throws Exception {
        String s = cds.tools.Util.extractJSON("T_MIN", json);
        if (s != null) {
            return 1;
        }
        s = cds.tools.Util.extractJSON("EXPTIME", json);
        if (s != null) {
            return 2;
        }
        s = cds.tools.Util.extractJSON("DATEOBS1", json);
        if (s != null) {
            return 3;
        }
        throw new Exception("Not able to determine HpxFinder time keywords (ex: T_MIN and T_MAX or MJD-OBS and EXPTIME, or DATEOBS1 and DATEOBS2");
    }

    private void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    private HealpixProgen createLeave(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HealpixProgen out = new HealpixProgen();
        out.loadStream(new FileInputStream(f));
        this.updateStat();
        return out;
    }
}

