/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.BuilderTMoc;
import cds.allsky.Context;
import cds.moc.STMoc;
import cds.tools.Util;

public class BuilderSTMoc
extends BuilderTMoc {
    public static final double DAYMICROSEC = 8.64E10;
    STMoc stMoc;
    int n = 0;

    public BuilderSTMoc(Context context) {
        super(context);
    }

    @Override
    protected void initIt() {
        this.stMoc = new STMoc(this.context.getOrder(), 14);
    }

    @Override
    protected void addIt(int order, long npix, double jdtmin, double jdtmax) {
        try {
            long tmin = (long)(jdtmin * 8.64E10);
            long tmax = (long)(jdtmax * 8.64E10);
            long smin = npix << 2 * (29 - order);
            long smax = npix + 1L << 2 * (29 - order);
            this.stMoc.add(tmin, tmax, smin, smax);
            ++this.n;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void writeIt() throws Exception {
        System.out.println("Order=" + this.stMoc.getTimeOrder() + " Ntimes=" + this.stMoc.getTimeRanges() + " Size=" + Util.getUnitDisk(this.stMoc.getMem()));
        String file = this.context.getOutputPath() + Util.FS + "STMoc.fits";
        this.stMoc.write(file);
    }

    @Override
    public void showStatistics() {
        super.showStatistics();
        this.context.info("STMOC time ranges:" + this.stMoc.getTimeRanges() + " size=" + Util.getUnitDisk(this.stMoc.getMem()));
    }
}

