/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.allsky.Action;
import cds.allsky.BuilderMoc;
import cds.allsky.Context;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;

public class BuilderMocIndex
extends BuilderMoc {
    public BuilderMocIndex(Context context) {
        super(context);
    }

    @Override
    public void run() throws Exception {
        long t = System.currentTimeMillis();
        String path = this.context.getHpxFinderPath();
        this.moc = new SMoc();
        this.mocOrder = Util.getMaxOrderByPath(path);
        this.moc.setMocOrder(this.mocOrder);
        String outputFile = path + cds.tools.Util.FS + "Moc.fits";
        String frame = this.getFrame();
        this.moc.setSys(frame);
        this.moc.setCheckConsistencyFlag(false);
        this.generateMoc(this.moc, this.mocOrder, path);
        this.moc.setCheckConsistencyFlag(true);
        this.moc.write(outputFile);
        long time = System.currentTimeMillis() - t;
        this.context.info("MOC Index done in " + cds.tools.Util.getTemps(time, true) + ": mocOrder=" + this.moc.getMocOrder() + "  frame=" + frame + " size=" + cds.tools.Util.getUnitDisk(this.moc.getSize()));
    }

    @Override
    public Action getAction() {
        return Action.MOCINDEX;
    }
}

