/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Coord;
import cds.aladin.Localisation;
import cds.aladin.MyInputStream;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.moc.Healpix;
import cds.moc.SMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;

public class BuilderMoc
extends Builder {
    protected SMoc moc;
    protected int mocOrder;
    protected int fileOrder;
    protected int tileOrder;
    protected boolean isMocHight;
    protected String ext = null;
    protected int frameCube = -1;
    long startTime = 0L;
    int nbTiles = -1;

    public BuilderMoc(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MOC;
    }

    @Override
    public void run() throws Exception {
        this.createMoc(this.context.getOutputPath());
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        if (!this.context.verifTileOrder()) {
            throw new Exception("Uncompatible tileOrder !");
        }
    }

    public SMoc getMoc() {
        return this.moc;
    }

    protected void createMoc(String path) throws Exception {
        this.moc = new SMoc();
        this.fileOrder = this.mocOrder = Util.getMaxOrderByPath(path);
        this.tileOrder = this.context.getTileOrder();
        if (this.context.getMocOrder() != -1) {
            this.mocOrder = this.context.getMocOrder();
        } else {
            this.mocOrder = this.fileOrder;
            if (this.mocOrder < 7) {
                this.mocOrder = 7;
            }
        }
        if (this.mocOrder > this.tileOrder + this.fileOrder) {
            this.context.warning("Too high mocOrder (" + this.mocOrder + ") => assume " + (this.tileOrder + this.fileOrder));
            this.mocOrder = this.tileOrder + this.fileOrder;
        }
        this.ext = this.getDefaultExt(path);
        if (this.ext != null) {
            this.context.info("MOC generation based on " + this.ext + " tiles");
        }
        this.frameCube = -1;
        if (this.context.getDepth() > 10) {
            this.frameCube = this.context.getDepth() / 2;
        }
        this.isMocHight = this.mocOrder > this.fileOrder && this.ext != null && this.ext.equals("fits");
        this.moc.setMocOrder(this.mocOrder);
        String outputFile = path + cds.tools.Util.FS + "Moc.fits";
        long t = System.currentTimeMillis();
        this.context.info("MOC generation (" + (this.isMocHight ? "deep resolution" : "regular resolution") + " mocOrder=" + this.moc.getMocOrder() + ")...");
        String frame = this.getFrame();
        this.moc.setSys(frame);
        this.moc.setCheckConsistencyFlag(false);
        this.generateMoc(this.moc, this.fileOrder, path);
        this.moc.setCheckConsistencyFlag(true);
        this.moc.write(outputFile);
        long time = System.currentTimeMillis() - t;
        this.context.info("MOC done in " + cds.tools.Util.getTemps(time, true) + ": mocOrder=" + this.moc.getMocOrder() + " size=" + cds.tools.Util.getUnitDisk(this.moc.getSize()));
    }

    public static SMoc convertTo(SMoc moc, String coordSys) throws Exception {
        int frameSrc;
        if (coordSys.equals(moc.getSys())) {
            return moc;
        }
        char a = moc.getSys().charAt(0);
        char b = coordSys.charAt(0);
        int n = a == 'G' ? 3 : (frameSrc = a == 'E' ? 2 : 0);
        int frameDst = b == 'G' ? 3 : (b == 'E' ? 2 : 0);
        Healpix hpx = new Healpix();
        int order = moc.getMaxUsedOrder();
        SMoc moc1 = new SMoc(coordSys, moc.getMinOrder(), moc.getMocOrder());
        moc1.setCheckConsistencyFlag(false);
        long onpix1 = -1L;
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long npix = it.next();
            for (int i = 0; i < 4; ++i) {
                double[] coo = hpx.pix2ang(order + 1, npix * 4L + (long)i);
                Coord c = new Coord(coo[0], coo[1]);
                c = Localisation.frameToFrame(c, frameSrc, frameDst);
                long npix1 = hpx.ang2pix(order + 1, c.al, c.del);
                if (npix1 == onpix1) continue;
                onpix1 = npix1;
                moc1.add(order, npix1 / 4L);
            }
        }
        moc1.setCheckConsistencyFlag(true);
        return moc1;
    }

    private String getDefaultExt(String path) {
        if (new File(path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.fits").exists()) {
            return "fits";
        }
        if (new File(path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.jpg").exists()) {
            return "jpg";
        }
        if (new File(path + cds.tools.Util.FS + "Norder3" + cds.tools.Util.FS + "Allsky.png").exists()) {
            return "png";
        }
        return null;
    }

    protected void initStat() {
        this.startTime = System.currentTimeMillis();
        this.nbTiles = 1;
    }

    protected void updateStat() {
        ++this.nbTiles;
    }

    @Override
    public void showStatistics() {
        long now = System.currentTimeMillis();
        long cTime = now - this.startTime;
        if (cTime < 2000L) {
            return;
        }
        this.context.stat(this.nbTiles + " tile" + (this.nbTiles > 1 ? "s" : "") + " scanned in " + cds.tools.Util.getTemps(cTime));
    }

    public long getUsedArea() {
        return this.moc.getNbCells();
    }

    public long getArea() {
        return this.moc.getNbCellsFull();
    }

    protected void generateMoc(SMoc moc, int fileOrder, String path) throws Exception {
        this.initStat();
        File f = new File(path + Util.FS + "Norder" + fileOrder);
        File[] sf = f.listFiles();
        if (sf == null || sf.length == 0) {
            throw new Exception("No tiles found !");
        }
        for (int i = 0; i < sf.length; ++i) {
            if (this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (!sf[i].isDirectory()) continue;
            File[] sf1 = sf[i].listFiles();
            for (int j = 0; j < sf1.length; ++j) {
                String file = sf1[j].getAbsolutePath();
                long npix = Util.getNpixFromPath(file);
                if (npix == -1L) continue;
                String e = this.getExt(file);
                if (this.ext == null) {
                    this.ext = e;
                } else if (!this.ext.equals(e)) continue;
                if (this.frameCube > -1 && this.getCubeFrameNumber(file) != this.frameCube) continue;
                this.generateTileMoc(moc, sf1[j], fileOrder, npix);
            }
            moc.checkAndFix();
        }
    }

    protected void generateTileMoc(SMoc moc, File f, int fileOrder, long npix) throws Exception {
        this.updateStat();
        if (this.isMocHight) {
            this.generateHighTileMoc(moc, fileOrder, f, npix);
        } else {
            moc.add(fileOrder, npix);
        }
    }

    private void generateHighTileMoc(SMoc moc, int fileOrder, File f, long npix) throws Exception {
        Fits fits = new Fits();
        try (MyInputStream dis = null;){
            dis = new MyInputStream(new FileInputStream(f));
            dis = dis.startRead();
            fits.loadFITS(dis);
            dis.close();
            dis = null;
        }
        long nside = fits.width;
        long min = nside * nside * npix;
        int mocOrder = moc.getMocOrder();
        int tileOrder = (int)CDSHealpix.log2(nside);
        int div = (fileOrder + tileOrder - mocOrder) * 2;
        this.context.createHealpixOrder(tileOrder);
        long oNpix = -1L;
        for (int y = 0; y < fits.height; ++y) {
            for (int x = 0; x < fits.width; ++x) {
                try {
                    double pixel;
                    npix = min + (long)this.context.xy2hpx(y * fits.width + x);
                    if ((npix >>>= div) == oNpix || fits.isBlankPixel(pixel = fits.getPixelDouble(x, y))) continue;
                    moc.add(mocOrder, npix);
                    oNpix = npix;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        moc.checkAndFix();
    }

    protected String getExt(String file) {
        int offset = file.lastIndexOf(46);
        if (offset == -1) {
            return "";
        }
        int pos = file.indexOf(Util.FS, offset);
        if (pos != -1) {
            return "";
        }
        return file.substring(offset + 1, file.length());
    }

    protected int getCubeFrameNumber(String file) {
        try {
            int fin = file.lastIndexOf(46);
            int deb = file.lastIndexOf(95, fin);
            if (deb == -1 || fin == -1) {
                return 0;
            }
            return Integer.parseInt(file.substring(deb + 1, fin));
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

