/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyInputStream;
import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.Context;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;

public class BuilderMirror
extends BuilderTiles {
    private static final int TIMEOUT = 15000;
    private static final int MAXRETRY = 10;
    private Fits bidon;
    private MyProperties prop;
    private boolean isPartial = false;
    private boolean isSmaller = false;
    private boolean isUpdate = false;
    private boolean flagIsUpToDate = false;
    private String dateRelease = "";
    private boolean isLocal = false;
    private long timeIP;
    private boolean check = false;
    private int statNbFile = 0;
    private long statCumul = 0L;
    private long lastCumul = 0L;
    private long lastTime = 0L;
    private long[] timeIPArray;
    private int timeIPindex = 0;
    private final int MAXTIMEIP = 50;
    private final int MAXMESURE = 3;
    private int nbMesure = 0;
    private long[] mesure = new long[3];
    boolean acceleration = true;
    private long lastMesure = 0L;

    public BuilderMirror(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MIRROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void validateContext() throws Exception {
        String dir = this.context.getInputPath();
        this.check = this.context.getMirrorCheck();
        boolean bl = this.isLocal = !dir.startsWith("http://") && !dir.startsWith("https://") && !dir.startsWith("ftp://");
        if (this.isLocal) {
            this.context.info("Local mirror copy");
        }
        if (!this.isLocal && this.check) {
            this.context.info("Will check all date and size for already loaded tiles");
        }
        this.prop = new MyProperties();
        MyInputStream in = null;
        try (InputStreamReader in1 = null;){
            in1 = new InputStreamReader((InputStream)cds.tools.Util.openAnyStream(this.context.getInputPath() + "/properties"), "UTF-8");
            this.prop.load(in1);
        }
        this.validateOutput();
        String s = this.prop.getProperty("hips_status");
        if (s != null && this.context.testClonable && s.indexOf("unclonable") >= 0) {
            throw new Exception("This HiPS is unclonable => status: " + s);
        }
        s = this.prop.getProperty("dataproduct_type");
        if (s != null && s.indexOf("catalog") >= 0) {
            throw new Exception("Hipsgen mirror not usable for catalog HiPS");
        }
        s = this.prop.getProperty("hips_order");
        if (s == null) {
            s = this.prop.getProperty("maxOrder");
        }
        if (s == null) {
            this.context.warning("No order specified in the remote HiPS properties file !");
        }
        int o = s == null ? -1 : Integer.parseInt(s);
        int paramO = this.context.getOrder();
        if (paramO == -1) {
            if (o == -1) {
                throw new Exception("Order unknown !");
            }
            this.context.setOrder(o);
        } else if (o != -1) {
            if (paramO > o) {
                throw new Exception("Order greater than the original");
            }
            if (o != paramO) {
                this.isPartial = true;
            }
        }
        s = this.prop.getProperty("hips_tile_format");
        if (s == null) {
            s = this.prop.getProperty("format");
        }
        if (this.context.tileFormat == null) {
            if (s == null) {
                throw new Exception("tile format unknown");
            }
            Tok tok = new Tok(s);
            while (tok.hasMoreTokens()) {
                this.context.addTileFormat(tok.nextToken());
            }
        } else if (s != null && !this.context.getTileFormat().equals(s)) {
            this.isPartial = true;
        }
        this.context.info("Mirroring tiles: " + this.context.getTileFormat() + "...");
        s = this.prop.getProperty("hips_frame");
        if (s == null) {
            s = this.prop.getProperty("coordsys");
        }
        if (s != null) {
            this.context.setFrameName(s);
        }
        SMoc area = new SMoc();
        in = null;
        try {
            in = cds.tools.Util.openAnyStream(this.context.getInputPath() + "/Moc.fits");
            area.read(in);
            if (!this.context.getFrameCode().equals(area.getSys())) {
                this.context.info("MOC conversion in " + this.context.getFrameName() + " frame (HiPS target frame)...");
                area = new SMoc(SMoc.convertTo(area, this.context.getFrameCode()));
            }
            if (this.context.getArea() == null) {
                this.context.setMocArea(area);
            } else if (!this.context.getArea().equals(area)) {
                this.isPartial = true;
                this.isSmaller = true;
                this.context.setMocArea((SMoc)area.intersection(this.context.getArea()));
                this.context.info("Partial spacial mirror");
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        s = this.prop.getProperty("dataproduct_subtype");
        if (s != null) {
            if (s.equals("color")) {
                this.context.setBitpixOrig(0);
            }
        } else {
            s = this.prop.getProperty("isColor");
            if (s == null) {
                s = this.prop.getProperty("isColor");
            }
            if (s != null && s.equals("true")) {
                this.context.setBitpixOrig(0);
            }
        }
        if (this.context.isColor()) {
            this.context.info("Mirroring colored HiPS");
        }
        if ((s = this.prop.getProperty("hips_cube_depth")) == null) {
            s = this.prop.getProperty("cubeDepth");
        }
        if (s != null) {
            int depth = Integer.parseInt(s);
            this.context.setDepth(depth);
        }
        if (this.context.isCube()) {
            this.context.info("Mirroring cube HiPS (depth=" + this.context.depth + ")");
        }
        this.context.moc = this.context.mocArea;
        this.context.setValidateRegion(true);
        if (new File(this.context.getOutputPath() + "/properties").exists()) {
            MyProperties localProp = new MyProperties();
            in1 = null;
            try {
                in1 = new InputStreamReader((InputStream)cds.tools.Util.openAnyStream(this.context.getOutputPath() + "/properties"), "UTF-8");
                localProp.load(in1);
                String dLocal = localProp.getProperty("hips_release_date");
                String dRemote = this.prop.getProperty("hips_release_date");
                if (dLocal != null && dRemote != null && dLocal.equals(dRemote)) {
                    this.dateRelease = dLocal;
                    this.flagIsUpToDate = !this.isSmaller && !this.isPartial;
                }
                this.isUpdate = true;
                this.context.info("Updating a previous HiPS copy [" + this.context.getOutputPath() + "]...");
            }
            finally {
                if (in1 != null) {
                    in1.close();
                }
            }
        }
        this.validateSplit(this.prop);
    }

    private void validateSplit(MyProperties prop) throws Exception {
        int depth;
        int order;
        int tileWidth;
        int bitpix;
        String splitCmd = this.context.getSplit();
        if (splitCmd == null) {
            return;
        }
        try {
            bitpix = Integer.parseInt(prop.getProperty("hips_pixel_bitpix"));
            tileWidth = Integer.parseInt(prop.getProperty("hips_tile_width"));
            order = Integer.parseInt(prop.getProperty("hips_order"));
            try {
                depth = Integer.parseInt(prop.getProperty("hips_cube_depth"));
            }
            catch (Exception e1) {
                depth = 1;
            }
        }
        catch (Exception e) {
            throw new Exception("Missing info in properties file => splitting action not possible");
        }
        SMoc m = (SMoc)(this.context.moc != null ? this.context.moc.clone() : this.context.mocIndex.clone());
        if (m == null) {
            throw new Exception("No MOC available => splitting action not possible");
        }
        this.validateSplit(this.context.getOutputPath(), splitCmd, m, order, bitpix, tileWidth, depth, this.context.getTileFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws Exception {
        if (this.flagIsUpToDate) {
            this.context.info("Local HiPS copy seems to be already up-to-date (same hips_release_date=" + this.dateRelease + ")");
            this.context.info("Only the properties file will be updated");
        } else {
            this.build();
            if (!this.context.isTaskAborting()) {
                this.copyX(this.context.getInputPath() + "/index.html", this.context.getOutputPath() + "/index.html");
                this.copyX(this.context.getInputPath() + "/preview.jpg", this.context.getOutputPath() + "/preview.jpg");
                try {
                    if (this.isSmaller) {
                        throw new Exception();
                    }
                    this.copy(this.context.getInputPath() + "/Moc.fits", this.context.getOutputPath() + "/Moc.fits");
                }
                catch (Exception e) {
                    this.b = new BuilderMoc(this.context);
                    this.b.run();
                    this.b = null;
                }
                this.copyAllsky();
                if (this.isSmaller) {
                    this.b = new BuilderTree(this.context);
                    this.b.run();
                    this.b = null;
                }
            }
        }
        if (!this.context.isTaskAborting()) {
            StringBuilder status1;
            this.prop.remove("hips_service_url");
            this.prop.remove("moc_access_url");
            this.prop.remove("hips_estsize");
            double skyFraction = this.context.moc.getCoverage();
            this.prop.replaceValue("moc_sky_fraction", cds.tools.Util.myRound(skyFraction));
            this.prop.replaceValue("hips_tile_format", this.context.getTileFormat());
            String status = this.prop.getProperty("hips_status");
            if (status == null) {
                status1 = new StringBuilder("public mirror clonableOnce");
            } else {
                Tok tok = new Tok(status);
                status1 = new StringBuilder();
                while (tok.hasMoreTokens()) {
                    String s = tok.nextToken();
                    if (s.equals("master")) {
                        String string = s = this.isPartial ? "partial" : "mirror";
                    }
                    if (s.equals("clonableOnce")) {
                        s = "unclonable";
                    }
                    if (status1.length() > 0) {
                        status1.append(' ');
                    }
                    status1.append(s);
                }
            }
            this.prop.replaceValue("hips_status", status1.toString());
            try (OutputStreamWriter out = null;){
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(this.context.getOutputPath() + "/properties"), "UTF-8");
                this.prop.store(out, null);
            }
        }
    }

    @Override
    public void showStatistics() {
        if (this.flagIsUpToDate) {
            return;
        }
        long t = System.currentTimeMillis();
        long delai = t - this.lastTime;
        long lastCumulPerSec = delai > 1000L && this.lastTime > 0L ? this.lastCumul / (delai / 1000L) : 0L;
        this.lastTime = t;
        this.lastCumul = 0L;
        long lastTimeIP = 0L;
        if (this.statNbFile >= 50) {
            t = 0L;
            for (long a : this.timeIPArray) {
                t += a;
            }
            lastTimeIP = t / 50L;
        }
        int nbThreads = this.getNbThreads();
        int statNbThreadRunning = this.getNbThreadRunning();
        int maxThreads = lastTimeIP == 0L ? 20 : 64;
        int max = this.context.getMaxNbThread();
        if (max != -1 && maxThreads > max) {
            maxThreads = max;
        }
        int minThreads = 16;
        if (!this.isLocal && this.statNbFile > 1 && nbThreads >= 0 && maxThreads > minThreads) {
            if (this.nbMesure < 3) {
                this.mesure[this.nbMesure++] = lastCumulPerSec;
            } else {
                long moyenne = 0L;
                for (long m : this.mesure) {
                    moyenne += m / (long)this.nbMesure;
                }
                if (this.lastMesure != 0L && moyenne < this.lastMesure) {
                    this.acceleration = !this.acceleration;
                }
                try {
                    BuilderMirror builderMirror = this;
                    if (builderMirror.context.getVerbose() >= 3) {
                        this.context.info("MODE " + (this.acceleration ? "acceleration" : "deceleration") + " lastMeasure=" + cds.tools.Util.getUnitDisk(this.lastMesure) + " newMeasure=" + cds.tools.Util.getUnitDisk(moyenne));
                    }
                    if (this.acceleration) {
                        if (nbThreads < maxThreads) {
                            this.addThreadBuilderHpx(nbThreads + 4 <= maxThreads ? 4 : maxThreads - nbThreads);
                        }
                    } else if (nbThreads > minThreads) {
                        this.removeThreadBuilderHpx(2);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (nbThreads <= minThreads) {
                    this.acceleration = true;
                }
                if (nbThreads >= maxThreads) {
                    this.acceleration = false;
                }
                this.lastMesure = moyenne;
                this.nbMesure = 0;
            }
        }
        this.context.showMirrorStat(this.statNbFile, this.statCumul, lastCumulPerSec, this.totalTime, nbThreads, statNbThreadRunning, lastTimeIP);
    }

    @Override
    public void build() throws Exception {
        this.bidon = new Fits();
        this.initStat();
        super.build();
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        return this.createLeaveHpx(hpx, file, path, order, npix, z, true);
    }

    private Fits createLeaveHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z, boolean stat) throws Exception {
        String fileInX = this.context.getInputPath() + "/" + Util.getFilePath(order, npix, z);
        try {
            long size = 0L;
            for (String ext : this.context.tileFormat) {
                String fileIn = fileInX + ext;
                String fileOut = file + ext;
                size += (long)this.copy(hpx, order, fileIn, fileOut);
            }
            if (stat) {
                this.updateStat(size, this.timeIP);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.context.taskAbort();
        }
        return this.bidon;
    }

    private void copyAllsky() throws Exception {
        for (int z = 0; z < this.context.depth; ++z) {
            for (String ext : this.context.tileFormat) {
                String suf = z == 0 ? "" : "_" + z;
                String fileIn = this.context.getInputPath() + "/Norder3/Allsky" + suf + ext;
                String fileOut = this.context.getOutputPath() + "/Norder3/Allsky" + suf + ext;
                this.copyX(fileIn, fileOut);
            }
        }
    }

    private int copyX(String fileIn, String fileOut) throws Exception {
        try {
            return this.copy(fileIn, fileOut);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private int copy(String fileIn, String fileOut) throws Exception {
        return this.copy(null, -1, fileIn, fileOut);
    }

    private int copy(ThreadBuilderTile hpx, int order, String fileIn, String fileOut) throws Exception {
        try {
            if (this.isLocal) {
                return BuilderMirror.copyLocal(fileIn, fileOut);
            }
            return this.copyRemote(hpx, fileIn, fileOut);
        }
        catch (FileNotFoundException e) {
            if (order >= 3) {
                this.context.warning("File not found [" + fileIn + "] => ignored (may be out of the MOC)");
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int copyRemote(ThreadBuilderTile hpx, String fileIn, String fileOut) throws Exception {
        fOut = null;
        lastModified = 0L;
        size = 0;
        sizeRead = 0;
        buf = new byte[512];
        try {
            if (this.context.mirrorDelay > 0) {
                Thread.currentThread().wait(this.context.mirrorDelay);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        i = 0;
        while (i < 10) {
            block60: {
                dis = null;
                f = null;
                timeout = null;
                httpc = null;
                try {
                    lastModified = -1L;
                    u = new URL(fileIn);
                    fOut = new File(fileOut);
                    if (fOut.exists() && (len = fOut.length()) > 0L) {
                        if (!this.check) {
                            if (fileOut.endsWith(".fits")) {
                                if (len > 2048L) {
                                    in = null;
                                    try {
                                        in = new MyInputStream(new FileInputStream(fOut));
                                        if (in.isGZ()) ** GOTO lbl44
                                        in.close();
                                        in = null;
                                        var20_28 = 0;
                                        return var20_28;
                                    }
                                    catch (Exception e) {
                                    }
                                    finally {
                                        if (in != null) {
                                            in.close();
                                        }
                                    }
                                }
                            } else if (len > 1024L) {
                                in = 0;
                                return in;
                            }
                        }
lbl44:
                        // 7 sources

                        httpc = (HttpURLConnection)u.openConnection();
                        timeout = new TimeOut(httpc, fileIn, 15000);
                        timeout.start();
                        httpc.setReadTimeout(14500);
                        httpc.setConnectTimeout(14500);
                        httpc.setRequestProperty("User-Agent", "Aladin/Hipsgen/v11.024");
                        httpc.setRequestMethod("HEAD");
                        lastModified = httpc.getLastModified();
                        size = httpc.getContentLength();
                        if ((long)size == fOut.length() && lastModified <= fOut.lastModified()) {
                            dis = httpc.getInputStream();
                            while (true) {
                                if ((n = dis.read(buf)) <= 0) {
                                    dis.close();
                                    dis = null;
                                    in = 256;
                                    return in;
                                }
                                sizeRead += n;
                            }
                        }
                    }
                    t0 = System.currentTimeMillis();
                    httpc = (HttpURLConnection)u.openConnection();
                    timeout = new TimeOut(httpc, fileIn, 15000);
                    timeout.start();
                    httpc.setReadTimeout(14500);
                    httpc.setConnectTimeout(14500);
                    httpc.setRequestProperty("User-Agent", "Aladin/Hipsgen/v11.024");
                    httpc.setRequestMethod("GET");
                    if (lastModified == -1L) {
                        lastModified = httpc.getLastModified();
                    }
                    dis = httpc.getInputStream();
                    t1 = System.currentTimeMillis();
                    this.timeIP = t1 - t0;
                    cds.tools.Util.createPath(fileOut);
                    f = new RandomAccessFile(fileOut, "rw");
                    while ((n = dis.read(buf)) > 0) {
                        timeout.setSize(sizeRead += n);
                        f.write(buf, 0, n);
                    }
                    timeout.end();
                    timeout = null;
                    dis.close();
                    dis = null;
                    f.close();
                    f = null;
                }
                catch (Exception e) {
                    if (e instanceof FileNotFoundException) {
                        throw e;
                    }
                    fOut.delete();
                    if (i >= 9) throw new Exception("File copy error [" + fileIn + "]");
                    this.context.warning("File copy error  => try again (" + (i + 1) + "x) [" + fileIn + "]");
                    break block60;
                }
                finally {
                    if (timeout != null) {
                        timeout.end();
                    }
                    if (dis != null) {
                        try {
                            dis.close();
                        }
                        catch (Exception e) {}
                    }
                    if (f != null) {
                        try {
                            f.close();
                        }
                        catch (Exception e) {}
                    }
                }
                if (lastModified != 0L) {
                    fOut.setLastModified(lastModified);
                }
                if (sizeRead <= 0) return sizeRead;
                if (new File(fileOut).length() >= (long)size) return sizeRead;
                if (i == 9) {
                    throw new Exception("Truncated file copy [" + fileIn + "]");
                }
                this.context.warning("Truncated file copy => try again [" + fileIn + "]");
            }
            ++i;
        }
        return sizeRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copyLocal(String fileIn, String fileOut) throws Exception {
        long size = -1L;
        File fIn = new File(fileIn);
        long lastModified = fIn.lastModified();
        File fOut = new File(fileOut);
        if (fOut.exists() && fOut.length() > 0L && (size = fIn.length()) == fOut.length() && lastModified <= fOut.lastModified()) {
            return 0;
        }
        size = 0L;
        RandomAccessFile f = null;
        RandomAccessFile g = null;
        byte[] buf = new byte[512];
        try {
            int n;
            cds.tools.Util.createPath(fileOut);
            f = new RandomAccessFile(fileOut, "rw");
            g = new RandomAccessFile(fileIn, "r");
            while ((n = g.read(buf)) > 0) {
                f.write(buf, 0, n);
                size += (long)n;
            }
            f.close();
            f = null;
            g.close();
            g = null;
        }
        finally {
            if (f != null) {
                try {
                    f.close();
                }
                catch (Exception e) {}
            }
            if (g != null) {
                try {
                    g.close();
                }
                catch (Exception e) {}
            }
        }
        fOut.setLastModified(lastModified);
        return (int)size;
    }

    @Override
    boolean oneWaiting() {
        try {
            Iterator it = this.threadList.iterator();
            while (it.hasNext()) {
                if (!((BuilderTiles.ThreadBuilder)it.next()).isWaitingAndUsable(false)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected Fits createNodeHpx(String file, String path, int order, long npix, Fits[] fils, int z) throws Exception {
        if (!this.isSmaller) {
            return this.createLeaveHpx(null, file, path, order, npix, z, false);
        }
        return this.bidon;
    }

    @Override
    public Fits findLeaf(String file) throws Exception {
        return null;
    }

    private void initStat() {
        this.statNbFile = 0;
        this.statCumul = 0L;
        this.startTime = System.currentTimeMillis();
        this.timeIPArray = new long[50];
        this.timeIPindex = 0;
    }

    private void updateStat(long size, long timeIP) {
        ++this.statNbFile;
        this.lastCumul += size;
        this.statCumul += size;
        this.totalTime = System.currentTimeMillis() - this.startTime;
        try {
            this.timeIPArray[this.timeIPindex++] = timeIP;
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.timeIPindex >= 50) {
            this.timeIPindex = 0;
        }
    }

    class TimeOut
    extends Thread {
        HttpURLConnection con;
        long lastSize = 0L;
        long size = 0L;
        boolean encore = true;
        int timeout;
        String file;

        TimeOut(HttpURLConnection con, String file, int timeout) {
            this.timeout = timeout;
            this.file = file;
            this.con = con;
        }

        void end() {
            this.encore = false;
            this.interrupt();
        }

        private long getBytes() {
            return this.size;
        }

        void setSize(long size) {
            this.size = size;
        }

        @Override
        public void run() {
            while (this.encore) {
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                if (!this.encore) continue;
                long size = this.getBytes();
                if (size == this.lastSize) {
                    this.con.disconnect();
                    this.encore = false;
                }
                this.lastSize = size;
            }
        }
    }
}

