/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.PlanImage;
import cds.aladin.Save;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Vector;

public final class BuilderMap
extends Builder {
    private int bitpix;
    private double blank;
    private String output;
    private int frame;
    private int losangeWidth;
    private long nside;

    public BuilderMap(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.MAP;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.output = this.context.getOutputPath();
        this.nside = this.context.getMapNside();
        this.bitpix = this.context.getBitpix();
        this.blank = this.context.getBlank();
        if (this.bitpix == -1) {
            this.context.loadProperties();
            this.bitpix = Integer.parseInt(this.context.prop.getProperty("hips_pixel_bitpix"));
            this.frame = this.context.prop.getProperty("hips_frame").startsWith("G") ? 3 : 0;
            this.losangeWidth = Integer.parseInt(this.context.prop.getProperty("hips_tile_width"));
        } else {
            this.frame = this.context.getFrame();
            this.losangeWidth = this.context.getTileSide();
        }
        this.nside = 4096L;
        if (this.bitpix > 0 && (this.context.getBZero() != 0.0 || this.context.getBScale() != 1.0)) {
            this.bitpix = -32;
            this.context.warning("Coding in real values due to BZERO/BSCALE factors");
        }
    }

    @Override
    public void run() throws Exception {
        this.exportHpx();
        String tForm = this.bitpix == 8 ? "I" : (this.bitpix == 16 ? "I" : (this.bitpix == 32 ? "J" : (this.bitpix == -32 ? "E" : "D")));
        this.context.info("HEALPix map generation in progress: NSIDE=" + this.nside + " frame=" + this.context.getFrameCode() + " TFORM=1" + tForm + " in " + this.output + Util.FS + "Map.fits");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportHpx() throws Exception {
        try (OutputStream f = null;){
            f = new FileOutputStream(this.output + Util.FS + "Map.fits");
            int size = 0;
            int orderLosange = (int)CDSHealpix.log2(this.losangeWidth);
            int orderMap = (int)CDSHealpix.log2(this.nside);
            int nbits = Math.abs(this.bitpix) / 8;
            long nbPix3 = 768L;
            boolean ring = false;
            int lenLine = 1024;
            Vector v = Save.generateHealpixHDU0(false);
            size = Save.writeFitsLines(f, v, size);
            byte[] end = Save.getEndBourrage(size);
            f.write(end);
            size += end.length;
            double badData = Double.NaN;
            if (this.bitpix > 0 && !Double.isNaN(this.blank)) {
                badData = this.blank;
            }
            v = Save.generateHealpixHDU1(orderMap, this.bitpix, ring, lenLine, this.frame, badData);
            size = Save.writeFitsLines(f, v, size);
            end = Save.getEndBourrage(size);
            f.write(end);
            size += end.length;
            byte[] buf = new byte[lenLine * nbits];
            int pos = 0;
            int nbPix = this.losangeWidth * this.losangeWidth;
            byte[] nan = new byte[nbPix * nbits];
            for (int i = 0; i < nbPix; ++i) {
                PlanImage.setPixVal(nan, this.bitpix, i, Double.NaN);
            }
            int[] hpx2xy = Util.createHpx2xy(orderLosange);
            int i = 0;
            while ((long)i < nbPix3) {
                boolean found = true;
                String filename = Util.getFilePath(this.output, 3, (long)i);
                Fits los = new Fits();
                try {
                    los.loadFITS(filename + ".fits");
                }
                catch (FileNotFoundException e) {
                    found = false;
                }
                if (!found) {
                    f.write(buf, 0, pos);
                    size += pos;
                    pos = 0;
                    f.write(nan);
                    pos = 0;
                    size += nan.length;
                } else {
                    for (int ipix = 0; ipix < nbPix; ++ipix) {
                        int idx = hpx2xy[ipix];
                        int yy = idx / this.losangeWidth;
                        int xx = idx - yy * this.losangeWidth;
                        double val = los.getPixelFull(xx, yy);
                        if (this.bitpix < 0 && los.isBlankPixel(val)) {
                            val = Double.NaN;
                        }
                        PlanImage.setPixVal(buf, this.bitpix, pos++, val);
                        if (pos != lenLine) continue;
                        f.write(buf);
                        pos = 0;
                        size += buf.length;
                    }
                }
                ++i;
            }
            if (pos > 0) {
                f.write(buf, 0, pos);
                size += pos;
            }
            end = Save.getEndBourrage(size);
            f.write(end);
            int n = size + end.length;
        }
    }
}

