/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.BuilderMoc;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.StringTokenizer;

public class BuilderCube
extends Builder {
    private String[] inputPath;
    private Mode mode = Mode.COPY;
    private int nbFmt = 1;
    private boolean hasFITS = false;
    private boolean hasPNG = false;
    private boolean hasJPEG = false;
    private int statNbFile;
    private long startTime;
    private long totalTime;

    public BuilderCube(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CUBE;
    }

    @Override
    public void run() throws Exception {
        this.build();
        if (!this.context.isTaskAborting()) {
            BuilderMoc bm = new BuilderMoc(this.context);
            bm.createMoc(this.context.getOutputPath());
            this.context.moc = bm.moc;
        }
        if (!this.context.isTaskAborting()) {
            this.context.writeMetaFile();
        }
    }

    private int getNbFmt() {
        int n = 0;
        if (this.hasFITS) {
            ++n;
        }
        if (this.hasJPEG) {
            ++n;
        }
        if (this.hasPNG) {
            ++n;
        }
        return Math.max(n, this.nbFmt);
    }

    @Override
    public void showStatistics() {
        this.context.showJpgStat(this.statNbFile / this.getNbFmt(), this.totalTime, 0, 0);
    }

    @Override
    public void validateContext() throws Exception {
        boolean propFound = false;
        String s = this.context.getInputPath();
        Tok st = new Tok(s, ";");
        this.inputPath = new String[st.countTokens()];
        for (int i = 0; i < this.inputPath.length; ++i) {
            this.inputPath[i] = st.nextToken();
            String path = this.inputPath[i];
            if (!new File(path).isDirectory()) {
                throw new Exception("Input HiPS error [" + path + "]");
            }
            int order = Util.getMaxOrderByPath(path);
            if (i == 0 && this.context.order == -1) {
                this.context.order = order;
            } else if (order < this.context.order) {
                this.context.warning("Input HiPS [" + path + " => order=" + order + "] not enough depth => ignored");
            }
            if (!propFound) {
                String propFile = path + Util.FS + "properties";
                this.context.prop = new MyProperties();
                File f = new File(propFile);
                if (f.exists()) {
                    if (!f.canRead()) {
                        throw new Exception("Propertie file not available ! [" + propFile + "]");
                    }
                    InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
                    this.context.prop.load(in);
                    in.close();
                    propFound = true;
                    try {
                        int n;
                        String fmt = this.context.prop.getProperty("hips_tile_format");
                        if (fmt == null) {
                            fmt = this.context.prop.getProperty("format");
                        }
                        if ((n = new StringTokenizer(fmt, " ").countTokens()) > 1) {
                            this.nbFmt = n;
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            String lab = this.getALabel(path, null);
            this.context.setPropriete("obs_title_" + i, lab);
            try {
                SMoc m = new SMoc();
                m.read(path + Util.FS + "Moc.fits");
                if (this.context.moc == null) {
                    this.context.moc = m;
                    continue;
                }
                this.context.moc = (SMoc)this.context.moc.union(m);
                continue;
            }
            catch (Exception e) {
                this.context.warning("Missing original MOC in " + path + " => running time estimation will be wrong");
            }
        }
        this.validateOutput();
        this.validateLabel();
        this.context.depth = this.inputPath.length;
        if (this.context.getMode().equals((Object)Mode.LINK)) {
            this.mode = this.context.getMode();
        }
        this.context.info(Mode.getExplanation(this.mode));
    }

    private void initStat() {
        this.statNbFile = 0;
        this.startTime = System.currentTimeMillis();
    }

    private void updateStat() {
        ++this.statNbFile;
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    @Override
    public void build() throws Exception {
        this.initStat();
        String output = this.context.getOutputPath();
        String outputHpxFinder = output + Util.FS + "HpxFinder";
        for (int z = 0; z < this.context.depth; ++z) {
            String input = this.inputPath[z];
            for (int order = 0; order <= this.context.getOrder(); ++order) {
                this.treeCopy(input, output, "Norder" + order, z);
            }
            String inputHpxFinder = input + Util.FS + "HpxFinder";
            if (!new File(inputHpxFinder).isDirectory()) continue;
            for (int order = 0; order <= this.context.getOrder(); ++order) {
                this.treeCopy(inputHpxFinder, outputHpxFinder, "Norder" + order, z);
            }
        }
    }

    private void treeCopy(String input, String output, String path, int z) throws Exception {
        String suffixe;
        File src = new File(input + Util.FS + path);
        if (!src.exists()) {
            return;
        }
        if (src.isDirectory()) {
            File[] list = src.listFiles();
            for (int i = 0; i < list.length; ++i) {
                String s1 = list[i].getName();
                this.treeCopy(input, output, path + Util.FS + s1, z);
            }
            return;
        }
        String s = src.getName();
        int pos = s.lastIndexOf(46);
        String ext = pos < 0 ? "" : s.substring(pos);
        String name = pos < 0 ? s : s.substring(0, pos);
        String string = suffixe = z == 0 ? "" : "_" + z;
        if (!this.hasPNG && ext.equals(".png")) {
            this.hasPNG = true;
        } else if (!this.hasFITS && ext.equals(".fits")) {
            this.hasFITS = true;
        } else if (!this.hasJPEG && ext.equals(".jpg")) {
            this.hasJPEG = true;
        }
        String subPath = new File(path).getParent();
        new File(output + Util.FS + subPath).mkdirs();
        File trg = new File(output + Util.FS + subPath + Util.FS + name + suffixe + ext);
        if (this.mode == Mode.LINK) {
            BuilderCube.link(src, trg);
        } else {
            this.copy(src, trg);
        }
        this.updateStat();
    }

    private static void link(File src, File trg) throws Exception {
        Files.createSymbolicLink(trg.toPath(), src.toPath(), new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(File src, File trg) throws Exception {
        byte[] buf = null;
        try (RandomAccessFile r = null;){
            r = new RandomAccessFile(src, "r");
            buf = new byte[(int)src.length()];
            r.read(buf);
        }
        r = null;
        try {
            r = new RandomAccessFile(trg, "rw");
            r.write(buf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
    }
}

