/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.HealpixProgen;
import cds.aladin.MyProperties;
import cds.aladin.PlanBG;
import cds.allsky.Action;
import cds.allsky.BuilderDetails;
import cds.allsky.BuilderJpg;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderMocIndex;
import cds.allsky.BuilderPng;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.Context;
import cds.allsky.Mode;
import cds.allsky.ThreadBuilderTile;
import cds.fits.Fits;
import cds.moc.SMoc;
import cds.tools.pixtools.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BuilderConcat
extends BuilderTiles {
    private SMoc inputMoc;
    private SMoc outputMoc;
    private String outputPath;
    private String inputPath;
    private String outputPathIndex;
    private String inputPathIndex;
    private Mode mode;
    private boolean doHpxFinder;
    private int tileMode;
    private int tileSide;
    private boolean live = false;
    private boolean liveIn;
    private boolean liveOut;

    public BuilderConcat(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CONCAT;
    }

    @Override
    public void run() throws Exception {
        this.build();
        new BuilderTree(this.context).run();
        this.context.info("tree updated");
        boolean inJpg = false;
        boolean inPng = false;
        if (!this.context.isColor()) {
            inJpg = new File(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.jpg").exists();
            if (inJpg) {
                new BuilderJpg(this.context).run();
                this.context.info("JPEG tiles updated");
            }
            if (inPng = new File(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.png").exists()) {
                new BuilderPng(this.context).run();
                this.context.info("PNG tiles updated");
            }
        }
        String outputPath = this.context.getOutputPath();
        this.outputMoc = new SMoc();
        File f = new File(outputPath + Util.FS + "Moc.fits");
        if (f.exists()) {
            this.outputMoc.read(f.getCanonicalPath());
            this.outputMoc = (SMoc)this.outputMoc.union(this.inputMoc);
            this.outputMoc.write(this.context.getOutputPath() + Util.FS + "Moc.fits");
            this.context.info("MOC updated");
        } else {
            new BuilderMoc(this.context).run();
            this.context.info("MOC done");
        }
        if (!this.doHpxFinder) {
            f = new File(this.outputPathIndex);
            if (f.isDirectory()) {
                f.renameTo(new File(this.outputPathIndex + "-partial"));
                this.context.warning("Previous HpxFinder has been removed as HpxFinder-partial");
            }
        } else {
            new BuilderMocIndex(this.context).run();
            this.context.info("Index MOC updated");
            f = new File(this.outputPathIndex + Util.FS + "metadata.xml");
            if (f.exists()) {
                BuilderDetails b = new BuilderDetails(this.context);
                b.validateContext();
                b.run();
                this.context.info("PROGEN tiles updated");
            }
        }
    }

    @Override
    public void validateContext() throws Exception {
        this.outputPath = this.context.getOutputPath();
        this.inputPath = this.context.getInputPath();
        this.outputPathIndex = cds.tools.Util.concatDir(this.outputPath, "HpxFinder");
        this.inputPathIndex = cds.tools.Util.concatDir(this.inputPath, "HpxFinder");
        this.mode = this.context.getMode();
        this.tileMode = 2;
        this.tileSide = this.context.getTileSide();
        if (this.inputPath == null) {
            throw new Exception("\"in\" parameter required !");
        }
        File f = new File(this.inputPath);
        if (!(!f.exists() || f.isDirectory() && f.canRead())) {
            throw new Exception("\"inputPath\" directory not available [" + this.inputPath + "]");
        }
        int order = Util.getMaxOrderByPath(this.outputPath);
        if (order == -1) {
            throw new Exception("No HiPS found in ouput dir");
        }
        this.context.setOrder(order);
        int inputOrder = Util.getMaxOrderByPath(this.inputPath);
        if (inputOrder == -1) {
            throw new Exception("No HiPS found in input dir");
        }
        if (order != inputOrder) {
            throw new Exception("Uncompatible HiPS: out.order=" + order + " input.order=" + inputOrder);
        }
        this.context.info("Order retrieved from [" + this.inputPath + "] => " + order);
        try {
            this.addAddendum(this.context.getInputPath(), this.context.getOutputPath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String allsky = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits";
        if (new File(allsky).exists()) {
            this.setContextParamFromPreviousAllskyFile(allsky);
            this.validateParams(this.inputPath + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
        } else {
            allsky = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.png";
            if (new File(allsky).exists()) {
                this.context.setColor("png");
                this.tileMode = 0;
                this.context.info("Processing HiPS colored in " + this.context.getTileExt() + " tiles");
            } else {
                allsky = this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.jpg";
                if (new File(allsky).exists()) {
                    this.context.setColor("jpg");
                    this.tileMode = 1;
                    this.context.info("Processing HiPS colored in " + this.context.getTileExt() + " tiles");
                }
            }
        }
        boolean bl = this.doHpxFinder = new File(this.inputPathIndex).isDirectory() && new File(this.outputPathIndex).isDirectory();
        if (this.doHpxFinder) {
            this.context.info("HpxFinder will be also concatenated (mode=" + (Object)((Object)this.mode) + ")");
        }
        this.inputMoc = new SMoc();
        f = new File(this.inputPath + Util.FS + "Moc.fits");
        if (f.exists()) {
            this.inputMoc.read(f.getCanonicalPath());
        } else {
            this.context.info("No input MOC found => generate it...");
            this.context.setOutputPath(this.inputPath);
            new BuilderMoc(this.context).run();
            this.context.setOutputPath(this.outputPath);
            f = new File(this.inputPath + Util.FS + "Moc.fits");
            this.inputMoc.read(f.getCanonicalPath());
        }
        if (this.context.mocArea != null) {
            this.inputMoc = (SMoc)this.inputMoc.intersection(this.context.mocArea);
        }
        this.context.moc = this.inputMoc;
        double[] cut = this.context.getCut();
        this.updateCutByProperties(cut);
        this.context.setCut(cut);
        this.context.setValidateCut(true);
        this.liveOut = this.checkLiveByProperties(this.context.getOutputPath());
        this.liveIn = this.checkLiveByProperties(this.context.getInputPath());
        boolean bl2 = this.live = this.liveIn && this.liveOut;
        if (this.mode == Mode.AVERAGE) {
            if (!this.live) {
                this.context.warning("Both HiPS to merge do not provide weight tiles => assuming basic average");
            } else if (!this.liveOut) {
                this.context.warning("Target HiPS do not provide weight tiles => assuming weigth 1 for each output pixel");
            } else if (!this.liveIn) {
                this.context.warning("Source HiPS do not provide weight tiles => assuming weigth 1 for each input pixel");
            }
        }
    }

    protected boolean checkLiveByProperties(String path) {
        try {
            String s = this.loadProperty(path, "dataproduct_subtype");
            return s != null && s.indexOf("live") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void addAddendum(String sourcePath, String targetPath) throws Exception {
        String targetHipsId = this.getHipsIdFromProperty(targetPath);
        this.context.setHipsId(targetHipsId);
        String addendumId = this.loadProperty(targetPath, "addendum_id");
        this.context.setAddendum(addendumId);
        String sourceHipsId = this.getHipsIdFromProperty(sourcePath);
        this.context.addAddendum(sourceHipsId);
        this.context.info("Merging " + sourceHipsId + " into " + targetHipsId + "...");
    }

    protected String loadProperty(String path, String key) throws Exception {
        MyProperties prop = this.loadProperties(path);
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key);
    }

    protected String getHipsIdFromProperty(String path) throws Exception {
        MyProperties prop = this.loadProperties(path);
        return PlanBG.getHiPSID(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyProperties loadProperties(String path) {
        InputStreamReader in = null;
        try {
            String propFile = path + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
                prop.load(in);
                in.close();
                in = null;
                MyProperties myProperties = prop;
                return myProperties;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    protected void setContextParamFromPreviousAllskyFile(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadHeaderFITS(allskyFile);
        double[] cut = new double[4];
        try {
            cut[0] = f.headerFits.getDoubleFromHeader("PIXELMIN");
            cut[1] = f.headerFits.getDoubleFromHeader("PIXELMAX");
        }
        catch (Exception e) {
            cut[1] = 0.0;
            cut[0] = 0.0;
        }
        try {
            cut[2] = f.headerFits.getDoubleFromHeader("DATAMIN");
            cut[3] = f.headerFits.getDoubleFromHeader("DATAMAX");
        }
        catch (Exception e) {
            cut[3] = 0.0;
            cut[2] = 0.0;
        }
        this.context.setCut(cut);
        try {
            double blank;
            this.context.blank = blank = f.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bscale;
            this.context.bscale = bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bzero;
            this.context.bzero = bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            int bitpix;
            this.context.bitpix = bitpix = f.headerFits.getIntFromHeader("BITPIX");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void validateParams(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadHeaderFITS(allskyFile);
        int bitpix = f.headerFits.getIntFromHeader("BITPIX");
        if (bitpix != this.context.bitpix) {
            throw new Exception("Uncompatible HiPS => input.BITPIX=" + bitpix + " output.BITPIX=" + this.context.bitpix);
        }
        double bscale = 1.0;
        try {
            bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bscale != this.context.bscale) {
            this.context.warning("BSCALE modification => ignored (input.BSCALE=" + bscale + " output.BSCALE=" + this.context.bscale + ")");
        }
        double bzero = 0.0;
        try {
            bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (bzero != this.context.bzero) {
            this.context.warning("BZERO modification =>ignored (input.BZERO=" + bzero + " output.BZERO=" + this.context.bzero + ")");
        }
        double blank = Double.NaN;
        try {
            blank = f.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!Double.isNaN(blank) && blank != this.context.blank) {
            this.context.warning("BLANK modification => ignored (input.BLANK=" + blank + " output.BLANK=" + this.context.blank + ")");
        }
    }

    @Override
    protected Fits createLeaveHpx(ThreadBuilderTile hpx, String file, String path, int order, long npix, int z) throws Exception {
        long t = System.currentTimeMillis();
        Fits out = null;
        String inputFile = Util.getFilePath(this.inputPath, order, npix, z);
        Fits input = this.loadTile(inputFile);
        if (input == null) {
            long duree = System.currentTimeMillis() - t;
            this.updateStat(0, 0, 1, duree, 0, 0L);
            return null;
        }
        double[] weightOut = null;
        double[] weightIn = null;
        String outFile = Util.getFilePath(this.outputPath, order, npix, z);
        if (this.mode != Mode.REPLACETILE && (out = this.loadTile(outFile)) != null && this.live) {
            weightOut = ThreadBuilderTile.loadWeight(outFile, this.tileSide, 1.0);
        }
        if (this.live) {
            weightIn = ThreadBuilderTile.loadWeight(inputFile, this.tileSide, 1.0);
        }
        switch (this.mode) {
            case REPLACETILE: {
                out = input;
                weightOut = weightIn;
                break;
            }
            case KEEPTILE: {
                if (out != null) break;
                out = input;
                weightOut = weightIn;
                break;
            }
            case AVERAGE: {
                if (out != null) {
                    if (!this.live) {
                        input.coadd(out, true);
                    } else {
                        input.coadd(out, weightIn, weightOut);
                    }
                }
                out = input;
                weightOut = weightIn;
                break;
            }
            case ADD: {
                if (out != null) {
                    input.coadd(out, false);
                    if (this.live) {
                        for (int i = 0; i < weightOut.length; ++i) {
                            int n = i;
                            weightIn[n] = weightIn[n] + weightOut[i];
                        }
                    }
                }
                out = input;
                weightOut = weightIn;
                break;
            }
            case OVERWRITE: {
                if (out != null) {
                    if (!this.live) {
                        out.mergeOnNaN(input);
                        break;
                    }
                    out.mergeOnNaN(input, weightOut, weightIn);
                    break;
                }
                out = input;
                weightOut = weightIn;
                break;
            }
            case KEEP: {
                if (out != null) {
                    if (!this.live) {
                        input.mergeOnNaN(out);
                    } else {
                        out.mergeOnNaN(out, weightIn, weightOut);
                    }
                }
                out = input;
                weightOut = weightIn;
            }
        }
        if (out == null) {
            throw new Exception("Y a un bl\u00e8me ! out==null");
        }
        this.write(outFile, out);
        if (this.liveOut) {
            ThreadBuilderTile.writeWeight(outFile, weightOut, this.tileSide);
        }
        if (this.context.isTaskAborting()) {
            throw new Exception("Task abort !");
        }
        if (this.doHpxFinder) {
            String inputIndexFile = Util.getFilePath(this.inputPathIndex, order, npix, z);
            HealpixProgen inputIndex = this.loadIndex(inputIndexFile);
            String outIndexFile = Util.getFilePath(this.outputPathIndex, order, npix, z);
            HealpixProgen outIndex = this.loadIndex(outIndexFile);
            switch (this.mode) {
                case REPLACETILE: {
                    outIndex = inputIndex;
                    break;
                }
                case KEEPTILE: {
                    if (outIndex != null) break;
                    outIndex = inputIndex;
                    break;
                }
                case AVERAGE: 
                case ADD: 
                case OVERWRITE: 
                case KEEP: {
                    if (outIndex != null) {
                        inputIndex.merge(outIndex);
                    }
                    outIndex = inputIndex;
                }
            }
            this.writeIndex(outIndexFile, outIndex);
        }
        long duree = System.currentTimeMillis() - t;
        this.updateStat(0, 1, 0, duree, 0, 0L);
        return out;
    }

    private Fits loadTile(String file) throws Exception {
        Fits f = new Fits();
        try {
            if (this.tileMode == 2) {
                f.loadFITS(file + ".fits");
            } else if (this.tileMode == 0) {
                f.loadPreview(file + ".png", true, false, 2);
            } else if (this.tileMode == 1) {
                f.loadPreview(file + ".jpg", true, false, 1);
            }
        }
        catch (Exception e) {
            f = null;
        }
        return f;
    }

    private void writeIndex(String file, HealpixProgen map) throws Exception {
        cds.tools.Util.createPath(file);
        map.writeStream(new FileOutputStream(file));
    }

    private HealpixProgen loadIndex(String file) throws Exception {
        File f = new File(file);
        if (!f.exists()) {
            return null;
        }
        HealpixProgen out = new HealpixProgen();
        out.loadStream(new FileInputStream(f));
        return out;
    }
}

