/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.allsky.HipsGen;
import cds.allsky.Mode;
import cds.tools.pixtools.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

public class BuilderAppend
extends Builder {
    private String outputPath;
    private String inputPath;
    private Mode mode;
    private boolean live = false;
    private String addHipsPath;
    private int order;
    private String skyval;
    private String skyvalues;
    private String bitpix;
    private String addendumId;

    public BuilderAppend(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.CONCAT;
    }

    @Override
    public void run() throws Exception {
        this.createAddHips();
        this.concatHips();
        this.removeAddHips();
    }

    private void createAddHips() throws Exception {
        HipsGen hi = new HipsGen();
        String cmd = "in=\"" + this.context.getInputPath() + "\" out=\"" + this.addHipsPath + "\" creator_did=" + this.addendumId + " hips_order=" + this.order + " hips_pixel_bitpix=" + this.bitpix + " -live" + (this.skyvalues != null ? " \"skyvalues=" + this.skyvalues + "\"" : (this.skyval != null ? " skyval=" + this.skyval : "")) + " INDEX TILES";
        Tok tok = new Tok(cmd);
        String[] param = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            param[i] = tok.nextToken();
            ++i;
        }
        hi.execute(param);
    }

    private void removeAddHips() throws Exception {
        this.context.info("Cleaning temporary HiPS " + this.addHipsPath + "...");
        cds.tools.Util.deleteDir(new File(this.addHipsPath));
    }

    private void concatHips() throws Exception {
        HipsGen hi = new HipsGen();
        String cmd = "out=\"" + this.context.getOutputPath() + "\" in=\"" + this.addHipsPath + "\" CONCAT";
        Tok tok = new Tok(cmd);
        String[] param = new String[tok.countTokens()];
        int i = 0;
        while (tok.hasMoreTokens()) {
            param[i] = tok.nextToken();
            ++i;
        }
        hi.execute(param);
    }

    @Override
    public void validateContext() throws Exception {
        this.outputPath = this.context.getOutputPath();
        this.inputPath = this.context.getInputPath();
        this.addHipsPath = cds.tools.Util.concatDir(this.outputPath, "AddsHiPS");
        this.mode = this.context.getMode();
        if (this.inputPath == null) {
            throw new Exception("\"in\" parameter required !");
        }
        File f = new File(this.inputPath);
        if (!(!f.exists() || f.isDirectory() && f.canRead())) {
            throw new Exception("\"inputPath\" directory not available [" + this.inputPath + "]");
        }
        this.skyval = this.getSkyVal(this.outputPath);
        if (this.skyval != null && this.skyval.toLowerCase().equals("auto")) {
            try {
                this.skyvalues = this.loadProperty(this.outputPath, "hips_skyval_value");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        this.bitpix = this.getBitpix(this.outputPath);
        this.order = Util.getMaxOrderByPath(this.outputPath);
        if (this.order == -1) {
            throw new Exception("No HiPS found in ouput dir");
        }
        this.context.setOrder(this.order);
        int inputOrder = Util.getMaxOrderByPath(this.inputPath);
        if (inputOrder != -1) {
            throw new Exception("The input directory must contains original images/cubes. Use CONCAT if you want to merge two HiPS");
        }
        this.context.info("Order retrieved from [" + this.outputPath + "] => " + this.order);
        this.live = this.checkLiveByProperties(this.context.getOutputPath());
        if (this.mode == Mode.AVERAGE && !this.live) {
            this.context.warning("Target HiPS does not provide weight tiles => assuming weigth 1 for each output pixel");
        }
        this.addendumId = "APPEND/P/" + System.currentTimeMillis() / 1000L;
    }

    protected boolean checkLiveByProperties(String path) {
        try {
            String s = this.loadProperty(path, "dataproduct_subtype");
            return s != null && s.indexOf("live") >= 0;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getSkyVal(String path) {
        try {
            String s = this.loadProperty(path, "hips_skyval_method");
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getBitpix(String path) {
        try {
            String s = this.loadProperty(path, "hips_pixel_bitpix");
            return s;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String loadProperty(String path, String key) throws Exception {
        MyProperties prop = this.loadProperties(path);
        if (prop == null) {
            return null;
        }
        return prop.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MyProperties loadProperties(String path) {
        InputStreamReader in = null;
        try {
            String propFile = path + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
                prop.load(in);
                in.close();
                in = null;
                MyProperties myProperties = prop;
                return myProperties;
            }
        }
        catch (Exception e) {
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }
}

