/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.Aladin;
import cds.allsky.Action;
import cds.allsky.Builder;
import cds.allsky.Context;
import cds.fits.Fits;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.File;

public final class BuilderAllsky
extends Builder {
    private boolean abort = false;
    public static final String FS = System.getProperty("file.separator");

    public BuilderAllsky(Context context) {
        super(context);
    }

    @Override
    public Action getAction() {
        return Action.ALLSKY;
    }

    @Override
    public void validateContext() throws Exception {
        this.validateOutput();
        this.context.setProgressMax(100.0);
    }

    protected void abort() {
        this.abort = true;
    }

    @Override
    public void run() throws Exception {
        this.abort = false;
        this.validateDepth();
        this.context.info("Creating Allsky...");
        for (int z = 0; !this.abort && z < this.context.depth; ++z) {
            if (!this.context.isColor()) {
                this.createAllSky(this.context.getOutputPath(), 3, 64, z);
            }
            try {
                if (z == 0 && !this.context.isColor()) {
                    this.validateCut();
                }
                this.createAllSkyColor(this.context.getOutputPath(), 3, "png", 64, z);
                this.createAllSkyColor(this.context.getOutputPath(), 3, "jpeg", 64, z);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.postJob();
    }

    public void runJpegOrPngOnly(String format) throws Exception {
        this.validateDepth();
        this.validateCut();
        for (int z = 0; z < this.context.depth; ++z) {
            this.createAllSkyColor(this.context.getOutputPath(), 3, format, 64, z);
        }
        this.postJob();
    }

    protected void postJob() throws Exception {
        this.validateLabel();
        this.validateBitpix();
        this.context.writeMetaFile();
    }

    public void createAllSky(String path, int order, int outLosangeWidth, int z) throws Exception {
        String f;
        int nbOutLosangeHeight;
        int nbOutLosangeWidth;
        long t = System.currentTimeMillis();
        int nside = (int)CDSHealpix.pow2(order);
        int n = 12 * nside * nside;
        if ((double)n / (double)(nbOutLosangeWidth = (int)Math.sqrt(n)) != (double)(nbOutLosangeHeight = (int)((double)n / (double)nbOutLosangeWidth))) {
            ++nbOutLosangeHeight;
        }
        int outFileWidth = outLosangeWidth * nbOutLosangeWidth;
        boolean findParam = false;
        double bzero = 0.0;
        double bscale = 1.0;
        double blank = Double.NaN;
        Fits out = null;
        for (int npix = 0; npix < n; ++npix) {
            if (this.abort || this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (this.context.getAction() == this.getAction()) {
                this.context.setProgress((double)npix * 100.0 / (double)n);
            }
            String name = Util.getFilePath("", order, npix, z);
            Fits in = new Fits();
            String filename = path + FS + name;
            try {
                if (!new File(filename + ".fits").exists()) continue;
                in.loadFITS(filename + ".fits");
                if (!findParam) {
                    bzero = in.getBzero();
                    bscale = in.getBscale();
                    blank = in.getBlank();
                    findParam = true;
                }
                if (out == null) {
                    if (in.width != 0 && in.width < outLosangeWidth) {
                        this.context.info("createAllsky: reducing width=>" + in.width + " ...");
                        this.createAllSky(path, order, in.width, z);
                        return;
                    }
                    out = new Fits(outFileWidth, nbOutLosangeHeight * outLosangeWidth, in.bitpix);
                    if (blank != 0.0) {
                        for (int y = 0; y < out.height; ++y) {
                            for (int x = 0; x < out.width; ++x) {
                                out.setPixelDouble(x, out.height - 1 - y, blank);
                            }
                        }
                    }
                }
                int yLosange = npix / nbOutLosangeWidth;
                int xLosange = npix % nbOutLosangeWidth;
                int gap = in.width / outLosangeWidth;
                for (int y = 0; y < in.width / gap; ++y) {
                    for (int x = 0; x < in.width / gap; ++x) {
                        double p = in.getPixelDouble(x * gap, in.height - 1 - y * gap);
                        int xOut = xLosange * outLosangeWidth + x;
                        int yOut = yLosange * outLosangeWidth + y;
                        out.setPixelDouble(xOut, out.height - 1 - yOut, p);
                    }
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (out == null) {
            return;
        }
        out.setBlank(blank);
        out.setBzero(bzero);
        out.setBscale(bscale);
        String filename = BuilderAllsky.getFileName(path, order, z);
        out.writeFITS(filename + ".fits");
        if (z > 1 && !new File((f = BuilderAllsky.getFileName(path, order, 0)) + ".fits").isFile()) {
            out.writeFITS(f + ".fits");
        }
        Aladin.trace(2, "BuilderAllsky.createAllSky()... bitpix=" + out.bitpix + " bzero=" + out.bzero + " bscale=" + out.bscale + "] created in " + (int)((System.currentTimeMillis() - t) / 1000L) + "s");
    }

    public static String getFileName(String path, int order, int z) {
        return path + FS + "Norder" + order + FS + "Allsky" + (z > 0 ? "_" + z : "");
    }

    public void createAllSkyColor(String path, int order, String mode, int outLosangeWidth, int z) throws Exception {
        String f;
        int nbOutLosangeHeight;
        int nbOutLosangeWidth;
        long t = System.currentTimeMillis();
        int nside = (int)CDSHealpix.pow2(order);
        int n = 12 * nside * nside;
        if ((double)n / (double)(nbOutLosangeWidth = (int)Math.sqrt(n)) != (double)(nbOutLosangeHeight = (int)((double)n / (double)nbOutLosangeWidth))) {
            ++nbOutLosangeHeight;
        }
        int outFileWidth = outLosangeWidth * nbOutLosangeWidth;
        int outFileHeight = nbOutLosangeHeight * outLosangeWidth;
        boolean first = true;
        String ext = mode.equals("png") ? ".png" : ".jpg";
        int format = mode.equals("png") ? 2 : 1;
        Aladin.trace(3, "Creation Allsky" + ext + " order=" + order + (z > 0 ? "_" + z : "") + " mode=FIRST color" + ": " + n + " losanges (" + nbOutLosangeWidth + "x" + nbOutLosangeHeight + " de " + outLosangeWidth + "x" + outLosangeWidth + " soit " + outFileWidth + "x" + nbOutLosangeHeight * outLosangeWidth + " pixels)...");
        Fits out = new Fits(outFileWidth, outFileHeight, 0);
        for (int npix = 0; npix < n; ++npix) {
            if (this.abort || this.context.isTaskAborting()) {
                throw new Exception("Task abort !");
            }
            if (this.context.getAction() == this.getAction()) {
                this.context.setProgress((double)npix * 100.0 / (double)n);
            }
            String name = Util.getFilePath(order, (long)npix, z);
            Fits in = new Fits();
            String filename = path + FS + name;
            try {
                if (!new File(filename + ext).exists()) continue;
                in.loadPreview(filename + ext, true, false, format);
                if (first && in.width != 0 && in.width < outLosangeWidth) {
                    Aladin.trace(3, "restart createAllsky: reducing width=>" + in.width + " ...");
                    this.createAllSkyColor(path, order, mode, in.width, z);
                    return;
                }
                first = false;
                int yLosange = npix / nbOutLosangeWidth;
                int xLosange = npix % nbOutLosangeWidth;
                int gap = in.width / outLosangeWidth;
                if (gap < 1) {
                    gap = 1;
                }
                for (int y = 0; y < in.width / gap; ++y) {
                    for (int x = 0; x < in.width / gap; ++x) {
                        int p = in.getPixelRGB(x * gap, in.width - y * gap - 1);
                        int xOut = xLosange * outLosangeWidth + x;
                        int yOut = yLosange * outLosangeWidth + y;
                        out.setPixelRGB(xOut, outFileHeight - yOut - 1, p);
                    }
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (first) {
            return;
        }
        String filename = BuilderAllsky.getFileName(path, order, z);
        out.writeCompressed(filename + ext, 0.0, 0.0, null, mode);
        if (z > 1 && !new File((f = BuilderAllsky.getFileName(path, order, 0)) + ext).isFile()) {
            out.writeCompressed(f + ext, 0.0, 0.0, null, mode);
        }
        this.context.trace(4, "SkyGenerator.createAllSkyColor()... " + (int)((System.currentTimeMillis() - t) / 1000L) + "s");
    }
}

