/*
 * Decompiled with CFR 0.152.
 */
package cds.allsky;

import cds.aladin.MyProperties;
import cds.aladin.Tok;
import cds.allsky.Action;
import cds.allsky.BuilderAllsky;
import cds.allsky.BuilderAppend;
import cds.allsky.BuilderClean;
import cds.allsky.BuilderCleanAll;
import cds.allsky.BuilderCleanDate;
import cds.allsky.BuilderCleanDetails;
import cds.allsky.BuilderCleanFits;
import cds.allsky.BuilderCleanIndex;
import cds.allsky.BuilderCleanJpg;
import cds.allsky.BuilderCleanPng;
import cds.allsky.BuilderCleanTIndex;
import cds.allsky.BuilderCleanTiles;
import cds.allsky.BuilderCleanWeight;
import cds.allsky.BuilderConcat;
import cds.allsky.BuilderCube;
import cds.allsky.BuilderDetails;
import cds.allsky.BuilderGunzip;
import cds.allsky.BuilderIndex;
import cds.allsky.BuilderJpg;
import cds.allsky.BuilderLint;
import cds.allsky.BuilderMap;
import cds.allsky.BuilderMapTiles;
import cds.allsky.BuilderMirror;
import cds.allsky.BuilderMoc;
import cds.allsky.BuilderMocError;
import cds.allsky.BuilderMocIndex;
import cds.allsky.BuilderPng;
import cds.allsky.BuilderProp;
import cds.allsky.BuilderRgb;
import cds.allsky.BuilderSTMoc;
import cds.allsky.BuilderTMoc;
import cds.allsky.BuilderTiles;
import cds.allsky.BuilderTree;
import cds.allsky.BuilderUpdate;
import cds.allsky.Context;
import cds.allsky.ContextGui;
import cds.fits.Fits;
import cds.moc.SMoc;
import cds.mocmulti.MultiMoc;
import cds.tools.pixtools.CDSHealpix;
import cds.tools.pixtools.Util;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;

public abstract class Builder {
    protected Builder b = null;
    protected Context context;
    private static String FS = cds.tools.Util.FS;
    static final int MAXPART = 10;
    protected Part[] part;

    protected Builder(Context context) {
        this.context = context;
    }

    public static Builder createBuilder(Context context, Action action) throws Exception {
        switch (action) {
            case INDEX: {
                return new BuilderIndex(context);
            }
            case TILES: {
                return new BuilderTiles(context);
            }
            case ALLSKY: {
                return new BuilderAllsky(context);
            }
            case JPEG: {
                return new BuilderJpg(context);
            }
            case PNG: {
                return new BuilderPng(context);
            }
            case MOC: {
                return new BuilderMoc(context);
            }
            case MOCERROR: {
                return new BuilderMocError(context);
            }
            case MOCINDEX: {
                return new BuilderMocIndex(context);
            }
            case CLEAN: {
                return new BuilderClean(context);
            }
            case CLEANALL: {
                return new BuilderCleanAll(context);
            }
            case CLEANINDEX: {
                return new BuilderCleanIndex(context);
            }
            case CLEANTINDEX: {
                return new BuilderCleanTIndex(context);
            }
            case CLEANDETAILS: {
                return new BuilderCleanDetails(context);
            }
            case CLEANTILES: {
                return new BuilderCleanTiles(context);
            }
            case CLEANFITS: {
                return new BuilderCleanFits(context);
            }
            case CLEANJPEG: {
                return new BuilderCleanJpg(context);
            }
            case CLEANPNG: {
                return new BuilderCleanPng(context);
            }
            case CLEANDATE: {
                return new BuilderCleanDate(context);
            }
            case CLEANWEIGHT: {
                return new BuilderCleanWeight(context);
            }
            case LINT: {
                return new BuilderLint(context);
            }
            case GUNZIP: {
                return new BuilderGunzip(context);
            }
            case RGB: {
                return new BuilderRgb(context);
            }
            case TREE: {
                return new BuilderTree(context);
            }
            case CONCAT: {
                return new BuilderConcat(context);
            }
            case APPEND: {
                return new BuilderAppend(context);
            }
            case CUBE: {
                return new BuilderCube(context);
            }
            case DETAILS: {
                return new BuilderDetails(context);
            }
            case MAPTILES: {
                return new BuilderMapTiles(context);
            }
            case UPDATE: {
                return new BuilderUpdate(context);
            }
            case PROP: {
                return new BuilderProp(context);
            }
            case MIRROR: {
                return new BuilderMirror(context);
            }
            case MAP: {
                return new BuilderMap(context);
            }
            case TMOC: {
                return new BuilderTMoc(context);
            }
            case STMOC: {
                return new BuilderSTMoc(context);
            }
        }
        throw new Exception("No builder associated to this action");
    }

    public abstract void validateContext() throws Exception;

    public boolean isAlreadyDone() {
        return false;
    }

    public abstract void run() throws Exception;

    protected void build() throws Exception {
    }

    public abstract Action getAction();

    public void showStatistics() {
    }

    public boolean isFake() {
        if (!this.context.fake) {
            return false;
        }
        this.context.info("Action " + (Object)((Object)this.getAction()) + " not run due to the -n option");
        return true;
    }

    protected void validateInput() throws Exception {
        if (this.context.isValidateInput()) {
            return;
        }
        String input = this.context.getInputPath();
        if (input == null) {
            throw new Exception("Argument \"input\" is required");
        }
        File f = new File(input);
        if (!f.canRead()) {
            throw new Exception("Input not available [" + input + "]");
        }
        if (f.isFile()) {
            this.context.info("Unique input image detected");
            this.context.setFlagInputFile(true);
        }
        if (this.context.isExistingAllskyDir(input) && this.context.hasPropertyFile(input)) {
            throw new Exception("The input directory must be a image collection, not a HiPS => aborted");
        }
        this.context.setValidateInput(true);
    }

    protected void validateOutput() throws Exception {
        int j;
        String input;
        int i;
        String output = this.context.getOutputPath();
        String name = null;
        String path = null;
        int n = i = output == null ? -1 : output.lastIndexOf(47);
        if (i == -1 && output != null) {
            i = output.lastIndexOf(92);
        }
        path = i >= 0 ? output.substring(0, i) : ((input = this.context.getInputPath()) != null && !input.startsWith("http://") && !input.startsWith("https://") ? ((j = input.lastIndexOf(FS)) >= 0 ? input.substring(0, j) : ".") : ".");
        if (output != null && i < output.length() - 1) {
            name = output.substring(i + 1);
        } else {
            String id = this.context.getHipsId();
            if (id == null) {
                String input2 = this.context.getInputPath();
                if (input2 != null && !input2.startsWith("http://") && !input2.startsWith("https://")) {
                    int j2 = input2.lastIndexOf(FS);
                    name = input2.substring(j2 + 1) + "HiPS";
                } else {
                    int j3 = input2.lastIndexOf(47);
                    name = input2.substring(j3 + 1);
                }
            } else {
                id = id.substring(6);
                id = id.replace('/', '_');
                name = id = id.replace('?', '_');
            }
        }
        output = path + FS + name;
        this.context.setOutputPath(output);
        File f = new File(output);
        if (!(!f.exists() || f.isDirectory() && f.canRead())) {
            throw new Exception("Ouput directory not available [" + output + "]");
        }
        this.context.info("the output directory will be " + output);
        this.context.setValidateOutput(true);
    }

    protected void validateIndex() throws Exception {
        String path = this.context.getHpxFinderPath();
        if (path == null) {
            throw new Exception("HEALPix index directory [HpxFinder] not defined => specify the output (or input) directory");
        }
        File f = new File(path);
        if (!(f.exists() && f.isDirectory() && f.canRead())) {
            throw new Exception("HEALPix index directory not available [" + path + "]");
        }
    }

    protected void validateOrder(String path) throws Exception {
        int order = this.context.getOrder();
        int orderIndex = Util.getMaxOrderByPath(path);
        if (order == -1 || this.context instanceof ContextGui) {
            this.context.info("Order retrieved from [" + path + "] => " + orderIndex);
            this.context.setOrder(orderIndex);
        } else if (orderIndex != -1 && order != orderIndex) {
            throw new Exception("Detected order [" + orderIndex + "] does not correspond to the param order [" + order + "]");
        }
    }

    protected void validateTileSide(String path) throws Exception {
        int tileSide = this.context.getTileSide();
        if (tileSide == -1) {
            return;
        }
        int tileSideByNpixFile = this.context.getTileWidthByNpixFile(path);
        if (tileSideByNpixFile != -1 && tileSide != tileSideByNpixFile) {
            this.context.warning("Size of pre-existing tiles incoherent with declarative tileSize (" + tileSide + "). Will assume " + tileSideByNpixFile);
            this.context.setTileOrder((int)CDSHealpix.log2(tileSideByNpixFile));
        }
    }

    protected void validateDepth() throws Exception {
        String s;
        if (this.context.depthInit) {
            return;
        }
        if (!this.context.isColor()) {
            String img = this.context.getImgEtalon();
            if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + img);
            }
            if (img != null) {
                try {
                    this.context.setImgEtalon(img);
                }
                catch (Exception e) {
                    this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
                }
            }
        }
        if (!this.context.depthInit) {
            try {
                int depth;
                this.context.loadProperties();
                s = this.context.prop.getProperty("hips_cube_depth");
                if (s == null) {
                    s = this.context.prop.getProperty("cubeDepth");
                }
                if (s != null && (depth = Integer.parseInt(s)) > 1) {
                    this.context.setDepth(depth);
                }
            }
            catch (Exception e) {
                this.context.warning("Propertie file problem => " + e.getMessage());
            }
        }
        if (this.context.depthInit && this.context.depth > 1) {
            s = "";
            if (this.context.isCubeCanal()) {
                s = " (crpix3=" + this.context.crpix3 + " crval3=" + this.context.crval3 + " cdelt3=" + this.context.cdelt3 + ")";
            }
            this.context.info("Working on HiPS cube => depth=" + this.context.depth + s);
        }
    }

    protected void validateCut() throws Exception {
        if (this.context.isValidateCut()) {
            return;
        }
        double[] cut = null;
        double[] pixelGood = this.context.pixelGood;
        boolean missingGood = pixelGood != null && this.context.good != null;
        boolean missingCut = cut == null || cut[0] == 0.0 && cut[1] == 0.0;
        boolean missingRange = cut == null || cut[2] == 0.0 && cut[3] == 0.0;
        double[] pixelRangeCut = this.context.getPixelRangeCut();
        if ((missingCut || missingRange) && pixelRangeCut != null || missingGood) {
            block24: {
                try {
                    this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                }
                catch (Exception e) {
                    String img = this.context.getImgEtalon();
                    if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                        this.context.info("Use this reference image => " + img);
                    }
                    if (img == null) break block24;
                    try {
                        this.context.setImgEtalon(img);
                    }
                    catch (Exception e1) {
                        this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
                    }
                }
            }
            try {
                int i;
                if (cut == null) {
                    cut = new double[5];
                }
                for (i = 0; i < 4; ++i) {
                    if (Double.isNaN(pixelRangeCut[i])) continue;
                    cut[i] = (pixelRangeCut[i] - this.context.bzero) / this.context.bscale;
                }
                if (missingGood) {
                    this.context.good = new double[2];
                    for (i = 0; i < 2; ++i) {
                        this.context.good[i] = (this.context.pixelGood[i] - this.context.bzero) / this.context.bscale;
                    }
                }
            }
            catch (Exception e) {
                throw new Exception("Cannot retrieve BZERO & BSCALE from previous Allsky.fits file or reference image");
            }
        }
        boolean bl = missingCut = cut == null || cut[0] == 0.0 && cut[1] == 0.0;
        if (missingCut) {
            String img = this.context.getImgEtalon();
            if (img == null && this.context.getInputPath() != null && (img = this.context.justFindImgEtalon(this.context.getInputPath())) != null) {
                this.context.info("Use this reference image => " + img);
            }
            if (img != null) {
                try {
                    this.context.setImgEtalon(img);
                }
                catch (Exception e) {
                    this.context.warning("Reference image problem [" + img + "] => " + e.getMessage());
                }
            }
            this.context.initParameters();
            double[] imgCut = this.context.getCut();
            if (cut == null) {
                cut = new double[5];
            }
            if (missingCut) {
                cut[0] = imgCut[0];
                cut[1] = imgCut[1];
                if (cut[0] != cut[1]) {
                    this.context.info("Estimating pixel cut from the reference image => [" + cut[0] + " .. " + cut[1] + "]");
                }
            }
        }
        boolean bl2 = missingCut = cut == null || cut[0] == 0.0 && cut[1] == 0.0;
        if (missingCut) {
            this.updateCutByProperties(cut);
        }
        this.context.setCut(cut);
        double bz = this.context.bzero;
        double bs = this.context.bscale;
        if (cut == null || cut[0] == 0.0 && cut[1] == 0.0) {
            throw new Exception("Argument \"pixelCut\" required");
        }
        if (!(cut[0] < cut[1])) {
            throw new Exception("pixelCut error [" + this.ip(cut[0], bz, bs) + " .. " + this.ip(cut[1], bz, bs) + "]");
        }
        this.context.info("pixel cut [" + this.ip(cut[0], bz, bs) + " .. " + this.ip(cut[1], bz, bs) + "]");
        this.context.setValidateCut(true);
    }

    protected void updateCutByProperties(double[] cut) {
        try {
            String propFile = this.context.getOutputPath() + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
                prop.load(in);
                in.close();
                String s = prop.getProperty("hips_pixel_cut");
                if (s == null) {
                    s = prop.getProperty("pixelCut");
                }
                this.context.setPixelCut(s);
                double[] pixelRangeCut = this.context.getPixelRangeCut();
                try {
                    this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
                    if (cut == null) {
                        cut = new double[5];
                    }
                    for (int i = 0; i < 4; ++i) {
                        if (Double.isNaN(pixelRangeCut[i])) continue;
                        cut[i] = (pixelRangeCut[i] - this.context.bzero) / this.context.bscale;
                    }
                    this.context.info("Pixel cut from the propertie file => [" + this.ip(cut[0], this.context.bzero, this.context.bscale) + " .. " + this.ip(cut[1], this.context.bzero, this.context.bscale) + "]");
                }
                catch (Exception e) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateBitpix() {
        if (this.context.bitpix != -1) {
            return;
        }
        try {
            this.setBzeroBscaleFromPreviousAllsky(this.context.getOutputPath() + Util.FS + "Norder3" + Util.FS + "Allsky.fits");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void validateLabel() {
        if (this.context.label != null) {
            return;
        }
        String label = this.getALabel(this.context.getOutputPath(), this.context.getInputPath());
        if (label != null && label.length() > 0) {
            this.context.label = label;
        }
    }

    protected String getALabel(String outputPath, String inputPath) {
        String label = null;
        try {
            String propFile = outputPath + Util.FS + "properties";
            MyProperties prop = new MyProperties();
            File f = new File(propFile);
            if (f.exists()) {
                InputStreamReader in = new InputStreamReader((InputStream)new BufferedInputStream(new FileInputStream(propFile)), "UTF-8");
                prop.load(in);
                in.close();
                String s = MultiMoc.getID(prop);
                s = this.context.getLabelFromHipsId(s);
                if (s == null) {
                    s = prop.getProperty("obs_title");
                }
                if (s == null) {
                    s = prop.getProperty("label");
                }
                if (s != null && s.length() > 0) {
                    label = s;
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (label != null) {
            return label;
        }
        if (inputPath != null) {
            int offset = inputPath.lastIndexOf(Util.FS);
            if (offset < 0) {
                offset = inputPath.lastIndexOf(47);
            }
            label = offset >= 0 ? inputPath.substring(offset + 1) : inputPath;
        } else {
            int offset = outputPath.lastIndexOf(Util.FS);
            if (offset < 0) {
                offset = outputPath.lastIndexOf(47);
            }
            label = offset >= 0 ? outputPath.substring(offset + 1) : outputPath;
        }
        return label;
    }

    protected String getFrame() {
        if (this.context.hasFrame()) {
            return this.context.getFrameCode();
        }
        try {
            String s;
            if (this.context.prop == null) {
                this.context.loadProperties();
            }
            if ((s = this.context.prop.getProperty("hips_frame")) == null) {
                s = this.context.prop.getProperty("coordsys");
            }
            if (s == null) {
                s = "G";
            }
            if (s.equals("equatorial")) {
                return "C";
            }
            if (s.equals("ecliptic")) {
                return "E";
            }
            if (s.equals("galactic")) {
                return "G";
            }
            return s;
        }
        catch (Exception e) {
            e.printStackTrace();
            return this.context.getFrameCode();
        }
    }

    protected String ip(double raw, double bzero, double bscale) {
        return cds.tools.Util.myRound(raw) + (bzero != 0.0 || bscale != 1.0 ? "/" + cds.tools.Util.myRound(raw * bscale + bzero) : "");
    }

    protected void setFitsParamFromPreviousAllsky(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadFITS(allskyFile);
        double[] cut = f.findAutocutRange(0.0, 0.0, true);
        this.context.setBitpix(f.bitpix);
        this.context.setCut(cut);
        try {
            double blank;
            this.context.blank = blank = f.headerFits.getDoubleFromHeader("BLANK");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bzero;
            this.context.bzero = bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bscale;
            this.context.bscale = bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    protected void setBzeroBscaleFromPreviousAllsky(String allskyFile) throws Exception {
        Fits f = new Fits();
        f.loadHeaderFITS(allskyFile);
        try {
            double bzero;
            this.context.bzero = bzero = f.headerFits.getDoubleFromHeader("BZERO");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            double bscale;
            this.context.bscale = bscale = f.headerFits.getDoubleFromHeader("BSCALE");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.context.bitpix == -1) {
            try {
                double bitpix = f.headerFits.getDoubleFromHeader("BITPIX");
                this.context.bitpix = (int)bitpix;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private double getMem(String s) throws Exception {
        double fct;
        char u = Character.toLowerCase(s.charAt(s.length() - 1));
        double d = u == 'k' ? 1.0 : (u == 'm' ? 1024.0 : (u == 'g' ? 1048576.0 : (fct = u == 't' ? 1.073741824E9 : -1.0)));
        if (fct == -1.0) {
            throw new Exception("Invalid mem unit");
        }
        return Double.parseDouble(s.substring(0, s.length() - 1)) * fct;
    }

    private long getTileSize(int bitpix, int width, int depth, String fmt) {
        long nbpix = width * width;
        if (bitpix == 0) {
            long nbBytesJpg = fmt.toLowerCase().indexOf("jpeg") >= 0 ? nbpix * 4L / 10L : 0L;
            long nbBytesPng = fmt.toLowerCase().indexOf("png") >= 0 ? nbpix * 4L / 8L : 0L;
            long nbBytes = (nbBytesJpg + nbBytesPng) * (long)depth;
            return nbBytes;
        }
        long nbBytesFits = fmt.toLowerCase().indexOf("fits") >= 0 ? 2880L + (long)(Math.abs(bitpix) / 8) * nbpix : 0L;
        long nbBytesJpg = fmt.toLowerCase().indexOf("jpeg") >= 0 ? nbBytesFits / 10L : 0L;
        long nbBytesPng = fmt.toLowerCase().indexOf("png") >= 0 ? nbBytesFits / 8L : 0L;
        long nbBytes = (nbBytesFits + nbBytesJpg + nbBytesPng) * (long)depth;
        return nbBytes;
    }

    protected void validateSplit(String outputPath, String split, SMoc moc, int order, int bitpix, int tileWidth, int depth, String fmt) throws Exception {
        moc.setMocOrder(order);
        long numberOfTiles = moc.getNbCells();
        long tileSize = this.getTileSize(bitpix, tileWidth, depth, fmt);
        if (tileSize == 0L) {
            throw new Exception("No remote tile found");
        }
        long fullSize = (long)((1.3 * (double)tileSize * (double)numberOfTiles + 8.0) / 1024.0);
        this.context.stat("Max order=" + order + ", Number of tiles=" + numberOfTiles + ", tile size(" + fmt + ")=" + cds.tools.Util.getUnitDisk(tileSize) + ", HiPS size estimation=" + cds.tools.Util.getUnitDisk(fullSize * 1024L));
        this.part = new Part[10];
        String s = split;
        Tok tok = new Tok(s, ";");
        double firstPartSize = this.getMem(tok.nextToken());
        if ((double)fullSize <= firstPartSize) {
            this.context.info("Enough space in master partition quota => no split required");
            return;
        }
        int n = 0;
        while (tok.hasMoreTokens()) {
            if (n == 10) {
                throw new Exception("Too many slitting partitions");
            }
            this.part[n] = new Part();
            String s1 = tok.nextToken();
            int i = s1.lastIndexOf(32);
            this.part[n].max = i < 0 ? -1.0 : this.getMem(s1.substring(i + 1));
            String string = this.part[n].dir = i < 0 ? s1 : s1.substring(0, i);
            if (!new File(this.part[n].dir).isAbsolute()) {
                throw new Exception("alternative target partitions must use an absolute path");
            }
            ++n;
        }
        HashMap<Long, Double> hashDir = new HashMap<Long, Double>();
        Iterator<Long> it = moc.pixelIterator();
        while (it.hasNext()) {
            long ndirLink = it.next() / 10000L;
            Double mem = (Double)hashDir.get(ndirLink);
            if (mem == null) {
                hashDir.put(ndirLink, (double)tileSize / 1024.0);
                continue;
            }
            hashDir.put(ndirLink, (double)tileSize / 1024.0 + mem);
        }
        String mainPart = outputPath;
        int nAltPart = 0;
        int nlinks = 0;
        int totNlinks = 0;
        boolean first = true;
        for (Long norderLink : hashDir.keySet()) {
            double sizeLink = (Double)hashDir.get(norderLink);
            fullSize = (long)((double)fullSize - sizeLink);
            if (this.part[nAltPart].size > this.part[nAltPart].max && this.part[nAltPart].max > 0.0) {
                this.context.stat(this.part[nAltPart].dir + " will content " + cds.tools.Util.getUnitDisk((long)(this.part[nAltPart].size * 1024.0)) + " thanks to " + nlinks + " links");
                ++nAltPart;
                nlinks = 0;
            }
            if (nAltPart >= this.part.length) {
                throw new Exception("Not enough space on alternative target partitions");
            }
            this.part[nAltPart].size += sizeLink;
            ++nlinks;
            ++totNlinks;
            if (!this.context.fake) {
                String sOrig = Util.getFileDir(mainPart, order, norderLink * 10000L);
                String sTarg = Util.getFileDir(this.part[nAltPart].dir, order, norderLink * 10000L);
                File fTarg = new File(sTarg);
                File fOrig = new File(sOrig);
                if (first) {
                    cds.tools.Util.createPath(sOrig);
                }
                fTarg.mkdirs();
                Files.createSymbolicLink(fOrig.toPath(), fTarg.toPath(), new FileAttribute[0]);
            }
            first = false;
            if (!((double)fullSize < firstPartSize)) continue;
            break;
        }
        if (this.part[nAltPart].size != 0.0) {
            this.context.stat(this.part[nAltPart].dir + " will content " + cds.tools.Util.getUnitDisk((long)(this.part[nAltPart].size * 1024.0)) + " thanks to " + nlinks + " links");
        }
        int nbdir = hashDir.size() - totNlinks;
        this.context.stat(mainPart + " will content " + cds.tools.Util.getUnitDisk(fullSize * 1024L) + " (HiPS hierarchy" + (nbdir > 0 ? " and " + nbdir + " directories)" : ")"));
    }

    private class Part {
        double size;
        double max;
        String dir;

        private Part() {
        }
    }
}

